/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.application.impl.onbrd.OnbrdCommonAppServiceImpl;
import kd.hr.hom.business.application.impl.onbrd.OnbrdConfirmAppServiceImpl;
import kd.hr.hom.business.application.impl.rule.OnbrdConfirmValidatorService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.sdk.hr.hom.business.onbrd.IConfirmOnbrdService;
import org.apache.commons.lang3.StringUtils;

public class OnbrdConfirmPlugin
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(OnbrdConfirmPlugin.class);
    private static final String OPCODE_DOCONFIRM = "doconfirm";
    private static final String EXCEL_FIELD_IFCANDOCONFIRM = "ifCanDoConfirm";
    private static final String EXCEL_FIELD_CANNOTCONFIRMREASON = "canNotConfirmReason";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)OPCODE_DOCONFIRM, (String)operateKey) || HRStringUtils.equals((String)"btn_confirmcheckin", (String)operateKey)) {
            if (!HRObjectUtils.isEmpty((Object)afterDoOperationEventArgs.getOperationResult()) && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                return;
            }
            this.showOnBrdConfirmPage(operateKey);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String billFormId;
        String actionId = closedCallBackEvent.getActionId();
        Object childViewDataObject = closedCallBackEvent.getReturnData();
        if (Objects.isNull(childViewDataObject)) {
            return;
        }
        String operateKey = null;
        IFormView view = this.getView();
        if (view instanceof IListView && ("hom_waitcheckin".equals(billFormId = ((IListView)view).getBillFormId()) || "hom_exceptioncheckin".equals(billFormId))) {
            operateKey = "btn_confirmcheckin";
        }
        switch (actionId) {
            case "hom_onbrdconfirmsingle": {
                this.doCallBackOnbrdConfirmSingle(childViewDataObject, operateKey);
                break;
            }
            case "hom_onbrdconfirmcount": {
                this.doCallBackOnbrdConfirmCount(childViewDataObject, operateKey);
                break;
            }
            case "hom_onbrdconfirmmulti": {
                this.doCallBackOnbrdConfirmMulti(childViewDataObject, operateKey);
                break;
            }
        }
    }

    private void doCallBackOnbrdConfirmMulti(Object childViewDataObject, String operateKey) {
        if (childViewDataObject instanceof DynamicObjectCollection) {
            DynamicObjectCollection collection = (DynamicObjectCollection)childViewDataObject;
            this.showOnBrdResultPage(collection, operateKey);
            this.getView().invokeOperation("refresh");
        }
    }

    private void doCallBackOnbrdConfirmCount(Object childViewDataObject, String operateKey) {
        Map childViewDataMap;
        Object fitIds;
        if (childViewDataObject instanceof Map && (fitIds = (childViewDataMap = (Map)childViewDataObject).get("fitIds")) instanceof List) {
            Integer countSelected = Integer.valueOf(childViewDataMap.get("allperson").toString());
            this.showOnBrdConfirmPageWithMultiData(countSelected, (List)fitIds, operateKey);
        }
    }

    private void doCallBackOnbrdConfirmSingle(Object childViewDataObject, String operateKey) {
        Map resultMap = (Map)childViewDataObject;
        Boolean isSuccess = (Boolean)resultMap.get("isSuccess");
        if (!isSuccess.booleanValue()) {
            String failReason = resultMap.get("failReason").toString();
            this.getView().showErrorNotification(failReason);
        } else {
            String msg = ResManager.loadKDString((String)"\u786e\u8ba4\u5165\u804c\u6210\u529f\u3002", (String)"OnbrdConfirmPlugin_30", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
        }
        this.getView().invokeOperation("refresh");
    }

    private void showOnBrdConfirmPage(String operateKey) {
        IFormView formView = this.getView();
        if (formView instanceof IListView) {
            IListView listview = (IListView)formView;
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            if (selectedRows.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5165\u804c\u7684\u4eba\u5458\u3002", (String)"OnbrdConfirmPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            Long[] onbrdIdArray = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(pkId -> Long.valueOf(pkId.toString())).toArray(Long[]::new);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IConfirmOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IConfirmOnbrdService", null);
            hrPluginProxy.callReplace(hrPlugin -> {
                hrPlugin.beforeConfirmOnbrds((Object[])onbrdIdArray);
                return null;
            });
            Object[] onbrdBillInfos = new OnbrdConfirmAppServiceImpl().getOnbrdBillsForShowPage(onbrdIdArray);
            if (HRArrayUtils.isEmpty((Object[])onbrdBillInfos)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u8bb0\u5f55\u3002", (String)"OnbrdConfirmPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            if (onbrdBillInfos.length == 1) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hom_onbrdconfirmsingle");
                if (new OnbrdConfirmValidatorService().checkCertCountForOnbrdConfirm(this.getView(), onbrdBillInfos.length, operateKey)) {
                    new OnbrdConfirmAppServiceImpl().showOnBrdConfirmPageWithOneData(this.getView(), (DynamicObject)onbrdBillInfos[0], closeCallBack, operateKey);
                }
            } else {
                this.dealOnBrdConfirmPageWithMultiData((DynamicObject[])onbrdBillInfos, operateKey);
            }
        }
    }

    private void dealOnBrdConfirmPageWithMultiData(DynamicObject[] onbrdBillInfos, String operateKey) {
        ArrayList<Object> fitIds = new ArrayList<Object>(onbrdBillInfos.length);
        OnbrdConfirmValidatorService onbrdConfirmValidatorService = new OnbrdConfirmValidatorService();
        Map checkResultMap = onbrdConfirmValidatorService.checkIfIsEligibleOnboard(onbrdBillInfos, operateKey);
        this.getView().getPageCache().put("checkResultMap", JSONObject.toJSONString((Object)checkResultMap));
        if (onbrdConfirmValidatorService.checkCertCountForOnbrdConfirm(this.getView(), onbrdBillInfos.length, operateKey)) {
            for (Map.Entry entry : checkResultMap.entrySet()) {
                if (((Optional)entry.getValue()).isPresent()) continue;
                fitIds.add(entry.getKey());
            }
        }
        if (onbrdBillInfos.length > fitIds.size()) {
            this.showOnBrdConfirmPageWithCount(onbrdBillInfos, fitIds, operateKey);
        } else {
            this.showOnBrdConfirmPageWithMultiData(onbrdBillInfos.length, fitIds, operateKey);
        }
    }

    private void showOnBrdConfirmPageWithCount(DynamicObject[] onbrdBillInfos, List<Object> fitIds, String operateKey) {
        Integer fitPersonCount = fitIds.size();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_onbrdconfirmcount");
        formShowParameter.setCustomParam("fitperson", (Object)fitPersonCount);
        formShowParameter.setCustomParam("nofitperson", (Object)(onbrdBillInfos.length - fitPersonCount));
        formShowParameter.setCustomParam("allperson", (Object)onbrdBillInfos.length);
        formShowParameter.setCustomParam("fitIds", fitIds);
        List<HRExportHeadObject> headDataList = this.getHeadDataListWithConfirmCount();
        formShowParameter.setCustomParam("headdatalist", headDataList);
        List<Map<String, Object>> templateExportDataList = this.getExportDataListWithConfirmCount(onbrdBillInfos, operateKey);
        this.getView().getPageCache().remove("checkResultMap");
        formShowParameter.setCustomParam("exportdatalist", templateExportDataList);
        if ("btn_confirmcheckin".equals(operateKey)) {
            String name = ResManager.loadKDString((String)"\u786e\u8ba4\u62a5\u5230", (String)"OnbrdConfirmPlugin_28", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            formShowParameter.setCustomParam("excelname", (Object)name);
            formShowParameter.setCaption(name);
        } else {
            formShowParameter.setCustomParam("excelname", (Object)ResManager.loadKDString((String)"\u786e\u8ba4\u5165\u804c", (String)"OnbrdConfirmPlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hom_onbrdconfirmcount"));
        this.getView().showForm(formShowParameter);
    }

    private void showOnBrdConfirmPageWithMultiData(int countSelected, List<Object> fitIds, String operateKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_onbrdconfirmmulti");
        formShowParameter.setCustomParam("fitIds", fitIds);
        if ("btn_confirmcheckin".equals(operateKey)) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6279\u91cf\u786e\u8ba4\u62a5\u5230", (String)"OnbrdConfirmPlugin_29", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        formShowParameter.setCustomParam("nofitnum", (Object)(countSelected - fitIds.size()));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hom_onbrdconfirmmulti"));
        this.getView().showForm(formShowParameter);
    }

    private List<HRExportHeadObject> getHeadDataListWithConfirmCount() {
        ArrayList<HRExportHeadObject> headdatalist = new ArrayList<HRExportHeadObject>(6);
        headdatalist.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"OnbrdConfirmPlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("candidatenumber", ResManager.loadKDString((String)"\u5019\u9009\u4eba\u7f16\u53f7", (String)"OnbrdConfirmPlugin_8", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("employeeno", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"OnbrdConfirmPlugin_9", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("effectdate", ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f", (String)"OnbrdConfirmPlugin_10", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("iseligibleonboard", ResManager.loadKDString((String)"\u662f\u5426\u6ee1\u8db3\u5165\u804c\u6761\u4ef6", (String)"OnbrdConfirmPlugin_11", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject(EXCEL_FIELD_IFCANDOCONFIRM, ResManager.loadKDString((String)"\u80fd\u5426\u8fdb\u884c\u786e\u8ba4\u5165\u804c", (String)"OnbrdConfirmPlugin_12", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject(EXCEL_FIELD_CANNOTCONFIRMREASON, ResManager.loadKDString((String)"\u4e0d\u80fd\u786e\u8ba4\u5165\u804c\u539f\u56e0", (String)"OnbrdConfirmPlugin_13", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        return headdatalist;
    }

    private List<Map<String, Object>> getExportDataListWithConfirmCount(DynamicObject[] onbrdBillInfos, String operateKey) {
        ArrayList<Map<String, Object>> exportdatalist = new ArrayList<Map<String, Object>>(onbrdBillInfos.length);
        String checkResults = this.getView().getPageCache().get("checkResultMap");
        Map checkResultMap = new HashMap(onbrdBillInfos.length);
        if (checkResults != null) {
            checkResultMap = (Map)JSONObject.parseObject((String)checkResults, Map.class);
        }
        for (DynamicObject onbrdBillInfo : onbrdBillInfos) {
            String canNotConfirmReason = (String)checkResultMap.get(onbrdBillInfo.getLong("id"));
            Map<String, Object> personInfoMap = this.convertDynamicObjectToMapForExcel(onbrdBillInfo, operateKey, canNotConfirmReason);
            exportdatalist.add(personInfoMap);
        }
        return exportdatalist;
    }

    private Map<String, Object> convertDynamicObjectToMapForExcel(DynamicObject onbrdBillInfo, String operateKey, String canNotConfirmReason) {
        Map<String, Object> onbrdBillInfoMap = new HashMap();
        try {
            onbrdBillInfoMap = HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)onbrdBillInfo);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        onbrdBillInfoMap.put("name", onbrdBillInfo.getLocaleString("name").getLocaleValue());
        Date effectDate = onbrdBillInfo.getDate("effectdate");
        if (Objects.nonNull(effectDate)) {
            onbrdBillInfoMap.put("effectdate", HRDateTimeUtils.format((Date)effectDate, (String)"yyyy/MM/dd"));
        }
        onbrdBillInfoMap.put("candidatenumber", onbrdBillInfoMap.get("candidatenumber"));
        String iseligibleonboard = onbrdBillInfo.getBoolean("iseligibleonboard") ? ResManager.loadKDString((String)"\u662f", (String)"OnbrdConfirmPlugin_31", (String)"hr-hom-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"OnbrdConfirmPlugin_32", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        onbrdBillInfoMap.put("iseligibleonboard", iseligibleonboard);
        if (StringUtils.isNotBlank((CharSequence)canNotConfirmReason)) {
            onbrdBillInfoMap.put(EXCEL_FIELD_IFCANDOCONFIRM, ResManager.loadKDString((String)"\u5426", (String)"OnbrdConfirmPlugin_32", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            onbrdBillInfoMap.put(EXCEL_FIELD_CANNOTCONFIRMREASON, canNotConfirmReason);
        } else {
            onbrdBillInfoMap.put(EXCEL_FIELD_IFCANDOCONFIRM, ResManager.loadKDString((String)"\u662f", (String)"OnbrdConfirmPlugin_31", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        return onbrdBillInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showOnBrdResultPage(DynamicObjectCollection dynamicObjectCollection, String operateKey) {
        List<Map<String, Object>> operationResultList = new ArrayList<Map<String, Object>>();
        if (!HRObjectUtils.isEmpty((Object)dynamicObjectCollection)) {
            List onbrdBillIds = dynamicObjectCollection.stream().map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toList());
            IHomDataMutexService homDataMutexService = IHomDataMutexService.getInstance();
            Map map = homDataMutexService.batchRequire(onbrdBillIds, "hom_onbrdinfo", OPCODE_DOCONFIRM);
            List failLockIds = map.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(entry -> (Long)entry.getKey()).collect(Collectors.toList());
            List successLockIds = map.entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> (Long)entry.getKey()).collect(Collectors.toList());
            try {
                if (!CollectionUtils.isEmpty(failLockIds)) {
                    new OnbrdCommonAppServiceImpl().showMutexMsgWithOnbrdBill(this.getView(), failLockIds, ResManager.loadKDString((String)"\u786e\u8ba4\u5165\u804c", (String)"OnbrdConfirmPlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long userId = RequestContext.get().getCurrUserId();
                DynamicObject[] onbrdBillSimpleInfoList = (DynamicObject[])dynamicObjectCollection.toArray((Object[])new DynamicObject[dynamicObjectCollection.size()]);
                operationResultList = new OnbrdConfirmAppServiceImpl().doComfirmWithSimpleInfo(userId, onbrdBillSimpleInfoList, operateKey);
            }
            finally {
                homDataMutexService.batchRelease(successLockIds, "hom_onbrdinfo", OPCODE_DOCONFIRM);
            }
        }
        int successOpCount = 0;
        for (Map map : operationResultList) {
            if (Boolean.parseBoolean(map.get("isSuccess").toString())) {
                ++successOpCount;
                map.put("isSuccess", ResManager.loadKDString((String)"\u662f", (String)"OnbrdConfirmPlugin_31", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                continue;
            }
            map.put("isSuccess", ResManager.loadKDString((String)"\u5426", (String)"OnbrdConfirmPlugin_32", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        String successOperation = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"OnbrdConfirmPlugin_14", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        String string = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"OnbrdConfirmPlugin_15", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        this.showOnBrdResultPage(successOpCount, successOperation, operationResultList.size() - successOpCount, string, operationResultList);
    }

    private void showOnBrdResultPage(Integer successOpCount, String successOperation, Integer failOpCount, String failOperation, List<Map<String, Object>> templateExportDataList) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String excelName = ResManager.loadKDString((String)"\u64cd\u4f5c\u63d0\u793a", (String)"OnbrdConfirmPlugin_17", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        if (failOpCount == 0) {
            formShowParameter.setFormId("hom_result_success");
        } else if (successOpCount == 0) {
            formShowParameter.setFormId("hom_result_fail");
        } else {
            formShowParameter.setFormId("hom_result_all");
            excelName = ResManager.loadKDString((String)"\u64cd\u4f5c\u63d0\u793a", (String)"OnbrdConfirmPlugin_17", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        }
        formShowParameter.setCustomParam("successperson", (Object)String.format(ResManager.loadKDString((String)"%s\u4eba", (String)"OnbrdConfirmPlugin_18", (String)"hr-hom-formplugin", (Object[])new Object[0]), successOpCount.toString()));
        formShowParameter.setCustomParam("successoperation", (Object)successOperation);
        formShowParameter.setCustomParam("failperson", (Object)String.format(ResManager.loadKDString((String)"%s\u4eba", (String)"OnbrdConfirmPlugin_18", (String)"hr-hom-formplugin", (Object[])new Object[0]), failOpCount.toString()));
        formShowParameter.setCustomParam("failoperation", (Object)failOperation);
        formShowParameter.setCaption(excelName);
        formShowParameter.setCustomParam("excelname", (Object)excelName);
        List<HRExportHeadObject> headDataList = this.getHeadDataListWithOpResult();
        formShowParameter.setCustomParam("headdatalist", headDataList);
        formShowParameter.setCustomParam("exportdatalist", templateExportDataList);
        this.getView().showForm(formShowParameter);
    }

    private List<HRExportHeadObject> getHeadDataListWithOpResult() {
        ArrayList<HRExportHeadObject> headdatalist = new ArrayList<HRExportHeadObject>(8);
        headdatalist.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"OnbrdConfirmPlugin_19", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("resumeno", ResManager.loadKDString((String)"\u7b80\u5386\u7f16\u53f7", (String)"OnbrdConfirmPlugin_20", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("employeeno", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"OnbrdConfirmPlugin_21", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("certificatetype.name", ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b", (String)"OnbrdConfirmPlugin_22", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("certificatenumber", ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801", (String)"OnbrdConfirmPlugin_23", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("effectdate", ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f", (String)"OnbrdConfirmPlugin_24", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("warnMessage", ResManager.loadKDString((String)"\u5165\u804c\u5f02\u5e38\u4fe1\u606f", (String)"OnbrdConfirmPlugin_25", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("isSuccess", ResManager.loadKDString((String)"\u5165\u804c\u662f\u5426\u6210\u529f", (String)"OnbrdConfirmPlugin_26", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("failReason", ResManager.loadKDString((String)"\u5165\u804c\u5931\u8d25\u539f\u56e0", (String)"OnbrdConfirmPlugin_27", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        return headdatalist;
    }
}

