/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.common.constant.EmpNoRuleCodeConstants;

public class OnbrdGetEmpNoPlugin
extends HRDataBaseList
implements EmpNoRuleCodeConstants {
    static final Log LOGGER = LogFactory.getLog(OnbrdGetEmpNoPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)"getempno", (String)operateKey)) {
            this.showNumberCodePage();
        }
    }

    public void showNumberCodePage() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection rows = listView.getSelectedRows();
        if (rows.size() <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u751f\u6210\u5de5\u53f7\u7684\u6570\u636e\u3002", (String)"OnbrdGetEmpNoPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showPage(rows);
    }

    public void showPage(ListSelectedRowCollection rows) {
        if (CollectionUtil.isEmpty((Collection)rows)) {
            return;
        }
        Long[] onbrdIdArray = (Long[])Arrays.stream(rows.getPrimaryKeyValues()).map(pkId -> Long.valueOf(pkId.toString())).toArray(Long[]::new);
        List<Long> failList = this.getBatchLock(rows);
        if (!CollectionUtils.isEmpty(failList)) {
            this.showLockString(failList);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("hom_empnumberrule");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("select_ids", (Object)onbrdIdArray);
        this.getView().showForm(showParameter);
    }

    public List<Long> getBatchLock(ListSelectedRowCollection selectRows) {
        List ids = selectRows.stream().map(selRow -> Long.valueOf(selRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        Map batchRequireResult = IHomDataMutexService.getInstance().batchRequire(ids, "hom_personwaitonbrd", "getempno", true);
        List<Long> failLockIds = batchRequireResult.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(entry -> (Long)entry.getKey()).collect(Collectors.toList());
        List successLockIds = batchRequireResult.entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> (Long)entry.getKey()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(failLockIds)) {
            IHomDataMutexService.getInstance().batchRelease(successLockIds, "hom_personwaitonbrd", "getempno");
        }
        return failLockIds;
    }

    private void showLockString(List<Long> ids) {
        Object[] dys = HomCommonRepository.queryDynamicObjectByPks((String)"hom_onbrdbillbase", (String)"name", (Object[])ids.toArray(new Long[ids.size()]));
        if (ArrayUtils.isEmpty((Object[])dys)) {
            LOGGER.info("OnbrdGetEmpNoPlugin_showLockString_nothing");
            return;
        }
        List nameList = Arrays.stream(dys).map(dy -> dy.getString("name")).collect(Collectors.toList());
        String msg = nameList.toString();
        String str = ResManager.loadKDString((String)"%s\u6b63\u5728\u751f\u6210\u5de5\u53f7\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"OnbrdGetEmpNoPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[]{msg.substring(1, msg.length() - 1)});
        this.getView().showTipNotification(str);
    }
}

