/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.application.impl.onbrd.OnbrdWorkTableServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdWorkTableService;
import kd.hr.hom.common.enums.OnbrdStatusEnum;

public class OnbrdPersonBillListPlugin
extends HRDataBaseList
implements TabSelectListener {
    private static final IOnbrdWorkTableService workTableService = new OnbrdWorkTableServiceImpl();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "all": {
                this.loadAllPersonList();
                break;
            }
            case "waitstart": {
                this.loadWaitStartPersonList();
                break;
            }
            case "waitonbrd": {
                this.loadWaitOnbrdPersonList();
                break;
            }
            case "hasonboarded": {
                this.loadHasOnbrdPersonList();
                break;
            }
            case "breakuponbrd": {
                this.loadBreakupOnboardPersonList();
                break;
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String key = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (HRStringUtils.isEmpty((String)key)) {
            this.loadAllPersonList();
            return;
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        if ("1".equals(key)) {
            tab.activeTab("waitstart");
        } else {
            tab.activeTab("waitonbrd");
        }
    }

    private void loadAllPersonList() {
        this.loadOnbrdPersonList("hom_personallonbrd", "alllist", null);
    }

    private void loadWaitStartPersonList() {
        this.loadOnbrdPersonList("hom_personwaitstart", "waitstartlist", OnbrdStatusEnum.WAIT_START.toString());
    }

    private void loadWaitOnbrdPersonList() {
        this.loadOnbrdPersonList("hom_personwaitonbrd", "waitonbrdlist", OnbrdStatusEnum.WAIT_ONBRD.toString());
    }

    private void loadHasOnbrdPersonList() {
        this.loadOnbrdPersonList("hom_personhasonbrd", "hasonboardedlist", OnbrdStatusEnum.HAS_ONBRD.toString());
    }

    private void loadBreakupOnboardPersonList() {
        this.loadOnbrdPersonList("hom_personbreakuponbrd", "breakuponboardlist", OnbrdStatusEnum.BREAK_UP.toString());
    }

    private Map<String, Object> getStringObjectMap(HRPageCache pageCache) {
        return workTableService.getStringObjectMap(pageCache);
    }

    private void loadOnbrdPersonList(String sourceFormId, String tabLabelName, String enrollStatus) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(sourceFormId);
        listShowParameter.getOpenStyle().setTargetKey(tabLabelName);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.setCustomParam("enrollstatus", (Object)enrollStatus);
        this.setWorkIngTableFilter(listShowParameter);
        this.setCalendarFilter(listShowParameter);
        if (HRStringUtils.isNotEmpty((String)enrollStatus)) {
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            QFilter enrollStatusFilter = new QFilter("enrollstatus", "=", (Object)enrollStatus);
            listFilterParameter.getQFilters().add(enrollStatusFilter);
            listShowParameter.setListFilterParameter(listFilterParameter);
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
        IFormView listView = this.getView().getView(listShowParameter.getPageId());
        if (null != listView) {
            this.getView().sendFormAction(listView);
        }
    }

    private void setWorkIngTableFilter(ListShowParameter listShowParameter) {
        String key = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if ("9".equals(key) || HRStringUtils.isEmpty((String)key)) {
            return;
        }
        HRPageCache pageCache = new HRPageCache(this.getView().getParentView().getParentView());
        Map<String, Object> map = this.getStringObjectMap(pageCache);
        listShowParameter.setCustomParam("hrbuids", map.get("hrbuids"));
        listShowParameter.setCustomParam("adminorgids", map.get("adminorgids"));
        String workTableInit = this.getView().getPageCache().get("is_init");
        if (workTableInit == null) {
            listShowParameter.setCustomParam("type", (Object)key);
            this.getView().getPageCache().put("is_init", "is_init");
        }
    }

    private void setCalendarFilter(ListShowParameter listShowParameter) {
        JSONArray array;
        String key = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (!"9".equals(key)) {
            return;
        }
        String st = (String)this.getView().getFormShowParameter().getCustomParam("hrbuids");
        String st1 = (String)this.getView().getFormShowParameter().getCustomParam("adminorgids");
        if (st != null) {
            array = JSONArray.parseArray((String)st);
            List HRBUIDS = array.stream().map(str -> Long.valueOf(String.valueOf(str))).collect(Collectors.toList());
            listShowParameter.setCustomParam("hrbuids", HRBUIDS);
        }
        if (st1 != null) {
            array = JSONArray.parseArray((String)st1);
            List ADMINORGIDS = array.stream().map(str -> Long.valueOf(String.valueOf(str))).collect(Collectors.toList());
            listShowParameter.setCustomParam("adminorgids", ADMINORGIDS);
        }
        String date = (String)this.getView().getFormShowParameter().getCustomParam("effectdate");
        listShowParameter.setCustomParam("effectdate", (Object)date);
        String workTableInit = this.getView().getPageCache().get("is_init");
        if (key != null && workTableInit == null) {
            listShowParameter.setCustomParam("type", (Object)key);
            this.getView().getPageCache().put("is_init", "is_init");
        }
    }
}

