/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.HomPageToHcfPageEnum;
import kd.hr.hom.common.enums.OnbrdPanelBtnParamsEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.formplugin.web.base.HomOnbrdDataBaseEdit;

public class OnbrdPersonBodyInfoPlugin
extends HomOnbrdDataBaseEdit {
    private static final Log logger = LogFactory.getLog(OnbrdPersonBodyInfoPlugin.class);
    private static final String KEY_BTN_START = "barstart";
    private static final String KEY_BTN_CONFIRM = "barconfirm";
    private static final String KEY_BTN_BREAKUP = "barbreakup";
    private static final String BTN_CLOSE = "barclose";
    private static final String KEY_BTN_BILLEDIT = "btn_billedit";
    private static final String TABPAGE_KEY_ACTIVITY = "tabactivity";
    private static final String FLEXPANELAP = "flexpanelap";
    private static final String BARSAVE = "barsave";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        IOnbrdBillDomainService.getInstance().generateViewForEnrollStatus(onbrdId, this.getView(), new String[]{FLEXPANELAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_personinfoclose", "btn_personinfosave", "btn_contactclose", "btn_contactsave", "btn_checkclose", "btn_checksave"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdId);
        DynamicObject onbrdDyObj = IOnbrdBillDomainService.getInstance().findOnbrdBill("enrollstatus", new QFilter[]{qFilter});
        if (HRObjectUtils.isEmpty((Object)onbrdDyObj)) {
            logger.info("Can not find OnbrdBill By the PkId " + onbrdId);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5165\u804c\u5355\u3002", (String)"OnbrdPersonBodyInfoPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        String enrollStatus = onbrdDyObj.getString("enrollstatus");
        if (OnbrdStatusEnum.WAIT_ONBRD.toString().equals(enrollStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_START});
        } else if (OnbrdStatusEnum.HAS_ONBRD.toString().equals(enrollStatus) || OnbrdStatusEnum.BREAK_UP.toString().equals(enrollStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BARSAVE, KEY_BTN_START, KEY_BTN_CONFIRM, KEY_BTN_BREAKUP, KEY_BTN_BILLEDIT});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap", "advcontoolbarap1", "advcontoolbarap1111121"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_CONFIRM, KEY_BTN_BREAKUP, TABPAGE_KEY_ACTIVITY});
        }
        this.showEntryBaseInfo("hom_onbrdpersoninfohead", "persononbrdhead", onbrdId, "");
        Tuple<String, String> dataIds = this.getOnbrdId();
        this.showPersonInfo(dataIds);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)"donothing_close", (String)opKey)) {
            if (!this.checkDataChange()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u51fa\uff1f", (String)"OnbrdBodyInfoPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_CLOSE, (IFormPlugin)this));
            } else {
                this.getView().close();
            }
            return;
        }
        if (HRStringUtils.equals((String)"donothing_view", (String)opKey)) {
            this.openOnbrdInfo();
        }
        Tuple<String, String> dataIds = this.getOnbrdId();
        this.clickOnPersonInfo(opKey, dataIds);
        this.clickOnContactInfo(opKey, dataIds);
        this.clickCheckInfo(opKey, dataIds);
    }

    private void openOnbrdInfo() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        FormShowParameter showParameter = new FormShowParameter();
        DynamicObject onbrdDyObj = IOnbrdBillDomainService.getInstance().findOnbrdBillById("id,name,candidate,viewtype", (Object)onbrdId);
        String name = onbrdDyObj.getString("name");
        String viewType = onbrdDyObj.getString("viewtype");
        if (ViewTypeEnum.AGAIN.getCode().equals(viewType)) {
            showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u518d\u5165\u804c\u529e\u7406\u5355-%s", (String)"OnbrdBillListPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), name));
        } else {
            showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5165\u804c\u529e\u7406\u5355-%s", (String)"OnbrdBillListPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), name));
        }
        showParameter.setFormId("hom_persononbrdhandlebody");
        showParameter.setCustomParam("checkRightAppId", (Object)this.getView().getFormShowParameter().getAppId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        IFormView currView = this.getView();
        IFormView parentView = HOMObjectUtils.getCurrAppHomeView((IFormView)currView);
        String appRootPageId = parentView == null ? currView.getFormShowParameter().getRootPageId() : parentView.getPageId();
        String pageId = HOMObjectUtils.getUniquePageId((String)"hom_persononbrdhandlebody", (Object)onbrdId, (String)appRootPageId);
        showParameter.setPageId(pageId);
        showParameter.setCustomParam("onbrdid", (Object)onbrdId);
        showParameter.setCustomParam("candidateid", (Object)onbrdDyObj.getString("candidate.id"));
        currView.showForm(showParameter);
    }

    private boolean checkDataChange() {
        IFormView childView1 = this.getEmbedPageViewOfClose(OnbrdPanelBtnParamsEnum.PERSON_INFO.getPageNumber());
        IFormView childView2 = this.getEmbedPageViewOfClose(OnbrdPanelBtnParamsEnum.CONTACT.getPageNumber());
        IFormView childView3 = this.getEmbedPageViewOfClose(OnbrdPanelBtnParamsEnum.CHECK.getPageNumber());
        return this.childViewChange(childView1) && this.childViewChange(childView2) && this.childViewChange(childView3);
    }

    private boolean childViewChange(IFormView childView) {
        try {
            if (childView != null && childView.getModel() != null && childView.getModel().getDataChanged()) {
                return false;
            }
        }
        catch (KDException exp) {
            logger.warn((Throwable)exp);
        }
        return true;
    }

    private void clickCheckInfo(String lblKey, Tuple<String, String> dataIds) {
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        if (("btn_checkmodity".equals(lblKey) || "btn_checksave".equals(lblKey)) && onbrdCommonAppService.isEnrolledWithTip(this.getView(), HRJSONUtils.getLongValOfCustomParam((Object)dataIds.item1))) {
            return;
        }
        switch (lblKey) {
            case "btn_checkmodity": {
                if (!this.require(dataIds, "hom_onbrdinfo") || !onbrdCommonAppService.checkPermissionAndShowTips(HomPageToHcfPageEnum.CHECK_INFO_AP.getHomPageNumberView(), "4715a0df000000ac", this.getView())) break;
                this.updatePageStatusToEdit(OnbrdPanelBtnParamsEnum.CHECK.getPageNumber(), OnbrdPanelBtnParamsEnum.CHECK.getTargetKey(), dataIds, OnbrdPanelBtnParamsEnum.CHECK.getBtnModify(), OnbrdPanelBtnParamsEnum.CHECK.getBtnSave(), OnbrdPanelBtnParamsEnum.CHECK.getBtnClose(), false);
                break;
            }
            case "btn_checkclose": {
                if (!this.checkCloseChange(OnbrdPanelBtnParamsEnum.CHECK.getPageNumber(), OnbrdPanelBtnParamsEnum.CHECK.getTargetKey(), dataIds, OnbrdPanelBtnParamsEnum.CHECK.getBtnModify(), OnbrdPanelBtnParamsEnum.CHECK.getBtnClose(), OnbrdPanelBtnParamsEnum.CHECK.getBtnSave(), false, "")) break;
                this.releaseLock(dataIds);
                break;
            }
            case "btn_checksave": {
                if (!onbrdCommonAppService.checkPermissionAndShowTips(HomPageToHcfPageEnum.CHECK_INFO_AP.getHomPageNumberView(), "0=KX5+QVF5+R", this.getView()) || !this.invokeChildOperation(OnbrdPanelBtnParamsEnum.CHECK.getPageNumber(), "save")) break;
                this.updatePageStatusToView(OnbrdPanelBtnParamsEnum.CHECK.getPageNumber(), OnbrdPanelBtnParamsEnum.CHECK.getTargetKey(), dataIds, OnbrdPanelBtnParamsEnum.CHECK.getBtnModify(), OnbrdPanelBtnParamsEnum.CHECK.getBtnSave(), OnbrdPanelBtnParamsEnum.CHECK.getBtnClose(), false);
                this.releaseLock(dataIds);
                break;
            }
        }
    }

    private void clickOnContactInfo(String lblKey, Tuple<String, String> dataIds) {
        if (("btn_contactmodity".equals(lblKey) || "btn_contactsave".equals(lblKey)) && IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), HRJSONUtils.getLongValOfCustomParam((Object)dataIds.item1))) {
            return;
        }
        switch (lblKey) {
            case "btn_contactmodity": {
                if (!IOnbrdCommonAppService.getInstance().checkPermissionAndShowTips("hom_cancontactinfo", "4715a0df000000ac", this.getView())) {
                    return;
                }
                if (!this.require(dataIds, "hom_onbrdinfo")) break;
                this.updatePageStatusToEdit(OnbrdPanelBtnParamsEnum.CONTACT.getPageNumber(), OnbrdPanelBtnParamsEnum.CONTACT.getTargetKey(), dataIds, OnbrdPanelBtnParamsEnum.CONTACT.getBtnModify(), OnbrdPanelBtnParamsEnum.CONTACT.getBtnSave(), OnbrdPanelBtnParamsEnum.CONTACT.getBtnClose(), true);
                break;
            }
            case "btn_contactclose": {
                if (!this.checkCloseChange(OnbrdPanelBtnParamsEnum.CONTACT.getPageNumber(), OnbrdPanelBtnParamsEnum.CONTACT.getTargetKey(), dataIds, OnbrdPanelBtnParamsEnum.CONTACT.getBtnModify(), OnbrdPanelBtnParamsEnum.CONTACT.getBtnClose(), OnbrdPanelBtnParamsEnum.CONTACT.getBtnSave(), true, "hcf_cancontactinfo")) break;
                this.releaseLock(dataIds);
                break;
            }
            case "btn_contactsave": {
                if (!this.invokeChildOperation(OnbrdPanelBtnParamsEnum.CONTACT.getPageNumber(), "save")) break;
                this.updatePageStatusToView(OnbrdPanelBtnParamsEnum.CONTACT.getPageNumber(), OnbrdPanelBtnParamsEnum.CONTACT.getTargetKey(), dataIds, OnbrdPanelBtnParamsEnum.CONTACT.getBtnModify(), OnbrdPanelBtnParamsEnum.CONTACT.getBtnSave(), OnbrdPanelBtnParamsEnum.CONTACT.getBtnClose(), true);
                this.releaseLock(dataIds);
                break;
            }
        }
    }

    private void clickOnPersonInfo(String lblKey, Tuple<String, String> dataIds) {
        if (("btn_personinfomodify".equals(lblKey) || "btn_personinfosave".equals(lblKey)) && IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), HRJSONUtils.getLongValOfCustomParam((Object)dataIds.item1))) {
            return;
        }
        switch (lblKey) {
            case "btn_personinfomodify": {
                if (!IOnbrdCommonAppService.getInstance().checkPermissionAndShowTips("hom_personbasicinfo", "4715a0df000000ac", this.getView())) {
                    return;
                }
                if (!this.require(dataIds, "hom_onbrdinfo")) break;
                this.updatePageStatusToEdit(OnbrdPanelBtnParamsEnum.PERSON_INFO.getPageNumber(), OnbrdPanelBtnParamsEnum.PERSON_INFO.getTargetKey(), dataIds, OnbrdPanelBtnParamsEnum.PERSON_INFO.getBtnModify(), OnbrdPanelBtnParamsEnum.PERSON_INFO.getBtnSave(), OnbrdPanelBtnParamsEnum.PERSON_INFO.getBtnClose(), true);
                break;
            }
            case "btn_personinfoclose": {
                if (!this.checkCloseChange(OnbrdPanelBtnParamsEnum.PERSON_INFO.getPageNumber(), OnbrdPanelBtnParamsEnum.PERSON_INFO.getTargetKey(), dataIds, OnbrdPanelBtnParamsEnum.PERSON_INFO.getBtnModify(), OnbrdPanelBtnParamsEnum.PERSON_INFO.getBtnClose(), OnbrdPanelBtnParamsEnum.PERSON_INFO.getBtnSave(), true, "hcf_canbaseinfo")) break;
                this.releaseLock(dataIds);
                break;
            }
            case "btn_personinfosave": {
                if (!this.invokeChildOperation(OnbrdPanelBtnParamsEnum.PERSON_INFO.getPageNumber(), "save")) break;
                this.updatePageStatusToView(OnbrdPanelBtnParamsEnum.PERSON_INFO.getPageNumber(), OnbrdPanelBtnParamsEnum.PERSON_INFO.getTargetKey(), dataIds, OnbrdPanelBtnParamsEnum.PERSON_INFO.getBtnModify(), OnbrdPanelBtnParamsEnum.PERSON_INFO.getBtnSave(), OnbrdPanelBtnParamsEnum.PERSON_INFO.getBtnClose(), true);
                this.refreshHeadPage();
                this.releaseLock(dataIds);
                break;
            }
        }
    }

    private boolean require(Tuple<String, String> dataIds, String dataEntityName) {
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)dataIds.item1);
        IHomDataMutexService.getInstance().cleanMutexLockCacheBeforeRequireLock(this.getView(), String.valueOf(onbrdBillId), dataEntityName, "modify");
        return IOnbrdCommonAppService.getInstance().tryRequireLockWithOnbrdBill(onbrdBillId, this.getView(), dataEntityName);
    }

    private void releaseLock(Tuple<String, String> dataIds) {
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)dataIds.item1);
        IOnbrdCommonAppService.getInstance().releaseLockWithOnbrdBill(onbrdBillId, "hom_onbrdinfo");
    }

    private Tuple<String, String> getOnbrdId() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        String candidateId = (String)this.getView().getFormShowParameter().getCustomParam("candidateid");
        return Tuple.create((Object)onbrdId.toString(), (Object)candidateId);
    }

    private void showPersonInfo(Tuple<String, String> dataIds) {
        this.showEmbedPage("hom_cancreshow", HomPageToHcfPageEnum.CERTIFICATED_AP, dataIds, OperationStatus.VIEW, true);
        this.showEmbedPage(HomPageToHcfPageEnum.BANKCARD_AP.getHomPageNumberView(), HomPageToHcfPageEnum.BANKCARD_AP, dataIds, OperationStatus.VIEW, true);
        this.showEmbedPage(HomPageToHcfPageEnum.EDUCATION_AP.getHomPageNumberView(), HomPageToHcfPageEnum.EDUCATION_AP, dataIds, OperationStatus.VIEW, true);
        this.showEmbedPage(HomPageToHcfPageEnum.EMERGENCY_CONTACT_AP.getHomPageNumberView(), HomPageToHcfPageEnum.EMERGENCY_CONTACT_AP, dataIds, OperationStatus.VIEW, true);
        this.showEmbedPage(HomPageToHcfPageEnum.FAMILY_AP.getHomPageNumberView(), HomPageToHcfPageEnum.FAMILY_AP, dataIds, OperationStatus.VIEW, true);
        this.showEmbedPage(HomPageToHcfPageEnum.LANGUAGE_SKILL_AP.getHomPageNumberView(), HomPageToHcfPageEnum.LANGUAGE_SKILL_AP, dataIds, OperationStatus.VIEW, true);
        this.showEmbedPage(HomPageToHcfPageEnum.PREVIOUS_WORK_EXP_AP.getHomPageNumberView(), HomPageToHcfPageEnum.PREVIOUS_WORK_EXP_AP, dataIds, OperationStatus.VIEW, true);
        this.showEmbedPage("hom_rsmpatinv_view", HomPageToHcfPageEnum.RSMPATINV, dataIds, OperationStatus.VIEW, true);
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        String appId = this.getView().getFormShowParameter().getAppId();
        if (onbrdCommonAppService.checkPermission(HomPageToHcfPageEnum.CHECK_INFO_AP.getHomPageNumberView(), "47150e89000000ac", appId)) {
            this.showEmbedBillPage(HomPageToHcfPageEnum.CHECK_INFO_AP.getHomPageNumberView(), HomPageToHcfPageEnum.CHECK_INFO_AP.getTargetKey(), dataIds, OperationStatus.VIEW, "");
            if (!onbrdCommonAppService.checkPermission(HomPageToHcfPageEnum.CHECK_INFO_AP.getHomPageNumberView(), "4715a0df000000ac", appId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{OnbrdPanelBtnParamsEnum.CHECK.getBtnModify()});
            }
            if (!onbrdCommonAppService.checkPermission(HomPageToHcfPageEnum.CHECK_INFO_AP.getHomPageNumberView(), "0=KX5+QVF5+R", appId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{OnbrdPanelBtnParamsEnum.CHECK.getBtnSave()});
            }
        } else {
            logger.info("No PermItem! pageNumber:{}, cardPanelKey:{}", (Object)HomPageToHcfPageEnum.CHECK_INFO_AP.getHomPageNumberView(), (Object)HomPageToHcfPageEnum.CHECK_INFO_AP.getCardPanelKey());
            this.getView().setVisible(Boolean.FALSE, new String[]{HomPageToHcfPageEnum.CHECK_INFO_AP.getCardPanelKey()});
        }
        this.visibleOfPermControl(dataIds, onbrdCommonAppService, HomPageToHcfPageEnum.PERSON_INFO_AP, OnbrdPanelBtnParamsEnum.PERSON_INFO);
        this.visibleOfPermControl(dataIds, onbrdCommonAppService, HomPageToHcfPageEnum.CONTACT_AP, OnbrdPanelBtnParamsEnum.CONTACT);
    }

    private void visibleOfPermControl(Tuple<String, String> dataIds, IOnbrdCommonAppService onbrdCommonAppService, HomPageToHcfPageEnum homPageToHcfPageEnum, OnbrdPanelBtnParamsEnum onbrdPanelBtnParamsEnum) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (onbrdCommonAppService.checkPermission(homPageToHcfPageEnum.getHomPageNumberView(), "47150e89000000ac", appId)) {
            this.showEmbedPage(homPageToHcfPageEnum.getHomPageNumberView(), homPageToHcfPageEnum.getTargetKey(), dataIds, OperationStatus.VIEW);
            if (!onbrdCommonAppService.checkPermission(homPageToHcfPageEnum.getHomPageNumberView(), "4715a0df000000ac", appId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{onbrdPanelBtnParamsEnum.getBtnModify()});
            }
            if (!onbrdCommonAppService.checkPermission(homPageToHcfPageEnum.getHomPageNumberView(), "0=KX5+QVF5+R", appId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{onbrdPanelBtnParamsEnum.getBtnSave()});
            }
        } else {
            logger.info("No PermItem! pageNumber:{}, cardPanelKey:{}", (Object)homPageToHcfPageEnum.getHomPageNumberView(), (Object)homPageToHcfPageEnum.getCardPanelKey());
            this.getView().setVisible(Boolean.FALSE, new String[]{homPageToHcfPageEnum.getCardPanelKey()});
        }
    }

    private void showEntryBaseInfo(String pageNumber, String targetKey, Long onbrdId, String billNo) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.setCustomParam("id", (Object)onbrdId);
        formShowParameter.setCustomParam("billno", (Object)billNo);
        formShowParameter.setFormId(pageNumber);
        formShowParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(formShowParameter);
    }

    private void refreshHeadPage() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        this.showEntryBaseInfo("hom_onbrdpersoninfohead", "persononbrdhead", onbrdId, "");
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)actionId, (String)BTN_CLOSE) && MessageBoxResult.Yes == resultValue) {
            this.getView().close();
        }
    }
}

