/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.application.impl.onbrd.OnbrdStartUpAppServiceImpl;

public class OnbrdStartupPlugin
extends HRDataBaseList {
    private static final String STARTUP_FLOW = "startupflow";
    private static final String STARTUP_CLOSE = "startupClose";
    private static final String DELETE_CUSTOM = "delete_custom";

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)STARTUP_CLOSE) && closedCallBackEvent.getReturnData() instanceof List) {
            List successIds = (List)closedCallBackEvent.getReturnData();
            new OnbrdStartUpAppServiceImpl().closedCallBack(this.getView(), successIds);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IFormView formView;
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)STARTUP_FLOW, (String)opKey) && (HRObjectUtils.isEmpty((Object)afterDoOperationEventArgs.getOperationResult()) || afterDoOperationEventArgs.getOperationResult().isSuccess())) {
            if (this.getSelectedRows().isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u542f\u52a8\u5165\u804c\u6d41\u7a0b\u7684\u4eba\u5458\u3002", (String)"OnbrdStartupPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            Set onbrdIds = Arrays.stream(this.getSelectedRows().getPrimaryKeyValues()).map(onbrdId -> Long.valueOf(onbrdId.toString())).collect(Collectors.toSet());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, STARTUP_CLOSE);
            new OnbrdStartUpAppServiceImpl().showStartupConfirmPage(onbrdIds, this.getView(), closeCallBack);
        } else if (HRStringUtils.equals((String)DELETE_CUSTOM, (String)opKey) && afterDoOperationEventArgs.getOperationResult().isSuccess() && (formView = this.getView()) instanceof IListView) {
            IListView listView = (IListView)formView;
            listView.refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        List onbrdIds = Arrays.stream(this.getSelectedRows().getPrimaryKeyValues()).map(onbrdId -> Long.valueOf(onbrdId.toString())).collect(Collectors.toList());
        if (HRStringUtils.equals((String)STARTUP_CLOSE, (String)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            Long onbrdId2 = (Long)onbrdIds.get(0);
            new OnbrdStartUpAppServiceImpl().closedCallBack(this.getView(), (List)ImmutableList.of((Object)onbrdId2));
        }
    }
}

