/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdBreakupAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IRepealOnbrdConfirmService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.business.domain.service.hpfs.IHpfsDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.DataDiv;
import kd.hr.hom.formplugin.web.personmange.OnbrdBreakupEdit;

public class RepealOnbrdConfirmEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(OnbrdBreakupEdit.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"RepealOnbrdConfirmEdit", (int)5, (int)1000);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btn_confirm"});
        BasedataEdit reasonBasedataEdit = (BasedataEdit)this.getView().getControl("repealreason");
        BasedataEdit typeBasedataEdit = (BasedataEdit)this.getView().getControl("repealtype");
        typeBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        reasonBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObject repealReasonDy;
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (HRStringUtils.equals((String)"repealtype", (String)event.getProperty().getName())) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u64a4\u56de\u7c7b\u578b", (String)"RepealOnbrdConfirmEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel dataModel = this.getModel();
        DynamicObject repealTypeDy = dataModel.getDataEntity().getDynamicObject("repealtype");
        if (Objects.nonNull(repealTypeDy)) {
            long repealTypeId = repealTypeDy.getLong("id");
            QFilter typeFilter = new QFilter("breakuptype", "=", (Object)repealTypeId);
            showParameter.getListFilterParameter().getQFilters().add(typeFilter);
        }
        if (Objects.nonNull(repealReasonDy = dataModel.getDataEntity().getDynamicObject("repealreason"))) {
            long repealReasonId = repealReasonDy.getLong("id");
            QFilter reasonFilter = new QFilter("id", "!=", (Object)repealReasonId);
            showParameter.getListFilterParameter().getQFilters().add(reasonFilter);
        }
        showParameter.setCaption(ResManager.loadKDString((String)"\u64a4\u56de\u539f\u56e0", (String)"RepealOnbrdConfirmEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String name = propertyChangedArgs.getProperty().getName();
        if (HRStringUtils.equals((String)"repealtype", (String)name)) {
            Object newValue = propertyChangedArgs.getChangeSet()[0].getNewValue();
            Object oldValue = propertyChangedArgs.getChangeSet()[0].getOldValue();
            DynamicObject breakupTypeDy = this.getModel().getDataEntity().getDynamicObject("repealtype");
            if (HRObjectUtils.isEmpty((Object)breakupTypeDy)) {
                this.getModel().setValue("repealreason", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{"repealreason"});
                return;
            }
            if (!newValue.equals(oldValue)) {
                this.getModel().setValue("repealreason", null);
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"repealreason"});
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getView().setEnable(Boolean.FALSE, new String[]{"repealreason"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (HRStringUtils.equals((String)"confirm", (String)args.getOperateKey()) && null != operationResult && operationResult.isSuccess()) {
            boolean checkPermResult = IOnbrdCommonAppService.getInstance().checkPermissionAndShowTips("hom_personhasonbrd", "03LX7W=NY=F2", this.getView());
            if (!checkPermResult) {
                return;
            }
            Long onbrdBillId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            List<Long> onbrdIds = Collections.singletonList(onbrdBillId);
            DynamicObject[] onbrdBills = this.queryOnbrdBill(onbrdIds);
            DynamicObject onbrdBill = onbrdBills[0];
            logger.info("###RepealOnbrdConfirmEdit.afterDoOperation validStatusAndProcessBill");
            DataDiv dataDiv = IRepealOnbrdConfirmService.getInstance().validStatusAndProcessBill(onbrdBill);
            if (dataDiv.hasErrMsg()) {
                this.getView().showErrorNotification(dataDiv.getFirstErrMsg());
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject repealType = dataEntity.getDynamicObject("repealtype");
            DynamicObject repealReason = dataEntity.getDynamicObject("repealreason");
            String repealRemarks = dataEntity.getString("repealremarks");
            IHomDataMutexService homDataMutexService = IHomDataMutexService.getInstance();
            Map batchRequireResult = homDataMutexService.batchRequire(onbrdIds, "hom_onbrdinfo", "hom_repealonbrdconfirm");
            List failLockIds = batchRequireResult.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
            List successLockIds = batchRequireResult.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            IFormView parentView = this.getView().getParentView();
            try {
                if (!CollectionUtils.isEmpty(failLockIds)) {
                    IOnbrdCommonAppService.getInstance().showMutexMsgWithOnbrdBill(this.getView(), failLockIds, ResManager.loadKDString((String)"\u5165\u804c\u64a4\u56de", (String)"RepealOnbrdConfirmEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object employeeId = dataDiv.getContextParam("employeeId");
                if (!HRObjectUtils.isEmpty((Object)employeeId)) {
                    dataDiv.addContextParam("depempInfo", (Object)this.getHrpiDepempByEmployeeId((Long)employeeId));
                }
                long billId = onbrdBill.getLong("id");
                long chgActionId = onbrdBill.getLong("affaction.id");
                String billNo = onbrdBill.getString("billno");
                logger.info("###RepealOnbrdConfirmEdit after baterminateOrDeleteTask");
                Map terminateResult = IHomToHrcsAppService.getInstance().terminateOrDeleteTask(onbrdIds);
                if (!Boolean.TRUE.toString().equals(terminateResult.get("success"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u5165\u804c\u64a4\u56de\u5931\u8d25\uff0c\u539f\u56e0\u662f\u8be5\u5165\u804c\u6d41\u7a0b\u4e2d\u5b58\u5728\u5171\u4eab\u4efb\u52a1\u7ec8\u6b62\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"RepealOnbrdConfirmEdit_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    return;
                }
                logger.info("###RepealOnbrdConfirmEdit.afterDoOperation dataRollback");
                String msg = IHpfsDataDomainService.getInstance().dataRollback(Long.valueOf(billId), Long.valueOf(chgActionId), billNo);
                if (HRStringUtils.isNotEmpty((String)msg)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\u3002", (String)"RepealOnbrdConfirmEdit_6", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    return;
                }
                logger.info("###RepealOnbrdConfirmEdit before doSomethingsWithBreakup");
                IOnbrdBreakupAppService.getInstance().doSomethingsWithBreakup(Collections.singletonList(onbrdBillId), repealType, repealReason, repealRemarks, null);
                logger.info("###RepealOnbrdConfirmEdit after doSomethingsWithBreakup");
                THREAD_POOL.execute(() -> IRepealOnbrdConfirmService.getInstance().callRpcService(dataDiv), RequestContext.getOrCreate());
            }
            finally {
                homDataMutexService.batchRelease(successLockIds, "hom_onbrdinfo", "hom_repealonbrdconfirm");
            }
            if (parentView instanceof IListView) {
                String desc = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"RepealOnbrdConfirmEdit_4", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                parentView.showSuccessNotification(desc);
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
            }
            this.getView().close();
        }
    }

    private DynamicObject getHrpiDepempByEmployeeId(Long employeeId) {
        QFilter qFilter = new QFilter("employee_id", "=", (Object)employeeId);
        qFilter.and("iscurrentversion", "=", (Object)"1");
        qFilter.and("businessstatus", "=", (Object)"1");
        Object[] depemps = IHomToHrpiAppService.getInstance().listFieldsFilterInfo("id,cmpemp,person", qFilter, "hrpi_depemp");
        if (HRArrayUtils.isEmpty((Object[])depemps)) {
            return null;
        }
        return depemps[0];
    }

    private DynamicObject[] queryOnbrdBill(List<Long> ids) {
        String selectProperties = String.join((CharSequence)",", "id", "billno", "enrollstatus", "synchstatus", "candidate", "affaction.id", "affrecord", "laborrelstatus");
        QFilter qFilter = new QFilter("id", "in", ids);
        return IOnbrdBillDomainService.getInstance().findOnbrdBills(selectProperties, qFilter.toArray());
    }
}

