/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import java.util.Collection;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.onbrd.IRepealOnbrdConfirmService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.DataDiv;

public class RepealOnbrdConfirmPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(RepealOnbrdConfirmPlugin.class);
    public static final String SELECT_PROPERTIES = String.join((CharSequence)",", "id", "billno", "enrollstatus", "synchstatus", "candidate");

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IListView listview;
        ListSelectedRowCollection selectedRows;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        if ("repealconfirm".equals(source.getOperateKey()) && HRCollUtil.isNotEmpty((Collection)(selectedRows = (listview = (IListView)this.getView()).getSelectedRows())) && selectedRows.size() > 1) {
            String msg = ResManager.loadKDString((String)"\u4e3a\u9632\u6b62\u8bef\u64cd\u4f5c\uff0c\u64a4\u56de\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c", (String)"OnbrdRepealConfirmPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        String opKey = args.getOperateKey();
        if ("repealconfirm".equals(opKey) && (Objects.isNull(opResult) || opResult.isSuccess())) {
            this.doRepealconfirm();
        }
    }

    private void doRepealconfirm() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        Object[] onbrdIds = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)onbrdIds);
        Object[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills(SELECT_PROPERTIES, qFilter.toArray());
        if (HRArrayUtils.isNotEmpty((Object[])onbrdBills)) {
            Object onbrdBill = onbrdBills[0];
            DataDiv dataDiv = IRepealOnbrdConfirmService.getInstance().validStatusAndProcessBill((DynamicObject)onbrdBill);
            if (dataDiv.hasErrMsg()) {
                this.getView().showErrorNotification(dataDiv.getFirstErrMsg());
                return;
            }
            if (dataDiv.hasTipMsg()) {
                this.getView().showConfirm(dataDiv.getFirstTipMsg(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("repealconfirm", (IFormPlugin)this));
                return;
            }
        }
        this.showOnbrdRepealConfirmPage();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("repealconfirm".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.showOnbrdRepealConfirmPage();
        }
    }

    private void showOnbrdRepealConfirmPage() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        Object[] onbrdIds = selectedRows.getPrimaryKeyValues();
        if (HRArrayUtils.isEmpty((Object[])onbrdIds) || onbrdIds.length > 1) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_repealonbrdconfirm");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("id", onbrdIds[0]);
        this.getView().showForm(formShowParameter);
    }
}

