/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.cvp.IHomToCvpAppService;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.extension.PersonInfoExService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.entity.ocr.AlgoResultData;
import kd.hr.hom.common.util.PutValueToModelUtils;
import kd.hr.hom.formplugin.web.base.HomDataBaseEdit;
import kd.hr.hom.formplugin.web.personmange.personinfo.CanFamilyEditPlugin;
import kd.sdk.hr.hom.business.personinfo.IBankCardService;
import kd.sdk.hr.hom.business.personinfo.IBasePeronInfoService;

public class BankCardEditPlugin
extends HomDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(CanFamilyEditPlugin.class);
    private static final String BTN_SAVE = "btn_save";
    private String CANBANK_PROPERTIES = "name,account,bankdeposit,socialrel,description,cardface,purposemulbase";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String status = formShowParameter.getStatus().name();
        if (HRStringUtils.equals((String)status, (String)"VIEW")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE});
        }
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("candidateid"));
        this.getView().getModel().setValue("candidate", (Object)candidateId);
        Long maidId = (Long)formShowParameter.getCustomParam("id");
        if (!HRObjectUtils.isEmpty((Object)maidId)) {
            Set exFields = PersonInfoExService.getExFields((IFormView)this.getView());
            if (!CollectionUtils.isEmpty((Collection)exFields)) {
                this.CANBANK_PROPERTIES = this.CANBANK_PROPERTIES + "," + String.join((CharSequence)",", exFields);
            }
            HashMap<String, String> entityFields = new HashMap<String, String>(2);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IBankCardService.class, (String)"kd.sdk.hr.hom.business.personinfo.IBankCardService", null);
            hrPluginProxy.callReplace(IBasePeronInfoService::getExtProperties).forEach(fieldStr -> {
                this.CANBANK_PROPERTIES = fieldStr;
            });
            entityFields.put("hcf_canbankcard", this.CANBANK_PROPERTIES);
            Map map = IHomToHcfAppService.getInstance().getCandidate(candidateId, entityFields, Long.valueOf(0L));
            DynamicObjectCollection canFamilyCollection = (DynamicObjectCollection)map.get("hcf_canbankcard");
            for (DynamicObject obj : canFamilyCollection) {
                if (obj.getLong("id") != maidId.longValue()) continue;
                PutValueToModelUtils.putValueToModel((IFormView)this.getView(), (DynamicObject)obj, (String[])this.CANBANK_PROPERTIES.split(","));
                if (this.getModel().getValue("socialrel") == null) {
                    this.getModel().setValue("socialrel", (Object)IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_payrollacrelation", BaseDataIdConstants.HBSS_PAYROLLACRELATION_1010, "number"));
                }
                break;
            }
        } else {
            this.getModel().setValue("socialrel", (Object)IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_payrollacrelation", BaseDataIdConstants.HBSS_PAYROLLACRELATION_1010, "number"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "cardface": {
                Object newValObj;
                if (e.getChangeSet() == null || e.getChangeSet().length <= 0 || HRObjectUtils.isEmpty((Object)(newValObj = e.getChangeSet()[0].getNewValue()))) break;
                String newValStr = newValObj.toString();
                if (!IHomToCvpAppService.getInstance().isEnableOcr(this.getView()).booleanValue()) break;
                this.setBankOcr(newValStr);
                break;
            }
            case "account": {
                if (HRStringUtils.isEmpty((String)this.getModel().getDataEntity().getString("account"))) break;
                String account = this.getModel().getDataEntity().getString("account");
                Optional accoutOp = IOnbrdCommonAppService.getInstance().checkAccount(account);
                if (!accoutOp.isPresent()) break;
                this.getView().showTipNotification((String)accoutOp.get());
                break;
            }
        }
    }

    private void setBankOcr(String newValStr) {
        this.getView().showLoading(ResManager.getLocaleString((String)"OCR\u6587\u672c\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"InfoGroupDynViewMobilePlugin_10", (String)"hr-hom-formplugin"));
        try {
            AlgoResultData resData = IHomToCvpAppService.getInstance().distinguishOcrImage("hcf_canbankcard", "OPM-BankCard", newValStr);
            LOGGER.info("===resData.errorCode:{}===", (Object)resData.getErrorCode());
            LOGGER.info("===resData.description:{}==", (Object)resData.getDescription());
            this.getView().hideLoading();
            if (resData.getErrorCode() != 0) {
                if (HRStringUtils.isEmpty((String)resData.getDescription())) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u672a\u8bc6\u522b\u5230\u6587\u672c\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u624b\u52a8\u8f93\u5165\u3002", (String)"Ocrcomn_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(resData.getDescription());
                }
            } else if (resData.getData() == null) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u672a\u8bc6\u522b\u5230\u6587\u672c\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u624b\u52a8\u8f93\u5165\u3002", (String)"Ocrcomn_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            } else {
                JSONObject obj = (JSONObject)resData.getData();
                if (HRStringUtils.isEmpty((String)obj.getString("cardNo"))) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u672a\u8bc6\u522b\u5230\u6587\u672c\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u624b\u52a8\u8f93\u5165\u3002", (String)"Ocrcomn_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadResFormat((String)"\u94f6\u884c\u5361\u5185\u5bb9\u8bc6\u522b\u6210\u529f\u3002", (String)"Bankcard_11", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                if (HRStringUtils.isEmpty((String)this.getModel().getDataEntity().getString("account"))) {
                    String cardNo = obj.getString("cardNo").replaceAll(" ", "");
                    this.getModel().setValue("account", (Object)cardNo);
                }
            }
        }
        catch (Exception exp) {
            LOGGER.error("===ocr bankcard err ===", (Throwable)exp);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"OCR\u8bc6\u522b\u94f6\u884c\u5361\u53f7\u5931\u8d25\u3002", (String)"Bankcard_6", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isAlreadyClose = this.getPageCache().get("isalreadyclose");
        if (this.getModel().getDataChanged() && HRStringUtils.isEmpty((String)isAlreadyClose)) {
            e.setCancel(true);
            this.clickCancelChanged("cancel");
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (HRStringUtils.equalsIgnoreCase((String)status.name(), (String)"VIEW")) {
                return;
            }
            Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            IOnbrdCommonAppService.getInstance().releaseLockByHCF(id, "hcf_canbankcard", "modify");
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_SAVE});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.checkDataValidate(args);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        if (!IHomToCvpAppService.getInstance().isEnableOcr().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ocrtip"});
        }
        this.getView().getModel().getDataEntity().getDataEntityState().setFromDatabase(true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (success && BTN_SAVE.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.updateOrSaveCanBankInfo();
            this.updateCanBankView();
        }
    }

    public void checkDataValidate(BeforeDoOperationEventArgs args) {
        Optional accoutOp;
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        if (IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
            args.setCancel(true);
            return;
        }
        DynamicObject dyo = this.getModel().getDataEntity();
        String errMsg = "";
        if (Objects.isNull(dyo)) {
            errMsg = ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728", (String)"Bankcard_3", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            args.setCancel(true);
        }
        String account = "";
        if (!Objects.isNull(dyo) && !Objects.isNull(dyo.getString("account"))) {
            account = dyo.getString("account");
        }
        if ((accoutOp = IOnbrdCommonAppService.getInstance().checkAccount(account)).isPresent()) {
            this.getView().showTipNotification((String)accoutOp.get());
            args.setCancel(true);
        }
    }

    private void updateCanBankView() {
        this.getPageCache().put("isalreadyclose", "1");
        if (HRStringUtils.equals((String)"hom_bankcard_show", (String)((String)this.getView().getFormShowParameter().getCustomParam("hom_bankcard_show")))) {
            this.getView().getParentView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView().getParentView());
            this.getView().close();
        } else {
            this.getView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    private void updateOrSaveCanBankInfo() {
        DynamicObject personBaseDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canbankcard"));
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        id = Optional.ofNullable(id).orElseGet(() -> ORM.create().genLongId("hcf_canbankcard"));
        personBaseDy.set("id", (Object)id);
        personBaseDy.set("candidate", this.getView().getModel().getValue("candidate"));
        personBaseDy.set("cardface", this.getView().getModel().getValue("cardface"));
        personBaseDy.set("name", this.getView().getModel().getValue("name"));
        personBaseDy.set("account", this.getView().getModel().getValue("account"));
        personBaseDy.set("bankdeposit", this.getView().getModel().getValue("bankdeposit"));
        personBaseDy.set("socialrel", this.getView().getModel().getValue("socialrel"));
        personBaseDy.set("description", this.getView().getModel().getValue("description"));
        personBaseDy.set("purposemulbase", this.getView().getModel().getValue("purposemulbase"));
        PersonInfoExService.setExFieldValue((IFormView)this.getView(), (DynamicObject)personBaseDy);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IBankCardService.class, (String)"kd.sdk.hr.hom.business.personinfo.IBankCardService", null);
        hrPluginProxy.callReplace(p -> {
            p.setDataModel(personBaseDy, this.getView().getModel());
            return null;
        });
        HashMap entities = Maps.newHashMapWithExpectedSize((int)1);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)personBaseDy);
        entities.put(personBaseDy.getLong("candidate.id"), collection);
        IHomToHcfAppService.getInstance().saveMultiRowEntityWithoutDelete((Map)entities, "hcf_canbankcard");
    }
}

