/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.web.base.HcfDataBaseEdit;
import kd.sdk.hr.hom.business.personinfo.ICanFamilyService;

public class CanFamilyShowPlugin
extends HcfDataBaseEdit {
    private static final Log logger = LogFactory.getLog(CanFamilyShowPlugin.class);
    private static final String BTN_EDIT = "btn_edit";
    private static final String BTN_DEL = "btn_del";
    private static final String CANFAMILYTITLE = "canfamilytitle";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParamsmap = showParameter.getCustomParams();
        String msg = ResManager.loadKDString((String)"\u5bb6\u5ead\u6210\u5458", (String)"CanFamilyEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        IDataModel dataModel = this.getView().getModel();
        String ship = (String)customParamsmap.get("familymembship");
        if (HRStringUtils.isEmpty((String)ship)) {
            dataModel.setValue("name", customParamsmap.get("name"));
        } else {
            dataModel.setValue("name", (Object)(customParamsmap.get("name") + "(" + customParamsmap.get("familymembship") + ")"));
        }
        dataModel.setValue("mobilephone", customParamsmap.get("mobilephone"));
        dataModel.setValue("country", customParamsmap.get("country"));
        dataModel.setValue(CANFAMILYTITLE, (Object)(msg + customParamsmap.get("index")));
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, kd.hr.hom.business.application.extension.ICanFamilyService.class, (String)"", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.setViewModel(dataModel, customParamsmap);
            return null;
        });
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create(null, ICanFamilyService.class, (String)"", null);
        hrPluginProxySdk.callReplace(hrPlugin -> {
            hrPlugin.setViewModel(dataModel, customParamsmap);
            return null;
        });
        this.isEnrolled(customParamsmap.get("onbrdid"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if (BTN_EDIT.equals(operate.getOperateKey())) {
            String appId = this.getView().getFormShowParameter().getAppId();
            if (IOnbrdCommonAppService.getInstance().checkPermission("hom_canfamily_show", "4715a0df000000ac", appId) || IOnbrdCommonAppService.getInstance().checkPermission("hom_canfamily_view", "4715a0df000000ac", appId)) {
                this.editCanFamilyPage(OperationStatus.EDIT);
            } else {
                this.editCanFamilyPage(OperationStatus.VIEW);
            }
        }
        if (BTN_DEL.equals(operate.getOperateKey())) {
            this.delCanFamilyPage(this.getView().getFormShowParameter().getCustomParam("id").toString());
        }
        if ("btn_view".equals(operate.getOperateKey())) {
            this.editCanFamilyPage(OperationStatus.VIEW);
        }
    }

    private void isEnrolled(Object onbrd) {
        if (onbrd instanceof Long) {
            boolean isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled((Long)onbrd);
            if (isEnroll) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"editanddeleteap"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"viewap"});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)actionId, (String)BTN_DEL) && MessageBoxResult.Yes == resultValue) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String conContactId = pageCache.get("canFamilyId");
            try {
                Map result = IHomToHcfAppService.getInstance().deleteById(Long.valueOf(conContactId), "hcf_canfamily");
                Boolean success = (Boolean)result.get("success");
                if (success.booleanValue()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"CanFamilyEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    this.getView().getParentView().updateView();
                    this.getView().sendFormAction(this.getView().getParentView());
                } else {
                    this.getView().showErrorNotification((String)result.get("message"));
                }
            }
            finally {
                IOnbrdCommonAppService.getInstance().releaseLockByHCF(Long.valueOf(conContactId), "hcf_canfamily", "delete");
            }
        }
    }

    private void delCanFamilyPage(String id) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        if (!this.checkDataIsExistById(Long.valueOf(id), candidateId)) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u5bb6\u5ead\u6210\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CanFamilyEdit_4", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        if (!this.getRequireLock(Long.valueOf(id), "delete")) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u8bb0\u5f55\uff1f", (String)"CanFamilyEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_DEL, (IFormPlugin)this));
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("canFamilyId", id);
    }

    private boolean checkDataIsExistById(Long id, Long candidateId) {
        DynamicObjectCollection coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, "hcf_canfamily");
        return !CollectionUtils.isEmpty((Collection)coll);
    }

    private void editCanFamilyPage(OperationStatus operationStatus) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        if (!this.checkDataIsExistById(id, candidateId)) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u5bb6\u5ead\u6210\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CanFamilyEdit_4", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(operationStatus);
        if (HRStringUtils.equals((String)OperationStatus.EDIT.name(), (String)operationStatus.name()) && !this.getRequireLock(id, "modify")) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        formShowParameter.setCustomParam("onbrdid", (Object)onbrdBillId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_canfamily_edit");
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("id", (Object)id);
        formShowParameter.setCustomParam("hom_canfamily_show", (Object)"hom_canfamily_show");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5bb6\u5ead\u6210\u5458", (String)"CanFamilyEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private boolean getRequireLock(Long id, String opKey) {
        return IOnbrdCommonAppService.getInstance().tryRequireLockByHCF(this.getView(), id, "hcf_canfamily", opKey);
    }
}

