/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.OnbrdNullPageServiceImpl;
import kd.hr.hom.business.application.impl.page.PanelApAdatper;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.web.base.HcfDataBaseEdit;
import kd.sdk.hr.hom.business.personinfo.ICanFamilyService;

public class CanFamilyViewPlugin
extends HcfDataBaseEdit {
    private static final String BTN_ADD = "btn_add";
    private static final String FLEXPANELAP1 = "flexpanelap1";
    private static final String KEY_ONBRDNULLPAGE = "onbrdnullpage";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        this.isEnrollStatus(onbrdBillId, this.getView());
        this.refreshCanFamilyData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if (BTN_ADD.equals(operate.getOperateKey())) {
            this.addCanFamilyView();
        }
    }

    private void addCanFamilyView() {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hom_canfamily_edit"));
        formShowParameter.setFormId("hom_canfamily_edit");
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("onbrdid", this.getView().getFormShowParameter().getCustomParam("id"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5bb6\u5ead\u6210\u5458", (String)"CanFamilyEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void refreshCanFamilyData() {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        DynamicObjectCollection canFamilyInfos = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_canfamily");
        if (CollectionUtils.isEmpty((Collection)canFamilyInfos)) {
            new OnbrdNullPageServiceImpl().loadOnbrdNullPage(this.getView());
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ONBRDNULLPAGE});
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP1});
        this.showUpCanFamilyView(canFamilyInfos, candidateId);
    }

    private void showUpCanFamilyView(DynamicObjectCollection canFamilyCollecttion, Long candidateId) {
        List canFamilyInfos = canFamilyCollecttion.stream().sorted(Comparator.comparing(dyo -> dyo.getDate("createtime"), Comparator.naturalOrder())).collect(Collectors.toList());
        FlexPanelAp allcanFamilyPanel = this.generateCanFamilyPanel(FLEXPANELAP1);
        for (int i = 0; i < canFamilyInfos.size(); ++i) {
            DynamicObject canFamilyInfo = (DynamicObject)canFamilyInfos.get(i);
            PanelApAdatper canFamilyPanelStyleAdapter = new PanelApAdatper("canFamilyPanel" + i){

                public void setStyle() {
                    this.panelAp.setWidth(new LocaleString("340px"));
                    this.panelAp.setHeight(new LocaleString("120px"));
                    this.panelAp.setGrow(0);
                    this.panelAp.setShrink(0);
                }
            };
            Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("canFamilyPanel" + i);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setFormId("hom_canfamily_show");
            formShowParameter.setCustomParams(this.getCanFamilyParams(canFamilyInfo));
            formShowParameter.setCustomParam("index", (Object)(i + 1 + ""));
            formShowParameter.setCustomParam("candidateid", (Object)candidateId);
            formShowParameter.setCustomParam("onbrdid", (Object)onbrdId);
            formShowParameter.setCustomParam("id", canFamilyInfo.get("id"));
            this.getView().showForm(formShowParameter);
            allcanFamilyPanel.getItems().add(canFamilyPanelStyleAdapter.getPanelAp());
        }
        this.getView().updateControlMetadata(allcanFamilyPanel.getKey(), allcanFamilyPanel.createControl());
    }

    private Map<String, Object> getCanFamilyParams(DynamicObject canFamilyInfo) {
        HashMap customParamsmap = Maps.newHashMapWithExpectedSize((int)6);
        String name = canFamilyInfo.getString("name");
        customParamsmap.put("name", name);
        String mobilephone = canFamilyInfo.getString("mobilephone");
        customParamsmap.put("mobilephone", mobilephone);
        DynamicObject familymembship = canFamilyInfo.getDynamicObject("familymembship");
        customParamsmap.put("familymembship", HRObjectUtils.isEmpty((Object)familymembship) ? "" : familymembship.getString("name"));
        String contactaddr = canFamilyInfo.getString("contactaddr");
        customParamsmap.put("contactaddr", contactaddr);
        DynamicObject country = canFamilyInfo.getDynamicObject("country");
        customParamsmap.put("country", HRObjectUtils.isEmpty((Object)country) ? "" : country.getString("name"));
        String workunit = canFamilyInfo.getString("workunit");
        customParamsmap.put("workunit", workunit);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, kd.hr.hom.business.application.extension.ICanFamilyService.class, (String)"kd.hr.hom.business.application.extension.ICanFamilyService", null);
        hrPluginProxy.callReplace(canFamilyService -> {
            canFamilyService.setCustomParamsMap(customParamsmap, canFamilyInfo);
            return null;
        });
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create(null, ICanFamilyService.class, (String)"kd.sdk.hr.hom.business.personinfo.ICanFamilyService", null);
        hrPluginProxySdk.callReplace(canFamilyService -> {
            canFamilyService.setCustomParamsMap(customParamsmap, canFamilyInfo);
            return null;
        });
        return customParamsmap;
    }

    private FlexPanelAp generateCanFamilyPanel(String panelKey) {
        PanelApAdatper mainPanelApt = new PanelApAdatper(panelKey){

            public void setStyle() {
                this.panelAp.setGrow(0);
                this.panelAp.setShrink(1);
                this.panelAp.setAlignSelf("stretch");
            }
        };
        return mainPanelApt.getPanelAp();
    }

    private boolean isEnrollStatus(Long onbrdId, IFormView view) {
        boolean isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        if (isEnroll) {
            view.setVisible(Boolean.FALSE, new String[]{BTN_ADD});
            return true;
        }
        return false;
    }
}

