/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.web.base.HcfDataBaseEdit;
import kd.sdk.hr.hom.business.personinfo.ICancontactService;

public class CancontactShowPlugin
extends HcfDataBaseEdit {
    private static Log logger = LogFactory.getLog(CancontactShowPlugin.class);
    private static final String KEY_EMRGCONTACTITLE = "emrgcontactitle";
    private static final String BTN_EDIT = "btn_edit";
    private static final String BTN_DEL = "btn_del";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String msg = ResManager.loadKDString((String)"\u7d27\u6025\u8054\u7cfb\u4eba", (String)"CanContactEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        Map customParamsmap = showParameter.getCustomParams();
        IDataModel dataModel = this.getView().getModel();
        String ship = (String)customParamsmap.get("emrgrelation");
        if (HRStringUtils.isEmpty((String)ship)) {
            dataModel.setValue("emrgname", customParamsmap.get("emrgname"));
        } else {
            dataModel.setValue("emrgname", (Object)(customParamsmap.get("emrgname") + "(" + ship + ")"));
        }
        dataModel.setValue("emrgphone", customParamsmap.get("emrgphone"));
        dataModel.setValue("country", customParamsmap.get("country"));
        dataModel.setValue(KEY_EMRGCONTACTITLE, (Object)(msg + customParamsmap.get("index")));
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ICancontactService.class, (String)"kd.sdk.hr.hom.business.personinfo.ICancontactService", null);
        hrPluginProxy.callReplace(p -> {
            p.setViewModel(this.getModel(), customParamsmap);
            return null;
        });
        this.isEnrolled(customParamsmap.get("onbrdid"));
    }

    private void isEnrolled(Object onbrd) {
        if (onbrd instanceof Long) {
            boolean isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled((Long)onbrd);
            if (isEnroll) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"editanddeleteap"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"viewap"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (BTN_EDIT.equals(operate.getOperateKey())) {
            String appId = this.getView().getFormShowParameter().getAppId();
            if (IOnbrdCommonAppService.getInstance().checkPermission("hom_emergencycontact_show", "4715a0df000000ac", appId)) {
                this.editCanContactPage(OperationStatus.EDIT);
            } else {
                this.editCanContactPage(OperationStatus.VIEW);
            }
        }
        if (BTN_DEL.equals(operate.getOperateKey())) {
            this.delCanContactPage(this.getView().getFormShowParameter().getCustomParam("id").toString());
        }
        if ("btn_view".equals(operate.getOperateKey())) {
            this.editCanContactPage(OperationStatus.VIEW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)actionId, (String)BTN_DEL) && MessageBoxResult.Yes == resultValue) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String conContactId = pageCache.get("conContactId");
            try {
                Map result = IHomToHcfAppService.getInstance().deleteById(Long.valueOf(conContactId), "hcf_cancontact");
                Boolean success = (Boolean)result.get("success");
                if (success.booleanValue()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"CanContactEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    this.getView().getParentView().updateView();
                    this.getView().sendFormAction(this.getView().getParentView());
                } else {
                    this.getView().showErrorNotification((String)result.get("message"));
                }
            }
            finally {
                IOnbrdCommonAppService.getInstance().releaseLockByHCF(Long.valueOf(conContactId), "hcf_cancontact", "delete");
            }
        }
    }

    private void delCanContactPage(String id) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        Long pkId = Long.valueOf(id);
        if (!this.checkDataIsExistById(pkId, candidateId)) {
            String errMsg = ResManager.loadKDString((String)"\u7d27\u6025\u8054\u7cfb\u4eba\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CanContactEdit_4", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        if (!this.getRequireLock(pkId, "delete")) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u8bb0\u5f55\uff1f", (String)"CanContactEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_DEL, (IFormPlugin)this));
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("conContactId", id);
    }

    private void editCanContactPage(OperationStatus operationStatus) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(operationStatus);
        if (!this.checkDataIsExistById(id, candidateId)) {
            String errMsg = ResManager.loadKDString((String)"\u7d27\u6025\u8054\u7cfb\u4eba\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CanContactEdit_4", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        if (HRStringUtils.equals((String)OperationStatus.EDIT.name(), (String)operationStatus.name()) && !this.getRequireLock(id, "modify")) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        formShowParameter.setCustomParam("onbrdid", (Object)onbrdBillId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_emergencycontact_edit");
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("id", (Object)id);
        formShowParameter.setCustomParam("hom_emergencycontact_show", (Object)"hom_emergencycontact_show");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7d27\u6025\u8054\u7cfb\u4eba", (String)"CanContactEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private boolean checkDataIsExistById(Long id, Long candidateId) {
        DynamicObjectCollection coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, "hcf_cancontact");
        return !CollectionUtils.isEmpty((Collection)coll);
    }

    private boolean getRequireLock(Long id, String opKey) {
        return IOnbrdCommonAppService.getInstance().tryRequireLockByHCF(this.getView(), id, "hcf_cancontact", opKey);
    }
}

