/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.impl.page.CertificatePageServiceImpl;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.formplugin.web.base.HcfDataBaseEdit;

public class CertificateShowEdit
extends HcfDataBaseEdit {
    private static final String BTN_ADD = "btn_add";
    private static final String KEY_CERTIFICATEDPANEL = "certificatedpanel";

    public void afterCreateNewData(EventObject eventObject) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        this.generateViewForEnrollStatus(onbrdBillId, this.getView(), BTN_ADD);
        new CertificatePageServiceImpl().generateCreCardsView(this.getView(), KEY_CERTIFICATEDPANEL, candidateId, onbrdBillId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if (BTN_ADD.equals(operate.getOperateKey())) {
            this.addCertificate();
        }
    }

    private boolean generateViewForEnrollStatus(Long onbrdId, IFormView view, String ... btnStrs) {
        if (this.isEnrolled(onbrdId).booleanValue()) {
            view.setVisible(Boolean.FALSE, btnStrs);
            return true;
        }
        return false;
    }

    private Boolean isEnrolled(Long onbrdId) {
        DynamicObject onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBillById("enrollstatus", (Object)onbrdId);
        if (!HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            String enrollStatus = onbrdBillInfo.getString("enrollstatus");
            if (HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.toString(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.toString(), (String)enrollStatus)) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private void addCertificate() {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        if (candidateId == null || onbrdBillId == null) {
            this.getView().showErrorNotification("Cannot addCertificate without onbrdbill");
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setHasRight(true);
        formShowParameter.setFormId("hom_cancreinfo_edit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hcf_cancre"));
        formShowParameter.setCustomParam("candidate", (Object)candidateId.toString());
        formShowParameter.setCustomParam("onbrdid", (Object)onbrdBillId.toString());
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u8bc1\u4ef6\u4fe1\u606f", (String)"CertificateShowEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }
}

