/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.CertificatePageServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;

public class CertificateSubEdit
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(CertificateSubEdit.class);
    private static final String OPKEY_EDIT = "donothing_edit";
    private static final String OPKEY_DELETE = "donothing_delete";
    private static final String OPKEY_VIEWNUMBER = "donothing_viewnumber";
    private static final String DONOTHING_VIEW = "donothing_view";

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParamsmap = showParameter.getCustomParams();
        new CertificatePageServiceImpl().setValueWithParamsMap(this.getView(), customParamsmap);
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam(customParamsmap.get("onbrdid"));
        boolean isEnrolled = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        if (isEnrolled) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"editanddeleteap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"viewap"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        if ((HRStringUtils.equals((String)OPKEY_EDIT, (String)opKey) || HRStringUtils.equals((String)OPKEY_DELETE, (String)opKey)) && IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdBillId)) {
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.equals((String)OPKEY_EDIT, (String)opKey)) {
            Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            boolean success = onbrdCommonAppService.tryRequireLockByHCF(this.getView(), id, "hcf_cancre", "modify");
            if (!success) {
                this.editCertificate(OperationStatus.VIEW);
                return;
            }
            String appId = this.getView().getFormShowParameter().getAppId();
            if (IOnbrdCommonAppService.getInstance().checkPermission("hom_cancreinfo_view", "4715a0df000000ac", appId) || IOnbrdCommonAppService.getInstance().checkPermission("hom_cancreshow", "4715a0df000000ac", appId)) {
                this.editCertificate(OperationStatus.EDIT);
            } else {
                this.editCertificate(OperationStatus.VIEW);
            }
        } else if (HRStringUtils.equals((String)OPKEY_DELETE, (String)opKey)) {
            Object candidate = this.getView().getFormShowParameter().getCustomParams().get("candidate");
            Long candidateId = Long.parseLong(candidate.toString());
            Map map = ((IHcfDataDomainService)ServiceFactory.getService(IHcfDataDomainService.class)).queryMultiRowEntity(Collections.singleton(candidateId), "hcf_cancre", "id,candidate");
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)map.get(candidateId);
            if (dynamicObjectCollection.size() == 1) {
                String remark = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bc1\u4ef6\u4e3a\u5fc5\u586b\u9879\u3002", (String)"AbstractCollectDynViewPlugin_14", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(remark);
                args.setCancel(true);
                return;
            }
            String msg = ResManager.loadKDString((String)"\u8bf7\u518d\u6b21\u786e\u8ba4\u5220\u9664\u6b64\u6761\u8bc1\u4ef6\u4fe1\u606f\u5185\u5bb9\u3002", (String)"CertificateSubEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            Boolean isMajora = this.getModel().getDataEntity().getBoolean("ismajora");
            if (isMajora.booleanValue()) {
                msg = ResManager.loadKDString((String)"\u4e3b\u8bc1\u4ef6\u65e0\u6cd5\u5220\u9664", (String)"CertificateSubEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                args.setCancel(true);
                return;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(OPKEY_DELETE);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, confirmCallBackListener);
        } else if (HRStringUtils.equals((String)OPKEY_VIEWNUMBER, (String)opKey)) {
            logger.info("beforeDoOperation donothing_viewnumber");
        } else if (HRStringUtils.equals((String)DONOTHING_VIEW, (String)opKey)) {
            this.editCertificate(OperationStatus.VIEW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)OPKEY_DELETE, (String)callBackId) && messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
            Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            boolean success = onbrdCommonAppService.tryRequireLockByHCF(this.getView(), id, "hcf_cancre", "delete");
            if (!success) {
                return;
            }
            try {
                this.deleteCertificate();
            }
            finally {
                onbrdCommonAppService.releaseLockByHCF(id, "hcf_cancre", "delete");
            }
        }
    }

    private void editCertificate(OperationStatus operationStatus) {
        String pkId = (String)this.getView().getFormShowParameter().getCustomParam("id");
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidate"));
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(operationStatus);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setHasRight(true);
        formShowParameter.setFormId("hom_cancreinfo_edit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hcf_cancre"));
        formShowParameter.setCustomParam("id", (Object)pkId);
        formShowParameter.setCustomParam("candidate", (Object)candidateId.toString());
        formShowParameter.setCustomParam("onbrdid", (Object)onbrdBillId.toString());
        DynamicObject credentialsType = this.getView().getModel().getDataEntity().getDynamicObject("credentialstype");
        if (!HRObjectUtils.isEmpty((Object)credentialsType)) {
            formShowParameter.setCustomParam("credentialstype.id", (Object)credentialsType.getString("id"));
            formShowParameter.setCustomParam("credentialstype.number", (Object)credentialsType.getString("number"));
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u8bc1\u4ef6\u4fe1\u606f", (String)"CertificateShowEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void deleteCertificate() {
        Long pkId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        try {
            IHomToHcfAppService.getInstance().getById(pkId, "hcf_cancre");
        }
        catch (KDException e) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u6761\u8bc1\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CertificateSubEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            return;
        }
        Map result = IHomToHcfAppService.getInstance().deleteById(pkId, "hcf_cancre");
        Boolean isSuccess = Boolean.valueOf(result.get("success").toString());
        if (isSuccess.booleanValue()) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        } else {
            String message = String.valueOf(result.get("message"));
            this.getView().showErrorNotification(message);
        }
    }
}

