/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.cvp.IHomToCvpAppService;
import kd.hr.hom.business.application.extension.ICertificateInfoService;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.impl.extension.PersonInfoExService;
import kd.hr.hom.business.application.impl.page.CertificatePageServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.utils.CertificateFieldUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.impl.collect.CollectServiceImpl;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.constant.HcfCanCreConstants;
import kd.hr.hom.common.entity.CertificateField;
import kd.hr.hom.common.entity.IDCardInfo;
import kd.hr.hom.common.entity.ocr.AlgoResultData;
import kd.hr.hom.common.entity.ocr.OcrIdCardResult;
import kd.hr.hom.common.enums.InfoGroupCertTypeEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.IDCardUtils;
import kd.hr.hom.common.util.PutValueToModelUtils;
import kd.hr.hom.formplugin.web.base.HomDataBaseEdit;

public class CertificateUpdateEdit
extends HomDataBaseEdit
implements BeforeF7SelectListener,
UploadListener,
Serializable {
    private static final Log logger = LogFactory.getLog(CertificateUpdateEdit.class);
    private static final String PANELKEY_CREPHOTOPANELAP = "crephotopanelap";
    private static final String PANELKEY_IDCARDPANEL = "idcardpanel";
    private static final String PANELKEY_PERMANENTLIVEPANEL = "permanentlivepanel";
    private static final String PANELKEY_HKANDMCPASSPANEL = "hkandmcpasspanel";
    private static final String PANELKEY_TAIWANPASSPANEL = "taiwanpasspanel";
    private static final String PANELKEY_PASSPORTCARDPANEL = "passportcardpanel";
    private static final String PANELKEY_FIELDSPANEL = "fieldspanel";
    private static final String PANELKEY_SELECTBLANKPANEL = "selectblankpanel";
    private static final String ATTACHMENT_COMMON = "attachmentcommon";
    private static final String ATTACHMENT_COMMON_STD = "attachmentpanelap_std";
    private static final String PANELKEY_PLACEHOLDERA = "placeholderapanel";
    private static final String PANELKEY_PLACEHOLDERB = "placeholderbpanel";
    private static final String PANELKEY_PLACEHOLDERC = "placeholdercpanel";
    private static final String OPKEY_SAVE = "donothing_save";
    private static final String CREDENTIALS_TYPE_COMMON = "credentialsTypeCommon";
    private static final Long CREDENTIALS_TYPE_COMMON_ID = -1L;
    private Set<String> FIELDSET_FIELDSPANEL = Sets.newHashSet((Object[])new String[]{"ismajor", "percardname", "number", "lastnameen", "firstnameen", "gender", "nation", "birthdate", "nationality", "country", "issuedate", "expirationdate", "regionmul", "issuingauthoritymul", "isidentity", "cardlocation", "firstname", "lastname", "ispermanent"});
    private static Set<String> FIELDSET_IDCARD = ImmutableSet.of((Object)"percardname", (Object)"number", (Object)"gender", (Object)"nation", (Object)"birthdate", (Object)"issuedate", (Object[])new String[]{"expirationdate", "ismajor", "isidentity", "cardlocation", "ispermanent", "issuingauthoritymul"});
    private static Set<String> FIELDSET_PERMANENTLIVE = ImmutableSet.of((Object)"percardname", (Object)"number", (Object)"gender", (Object)"birthdate", (Object)"nationality", (Object)"issuedate", (Object[])new String[]{"ismajor", "isidentity", "ispermanent", "expirationdate"});
    private static Set<String> FIELDSET_FOREIGNERWORK = ImmutableSet.of((Object)"percardname", (Object)"number", (Object)"gender", (Object)"issuingauthoritymul", (Object)"nationality", (Object)"issuedate", (Object[])new String[]{"ismajor", "isidentity", "ispermanent", "expirationdate"});
    private static Set<String> FIELDSET_DRIVER = ImmutableSet.of((Object)"percardname", (Object)"number", (Object)"gender", (Object)"birthdate", (Object)"nationality", (Object)"issuedate", (Object[])new String[]{"ismajor", "isidentity", "ispermanent", "cardlocation", "expirationdate"});
    private static Set<String> FIELDSET_OFFICER = ImmutableSet.of((Object)"percardname", (Object)"number", (Object)"gender", (Object)"birthdate", (Object)"issuedate", (Object)"expirationdate", (Object[])new String[]{"ismajor", "isidentity", "ispermanent", "cardlocation", "nation", "issuingauthoritymul"});
    private static Set<String> FIELDSET_PASSCHECK = ImmutableSet.of((Object)"percardname", (Object)"number", (Object)"gender", (Object)"birthdate", (Object)"issuedate", (Object)"expirationdate", (Object[])new String[]{"ismajor", "isidentity", "ispermanent", "cardlocation", "lastnameen", "firstnameen", "regionmul", "issuingauthoritymul"});
    private static Set<String> FIELDSET_HKANDMCPASS = ImmutableSet.of((Object)"percardname", (Object)"number", (Object)"gender", (Object)"birthdate", (Object)"issuedate", (Object)"expirationdate", (Object[])new String[]{"regionmul", "ismajor", "isidentity", "ispermanent", "cardlocation", "nation", "issuingauthoritymul"});
    private static Set<String> FIELDSET_COMMON = ImmutableSet.of((Object)"percardname", (Object)"number", (Object)"expirationdate", (Object)"ismajor", (Object)"isidentity", (Object)"ispermanent", (Object[])new String[0]);
    private static Set<String> FIELDSET_TAIWANPASS = ImmutableSet.of((Object)"percardname", (Object)"number", (Object)"gender", (Object)"birthdate", (Object)"issuedate", (Object)"expirationdate", (Object[])new String[]{"regionmul", "ismajor", "isidentity", "ispermanent", "cardlocation", "nation", "issuingauthoritymul"});
    private static Set<String> FIELDSET_PASSPORT = ImmutableSet.of((Object)"percardname", (Object)"number", (Object)"lastnameen", (Object)"firstnameen", (Object)"gender", (Object)"birthdate", (Object[])new String[]{"nationality", "issuedate", "expirationdate", "regionmul", "ismajor", "isidentity", "lastname", "firstname", "ispermanent", "issuingauthoritymul"});
    private static Map<Long, Set<String>> CREDENTIALSTYPE_FIELDSET = ImmutableMap.builder().put((Object)HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD, FIELDSET_IDCARD).put((Object)HcfCanCreConstants.CREDENTIALSTYPE_ID_PASSPORT, FIELDSET_PASSPORT).put((Object)HcfCanCreConstants.NUMBER_1030_S_ID, FIELDSET_IDCARD).put((Object)HcfCanCreConstants.NUMBER_1040_S_ID, FIELDSET_IDCARD).put((Object)HcfCanCreConstants.CREDENTIALSTYPE_ID_PERMANENTLIVE, FIELDSET_PERMANENTLIVE).put((Object)HcfCanCreConstants.CREDENTIALSTYPE_ID_HKANDMCPASS, FIELDSET_HKANDMCPASS).put((Object)HcfCanCreConstants.CREDENTIALSTYPE_ID_TAIWANPASS, FIELDSET_TAIWANPASS).put((Object)HcfCanCreConstants.NUMBER_1080_S_ID, FIELDSET_OFFICER).put((Object)HcfCanCreConstants.NUMBER_1090_S_ID, FIELDSET_PASSCHECK).put((Object)HcfCanCreConstants.NUMBER_1100_S_ID, FIELDSET_PASSCHECK).put((Object)HcfCanCreConstants.NUMBER_1110_S_ID, FIELDSET_DRIVER).put((Object)HcfCanCreConstants.NUMBER_1120_S_ID, FIELDSET_FOREIGNERWORK).put((Object)HcfCanCreConstants.NUMBER_1130_S_ID, FIELDSET_FOREIGNERWORK).put((Object)HcfCanCreConstants.NUMBER_1140_S_ID, FIELDSET_FOREIGNERWORK).put((Object)CREDENTIALS_TYPE_COMMON_ID, FIELDSET_COMMON).build();
    private static Map<Long, Map<String, String>> CRETYPE_IMAGE_MAP = ImmutableMap.builder().put((Object)HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD, (Object)ImmutableMap.builder().put((Object)"faceimage", (Object)"idfrontimage").put((Object)"reverseimage", (Object)"idbackimage").build()).put((Object)HcfCanCreConstants.CREDENTIALSTYPE_ID_PASSPORT, (Object)ImmutableMap.builder().put((Object)"faceimage", (Object)"passportfrontimage").build()).put((Object)HcfCanCreConstants.CREDENTIALSTYPE_ID_PERMANENTLIVE, (Object)ImmutableMap.builder().put((Object)"faceimage", (Object)"permanentlivefrontimage").put((Object)"reverseimage", (Object)"permanentlivebackimage").build()).put((Object)HcfCanCreConstants.CREDENTIALSTYPE_ID_HKANDMCPASS, (Object)ImmutableMap.builder().put((Object)"faceimage", (Object)"hkandmcpassfrontimage").put((Object)"reverseimage", (Object)"hkandmcpassimage").build()).put((Object)HcfCanCreConstants.CREDENTIALSTYPE_ID_TAIWANPASS, (Object)ImmutableMap.builder().put((Object)"faceimage", (Object)"taiwanpassfrontimage").put((Object)"reverseimage", (Object)"taiwanpassbackimage").build()).put((Object)HcfCanCreConstants.NUMBER_DEFAULT_ID, (Object)ImmutableMap.builder().put((Object)"faceimage", (Object)"faceimage").put((Object)"reverseimage", (Object)"reverseimage").build()).build();
    private static final long serialVersionUID = 5494970780249547013L;
    private static final String CERTIFICATEPANEL = "certificatepanel";
    private static final String FACEAP = "faceap";
    private static final String REVERSEAP = "reverseap";
    private static final String ITEM = "item";
    private static final String REVERSELABEL = "reverselabel";
    private static final String FACELABEL = "facelabel";

    public void afterCreateNewData(EventObject eventObject) {
        this.initScopeForDateControl();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long pkId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("id"));
        long creTypeID = 0L;
        if (!HRObjectUtils.isEmpty((Object)formShowParameter.getCustomParam("credentialstype.id"))) {
            creTypeID = Long.parseLong(formShowParameter.getCustomParam("credentialstype.id").toString());
        }
        this.setVisibleByCreType(creTypeID);
        if (!HRObjectUtils.isEmpty((Object)pkId)) {
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ICertificateInfoService.class, (String)"kd.hr.hom.business.application.extension.ICertificateInfoService", null);
            HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create(null, kd.sdk.hr.hom.business.personinfo.ICertificateInfoService.class, (String)"kd.sdk.hr.hom.business.personinfo.ICertificateInfoService", null);
            hrPluginProxy.callReplace(ICertificateInfoService::getCertExtProperties).forEach(properties -> this.FIELDSET_FIELDSPANEL.addAll((Collection<String>)properties));
            hrPluginProxySdk.callReplace(kd.sdk.hr.hom.business.personinfo.ICertificateInfoService::getCertExtProperties).forEach(properties -> this.FIELDSET_FIELDSPANEL.addAll((Collection<String>)properties));
            Set exFields = PersonInfoExService.getExFields((IFormView)this.getView());
            if (!CollectionUtils.isEmpty((Collection)exFields)) {
                this.FIELDSET_FIELDSPANEL.addAll(exFields);
            }
            Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("candidate"));
            StringBuilder properties2 = new StringBuilder("candidate").append(',').append("credentialstype").append(',').append("faceimage").append(',').append("reverseimage").append(',').append("birthday");
            this.FIELDSET_FIELDSPANEL.forEach(fieldName -> properties2.append(',').append((String)fieldName));
            HashMap entityFields = Maps.newHashMapWithExpectedSize((int)2);
            entityFields.put("hcf_cancre", properties2.toString());
            Map map = IHomToHcfAppService.getInstance().getCandidate(candidateId, (Map)entityFields, Long.valueOf(0L));
            DynamicObjectCollection creCollection = (DynamicObjectCollection)map.get("hcf_cancre");
            for (DynamicObject certificateInfo : creCollection) {
                if (certificateInfo.getLong("id") != pkId.longValue()) continue;
                DynamicObject credentialsType = certificateInfo.getDynamicObject("credentialstype");
                this.getModel().setValue("credentialstype", (Object)(credentialsType == null ? 0L : credentialsType.getLong("id")));
                PutValueToModelUtils.putValueToModel((IFormView)this.getView(), (DynamicObject)certificateInfo, (String[])this.FIELDSET_FIELDSPANEL.toArray(new String[0]));
                this.putValueToPhoto(certificateInfo);
                if (!certificateInfo.getBoolean("ispermanent")) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"expirationdate"});
                break;
            }
        }
        this.setValueWhenNew();
    }

    private void setValueWhenNew() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("candidate"));
        DynamicObject canBaseInfo = IHomToHcfAppService.getInstance().getSingleRowEntity(candidateId, "hcf_canbaseinfo");
        if (HRObjectUtils.isEmpty((Object)canBaseInfo)) {
            return;
        }
        HOMObjectUtils.setFieldValueIfEmpty((IDataModel)this.getModel(), (String)"percardname", (Object)canBaseInfo.get("name"));
        HOMObjectUtils.setFieldValueIfEmpty((IDataModel)this.getModel(), (String)"gender", (Object)canBaseInfo.get("gender"));
        HOMObjectUtils.setFieldValueIfEmpty((IDataModel)this.getModel(), (String)"nationality", (Object)canBaseInfo.get("nationality"));
        HOMObjectUtils.setFieldValueIfEmpty((IDataModel)this.getModel(), (String)"birthdate", (Object)canBaseInfo.get("birthday"));
        HOMObjectUtils.setFieldValueIfEmpty((IDataModel)this.getModel(), (String)"nation", (Object)canBaseInfo.get("folk"));
    }

    private void putValueToPhoto(DynamicObject certificateInfo) {
        DynamicObject credentialsType = certificateInfo.getDynamicObject("credentialstype");
        Long creTypeNumber = HRObjectUtils.isEmpty((Object)credentialsType) ? 0L : credentialsType.getLong("id");
        Map<String, String> imageMap = CRETYPE_IMAGE_MAP.getOrDefault(creTypeNumber, CRETYPE_IMAGE_MAP.get(HcfCanCreConstants.NUMBER_DEFAULT_ID));
        if (CollectionUtils.isEmpty(imageMap)) {
            return;
        }
        for (Map.Entry<String, String> entry : imageMap.entrySet()) {
            this.getModel().setValue(entry.getValue(), (Object)certificateInfo.getString(entry.getKey()));
        }
    }

    private void initScopeForDateControl() {
        Date today = new Date();
        DateEdit birthDateEdit = (DateEdit)this.getView().getControl("birthdate");
        birthDateEdit.setMaxDate(HRDateTimeUtils.addDay((Date)today, (long)-1L));
        DateEdit issueDateEdit = (DateEdit)this.getView().getControl("issuedate");
        issueDateEdit.setMaxDate(today);
        DateEdit expirationDateEdit = (DateEdit)this.getView().getControl("expirationdate");
        expirationDateEdit.setMinDate(today);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "credentialstype": {
                this.changeWithCredentialsType();
                break;
            }
            case "idfrontimage": {
                if (HRObjectUtils.isEmpty((Object)args.getChangeSet()[0].getNewValue()) || !IHomToCvpAppService.getInstance().isEnableOcr(this.getView()).booleanValue()) break;
                this.ocrIdFrontImage(propertyName, "OPM-IdCardBack");
                break;
            }
            case "idbackimage": {
                if (HRObjectUtils.isEmpty((Object)args.getChangeSet()[0].getNewValue()) || !IHomToCvpAppService.getInstance().isEnableOcr(this.getView()).booleanValue()) break;
                this.ocrIdBackImage(propertyName, "OPM-IDCardFront");
                break;
            }
            case "passportfrontimage": {
                if (HRObjectUtils.isEmpty((Object)args.getChangeSet()[0].getNewValue()) || !IHomToCvpAppService.getInstance().isEnableOcr(this.getView()).booleanValue()) break;
                this.ocrPassportFrontImage(propertyName, "OPM-IdCardBack");
                break;
            }
            case "ispermanent": {
                this.changeWithIspermanent();
                break;
            }
        }
    }

    private void changeWithIspermanent() {
        boolean ispermanent = HOMObjectUtils.getBooleanValOfObject((Object)this.getModel().getValue("ispermanent"));
        if (ispermanent) {
            this.getModel().setValue("expirationdate", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"expirationdate"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"expirationdate"});
        }
    }

    private void changeWithCredentialsType() {
        this.setCertificateField();
        DynamicObject credentialsType = this.getModel().getDataEntity().getDynamicObject("credentialstype");
        if (!HRObjectUtils.isEmpty((Object)credentialsType)) {
            Long creTypeNumber = credentialsType.getLong("id");
            this.setVisibleByCreType(creTypeNumber);
            Set<String> fieldSet = CREDENTIALSTYPE_FIELDSET.getOrDefault(creTypeNumber, CREDENTIALSTYPE_FIELDSET.get(CREDENTIALS_TYPE_COMMON_ID));
            for (String field : fieldSet) {
                this.getModel().setValue(field, null);
            }
            this.setValueWhenNew();
        }
    }

    private void setCertificateField() {
        HashMap mapsTemp = new HashMap();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ICertificateInfoService.class, (String)"kd.hr.hom.business.application.extension.ICertificateInfoService", null);
        List maps = hrPluginProxy.callReplace(ICertificateInfoService::getExtPropertiesByCert);
        maps.forEach(mapsTemp::putAll);
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create(null, kd.sdk.hr.hom.business.personinfo.ICertificateInfoService.class, (String)"kd.sdk.hr.hom.business.personinfo.ICertificateInfoService", null);
        List mapsSdkTemp = hrPluginProxySdk.callReplace(kd.sdk.hr.hom.business.personinfo.ICertificateInfoService::getExtPropertiesByCert);
        mapsSdkTemp.forEach(mapsTemp::putAll);
        for (Map.Entry stringSetEntry : mapsTemp.entrySet()) {
            DynamicObject dynamicObject;
            String key = (String)stringSetEntry.getKey();
            if (HRObjectUtils.isEmpty(stringSetEntry.getValue()) || HRObjectUtils.isEmpty((Object)(dynamicObject = HomCommonRepository.queryDynamicObjectByNumber((String)"hbss_credentialstype", (String)"id,number", (Object)key)))) continue;
            CREDENTIALSTYPE_FIELDSET.put(dynamicObject.getLong("id"), (Set<String>)stringSetEntry.getValue());
        }
        List mapsSdk = hrPluginProxySdk.callReplace(kd.sdk.hr.hom.business.personinfo.ICertificateInfoService::getExtPropertiesByCertID);
        mapsSdk.stream().filter(Objects::nonNull).forEach(CREDENTIALSTYPE_FIELDSET::putAll);
        mapsSdk.stream().filter(Objects::nonNull).forEach(mapsSdkVar -> {
            if (HRObjectUtils.isEmpty((Object)mapsSdkVar)) {
                return;
            }
            CREDENTIALSTYPE_FIELDSET.putAll((Map<Long, Set<String>>)mapsSdkVar);
        });
    }

    private Object ocrImage(String propertyName, String templateNumber) {
        this.getView().showLoading(ResManager.getLocaleString((String)"OCR\u6587\u672c\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"InfoGroupDynViewMobilePlugin_10", (String)"hr-hom-formplugin"));
        String relativeUrl = this.getModel().getDataEntity().getString(propertyName);
        if (HRStringUtils.isEmpty((String)relativeUrl)) {
            return null;
        }
        AlgoResultData algoResultData = IHomToCvpAppService.getInstance().distinguishOcrImage("hcf_cancre", templateNumber, relativeUrl);
        logger.info("===algoResultData.errorCode:{}===", (Object)algoResultData.getErrorCode());
        logger.info("===algoResultData.description:{}==", (Object)algoResultData.getDescription());
        this.getView().hideLoading();
        if (algoResultData.getErrorCode() != 0) {
            if (HRStringUtils.isEmpty((String)algoResultData.getDescription())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u6587\u672c\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u624b\u52a8\u8f93\u5165\u3002", (String)"Ocrcomn_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(algoResultData.getDescription());
            }
            return null;
        }
        Object data = algoResultData.getData();
        if (data == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u6587\u672c\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u624b\u52a8\u8f93\u5165\u3002", (String)"Ocrcomn_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        return data;
    }

    private void ocrIdFrontImage(String propertyName, String templateNumber) {
        try {
            String chuanQing;
            String nation;
            Object data = this.ocrImage(propertyName, templateNumber);
            if (data == null) {
                return;
            }
            OcrIdCardResult ocrIdCardResult = (OcrIdCardResult)JSONObject.parseObject((String)data.toString(), OcrIdCardResult.class);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u4fe1\u606f\u8bc6\u522b\u6210\u529f\u3002", (String)"CertificateUpdateEdit_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.setFieldValueWithOcr("percardname", ocrIdCardResult.getName());
            String sexName = ocrIdCardResult.getSex();
            if (HRStringUtils.isNotEmpty((String)sexName)) {
                DynamicObject gender = IBaseDataDomainService.getInstance().getSexInfo(sexName, null);
                this.setFieldValueWithOcr("gender", gender);
            }
            if (!HRStringUtils.equals((String)(nation = ocrIdCardResult.getNation()), (String)(chuanQing = ResManager.loadKDString((String)"\u7a7f\u9752\u4eba", (String)"OcrToBusinessUtils_0", (String)"hr-hom-formplugin", (Object[])new Object[0])))) {
                String zu = ResManager.loadKDString((String)"\u65cf", (String)"OcrToBusinessUtils_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                nation = ocrIdCardResult.getNation() + zu;
            }
            DynamicObject flokObj = HomCommonRepository.queryDynamicObject((String)"hbss_flok", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)nation)});
            this.setFieldValueWithOcr("nation", flokObj);
            this.setFieldValueWithOcr("birthdate", ocrIdCardResult.getBirth());
            this.setFieldValueWithOcr("cardlocation", ocrIdCardResult.getAddress());
            this.setFieldValueWithOcr("number", ocrIdCardResult.getIdNum());
        }
        catch (Exception exp) {
            logger.error("===ocrIdFrontImage===", (Throwable)exp);
            this.getView().showTipNotification(exp.getMessage());
        }
    }

    private void ocrIdBackImage(String propertyName, String templateNumber) {
        try {
            Object data = this.ocrImage(propertyName, templateNumber);
            if (data == null) {
                return;
            }
            OcrIdCardResult ocrIdCardResult = (OcrIdCardResult)JSONObject.parseObject((String)data.toString(), OcrIdCardResult.class);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u4fe1\u606f\u8bc6\u522b\u6210\u529f\u3002", (String)"CertificateUpdateEdit_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.setFieldValueWithOcr("issuingauthoritymul", new LocaleString(ocrIdCardResult.getAuthority()));
            this.setFieldValueWithOcr("issuedate", ocrIdCardResult.getIssuedate());
            this.setFieldValueWithOcr("expirationdate", ocrIdCardResult.getExpirationdate());
        }
        catch (Exception exp) {
            logger.error("===ocrIdBackImage===", (Throwable)exp);
            this.getView().showTipNotification(exp.getMessage());
        }
    }

    private void ocrPassportFrontImage(String propertyName, String templateNumber) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.setCertificateField();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        if (IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
            args.setCancel(true);
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if (OPKEY_SAVE.equals(operate.getOperateKey())) {
            String candidateNumStr;
            String credentialsNumber;
            CertificatePageServiceImpl certificatePageService = new CertificatePageServiceImpl();
            DynamicObject dynamicObjectPage = this.getView().getModel().getDataEntity();
            DynamicObject credentialsType = dynamicObjectPage.getDynamicObject("credentialstype");
            if (!certificatePageService.validateCreNumber(credentialsType, credentialsNumber = dynamicObjectPage.getString("number"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8eab\u4efd\u8bc1\u53f7\u7801\u6821\u9a8c\u672a\u901a\u8fc7\u3002", (String)"CertificateUpdateEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            Set candidateId = new CertificatePageServiceImpl().judgeCertificateIfDuplicate(credentialsType, credentialsNumber, id);
            if (!CollectionUtils.isEmpty((Collection)candidateId) && !HRStringUtils.isEmpty((String)(candidateNumStr = IOnbrdCommonAppService.getInstance().validCandidate(candidateId)))) {
                String msg = String.format(ResManager.loadKDString((String)"\u201c\u8bc1\u4ef6\u53f7\u7801\u201d\u4e0e\u5df2\u6709\u5019\u9009\u4eba\uff08\u5019\u9009\u4eba\u7f16\u53f7\u4e3a%s\uff09\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdInfoEdit_15", (String)"hr-hom-formplugin", (Object[])new Object[0]), candidateNumStr);
                this.getView().showTipNotification(msg);
                args.setCancel(true);
                return;
            }
            if (this.judgeCreTypeIfDuplicate(dynamicObjectPage)) {
                String creTypeName = HRObjectUtils.isEmpty((Object)credentialsType) ? "" : credentialsType.getString("name");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5df2\u6709\u201c%s\u201d\u6570\u636e\uff0c\u8bf7\u5148\u5220\u9664\u5df2\u6709\u8bc1\u4ef6\u518d\u8fdb\u884c\u65b0\u589e\u3002", (String)"CertificateUpdateEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), creTypeName));
                return;
            }
            DynamicObject dy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hom_onbrdbillbase"));
            Long onbrdid = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
            DynamicObject onbrdBillInfo = HomCommonRepository.queryDynamicObjectByPk((String)"hom_onbrdbillbase", (String)"certificatenumber,certificatetype,peremail,phone,name,viewtype,employeeno,candidatenumber", (Object)onbrdid);
            if (!HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
                HRDynamicObjectUtils.copy((DynamicObject)onbrdBillInfo, (DynamicObject)dy);
            }
            dy.set("certificatetype", (Object)credentialsType);
            dy.set("certificatenumber", (Object)credentialsNumber);
            Optional cardRes = IHomToHrpiAppService.getInstance().validOnePersonWithTip(dy, "certificatenumber");
            if (cardRes.isPresent()) {
                this.getView().showTipNotification((String)cardRes.get());
                return;
            }
            String errorMsg = new CertificatePageServiceImpl().validateDateField(dynamicObjectPage);
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                this.getView().showTipNotification(errorMsg);
                return;
            }
            this.updateOrSaveCancreInfo();
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        if (!IHomToCvpAppService.getInstance().isEnableOcr().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ocrtip"});
        }
        this.setCertificateField();
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.setCommonAttachmentPanel();
        if (this.getModel().getDataEntity().getBoolean("ismajor")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"ismajor"});
        }
        this.getView().getModel().getDataEntity().getDataEntityState().setFromDatabase(true);
    }

    private void setCommonAttachmentPanel() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long pkId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("id"));
        long creTypeNumber = 0L;
        if (!HRObjectUtils.isEmpty((Object)formShowParameter.getCustomParam("credentialstype.id"))) {
            creTypeNumber = Long.parseLong(formShowParameter.getCustomParam("credentialstype.id").toString());
        }
        if (CREDENTIALSTYPE_FIELDSET.get(creTypeNumber) == null) {
            List attachments = AttachmentServiceHelper.getAttachments((String)"hcf_cancre", (Object)pkId, (String)ATTACHMENT_COMMON_STD);
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_COMMON);
            if (!CollectionUtils.isEmpty((Collection)attachments)) {
                attachmentPanel.bindData(attachments);
            }
            TextEdit flexEdit = (TextEdit)this.getView().getControl("percardname");
            flexEdit.setMustInput(true);
            TextProp textProp = (TextProp)this.getModel().getDataEntityType().getProperties().get((Object)"percardname");
            textProp.setMustInput(true);
        }
    }

    private boolean judgeCreTypeIfDuplicate(DynamicObject certificateInfo) {
        DynamicObject credentialsType = certificateInfo.getDynamicObject("credentialstype");
        long creTypeNumber = HRObjectUtils.isEmpty((Object)credentialsType) ? 0L : credentialsType.getLong("id");
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidate"));
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        id = id == null ? Long.valueOf(0L) : id;
        Map creTypeNumberMap = new CertificatePageServiceImpl().getCreTypeNumberMap(candidateId);
        for (Map.Entry entry : creTypeNumberMap.entrySet()) {
            if (id.longValue() == ((Long)entry.getKey()).longValue() || creTypeNumber != (Long)entry.getKey() || InfoGroupCertTypeEnum.PASSPORT.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    private void setVisibleByCreType(long creType) {
        if (creType == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PANELKEY_CREPHOTOPANELAP, PANELKEY_FIELDSPANEL, ATTACHMENT_COMMON});
            this.getView().setVisible(Boolean.TRUE, new String[]{PANELKEY_SELECTBLANKPANEL});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{PANELKEY_SELECTBLANKPANEL, PANELKEY_PASSPORTCARDPANEL, PANELKEY_IDCARDPANEL, PANELKEY_PERMANENTLIVEPANEL, PANELKEY_HKANDMCPASSPANEL, PANELKEY_TAIWANPASSPANEL, ATTACHMENT_COMMON, CERTIFICATEPANEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{FACEAP, REVERSEAP});
        this.getView().setVisible(Boolean.TRUE, new String[]{PANELKEY_CREPHOTOPANELAP, PANELKEY_FIELDSPANEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{PANELKEY_PLACEHOLDERA, PANELKEY_PLACEHOLDERB, PANELKEY_PLACEHOLDERC});
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ICertificateInfoService.class, (String)"kd.hr.hom.business.application.extension.ICertificateInfoService", null);
        hrPluginProxy.callReplace(ICertificateInfoService::getCertExtProperties).forEach(properties -> this.FIELDSET_FIELDSPANEL.addAll((Collection<String>)properties));
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create(null, kd.sdk.hr.hom.business.personinfo.ICertificateInfoService.class, (String)"kd.sdk.hr.hom.business.personinfo.ICertificateInfoService", null);
        hrPluginProxySdk.callReplace(kd.sdk.hr.hom.business.personinfo.ICertificateInfoService::getCertExtProperties).forEach(properties -> this.FIELDSET_FIELDSPANEL.addAll((Collection<String>)properties));
        this.getView().setVisible(Boolean.FALSE, this.FIELDSET_FIELDSPANEL.toArray(new String[0]));
        Set<String> fieldSet = CREDENTIALSTYPE_FIELDSET.getOrDefault(creType, CREDENTIALSTYPE_FIELDSET.get(CREDENTIALS_TYPE_COMMON_ID));
        this.getView().setVisible(Boolean.TRUE, fieldSet.toArray(new String[0]));
        DateEdit expirationDateEdit = (DateEdit)this.getView().getControl("expirationdate");
        expirationDateEdit.hideTips();
        if (creType == HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANELKEY_IDCARDPANEL});
            Tips tips = new Tips();
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u82e5\u4e3a\u957f\u671f\u6709\u6548\u7684\u4e2d\u56fd\u4e8c\u4ee3\u5c45\u6c11\u8eab\u4efd\u8bc1\uff0c\u5219\u8bc1\u4ef6\u5230\u671f\u65e5\u671f\u9ed8\u8ba4\u4e3a\uff1a2199-12-31\u3002", (String)"CertificateUpdateEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0])));
            tips.setType("text");
            tips.setTriggerType("hover");
            expirationDateEdit.addTips(tips);
        } else if (creType == HcfCanCreConstants.CREDENTIALSTYPE_ID_PASSPORT) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANELKEY_PASSPORTCARDPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANELKEY_PLACEHOLDERA, PANELKEY_PLACEHOLDERB, PANELKEY_PLACEHOLDERC});
        } else if (creType == HcfCanCreConstants.CREDENTIALSTYPE_ID_PERMANENTLIVE) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANELKEY_PERMANENTLIVEPANEL});
        } else if (creType == HcfCanCreConstants.CREDENTIALSTYPE_ID_HKANDMCPASS) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANELKEY_HKANDMCPASSPANEL});
        } else if (creType == HcfCanCreConstants.CREDENTIALSTYPE_ID_TAIWANPASS) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANELKEY_TAIWANPASSPANEL});
        } else if (creType == HcfCanCreConstants.NUMBER_1080_S_ID) {
            this.showImage(creType, ResManager.loadKDString((String)"\u5185\u5bb9\u9875", (String)"CertificateUpdateEdit_7", (String)"hr-hom-formplugin", (Object[])new Object[0]), null);
        } else if (creType == HcfCanCreConstants.NUMBER_1110_S_ID) {
            this.showImage(creType, ResManager.loadKDString((String)"\u9a7e\u9a76\u8bc1\u4e3b\u9875", (String)"CertificateUpdateEdit_8", (String)"hr-hom-formplugin", (Object[])new Object[0]), null);
        } else if (creType == HcfCanCreConstants.NUMBER_1120_S_ID || creType == HcfCanCreConstants.NUMBER_1130_S_ID || creType == HcfCanCreConstants.NUMBER_1140_S_ID) {
            this.showImage(creType, ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f\u9762", (String)"CertificateUpdateEdit_6", (String)"hr-hom-formplugin", (Object[])new Object[0]), null);
        } else if (creType == HcfCanCreConstants.NUMBER_1030_S_ID || creType == HcfCanCreConstants.NUMBER_1040_S_ID || creType == HcfCanCreConstants.NUMBER_1090_S_ID || creType == HcfCanCreConstants.NUMBER_1100_S_ID) {
            this.showImage(creType, null, null);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{ATTACHMENT_COMMON});
        }
    }

    private void showImage(Long creType, String faceImageName, String resImageName) {
        this.getView().setVisible(Boolean.TRUE, new String[]{CERTIFICATEPANEL});
        CertificateField certificateField = CertificateFieldUtils.CERTIFICATE_IMAGE_MAP.getOrDefault(creType, null);
        if (certificateField == null) {
            return;
        }
        String faceUrl = certificateField.getFaceUrl();
        String reverseUrl = certificateField.getReverseUrl();
        if (StringUtils.isBlank((CharSequence)faceUrl)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FACEAP});
        }
        if (StringUtils.isBlank((CharSequence)reverseUrl)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{REVERSEAP});
        }
        this.showDiffBackImg(faceImageName, resImageName, faceUrl, reverseUrl);
    }

    private void showDiffBackImg(String faceImageName, String resImgLab, String imgUrl, String resImgUrl) {
        HashMap item;
        HashMap map;
        if (HRStringUtils.isEmpty((String)faceImageName)) {
            faceImageName = ResManager.loadKDString((String)"\u8bc1\u4ef6\u6b63\u9762", (String)"CertificateUpdateEdit_9", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        }
        Label faceLabelAp = (Label)this.getView().getControl(FACELABEL);
        faceLabelAp.setText(faceImageName);
        if (HRStringUtils.isEmpty((String)resImgLab)) {
            resImgLab = ResManager.loadKDString((String)"\u8bc1\u4ef6\u53cd\u9762", (String)"CertificateUpdateEdit_10", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        }
        Label resLabelAp = (Label)this.getView().getControl(REVERSELABEL);
        resLabelAp.setText(resImgLab);
        if (HRStringUtils.isNotEmpty((String)imgUrl)) {
            map = Maps.newHashMapWithExpectedSize((int)1);
            item = Maps.newHashMapWithExpectedSize((int)1);
            map.put("bgik", imgUrl);
            item.put(ITEM, map);
            this.getView().updateControlMetadata("faceimage", (Map)item);
        }
        if (HRStringUtils.isNotEmpty((String)resImgUrl)) {
            map = Maps.newHashMapWithExpectedSize((int)1);
            item = Maps.newHashMapWithExpectedSize((int)1);
            map.put("bgik", resImgUrl);
            item.put(ITEM, map);
            this.getView().updateControlMetadata("reverseimage", (Map)item);
        }
    }

    private DynamicObject getCertificateDyForSave(Long candidateId, DynamicObject creInfoFromPage) {
        Long creTypeId;
        Map<String, String> imageMap;
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        DynamicObject cancreDyo = null;
        if (!HRObjectUtils.isEmpty((Object)id)) {
            DynamicObjectCollection coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, "hcf_cancre");
            if (!CollectionUtils.isEmpty((Collection)coll)) {
                cancreDyo = (DynamicObject)coll.get(0);
            }
        } else {
            id = ORM.create().genLongId("hcf_cancre");
        }
        DynamicObject certificateDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_cancre"));
        if (cancreDyo == null) {
            certificateDy.set("boid", null);
        } else {
            certificateDy.set("boid", (Object)cancreDyo.getLong("boid"));
        }
        certificateDy.set("id", (Object)(HRObjectUtils.isEmpty((Object)cancreDyo) ? id : 0L));
        certificateDy.set("candidate", (Object)candidateId);
        certificateDy.set("ismajor", (Object)creInfoFromPage.getBoolean("ismajor"));
        DynamicObject credentialsType = creInfoFromPage.getDynamicObject("credentialstype");
        certificateDy.set("credentialstype", (Object)credentialsType);
        if (CREDENTIALSTYPE_FIELDSET.get(credentialsType.getLong("id")) == null) {
            IPageCache cache;
            String removeUidString;
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_COMMON);
            HashMap<String, List> attachmentDataMap = new HashMap<String, List>(2);
            attachmentDataMap.put(ATTACHMENT_COMMON_STD, attachmentPanel.getAttachmentData());
            AttachmentServiceHelper.saveTempAttachments((String)"hcf_cancre", (Object)id, (String)"hcf", attachmentDataMap);
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && !HRStringUtils.isEmpty((String)(removeUidString = (cache = parentView.getPageCache()).get("removeUid")))) {
                Set removeUidSet = (Set)SerializationUtils.fromJsonString((String)removeUidString, Set.class);
                Long finalId = id;
                removeUidSet.forEach(uid -> AttachmentServiceHelper.remove((String)"hcf_cancre", (Object)finalId, (Object)uid));
            }
        }
        if ((imageMap = CRETYPE_IMAGE_MAP.getOrDefault(creTypeId = Long.valueOf(credentialsType.getLong("id")), CRETYPE_IMAGE_MAP.get(HcfCanCreConstants.NUMBER_DEFAULT_ID))) != null) {
            for (Map.Entry<String, String> entry : imageMap.entrySet()) {
                certificateDy.set(entry.getKey(), creInfoFromPage.get(entry.getValue()));
            }
        }
        Set<String> fieldSet = CREDENTIALSTYPE_FIELDSET.getOrDefault(creTypeId, CREDENTIALSTYPE_FIELDSET.get(CREDENTIALS_TYPE_COMMON_ID));
        for (String fieldName : fieldSet) {
            certificateDy.set(fieldName, creInfoFromPage.get(fieldName));
        }
        return certificateDy;
    }

    public void remove(UploadEvent evt) {
        if (evt.getSource() instanceof AttachmentPanel) {
            IPageCache cache = this.getView().getParentView().getPageCache();
            Object[] attachs = evt.getUrls();
            Map attachment = (Map)attachs[0];
            Object removeUid = attachment.get("uid");
            String removeUidString = cache.get("removeUid");
            Set<String> removeUidSet = new HashSet<String>(attachs.length);
            if (!HRStringUtils.isEmpty((String)removeUidString)) {
                removeUidSet = (Set)SerializationUtils.fromJsonString((String)removeUidString, Set.class);
            }
            removeUidSet.add(removeUid.toString());
            cache.put("removeUid", SerializationUtils.toJsonString(removeUidSet));
        }
    }

    private void updateOrSaveCancreInfo() {
        DynamicObject dynamicObjectPage = this.getView().getModel().getDataEntity();
        DynamicObject credentialsType = dynamicObjectPage.getDynamicObject("credentialstype");
        if (HRObjectUtils.isEmpty((Object)credentialsType)) {
            return;
        }
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidate"));
        DynamicObject certificateDy = this.getCertificateDyForSave(candidateId, dynamicObjectPage);
        DynamicObjectCollection certificateFromDBs = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_cancre");
        DynamicObjectCollection updateCollection = new DynamicObjectCollection();
        if (CollectionUtils.isEmpty((Collection)certificateFromDBs)) {
            certificateDy.set("ismajor", (Object)Boolean.TRUE);
        } else if (certificateDy.getBoolean("ismajor")) {
            for (DynamicObject certificateFromDB : certificateFromDBs) {
                if (certificateDy.getLong("boid") == certificateFromDB.getLong("boid") || !certificateFromDB.getBoolean("ismajor")) continue;
                certificateFromDB.set("ismajor", (Object)Boolean.FALSE);
                DynamicObject cancreInfoCopy = HOMObjectUtils.copyHcfHisDynamicObject((String)"hcf_cancre", (DynamicObject)certificateFromDB);
                updateCollection.add((Object)cancreInfoCopy);
            }
        }
        PersonInfoExService.setExFieldValue((IFormView)this.getView(), (DynamicObject)certificateDy);
        updateCollection.add((Object)certificateDy);
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("hcf_cancre", updateCollection);
        ArrayList<HashMap> list = new ArrayList<HashMap>(1);
        list.add(map);
        Map result = IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
        Boolean isSuccess = Boolean.valueOf(result.get("success").toString());
        if (isSuccess.booleanValue()) {
            this.getPageCache().put("isalreadyclose", "1");
            this.getView().close();
            if (HRStringUtils.equals((String)this.getView().getParentView().getEntityId(), (String)"hom_cancreinfo_view")) {
                this.getView().getParentView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView().getParentView());
            } else {
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            }
            Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
            new CertificatePageServiceImpl().synOnbrdCreNumber(onbrdId, certificateDy);
            new CollectServiceImpl().syncSubmitPro(onbrdId);
        } else {
            String message = String.valueOf(result.get("message"));
            this.getView().showErrorNotification(message);
        }
        this.syncInfoToHcfBaseInfo(candidateId, certificateDy);
    }

    private void syncInfoToHcfBaseInfo(Long candidateId, DynamicObject certificateDy) {
        DynamicObject newCanBaseInfo;
        DynamicObjectCollection baseInfos;
        Map candidateInfoMap;
        DynamicObject certificateType = certificateDy.getDynamicObject("credentialstype");
        long cerTypeNum = certificateType.getLong("id");
        if (!HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD.equals(cerTypeNum)) {
            return;
        }
        IDCardInfo idCardInfo = IDCardUtils.parse((String)certificateDy.getString("number"));
        if (idCardInfo == null) {
            return;
        }
        HashMap entityFieldsMap = Maps.newHashMapWithExpectedSize((int)2);
        entityFieldsMap.put("hcf_canbaseinfo", "");
        IHcfDataDomainService hcfDataDomainService = IHcfDataDomainService.getInstance();
        Map candidateInfoMaps = hcfDataDomainService.queryOrLoadHcfAttachedData((List)ImmutableList.of((Object)candidateId), (Map)entityFieldsMap);
        DynamicObject canBaseInfo = null;
        if (!(CollectionUtils.isEmpty((Map)candidateInfoMaps) || CollectionUtils.isEmpty((Map)(candidateInfoMap = (Map)candidateInfoMaps.get(candidateId))) || CollectionUtils.isEmpty((Collection)(baseInfos = (DynamicObjectCollection)candidateInfoMap.get("hcf_canbaseinfo"))))) {
            canBaseInfo = (DynamicObject)baseInfos.get(0);
        }
        if (canBaseInfo == null) {
            logger.info("cannot find baseinfo");
            newCanBaseInfo = HOMObjectUtils.newHcfHisDynamicObject((String)"hcf_canbaseinfo", (Long)candidateId);
        } else {
            newCanBaseInfo = HOMObjectUtils.copyHcfHisDynamicObject((String)"hcf_canbaseinfo", canBaseInfo);
        }
        DynamicObject nationalityChina = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_nationality", BaseDataIdConstants.HBSS_NATIONALITY_1010, "number");
        HOMObjectUtils.setFieldValueIfEmpty((DynamicObject)newCanBaseInfo, (String)"nationality", (Object)nationalityChina);
        DynamicObject sexMan = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_sex", BaseDataIdConstants.HBSS_SEX_1010, "number");
        DynamicObject sexWoman = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_sex", BaseDataIdConstants.HBSS_SEX_1020, "number");
        HOMObjectUtils.setFieldValueIfEmpty((DynamicObject)newCanBaseInfo, (String)"gender", (Object)(idCardInfo.getGender() ? sexMan : sexWoman));
        HOMObjectUtils.setFieldValueIfEmpty((DynamicObject)newCanBaseInfo, (String)"birthday", (Object)idCardInfo.getBirthDay());
        hcfDataDomainService.saveHcfAttachedData("hcf_canbaseinfo", new DynamicObject[]{newCanBaseInfo});
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("credentialstype");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_COMMON);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        String isAlreadyClose = this.getPageCache().get("isalreadyclose");
        if (this.getModel().getDataChanged() && HRStringUtils.isEmpty((String)isAlreadyClose)) {
            beforeClosedEvent.setCancel(true);
            this.clickCancelChanged("cancel");
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (HRStringUtils.equalsIgnoreCase((String)status.name(), (String)"VIEW")) {
                return;
            }
            Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            IOnbrdCommonAppService.getInstance().releaseLockByHCF(id, "hcf_cancre", "modify");
        }
    }
}

