/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.AttachmentDownloadListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.cvp.IHomToCvpAppService;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.extension.PersonInfoExService;
import kd.hr.hom.business.application.impl.page.EduPageServiceImpl;
import kd.hr.hom.business.application.onbrd.IAttachmentAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.base.IUploadConfigDomainService;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.common.constant.BaseDataConstants;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.entity.ocr.CertificateOfDegreeResult;
import kd.hr.hom.common.entity.ocr.DiplomaResult;
import kd.hr.hom.common.enums.AttachmentTypeEnum;
import kd.hr.hom.common.util.DateUtils;
import kd.hr.hom.common.util.PutValueToModelUtils;
import kd.hr.hom.formplugin.common.OcrToBusinessUtils;
import kd.hr.hom.formplugin.web.base.HomDataBaseEdit;
import kd.sdk.hr.hom.business.personinfo.IEducationExpService;

public class EducationExpEditPlugin
extends HomDataBaseEdit
implements UploadListener,
AttachmentDownloadListener {
    private static final Log logger = LogFactory.getLog(EducationExpEditPlugin.class);
    private String EDUCATION_PROPERTIES = "admissiondate,gradutiondate,graduateschool,collegecountry,major,secondmajor,educationid,degreeid,faculty,isoverseasexp,isfulltime,ishighestdegree,schoolrecord";
    private static final String EDUCERT_PROPERTIES = "certtype,number,certnumber,edu,candidate,iscertification";
    private static final String CERTTYPE = "certtype";
    private static final String NUMBER_1010 = "number1010";
    private static final String NUMBER_1020 = "number1020";
    private static final String BTN_SAVE = "btnsave";
    private static final String BAR_SAVE = "bar_save";
    private static final String EDUCATIONATTACH = "educationattach";
    private static final String DEGREEATTACH = "degreeattach";
    private static final List<String> FIELDLIST = new ArrayList<String>();
    private static final String EDUID = "edu.id";
    private static final String CACHEKEY_CHECKCHANGEOP = "checkchangeop";
    private static final String ENTRY_ENTITY = "entryentity";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_SAVE});
    }

    public void afterCreateNewData(EventObject eventObject) {
        Boolean flag;
        this.getView().setVisible(Boolean.FALSE, new String[]{"schoolrecord"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"otherschool"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String status = formShowParameter.getStatus().name();
        if (HRStringUtils.equals((String)status, (String)"VIEW")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
            this.getView().setEnable(Boolean.FALSE, new String[]{EDUCATIONATTACH});
            this.getView().setEnable(Boolean.FALSE, new String[]{DEGREEATTACH});
        }
        if (formShowParameter.getCustomParam("isexistdegree") instanceof Boolean && !(flag = (Boolean)formShowParameter.getCustomParam("isexistdegree")).booleanValue()) {
            this.setModelValue(Boolean.TRUE, "ishighestdegree");
        }
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("candidateid"));
        this.getView().getModel().setValue("candidate", (Object)candidateId);
        Long maidId = (Long)formShowParameter.getCustomParam("id");
        EduPageServiceImpl service = new EduPageServiceImpl();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, kd.hr.hom.business.application.extension.IEducationExpService.class, (String)"kd.hr.hom.business.application.extension.IEducationExpService", null);
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create(null, IEducationExpService.class, (String)"kd.sdk.hr.hom.business.personinfo.IEducationExpService", null);
        if (!HRObjectUtils.isEmpty((Object)maidId)) {
            HashMap<String, String> entityFields = new HashMap<String, String>(2);
            List eduExpProperties = hrPluginProxy.callReplace(kd.hr.hom.business.application.extension.IEducationExpService::getExtPropertiesForExp);
            Set exFields = PersonInfoExService.getExFields((IFormView)this.getView());
            if (!CollectionUtils.isEmpty((Collection)exFields)) {
                this.EDUCATION_PROPERTIES = this.EDUCATION_PROPERTIES + "," + String.join((CharSequence)",", exFields);
            }
            eduExpProperties.add(this.EDUCATION_PROPERTIES);
            eduExpProperties.addAll(hrPluginProxySdk.callReplace(IEducationExpService::getExtPropertiesForExp));
            entityFields.put("hcf_caneduexp", String.join((CharSequence)",", eduExpProperties));
            List eduCertProperties = hrPluginProxy.callReplace(kd.hr.hom.business.application.extension.IEducationExpService::getExtPropertiesForCert);
            eduCertProperties.add(EDUCERT_PROPERTIES);
            eduCertProperties.addAll(hrPluginProxySdk.callReplace(IEducationExpService::getExtPropertiesForCert));
            entityFields.put("hcf_educertificate", String.join((CharSequence)",", eduCertProperties));
            Map map = IHomToHcfAppService.getInstance().getCandidate(candidateId, entityFields, Long.valueOf(0L));
            DynamicObjectCollection eduCollection = (DynamicObjectCollection)map.get("hcf_caneduexp");
            DynamicObject currentEduInfo = null;
            for (DynamicObject obj : eduCollection) {
                if (obj.getLong("id") != maidId.longValue()) continue;
                this.setGraduateVisible(obj);
                this.setEduDate(obj);
                PutValueToModelUtils.putValueToModel((IFormView)this.getView(), (DynamicObject)obj, (String[])this.EDUCATION_PROPERTIES.split(","));
                this.setModelValue(obj);
                if (service.checkEduIsHighSchool((Object)obj).booleanValue()) {
                    this.getView().getModel().setValue("otherschool", (Object)obj.getString("schoolrecord"));
                }
                this.setFieldVisibleAndCleanVal(service.checkEduIsHighSchool((Object)obj) == false, this.getModel().getDataEntity());
                currentEduInfo = obj;
                break;
            }
            DynamicObjectCollection currentEduCertInfos = new DynamicObjectCollection();
            DynamicObjectCollection certCollection = (DynamicObjectCollection)map.get("hcf_educertificate");
            for (DynamicObject obj : certCollection) {
                if (obj.getLong(EDUID) != maidId.longValue()) continue;
                this.setValueEduCert(obj);
                this.putCertIdToPageCache(obj.getString("certtype.id"), obj.getLong("id"));
                currentEduCertInfos.add((Object)obj);
            }
            DynamicObject finalCurrentEduInfo = currentEduInfo;
            hrPluginProxy.callReplace(p -> {
                p.initViewForExt(this.getView(), finalCurrentEduInfo, currentEduCertInfos);
                return null;
            });
            hrPluginProxySdk.callReplace(p -> {
                p.initViewForExt(this.getView(), finalCurrentEduInfo, currentEduCertInfos);
                return null;
            });
        } else {
            DynamicObject bdCountry = IBaseDataDomainService.getInstance().getBaseDataInfoById("bd_country", BaseDataConstants.BD_COUNTRY_ID_CHINA, "number");
            this.getModel().setValue("collegecountry", (Object)(bdCountry == null ? 0L : bdCountry.getLong("id")));
        }
        this.updateViewWithCountry();
    }

    private void putCertIdToPageCache(String certtypeNumber, Long certificateId) {
        this.getView().getPageCache().put(certtypeNumber, certificateId.toString());
    }

    private long getCertIdFromPageCache(String certtypeNumber) {
        Long certificateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getPageCache().get(certtypeNumber));
        return certificateId == null || certificateId == 0L ? 0L : certificateId;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.checkDataValidate(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (success && BTN_SAVE.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getPageCache().put(CACHEKEY_CHECKCHANGEOP, BTN_SAVE);
            this.updateOrSaveEduInfo();
            this.updateHighDegree();
            this.updateView();
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String name = evt.getProperty().getName();
        DynamicObject dyo = this.getModel().getDataEntity();
        EduPageServiceImpl service = new EduPageServiceImpl();
        switch (name) {
            case "collegecountry": {
                this.getModel().beginInit();
                this.updateViewWithCountry();
                this.getModel().endInit();
                break;
            }
            case "admissiondate": 
            case "gradutiondate": {
                this.setEduDate(dyo);
                break;
            }
            case "graduateschool": {
                this.setGraduateVisible(dyo);
                break;
            }
            case "educationid": {
                this.setFieldVisibleAndCleanVal(service.checkEduIsHighSchool((Object)dyo) == false, dyo);
                break;
            }
            case "attachmentfield": {
                Object[] changeDatas = evt.getChangeSet();
                if (HRArrayUtils.isEmpty((Object[])changeDatas)) {
                    return;
                }
                int rowIndex = changeDatas[0].getRowIndex();
                DynamicObject certType = (DynamicObject)this.getModel().getValue(CERTTYPE, rowIndex);
                DynamicObjectCollection newObjects = (DynamicObjectCollection)changeDatas[0].getNewValue();
                this.refreshEntryRow(rowIndex, newObjects);
                if (CollectionUtils.isEmpty((Collection)newObjects)) {
                    return;
                }
                DynamicObjectCollection oldObjects = (DynamicObjectCollection)changeDatas[0].getOldValue();
                Set oldUidSet = oldObjects.stream().filter(oldObject -> oldObject.getDynamicObject("fbasedataid") != null).map(oldObject -> oldObject.getDynamicObject("fbasedataid").getString("uid")).collect(Collectors.toSet());
                DynamicObjectCollection ocrFlashDys = new DynamicObjectCollection();
                for (DynamicObject newObject : newObjects) {
                    DynamicObject basedata = newObject.getDynamicObject("fbasedataid");
                    if (oldUidSet.contains(basedata.getString("uid"))) continue;
                    ocrFlashDys.add((Object)newObject);
                }
                this.ocrWithAttachmentfield(certType, ocrFlashDys);
                break;
            }
        }
    }

    private void setFieldVisibleAndCleanVal(Boolean b, DynamicObject dy) {
        this.getView().setVisible(b, new String[]{"graduateschool"});
        this.getView().setVisible(b, new String[]{"collegecharact"});
        this.getView().setVisible(b, new String[]{"major"});
        this.getView().setVisible(b, new String[]{"secondmajor"});
        this.getView().setVisible(b, new String[]{"degreeid"});
        this.getView().setVisible(b, new String[]{"faculty"});
        if (b.booleanValue()) {
            this.setGraduateVisible(dy);
        }
        this.getView().setVisible(Boolean.valueOf(b == false), new String[]{"otherschool"});
        if (!b.booleanValue()) {
            this.getView().getModel().setValue("graduateschool", null);
            this.getView().getModel().setValue("major", (Object)"");
            this.getView().getModel().setValue("secondmajor", (Object)"");
            this.getView().getModel().setValue("degreeid", null);
            this.getView().getModel().setValue("faculty", (Object)"");
            this.getView().getModel().setValue("schoolrecord", (Object)"");
        } else {
            this.getView().getModel().setValue("otherschool", (Object)"");
        }
    }

    public void clientCallBack(ClientCallBackEvent event) {
        List results = IHomToCvpAppService.getInstance().getOcrResult(event, this.getView(), "PC");
        switch (event.getName()) {
            case "OPM-Diploma": {
                this.setDiplomaResult(results);
                break;
            }
            case "OPM-CertificateOfDegree": {
                this.setDegreeResult(results);
                break;
            }
        }
    }

    private void setDegreeResult(List<Object> results) {
        for (Object object : results) {
            CertificateOfDegreeResult certificateOfDegreeResult = (CertificateOfDegreeResult)JSON.parseObject((String)JSON.toJSONString((Object)object), CertificateOfDegreeResult.class);
            String degreeCertificationId = certificateOfDegreeResult.getDegreeCertificationId();
            this.setFieldValueWithOcr(NUMBER_1020, degreeCertificationId);
            String education = certificateOfDegreeResult.getEducation();
            DynamicObject diplomaObject = HomCommonRepository.queryDynamicObject((String)"hbss_diploma", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)education)});
            if (diplomaObject != null) {
                this.setFieldValueWithOcr("educationid", diplomaObject.getLong("id"));
            }
            String discipline = certificateOfDegreeResult.getDiscipline();
            this.setFieldValueWithOcr("major", discipline);
            String degree = certificateOfDegreeResult.getDegree();
            DynamicObject degreeObject = HomCommonRepository.queryDynamicObject((String)"hbss_degree", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)degree)});
            if (degreeObject != null) {
                this.setFieldValueWithOcr("degreeid", degreeObject.getLong("id"));
            }
            String school = certificateOfDegreeResult.getSchool();
            DynamicObject schoolObject = HomCommonRepository.queryDynamicObject((String)"hbss_college", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)school)});
            if (schoolObject == null) continue;
            this.setFieldValueWithOcr("graduateschool", schoolObject.getLong("id"));
        }
    }

    private void setDiplomaResult(List<Object> results) {
        for (Object object : results) {
            DiplomaResult diplomaResult = (DiplomaResult)JSON.parseObject((String)JSON.toJSONString((Object)object), DiplomaResult.class);
            String diplomaId = diplomaResult.getDiplomaId();
            this.setFieldValueWithOcr(NUMBER_1010, diplomaId);
            String startYear = diplomaResult.getStartYear();
            this.setFieldValueWithOcr("admissiondate", DateUtils.parseDate((String)startYear));
            String endYear = diplomaResult.getEndYear();
            this.setFieldValueWithOcr("gradutiondate", DateUtils.parseDate((String)endYear));
            String discipline = diplomaResult.getDiscipline();
            this.setFieldValueWithOcr("major", discipline);
            String education = diplomaResult.getEducation();
            DynamicObject diplomaObject = HomCommonRepository.queryDynamicObject((String)"hbss_diploma", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)education)});
            if (diplomaObject != null) {
                this.setFieldValueWithOcr("educationid", diplomaObject.getLong("id"));
            }
            String school = diplomaResult.getSchool();
            DynamicObject schoolObject = HomCommonRepository.queryDynamicObject((String)"hbss_college", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)school)});
            if (schoolObject == null) continue;
            this.setFieldValueWithOcr("graduateschool", schoolObject.getLong("id"));
        }
    }

    private void updateHighDegree() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        QFilter filter = new QFilter("id", "!=", (Object)Long.valueOf(this.getView().getPageCache().get("eduid")));
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("candidateid"));
        DynamicObjectCollection coll = new DynamicObjectCollection();
        if ("1".equals(this.getView().getModel().getValue("ishighestdegree"))) {
            DynamicObjectCollection collection = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_caneduexp", new QFilter[]{filter});
            for (DynamicObject dyo : collection) {
                DynamicObject eduDyo = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_caneduexp"));
                HRDynamicObjectUtils.copy((DynamicObject)dyo, (DynamicObject)eduDyo);
                eduDyo.set("ishighestdegree", (Object)"0");
                eduDyo.set("id", (Object)0L);
                eduDyo.set("sourcevid", (Object)0L);
                coll.add((Object)eduDyo);
            }
            if (!CollectionUtils.isEmpty((Collection)coll)) {
                HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>(2);
                map.put("hcf_caneduexp", coll);
                ArrayList<HashMap<String, DynamicObjectCollection>> list = new ArrayList<HashMap<String, DynamicObjectCollection>>(1);
                list.add(map);
                IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
                this.getView().getPageCache().remove("eduid");
            }
        }
    }

    public void checkDataValidate(BeforeDoOperationEventArgs args) {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        if (IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
            args.setCancel(true);
            return;
        }
        DynamicObject eduDyo = this.getModel().getDataEntity();
        Object degreeObj = eduDyo.get("ishighestdegree");
        Object fulltimeObj = eduDyo.get("isfulltime");
        String errMsg = "";
        if (HRObjectUtils.isEmpty((Object)degreeObj)) {
            errMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u662f\u5426\u6700\u9ad8\u5b66\u5386\u201d \u3002", (String)"EduEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.cancelDoOperation(errMsg, args);
        }
        if (HRObjectUtils.isEmpty((Object)fulltimeObj)) {
            errMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u662f\u5426\u5168\u65e5\u5236\u201d \u3002", (String)"EduEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.cancelDoOperation(errMsg, args);
        }
        if (this.validateSameEdu(eduDyo)) {
            errMsg = ResManager.loadKDString((String)"\u8be5\u6761\u6559\u80b2\u7ecf\u5386\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"EduEdit_5", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.cancelDoOperation(errMsg, args);
        }
    }

    private void cancelDoOperation(String errMsg, BeforeDoOperationEventArgs args) {
        this.getView().showTipNotification(errMsg);
        args.setCancel(true);
    }

    private boolean validateSameEdu(DynamicObject eduDyo) {
        DynamicObjectCollection entity;
        EduPageServiceImpl service = new EduPageServiceImpl();
        Date admissionDate = eduDyo.getDate("admissiondate");
        Date gradutionDate = eduDyo.getDate("gradutiondate");
        DynamicObject graduate = eduDyo.getDynamicObject("graduateschool");
        String schoolrecord = service.checkEduIsHighSchool((Object)eduDyo) != false ? eduDyo.getString("otherschool") : eduDyo.getString("schoolrecord");
        DynamicObject education = eduDyo.getDynamicObject("educationid");
        String major = eduDyo.getString("major");
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        QFilter filter = new QFilter("admissiondate", "=", (Object)admissionDate).and("gradutiondate", "=", (Object)gradutionDate).and("schoolrecord", "=", (Object)schoolrecord).and("educationid", "=", education.get("id")).and("major", "=", (Object)major).and("id", "!=", this.getView().getFormShowParameter().getCustomParams().get("id"));
        if (graduate != null) {
            filter.and("graduateschool", "=", graduate.get("id"));
        }
        return !CollectionUtils.isEmpty((Collection)(entity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_caneduexp", new QFilter[]{filter})));
    }

    public void beforeClosed(BeforeClosedEvent event) {
        OperationStatus status;
        super.beforeClosed(event);
        String checkchangeOpKey = this.getPageCache().get(CACHEKEY_CHECKCHANGEOP);
        if (HRStringUtils.equals((String)checkchangeOpKey, (String)BTN_SAVE)) {
            event.setCheckDataChange(false);
        }
        if (HRStringUtils.equalsIgnoreCase((String)(status = this.getView().getFormShowParameter().getStatus()).name(), (String)"VIEW")) {
            return;
        }
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        IOnbrdCommonAppService.getInstance().releaseLockByHCF(id, "hcf_caneduexp", "modify");
    }

    private void updateView() {
        this.getModel().setDataChanged(false);
        if (HRStringUtils.equals((String)"hom_educationexp_show", (String)((String)this.getView().getFormShowParameter().getCustomParam("hom_educationexp_show")))) {
            this.getView().getParentView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView().getParentView());
            this.getView().close();
        } else {
            this.getView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    private void updateOrSaveEduInfo() {
        DynamicObject eduDyo = null;
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        if (!HRObjectUtils.isEmpty((Object)id)) {
            DynamicObjectCollection coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, "hcf_caneduexp");
            if (!CollectionUtils.isEmpty((Collection)coll)) {
                eduDyo = (DynamicObject)coll.get(0);
            }
        } else {
            id = ORM.create().genLongId("hcf_caneduexp");
        }
        DynamicObject personBaseDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_caneduexp"));
        DynamicObject canDyo = (DynamicObject)this.getView().getModel().getValue("candidate");
        this.getView().getPageCache().put("eduid", id.toString());
        personBaseDy.set("candidate", (Object)canDyo);
        if (eduDyo == null) {
            personBaseDy.set("boid", null);
        } else {
            personBaseDy.set("boid", (Object)eduDyo.getLong("boid"));
        }
        this.setPersonEduDy(personBaseDy);
        personBaseDy.set("id", (Object)(HRObjectUtils.isEmpty((Object)eduDyo) ? id : 0L));
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, kd.hr.hom.business.application.extension.IEducationExpService.class, (String)"kd.hr.hom.business.application.extension.IEducationExpService", null);
        hrPluginProxy.callReplace(p -> {
            p.setValueBeforeSaveEduExp(this.getView(), personBaseDy);
            return null;
        });
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create(null, IEducationExpService.class, (String)"kd.sdk.hr.hom.business.personinfo.IEducationExpService", null);
        hrPluginProxySdk.callReplace(p -> {
            p.setValueBeforeSaveEduExp(this.getView(), personBaseDy);
            return null;
        });
        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>(2);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)personBaseDy);
        map.put("hcf_caneduexp", collection);
        ArrayList<HashMap<String, DynamicObjectCollection>> list = new ArrayList<HashMap<String, DynamicObjectCollection>>(1);
        list.add(map);
        Map eduMap = IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
        if (((Boolean)eduMap.get("success")).booleanValue()) {
            HashMap<Long, DynamicObjectCollection> entities = new HashMap<Long, DynamicObjectCollection>(2);
            DynamicObjectCollection certCollection = this.getEduCertificates(candidateId, id);
            entities.put(candidateId, certCollection);
            hrPluginProxy.callReplace(p -> {
                p.setValueBeforeSaveEduCert(this.getView(), certCollection);
                return null;
            });
            hrPluginProxySdk.callReplace(p -> {
                p.setValueBeforeSaveEduCert(this.getView(), certCollection);
                return null;
            });
            IHomToHcfAppService.getInstance().saveMultiRowEntityWithoutDelete(entities, "hcf_educertificate");
            if (((Boolean)eduMap.get("success")).booleanValue()) {
                this.saveAttachmentfieldToPanel();
            } else {
                IHomToHcfAppService.getInstance().deleteById(id, "hcf_caneduexp");
                logger.info("save eduCert fail {}", (Object)id);
            }
        }
    }

    private DynamicObjectCollection getEduCertificates(Long candidateId, Long eduId) {
        DynamicObjectCollection certCollection = new DynamicObjectCollection();
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int endIndex = entry.getEntryData().getEndIndex();
        long[] eduCertIds = ORM.create().genLongIds("hcf_educertificate", endIndex);
        for (int i = 0; i < endIndex; ++i) {
            DynamicObject eduCerDy = null;
            DynamicObject certificateFromPage = this.getModel().getEntryRowEntity(ENTRY_ENTITY, i);
            DynamicObject certType = certificateFromPage.getDynamicObject(CERTTYPE);
            if (certType == null) {
                logger.info("Cannot save eduCerDy when certType is null");
                continue;
            }
            String certTypeNumber = certType.getString("id");
            long eduCertId = this.getCertIdFromPageCache(certTypeNumber);
            eduCerDy = eduCertId == 0L ? new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_educertificate")) : IHomToHcfAppService.getInstance().getById(Long.valueOf(eduCertId), "hcf_educertificate");
            eduCertId = eduCerDy.getLong("id");
            if (eduCertId == 0L) {
                eduCertId = eduCertIds[i];
                eduCerDy.set("id", (Object)eduCertId);
            }
            this.putCertIdToPageCache(certTypeNumber, eduCertId);
            String fieldSuffix = certTypeNumber;
            if (HRStringUtils.equals((String)certTypeNumber, (String)"1010") || HRStringUtils.equals((String)certTypeNumber, (String)"1020")) {
                String keyCertnumber = "certnumber" + fieldSuffix;
                eduCerDy.set("certnumber", this.getView().getModel().getValue(keyCertnumber));
                String keyIscertification = "iscertification" + fieldSuffix;
                eduCerDy.set("iscertification", this.getView().getModel().getValue(keyIscertification));
            }
            String keyNumber = "number" + fieldSuffix;
            eduCerDy.set("number", this.getView().getModel().getValue(keyNumber));
            eduCerDy.set(CERTTYPE, (Object)certType.getLong("id"));
            eduCerDy.set("edu", (Object)eduId);
            eduCerDy.set("candidate", (Object)candidateId);
            certCollection.add((Object)eduCerDy);
        }
        return certCollection;
    }

    private void setPersonEduDy(DynamicObject personBaseDy) {
        EduPageServiceImpl service = new EduPageServiceImpl();
        for (String str : this.EDUCATION_PROPERTIES.split(",")) {
            personBaseDy.set(str, this.getView().getModel().getValue(str));
        }
        PersonInfoExService.setExFieldValue((IFormView)this.getView(), (DynamicObject)personBaseDy);
        if (service.checkEduIsHighSchool((Object)this.getView().getModel().getDataEntity()).booleanValue()) {
            personBaseDy.set("schoolrecord", this.getView().getModel().getValue("otherschool"));
            QFilter filter = new QFilter("id", "=", (Object)BaseDataIdConstants.HBSS_COLLEGE_OTHER_SCHOOL).and("enable", "=", (Object)"1").and("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus()).and("iscurrentversion", "=", (Object)Boolean.TRUE);
            DynamicObject graduateShoolDy = HomCommonRepository.queryDynamicObject((String)"hbss_college", (String)"id", (QFilter[])new QFilter[]{filter});
            if (graduateShoolDy != null) {
                personBaseDy.set("graduateschool", (Object)graduateShoolDy);
            }
        }
    }

    private void setEduDate(DynamicObject obj) {
        Date admissionDate = obj.getDate("admissiondate");
        Date gradutionDate = obj.getDate("gradutiondate");
        DateEdit admissionDateEdit = (DateEdit)this.getView().getControl("admissiondate");
        DateEdit gradutionDateEdit = (DateEdit)this.getView().getControl("gradutiondate");
        if (gradutionDate != null) {
            admissionDateEdit.setMaxDate(DateUtils.selDay((Date)gradutionDate, (int)-1));
        }
        if (admissionDate != null) {
            gradutionDateEdit.setMinDate(DateUtils.selDay((Date)admissionDate, (int)1));
        }
    }

    private void setGraduateVisible(DynamicObject obj) {
        Long graduateNum = obj.getLong("graduateschool.id");
        EduPageServiceImpl service = new EduPageServiceImpl();
        if (BaseDataIdConstants.HBSS_COLLEGE_OTHER_SCHOOL.equals(graduateNum) && !service.checkEduIsHighSchool((Object)obj).booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"schoolrecord"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"schoolrecord"});
            this.getModel().setValue("schoolrecord", (Object)"");
        }
    }

    private void setValueEduCert(DynamicObject obj) {
        String certTypeNum;
        DynamicObject eduCertDyo = obj.getDynamicObject(CERTTYPE);
        if (eduCertDyo == null) {
            return;
        }
        String fieldSuffix = certTypeNum = eduCertDyo.getString("id");
        if (HRStringUtils.equals((String)certTypeNum, (String)"1010") || HRStringUtils.equals((String)certTypeNum, (String)"1020")) {
            String keyCertnumber = "certnumber" + fieldSuffix;
            this.getView().getModel().setValue(keyCertnumber, obj.get("certnumber"));
            String keyIscertification = "iscertification" + fieldSuffix;
            this.getView().getModel().setValue(keyIscertification, (Object)(obj.getBoolean("iscertification") ? "1" : "0"));
        }
        String keyNumber = "number" + fieldSuffix;
        this.getView().getModel().setValue(keyNumber, obj.get("number"));
        this.putCertIdToPageCache(certTypeNum, obj.getLong("id"));
    }

    private void setModelValue(DynamicObject obj) {
        for (String str : FIELDLIST) {
            Object tmpObj = obj.get(str);
            if (!(tmpObj instanceof Boolean)) continue;
            this.setModelValue((Boolean)tmpObj, str);
        }
    }

    private void setModelValue(Boolean bool, String key) {
        if (bool.booleanValue()) {
            this.getView().getModel().setValue(key, (Object)"1");
        } else {
            this.getView().getModel().setValue(key, (Object)"0");
        }
    }

    private void updateViewWithCountry() {
        DynamicObject collegeCountry = this.getModel().getDataEntity().getDynamicObject("collegecountry");
        if (HRObjectUtils.isEmpty((Object)collegeCountry)) {
            return;
        }
        Long countryId = collegeCountry.getLong("id");
        this.updateEntry(countryId);
        if (BaseDataConstants.BD_COUNTRY_ID_CHINA.equals(countryId)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"panelap1010", "panelap1020", "panelap1040"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"panelap1050", "panelap1030"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"panelap1010", "panelap1020", "panelap1040"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"panelap1050", "panelap1030"});
        }
    }

    private void updateEntry(Long countryId) {
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.deleteEntryData(ENTRY_ENTITY);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        if (BaseDataConstants.BD_COUNTRY_ID_CHINA.equals(countryId)) {
            ImmutableSet certtypeNumSet = ImmutableSet.of((Object)BaseDataIdConstants.HBSS_EDUCERTTYPE_1010, (Object)BaseDataIdConstants.HBSS_EDUCERTTYPE_1020, (Object)BaseDataIdConstants.HBSS_EDUCERTTYPE_1040, (Object)BaseDataIdConstants.HBSS_EDUCERTTYPE_1030);
            Map certtypeMap = IBaseDataDomainService.getInstance().getBaseDataInfoByIds("hbss_educerttype", (Collection)certtypeNumSet, null);
            List edugraduationList = IHomToHcfAppService.getInstance().queryAttach(Long.valueOf(this.getCertIdFromPageCache("1010")), IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(AttachmentTypeEnum.EDUGRADUATION.getId())));
            this.setTableValue(vs, 0, (DynamicObject)certtypeMap.get(BaseDataIdConstants.HBSS_EDUCERTTYPE_1010), edugraduationList);
            List edudegreeList = IHomToHcfAppService.getInstance().queryAttach(Long.valueOf(this.getCertIdFromPageCache("1020")), IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(AttachmentTypeEnum.EDUDEGREE.getId())));
            this.setTableValue(vs, 1, (DynamicObject)certtypeMap.get(BaseDataIdConstants.HBSS_EDUCERTTYPE_1020), edudegreeList);
            List edurecordList = IHomToHcfAppService.getInstance().queryAttach(Long.valueOf(this.getCertIdFromPageCache("1040")), IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(AttachmentTypeEnum.EDURECORD.getId())));
            this.setTableValue(vs, 2, (DynamicObject)certtypeMap.get(BaseDataIdConstants.HBSS_EDUCERTTYPE_1040), edurecordList);
        } else {
            ImmutableSet certtypeNumSet = ImmutableSet.of((Object)BaseDataIdConstants.HBSS_EDUCERTTYPE_1050, (Object)BaseDataIdConstants.HBSS_EDUCERTTYPE_1030);
            Map certtypeMap = IBaseDataDomainService.getInstance().getBaseDataInfoByIds("hbss_educerttype", (Collection)certtypeNumSet, null);
            List edudiplomaList = IHomToHcfAppService.getInstance().queryAttach(Long.valueOf(this.getCertIdFromPageCache("1050")), IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(AttachmentTypeEnum.EDUDIPLOMA.getId())));
            this.setTableValue(vs, 0, (DynamicObject)certtypeMap.get(BaseDataIdConstants.HBSS_EDUCERTTYPE_1050), edudiplomaList);
            List edudiplomaSeaList = IHomToHcfAppService.getInstance().queryAttach(Long.valueOf(this.getCertIdFromPageCache("1030")), IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(AttachmentTypeEnum.EDUDIPLOMASEA.getId())));
            this.setTableValue(vs, 1, (DynamicObject)certtypeMap.get(BaseDataIdConstants.HBSS_EDUCERTTYPE_1030), edudiplomaSeaList);
        }
        model.beginInit();
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
        if (BaseDataConstants.BD_COUNTRY_ID_CHINA.equals(countryId)) {
            this.setAttachmentfield(this.getCertIdFromPageCache("1010"), "attachmentpanelap", 0);
            this.setAttachmentfield(this.getCertIdFromPageCache("1020"), "attachmentpanelap", 1);
            this.setAttachmentfield(this.getCertIdFromPageCache("1040"), "attachmentpanelap", 2);
        } else {
            this.setAttachmentfield(this.getCertIdFromPageCache("1050"), "attachmentpanelap", 0);
            this.setAttachmentfield(this.getCertIdFromPageCache("1030"), "attachmentpanelap", 1);
        }
    }

    private void setTableValue(TableValueSetter vs, int indexRow, DynamicObject certtype, List<DynamicObject> attachmentList) {
        vs.set(CERTTYPE, (Object)certtype.getLong("id"), indexRow);
        if (!CollectionUtils.isEmpty(attachmentList)) {
            vs.set("id", (Object)attachmentList.get(0).getLong("id"), indexRow);
            if (!HRObjectUtils.isEmpty((Object)attachmentList.get(0).getDynamicObject("fmodifymen"))) {
                vs.set("uploaduser", (Object)attachmentList.get(0).getDynamicObject("fmodifymen").getLong("id"), indexRow);
            } else {
                vs.set("uploaduser", (Object)0L, indexRow);
            }
            vs.set("uploadtime", (Object)attachmentList.get(0).getDate("fmodifytime"), indexRow);
        }
    }

    private void setAttachmentfield(Long pkId, String attachmentPanelName, int indexRow) {
        if (pkId == null || pkId == 0L) {
            this.getModel().setValue("attachmentfield", (Object)new Object[0], indexRow);
            return;
        }
        AttachmentEdit attEdit = (AttachmentEdit)this.getView().getControl("attachmentfield");
        List attachmentDataPanels = IAttachmentAppService.getInstance().getAttachments("hcf_educertificate", (Object)pkId, attachmentPanelName);
        Set uidFromDBSet = attachmentDataPanels.stream().map(attachmentData -> attachmentData.get("uid").toString()).collect(Collectors.toSet());
        Set uidFromDBPreSet = (Set)JSONObject.parseObject((String)this.getPageCache().get("attachmentfield"), Set.class);
        if (!CollectionUtils.isEmpty((Collection)uidFromDBPreSet)) {
            uidFromDBSet.addAll(uidFromDBPreSet);
        }
        this.getPageCache().put("attachmentfield", JSONObject.toJSONString(uidFromDBSet));
        IAttachmentAppService.getInstance().changeAttachmentPanelUrl(attachmentDataPanels);
        List saveAttachmentFields = attEdit.getAttachmentModel().saveAttachments(attEdit.getModel(), this.getView().getPageId(), "hcf_educertificate", attachmentDataPanels);
        Map<String, DynamicObject> attachmentFieldMap = saveAttachmentFields.stream().collect(Collectors.toMap(attachment -> attachment.getString("uid"), attachment -> attachment, (oldValue, newValue) -> newValue));
        for (Map attachmentDataPanel : attachmentDataPanels) {
            String uid = attachmentDataPanel.get("uid").toString();
            DynamicObject attachmentFieldData = attachmentFieldMap.get(uid);
            Object creator = attachmentDataPanel.get("creator");
            if (attachmentFieldData.get("creator") instanceof DynamicObject) {
                attachmentFieldData.getDynamicObject("creator").set("name", creator);
            } else {
                attachmentFieldData.set("creator", creator);
            }
            attachmentFieldData.set("createtime", attachmentDataPanel.get("createdate"));
        }
        A[] attachmentIds = saveAttachmentFields.stream().map(attachment -> attachment.getLong("id")).toArray(Object[]::new);
        this.getModel().setValue("attachmentfield", attachmentIds, indexRow);
    }

    private void saveAttachmentfieldToPanel() {
        DynamicObject collegeCountry = this.getModel().getDataEntity().getDynamicObject("collegecountry");
        if (HRObjectUtils.isEmpty((Object)collegeCountry)) {
            return;
        }
        Long countryId = collegeCountry.getLong("id");
        if (BaseDataConstants.BD_COUNTRY_ID_CHINA.equals(countryId)) {
            this.saveAttachmentfieldToPanel(this.getCertIdFromPageCache("1010"), 0, AttachmentTypeEnum.EDUGRADUATION);
            this.saveAttachmentfieldToPanel(this.getCertIdFromPageCache("1020"), 1, AttachmentTypeEnum.EDUDEGREE);
            this.saveAttachmentfieldToPanel(this.getCertIdFromPageCache("1040"), 2, AttachmentTypeEnum.EDURECORD);
        } else {
            this.saveAttachmentfieldToPanel(this.getCertIdFromPageCache("1050"), 0, AttachmentTypeEnum.EDUDIPLOMA);
            this.saveAttachmentfieldToPanel(this.getCertIdFromPageCache("1030"), 1, AttachmentTypeEnum.EDUDIPLOMASEA);
        }
    }

    private void saveAttachmentfieldToPanel(Long pkId, int indexRow, AttachmentTypeEnum attachmentTypeEnum) {
        if (pkId == 0L) {
            logger.info("pkId==0");
            return;
        }
        DynamicObject dataFromPageEntry = this.getModel().getEntryRowEntity(ENTRY_ENTITY, indexRow);
        DynamicObjectCollection attachmentFieldData = dataFromPageEntry.getDynamicObjectCollection("attachmentfield");
        Map<String, DynamicObject> attachmentFieldMap = attachmentFieldData.stream().collect(Collectors.toMap(attachment -> attachment.getDynamicObject("fbasedataid").getString("uid"), attachment -> attachment, (oldValue, newValue) -> newValue));
        logger.info("attachmentFieldMap:{}", attachmentFieldMap);
        HashSet uidFromDBPreSet = (HashSet)JSONObject.parseObject((String)this.getPageCache().get("attachmentfield"), Set.class);
        if (!CollectionUtils.isEmpty((Collection)uidFromDBPreSet)) {
            uidFromDBPreSet.forEach(uid -> {
                if (attachmentFieldMap.get(uid) == null) {
                    AttachmentServiceHelper.remove((String)"hcf_educertificate", (Object)pkId, (Object)uid);
                }
            });
        } else {
            logger.info("uidFromDBPreSet == null");
            uidFromDBPreSet = new HashSet();
        }
        List attachmentDataPanel = IAttachmentAppService.getInstance().getAttachments("hcf_educertificate", (Object)pkId, "attachmentpanelap");
        logger.info("attachmentDataPanel:{}", (Object)attachmentDataPanel);
        for (Map attachmentData : attachmentDataPanel) {
            String oldUid = attachmentData.get("uid").toString();
            attachmentFieldMap.remove(oldUid);
        }
        DynamicObjectCollection newAttachFieldData = new DynamicObjectCollection();
        HashSet finalUidFromDBPreSet = uidFromDBPreSet;
        attachmentFieldMap.entrySet().forEach(entry -> {
            if (!finalUidFromDBPreSet.contains(entry.getKey())) {
                newAttachFieldData.add(entry.getValue());
            }
        });
        logger.info("newAttachFieldData:{}", (Object)newAttachFieldData);
        List attachemntsList = IAttachmentAppService.getInstance().buildAttachmentDataFromEdit("hcf_educertificate", pkId.toString(), newAttachFieldData);
        logger.info("attachemntsList:{}", (Object)attachemntsList);
        IAttachmentAppService.getInstance().saveAttachmentToHcf(attachemntsList, pkId.longValue(), attachmentTypeEnum.getId());
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        if (!IHomToCvpAppService.getInstance().isEnableOcr().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ocrtip"});
        }
    }

    private void ocrWithAttachmentfield(DynamicObject certType, DynamicObjectCollection ocrFlashDys) {
        if (HRObjectUtils.isEmpty((Object)certType) || CollectionUtils.isEmpty((Collection)ocrFlashDys)) {
            return;
        }
        Object[] urls = ocrFlashDys.stream().map(ocrFlashDy -> ocrFlashDy.getDynamicObject("fbasedataid").getString("url")).toArray();
        IFormView view = this.getView();
        switch (certType.getString("id")) {
            case "1010": {
                OcrToBusinessUtils.ocrWithData(urls, "hcf_caneduexp", "OPM-Diploma", view);
                break;
            }
            case "1020": {
                OcrToBusinessUtils.ocrWithData(urls, "hcf_caneduexp", "OPM-CertificateOfDegree", view);
                break;
            }
        }
    }

    private void refreshEntryRow(int rowIndex, DynamicObjectCollection newAttachDys) {
        if (CollectionUtils.isEmpty((Collection)newAttachDys)) {
            this.getModel().setValue("uploaduser", null, rowIndex);
            this.getModel().setValue("uploadtime", null, rowIndex);
        } else {
            this.getModel().setValue("uploaduser", (Object)((DynamicObject)newAttachDys.get(0)).getDynamicObject("fbasedataid").getDynamicObject("creator").getLong("id"), rowIndex);
            this.getModel().setValue("uploadtime", (Object)((DynamicObject)newAttachDys.get(0)).getDynamicObject("fbasedataid").getDate("modifytime"), rowIndex);
        }
    }

    static {
        FIELDLIST.add("isfulltime");
        FIELDLIST.add("isoverseasexp");
        FIELDLIST.add("ishighestdegree");
    }
}

