/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.EduPageServiceImpl;
import kd.hr.hom.business.application.impl.page.LabelApAdatper;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.HcfRepository;
import kd.hr.hom.business.domain.service.base.IUploadConfigDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.formplugin.common.ApBuildUtils;
import kd.hr.hom.formplugin.web.base.HcfDataBaseEdit;

public class EducationExpShowPlugin
extends HcfDataBaseEdit {
    private static final Log logger = LogFactory.getLog(EducationExpShowPlugin.class);
    private static final String COLLEGECHARACT = "collegecharact";
    private static final String BTN_EDIT = "btn_edit";
    private static final String BTN_DEL = "btn_del";
    private static final String BTN_VIEW = "btn_view";
    private static final long ATTACH_GRA_TYPE = 1041840383514029056L;
    private static final HRBaseServiceHelper HBSS_COLLEGE_HEPLER = new HRBaseServiceHelper("hbss_college");

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long pkId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("id"));
        Map customParams = formShowParameter.getCustomParams();
        if (String.valueOf(customParams.get("index")).contains("last")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap9"});
        }
        if (!HRObjectUtils.isEmpty((Object)pkId)) {
            this.setValueWithMap(customParams);
        }
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("onbrdid"));
        boolean isEnrolled = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        if (isEnrolled) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"editanddeleteap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"viewap"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if (BTN_EDIT.equals(operate.getOperateKey())) {
            String appId = this.getView().getFormShowParameter().getAppId();
            if (IOnbrdCommonAppService.getInstance().checkPermission("hom_educationexp_show", "4715a0df000000ac", appId) || IOnbrdCommonAppService.getInstance().checkPermission("hom_educationexp_view", "4715a0df000000ac", appId)) {
                this.editEditPage(OperationStatus.EDIT);
            } else {
                this.editEditPage(OperationStatus.VIEW);
            }
        }
        if (BTN_DEL.equals(operate.getOperateKey())) {
            this.delEduCard(this.getView().getFormShowParameter().getCustomParam("id").toString());
        }
        if (BTN_VIEW.equals(operate.getOperateKey())) {
            this.editEditPage(OperationStatus.VIEW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)actionId, (String)BTN_DEL) && MessageBoxResult.Yes == resultValue) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String eduCardId = pageCache.get("eduCardId");
            try {
                IHomToHcfAppService.getInstance().deleteById(Long.valueOf(eduCardId), "hcf_caneduexp");
                QFilter filter = new QFilter("edu", "=", (Object)Long.valueOf(eduCardId));
                DynamicObject[] dyos = HcfRepository.queryHcfAttachedData((String)"hcf_educertificate", (String)"id", (QFilter[])new QFilter[]{filter});
                if (!Objects.isNull(dyos)) {
                    List edulist;
                    HashSet<Long> ids = new HashSet<Long>(dyos.length);
                    HashSet<String> targetIds = new HashSet<String>(dyos.length);
                    for (DynamicObject dyo : dyos) {
                        ids.add(dyo.getLong("id"));
                        targetIds.add(String.valueOf(dyo.getLong("id")));
                    }
                    HcfRepository.deleteByIds(ids, (String)"hcf_educertificate");
                    if (!CollectionUtils.isEmpty(targetIds) && !CollectionUtils.isEmpty((Collection)(edulist = IHomToHcfAppService.getInstance().queryAttach(targetIds, IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(1041840383514029056L)), "attachmentpanelap")))) {
                        this.delAllAttachment(edulist);
                    }
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"LanguageSkillViewPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                this.getView().getParentView().updateView();
                this.getView().sendFormAction(this.getView().getParentView());
            }
            finally {
                IOnbrdCommonAppService.getInstance().releaseLockByHCF(Long.valueOf(eduCardId), "hcf_caneduexp", "delete");
            }
        }
    }

    private void delAllAttachment(List<DynamicObject> list) {
        for (DynamicObject dyo : list) {
            AttachmentServiceHelper.remove((String)dyo.getString("fbilltype"), (Object)dyo.get("FInterID"), (Object)dyo.get("fnumber"));
        }
    }

    private void editEditPage(OperationStatus operationStatus) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(operationStatus);
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        if (!this.checkDataIsExistById(id, candidateId)) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u6761\u6559\u80b2\u7ecf\u5386\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"EduEdit_6", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        if (HRStringUtils.equals((String)OperationStatus.EDIT.name(), (String)operationStatus.name()) && !this.getRequireLock(id, "modify")) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        formShowParameter.setCustomParam("onbrdid", (Object)onbrdBillId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_educationexp_edit");
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("id", this.getView().getFormShowParameter().getCustomParam("id"));
        formShowParameter.setCustomParam("hom_educationexp_show", (Object)"hom_educationexp_show");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6559\u80b2\u7ecf\u5386", (String)"EduEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private boolean getRequireLock(Long id, String opKey) {
        return IOnbrdCommonAppService.getInstance().tryRequireLockByHCF(this.getView(), id, "hcf_caneduexp", opKey);
    }

    private boolean checkDataIsExistById(Long id, Long candidateId) {
        DynamicObjectCollection coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, "hcf_caneduexp");
        return !CollectionUtils.isEmpty((Collection)coll);
    }

    private void delEduCard(String id) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        if (!this.checkDataIsExistById(Long.valueOf(id), candidateId)) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u6761\u6559\u80b2\u7ecf\u5386\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"EduEdit_6", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        if (!this.getRequireLock(Long.valueOf(id), "delete")) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u8bb0\u5f55\uff1f", (String)"CanContactEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_DEL, (IFormPlugin)this));
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("eduCardId", id);
    }

    private void setValueWithMap(Map<String, Object> customParams) {
        QFilter filter;
        DynamicObject college;
        String[] arr;
        for (String str : arr = "admissiondate,gradutiondate,graduateschool,collegecountry,educationid,degreeid,faculty,major,isfulltime,ishighestdegree,isoverseasexp".split(",")) {
            this.setLabelData(this.getView(), str, customParams.get(str));
        }
        Object numObj = customParams.get("graduateschoolid");
        Long longValOfCustomParam = HRJSONUtils.getLongValOfCustomParam((Object)numObj);
        if (numObj != null && BaseDataIdConstants.HBSS_COLLEGE_OTHER_SCHOOL.equals(longValOfCustomParam)) {
            Object paramsObj = customParams.get("schoolrecord");
            String otherSchool = paramsObj == null ? "" : paramsObj.toString();
            ApBuildUtils.setLabelData(this.getView(), "graduateschool", otherSchool);
            Object eduObj = customParams.get("educationid.number");
            EduPageServiceImpl service = new EduPageServiceImpl();
            if (eduObj != null && service.checkEduIsHighSchool((Object)eduObj.toString()).booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"degreeidtitle"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"degreeid"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"facultytitle"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"faculty"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"majortitle"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"major"});
            }
        }
        if (this.isHighFullTimeOverseas(customParams.get("isfulltime"))) {
            this.setLabelStyle(ResManager.loadKDString((String)"\u5168\u65e5\u5236", (String)"EduEdit_7", (String)"hr-hom-formplugin", (Object[])new Object[0]), "isfullname", 0);
        }
        if (this.isHighFullTimeOverseas(customParams.get("ishighestdegree"))) {
            this.setLabelStyle(ResManager.loadKDString((String)"\u6700\u9ad8\u5b66\u5386", (String)"EduEdit_8", (String)"hr-hom-formplugin", (Object[])new Object[0]), "ishighestdegree", 0);
        }
        if (this.isHighFullTimeOverseas(customParams.get("isoverseasexp"))) {
            this.setLabelStyle(ResManager.loadKDString((String)"\u6d77\u5916\u7ecf\u5386", (String)"EduEdit_9", (String)"hr-hom-formplugin", (Object[])new Object[0]), "isoverseasexp", 0);
        }
        if (!HRObjectUtils.isEmpty((Object)(college = HBSS_COLLEGE_HEPLER.queryOne(COLLEGECHARACT, filter = new QFilter("id", "=", customParams.get("graduateschoolid")))))) {
            DynamicObjectCollection collection = (DynamicObjectCollection)college.get(COLLEGECHARACT);
            for (int i = 0; i < collection.size(); ++i) {
                this.setLabelStyle(((DynamicObject)collection.get(i)).getDynamicObject("fbasedataid").getString("name"), COLLEGECHARACT, i);
            }
        }
    }

    private void setLabelStyle(String name, String key, int i) {
        Container flexPanel = (Container)this.getView().getControl("flexpanelap4");
        LabelApAdatper eduLabelAdapter = new LabelApAdatper(key + i, name){

            public void setStyle() {
                this.margin.setTop("1px");
                this.margin.setLeft("8px");
                this.margin.setRight("8px");
            }
        };
        flexPanel.addControls(Collections.singletonList(eduLabelAdapter.getLabelAp().createControl()));
    }

    private boolean isHighFullTimeOverseas(Object obj) {
        if (obj == null) {
            return false;
        }
        String str = String.valueOf(obj);
        return HRStringUtils.equals((String)"true", (String)str);
    }

    private void setLabelData(IFormView formView, String labelKey, Object data) {
        Label label = (Label)formView.getControl(labelKey);
        if (HRStringUtils.isNotEmpty((String)labelKey) && !HRObjectUtils.isEmpty((Object)data)) {
            if (label != null) {
                label.setText(data.toString());
            }
        } else {
            label.setText("");
        }
    }
}

