/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.OnbrdNullPageServiceImpl;
import kd.hr.hom.business.application.impl.page.PanelApAdatper;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.web.base.HcfDataBaseEdit;

public class EducationExpViewPlugin
extends HcfDataBaseEdit {
    private static final String BTN_ADD = "btn_add";
    private static final String KEY_FLEXPANELAP1 = "flexpanelap1";
    private static final String KEY_ONBRDNULLPAGE = "onbrdnullpage";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        this.generateViewForEnrollStatus(onbrdBillId, this.getView(), BTN_ADD);
        this.refreshEntryEntity();
    }

    private void refreshEntryEntity() {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        DynamicObjectCollection eduInfos = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_caneduexp");
        if (CollectionUtils.isEmpty((Collection)eduInfos)) {
            new OnbrdNullPageServiceImpl().loadOnbrdNullPage(this.getView());
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEXPANELAP1});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ONBRDNULLPAGE});
        this.showUpEduView(eduInfos, candidateId);
    }

    private void showUpEduView(DynamicObjectCollection eduCollection, Long candidateId) {
        List eduInfos = eduCollection.stream().sorted(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                int compare = 1;
                Date admissiondate1 = o1.getDate("admissiondate");
                Date admissiondate2 = o2.getDate("admissiondate");
                if (admissiondate1 != null && admissiondate2 != null && (compare = admissiondate2.compareTo(admissiondate1)) == 0) {
                    return this.compareGradution(o1, o2, compare);
                }
                return compare;
            }

            private int compareGradution(DynamicObject o1, DynamicObject o2, int compare) {
                if (compare == 0) {
                    Date gradutiondate1 = o1.getDate("gradutiondate");
                    Date gradutiondate2 = o2.getDate("gradutiondate");
                    if (gradutiondate1 != null && gradutiondate2 != null) {
                        return gradutiondate2.compareTo(gradutiondate1);
                    }
                }
                return compare;
            }
        }).collect(Collectors.toList());
        FlexPanelAp allEduPanel = this.generateEduPanel(KEY_FLEXPANELAP1);
        for (int i = 0; i < eduInfos.size(); ++i) {
            DynamicObject eduInfo = (DynamicObject)eduInfos.get(i);
            PanelApAdatper eduPanelStyleAdapter = new PanelApAdatper("eduPanel" + i){

                public void setStyle() {
                    this.panelAp.setGrow(0);
                    this.panelAp.setShrink(0);
                    this.panelAp.setDirection("column");
                }
            };
            Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("eduPanel" + i);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setFormId("hom_educationexp_show");
            formShowParameter.setCustomParams(this.getParamsMapForShowEdu(eduInfo));
            if (i == eduInfos.size() - 1) {
                formShowParameter.setCustomParam("index", (Object)(i + "last"));
            } else {
                formShowParameter.setCustomParam("index", (Object)(i + ""));
            }
            formShowParameter.setCustomParam("candidateid", (Object)candidateId);
            formShowParameter.setCustomParam("onbrdid", (Object)onbrdId);
            formShowParameter.setCustomParam("id", eduInfo.get("id"));
            this.getView().showForm(formShowParameter);
            allEduPanel.getItems().add(eduPanelStyleAdapter.getPanelAp());
        }
        this.getView().updateControlMetadata(allEduPanel.getKey(), allEduPanel.createControl());
    }

    private Map<String, Object> getParamsMapForShowEdu(DynamicObject eduInfo) {
        String[] arr = "admissiondate,gradutiondate,graduateschool,collegecountry,educationid,degreeid,faculty,major,isfulltime,ishighestdegree,isoverseasexp".split(",");
        HashMap customParamsmap = Maps.newHashMapWithExpectedSize((int)arr.length);
        for (String str : arr) {
            String resStr = "";
            Object obj = eduInfo.get(str);
            if (HRObjectUtils.isEmpty((Object)obj)) {
                customParamsmap.put(str, resStr);
                continue;
            }
            if (obj instanceof Date) {
                resStr = HRInteDateTimeUtil.formatDate((String)"hom_educationexp_edit", (String)str, (Date)((Date)obj));
            } else if (obj instanceof DynamicObject) {
                if ("graduateschool".equals(str)) {
                    Long id = ((DynamicObject)obj).getLong("id");
                    customParamsmap.put("graduateschoolid", id);
                    customParamsmap.put("graduateschool.number", ((DynamicObject)obj).getString("number"));
                }
                if ("educationid".equals(str)) {
                    customParamsmap.put("educationid.number", ((DynamicObject)obj).getString("number"));
                }
                resStr = ((DynamicObject)obj).getString("name");
            } else {
                resStr = obj.toString();
            }
            customParamsmap.put(str, resStr);
        }
        customParamsmap.put("schoolrecord", eduInfo.getString("schoolrecord"));
        return customParamsmap;
    }

    private FlexPanelAp generateEduPanel(String panelKey) {
        PanelApAdatper mainPanelApt = new PanelApAdatper(panelKey){

            public void setStyle() {
                this.panelAp.setGrow(0);
                this.panelAp.setShrink(0);
                this.panelAp.setDirection("column");
            }
        };
        return mainPanelApt.getPanelAp();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if (BTN_ADD.equals(operate.getOperateKey())) {
            this.addEduView();
        }
    }

    private boolean generateViewForEnrollStatus(Long onbrdId, IFormView view, String ... btnStrs) {
        boolean isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        if (isEnroll) {
            view.setVisible(Boolean.FALSE, btnStrs);
            return true;
        }
        return false;
    }

    private void addEduView() {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_educationexp_edit");
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("isexistdegree", (Object)this.checkIsExistHighDegree(candidateId));
        formShowParameter.setCustomParam("onbrdid", this.getView().getFormShowParameter().getCustomParam("id"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6559\u80b2\u7ecf\u5386", (String)"EduEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private Boolean checkIsExistHighDegree(Long candidateId) {
        DynamicObjectCollection eduInfos = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_caneduexp");
        if (!CollectionUtils.isEmpty((Collection)eduInfos)) {
            for (DynamicObject eduInfo : eduInfos) {
                boolean flag = eduInfo.getBoolean("ishighestdegree");
                if (!flag) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

