/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.extension.PersonInfoExService;
import kd.hr.hom.business.application.onbrd.IAttachmentAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.base.IUploadConfigDomainService;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.util.PutValueToModelUtils;
import kd.hr.hom.formplugin.web.base.HomDataBaseEdit;
import kd.sdk.hr.hom.business.personinfo.IBasePeronInfoService;
import kd.sdk.hr.hom.business.personinfo.ILanguageSkillService;

public class LanguageSkillEditPlugin
extends HomDataBaseEdit
implements BeforeF7SelectListener,
UploadListener {
    private String LANGUAGE_PROPERTIES = "language,certificate,score,readscore,writescore,listenscore,speakscore,signofftime,isworkinglanguage,read,write,listen,speak,othercertificate";
    private String LANGUAGE_SHOW_PROPERTIES = "language,certificate,score,readscore,writescore,listenscore,speakscore,signofftime,isworkinglanguage,othercertificate";
    private static final String BTN_SAVE = "btnsave";
    private static final String CERTIFICATE = "certificate";
    private static final String LANGUAGETYPE = "languagetype";
    private static final String LANGUAGE = "language";
    private static final long ATTACH_TYPE = 1057970182745534464L;
    private static final String ATTACHMENT_NAME = "attachmentpanelap";
    public static final String KEY_SCORE = "score";
    public static final String KEY_READS_CORE = "readscore";
    public static final String KEY_WRITES_CORE = "writescore";
    public static final String KEY_LISTENS_CORE = "listenscore";
    public static final String KEY_SPEAKS_CORE = "speakscore";
    public static final String KEY_SIGNOFFTIME = "signofftime";
    private static final String ISWORKINGLANGUAGE = "isworkinglanguage";
    private static final String OTHERCERTIFICATE = "othercertificate";
    private static final String LISTEN = "listen";
    private static final String SPEAK = "speak";
    private static final String READ = "read";
    private static final String WRITE = "write";
    Map<String, String> langMap = new ImmutableMap.Builder().put((Object)"listenscore", (Object)"listen").put((Object)"speakscore", (Object)"speak").put((Object)"readscore", (Object)"read").put((Object)"writescore", (Object)"write").build();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_SAVE});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(CERTIFICATE);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_NAME);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isAlreadyClose = this.getPageCache().get("isalreadyclose");
        if (this.getModel().getDataChanged() && HRStringUtils.isEmpty((String)isAlreadyClose)) {
            e.setCancel(true);
            this.clickCancelChanged("cancel");
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (HRStringUtils.equalsIgnoreCase((String)status.name(), (String)"VIEW")) {
                return;
            }
            Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            IOnbrdCommonAppService.getInstance().releaseLockByHCF(id, "hcf_canlgability", "modify");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.validateData(args);
    }

    private void validateData(BeforeDoOperationEventArgs args) {
        DynamicObject languagetypeDyo;
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        if (IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
            args.setCancel(true);
            return;
        }
        DynamicObject dyo = this.getModel().getDataEntity();
        DynamicObject certificateDyo = dyo.getDynamicObject(CERTIFICATE);
        if (this.validateSameLangue(certificateDyo, languagetypeDyo = dyo.getDynamicObject(LANGUAGE))) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u8bed\u8a00\u8bc1\u4e66\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"LanguageEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            args.setCancel(true);
        }
    }

    private boolean validateSameLangue(DynamicObject certificateDyo, DynamicObject languagetypeDyo) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        QFilter filter = new QFilter(CERTIFICATE, "=", certificateDyo.get("id")).and(LANGUAGE, "=", languagetypeDyo.get("id")).and("id", "!=", this.getView().getFormShowParameter().getCustomParams().get("id"));
        DynamicObjectCollection entity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_canlgability", new QFilter[]{filter});
        return !CollectionUtils.isEmpty((Collection)entity);
    }

    public void remove(UploadEvent evt) {
        Object[] urls;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long maidId = (Long)formShowParameter.getCustomParam("id");
        for (Object url : urls = evt.getUrls()) {
            if (!(url instanceof LinkedHashMap)) continue;
            AttachmentServiceHelper.remove((String)"hcf_canlgability", (Object)maidId, ((LinkedHashMap)url).get("uid"));
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        if (this.getModel().getValue(LANGUAGE) == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{CERTIFICATE});
        }
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        cache.remove("TampAttCache" + this.getView().getPageId());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.equals(CERTIFICATE)) {
            if (this.getModel().getValue(LANGUAGE) != null) {
                QFilter languageFilter = new QFilter(LANGUAGETYPE, "=", (Object)((DynamicObject)this.getModel().getValue(LANGUAGE)).getLong("id"));
                beforeF7SelectEvent.addCustomQFilter(languageFilter);
            } else {
                beforeF7SelectEvent.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        DynamicObject dyo = this.getModel().getDataEntity();
        if (LANGUAGE.equals(name)) {
            this.getView().setEnable(Boolean.valueOf(this.getModel().getValue(LANGUAGE) != null), new String[]{CERTIFICATE});
            this.getModel().setValue(CERTIFICATE, null);
        }
        if (HRStringUtils.equals((String)name, (String)CERTIFICATE)) {
            this.setOtherCertVisible(dyo);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (success && "save".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.updateOrSaveLanguageInfo();
            this.getPageCache().put("isalreadyclose", "1");
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{OTHERCERTIFICATE});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String status = formShowParameter.getStatus().name();
        if (HRStringUtils.equals((String)status, (String)"VIEW")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE});
            this.getView().setEnable(Boolean.FALSE, new String[]{ATTACHMENT_NAME});
        }
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("candidateid"));
        this.getView().getModel().setValue("candidate", (Object)candidateId);
        Long maidId = (Long)formShowParameter.getCustomParam("id");
        if (!HRObjectUtils.isEmpty((Object)maidId)) {
            Set exFields = PersonInfoExService.getExFields((IFormView)this.getView());
            if (!CollectionUtils.isEmpty((Collection)exFields)) {
                String ex = "," + String.join((CharSequence)",", exFields);
                this.LANGUAGE_PROPERTIES = this.LANGUAGE_PROPERTIES + ex;
                this.LANGUAGE_SHOW_PROPERTIES = this.LANGUAGE_SHOW_PROPERTIES + ex;
            }
            HashMap<String, String> entityFields = new HashMap<String, String>(2);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ILanguageSkillService.class, (String)"kd.sdk.hr.hom.business.personinfo.ILanguageSkillService", null);
            hrPluginProxy.callReplace(IBasePeronInfoService::getExtProperties).forEach(fieldStr -> {
                this.LANGUAGE_PROPERTIES = fieldStr;
            });
            entityFields.put("hcf_canlgability", this.LANGUAGE_PROPERTIES);
            Map map = IHomToHcfAppService.getInstance().getCandidate(candidateId, entityFields, Long.valueOf(0L));
            DynamicObjectCollection dataCollection = (DynamicObjectCollection)map.get("hcf_canlgability");
            for (DynamicObject obj : dataCollection) {
                if (obj.getLong("id") != maidId.longValue()) continue;
                this.setOtherCertVisible(obj);
                hrPluginProxy.callReplace(ILanguageSkillService::getExtShowField).forEach(fieldStr -> {
                    this.LANGUAGE_SHOW_PROPERTIES = fieldStr;
                });
                PutValueToModelUtils.putValueToModel((IFormView)this.getView(), (DynamicObject)obj, (String[])this.LANGUAGE_SHOW_PROPERTIES.split(","));
                PutValueToModelUtils.putValueToModel((IFormView)this.getView(), (DynamicObject)obj, this.langMap);
                break;
            }
            List list = IHomToHcfAppService.getInstance().queryAttach(maidId, IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(1057970182745534464L)));
            IAttachmentAppService.getInstance().bindAttachmentInfo(list, this.getView(), ATTACHMENT_NAME);
        } else {
            this.getView().getModel().setValue(ISWORKINGLANGUAGE, (Object)"1");
        }
    }

    private void setOtherCertVisible(DynamicObject obj) {
        long certNum;
        try {
            certNum = obj.getLong("certificate.id");
        }
        catch (Exception e) {
            certNum = 0L;
        }
        if (BaseDataIdConstants.HBSS_LANGUAGECERT_1420.equals(certNum)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{OTHERCERTIFICATE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{OTHERCERTIFICATE});
            this.getModel().setValue(OTHERCERTIFICATE, null);
        }
    }

    private void updateOrSaveLanguageInfo() {
        DynamicObject langDyo = null;
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        if (!HRObjectUtils.isEmpty((Object)id)) {
            DynamicObjectCollection coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, "hcf_canlgability");
            if (!CollectionUtils.isEmpty((Collection)coll)) {
                langDyo = (DynamicObject)coll.get(0);
            }
        } else {
            id = ORM.create().genLongId("hcf_canlgability");
        }
        DynamicObject personBaseDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canlgability"));
        if (langDyo == null) {
            personBaseDy.set("boid", null);
        } else {
            personBaseDy.set("boid", (Object)langDyo.getLong("boid"));
        }
        personBaseDy.set("id", (Object)(HRObjectUtils.isEmpty((Object)langDyo) ? id : 0L));
        personBaseDy.set("candidate", this.getView().getModel().getValue("candidate"));
        personBaseDy.set(CERTIFICATE, this.getView().getModel().getValue(CERTIFICATE));
        personBaseDy.set(LANGUAGE, this.getView().getModel().getValue(LANGUAGE));
        personBaseDy.set(KEY_SCORE, this.getView().getModel().getValue(KEY_SCORE));
        personBaseDy.set(LISTEN, this.getView().getModel().getValue(KEY_LISTENS_CORE));
        personBaseDy.set(READ, this.getView().getModel().getValue(KEY_READS_CORE));
        personBaseDy.set(SPEAK, this.getView().getModel().getValue(KEY_SPEAKS_CORE));
        personBaseDy.set(WRITE, this.getView().getModel().getValue(KEY_WRITES_CORE));
        personBaseDy.set(KEY_SIGNOFFTIME, this.getView().getModel().getValue(KEY_SIGNOFFTIME));
        personBaseDy.set(ISWORKINGLANGUAGE, this.getView().getModel().getValue(ISWORKINGLANGUAGE));
        personBaseDy.set(OTHERCERTIFICATE, this.getView().getModel().getValue(OTHERCERTIFICATE));
        PersonInfoExService.setExFieldValue((IFormView)this.getView(), (DynamicObject)personBaseDy);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ILanguageSkillService.class, (String)"kd.sdk.hr.hom.business.personinfo.ILanguageSkillService", null);
        hrPluginProxy.callReplace(plugin -> {
            plugin.setDataModel(personBaseDy, this.getView().getModel());
            return null;
        });
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)personBaseDy);
        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>(2);
        map.put("hcf_canlgability", collection);
        ArrayList<HashMap<String, DynamicObjectCollection>> list = new ArrayList<HashMap<String, DynamicObjectCollection>>(1);
        list.add(map);
        IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
        AttachmentPanel attachmentPanelAp = (AttachmentPanel)this.getView().getControl(ATTACHMENT_NAME);
        List attachmentData = attachmentPanelAp.getAttachmentData();
        IAttachmentAppService.getInstance().saveAttachmentToHcf(attachmentData, id.longValue(), 1057970182745534464L);
    }
}

