/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.OnbrdNullPageServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.base.IUploadConfigDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.sdk.hr.hom.business.personinfo.ILanguageSkillService;

public class LanguageSkillViewPlugin
extends HRDynamicFormBasePlugin
implements UploadListener {
    private static final String BTN_ADD = "btn_add";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final long ATTACH_TYPE = 1032641603216391168L;
    public static final String KEY_LANGUAGE = "language";
    public static final String KEY_CERTIFICATE = "certificate";
    public static final String KEY_SCORE = "score";
    public static final String KEY_READS_CORE = "readscore";
    public static final String KEY_WRITES_CORE = "writescore";
    public static final String KEY_LISTENS_CORE = "listenscore";
    public static final String KEY_SPEAKS_CORE = "speakscore";
    private static final String ISWORKINGLANGUAGE = "isworkinglanguage";
    public static final String KEY_SIGNOFFTIME = "signofftime";
    private static final String DONOTHING_DELETE = "donothing_delete";
    private static final String LISTEN = "listen";
    private static final String SPEAK = "speak";
    private static final String READ = "read";
    private static final String WRITE = "write";
    private static final Log logger = LogFactory.getLog(LanguageSkillViewPlugin.class);
    private static final String FLEXPANELAP_1 = "flexpanelap1";
    private static final String ONBRDNULLPAGE = "onbrdnullpage";
    private static final String OPERATIONCOLUMNAP = "operationcolumnap";
    private static final String OPERATIONCOLUMNAP_1 = "operationcolumnap1";
    private static final String DONOTHING_EDIT = "donothing_edit";
    private static final String DONOTHING_VIEW = "donothing_view";
    private static final String FATTACHMENTNAME = "fattachmentname";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.refreshEntryEntity();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        IOnbrdBillDomainService.getInstance().generateViewForEnrollStatus(onbrdId, this.getView(), new String[]{BTN_ADD});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("hom_languageskill_edit".equals(actionId)) {
            this.refreshEntryEntity();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operationKey = (FormOperate)args.getSource();
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject languageInfo = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, entryCurrentRowIndex);
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        String operateKey = operationKey.getOperateKey();
        if ((DONOTHING_EDIT.equals(operateKey) || DONOTHING_DELETE.equals(operateKey) || BTN_ADD.equals(operateKey)) && IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
            args.setCancel(true);
            return;
        }
        switch (operateKey) {
            case "donothing_view": {
                this.viewLanguageSkill(candidateId, languageInfo);
                break;
            }
            case "donothing_edit": {
                String appId = this.getView().getFormShowParameter().getAppId();
                if (IOnbrdCommonAppService.getInstance().checkPermission("hom_languageskill_view", "4715a0df000000ac", appId)) {
                    this.editLanguageSkill(candidateId, languageInfo);
                    break;
                }
                this.viewLanguageSkill(candidateId, languageInfo);
                break;
            }
            case "donothing_delete": {
                this.delLanguageSkill(languageInfo);
                break;
            }
            case "btn_add": {
                this.addLanguageSkill(candidateId);
                break;
            }
        }
    }

    private void viewLanguageSkill(Long candidateId, DynamicObject languageInfo) {
        this.showUpdatePage(candidateId, languageInfo, OperationStatus.VIEW);
    }

    private void delLanguageSkill(DynamicObject languageInfo) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        if (!this.checkDataIsExistById(languageInfo.getLong("id"), candidateId)) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u6761\u8bed\u8a00\u6280\u80fd\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"LanguageEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        if (!this.getRequireLock(languageInfo.getLong("id"), "delete")) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u8bb0\u5f55\uff1f", (String)"LanguageSkillViewPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DONOTHING_DELETE, (IFormPlugin)this));
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("languageId", languageInfo.getString("id"));
    }

    private void addLanguageSkill(Long candidateId) {
        this.showNewPage(candidateId);
    }

    private void editLanguageSkill(Long candidateId, DynamicObject languageInfo) {
        this.showUpdatePage(candidateId, languageInfo, OperationStatus.EDIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)actionId, (String)DONOTHING_DELETE) && MessageBoxResult.Yes == resultValue) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String languageId = pageCache.get("languageId");
            try {
                Map result = IHomToHcfAppService.getInstance().deleteById(Long.valueOf(languageId), "hcf_canlgability");
                Boolean success = (Boolean)result.get("success");
                if (success.booleanValue()) {
                    List list = IHomToHcfAppService.getInstance().queryAttach(Long.valueOf(languageId), IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(1032641603216391168L)));
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        DynamicObject dynamicObject = (DynamicObject)list.get(0);
                        AttachmentServiceHelper.remove((String)dynamicObject.getString("fbilltype"), (Object)languageId);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"LanguageSkillViewPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    this.getView().updateView();
                } else {
                    this.getView().showErrorNotification((String)result.get("message"));
                }
            }
            finally {
                IOnbrdCommonAppService.getInstance().releaseLockByHCF(Long.valueOf(languageId), "hcf_canlgability", "delete");
            }
        }
    }

    private void showNewPage(Long personId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_languageskill_edit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hom_languageskill_edit"));
        formShowParameter.setCustomParam("candidateid", (Object)personId);
        formShowParameter.setCustomParam("onbrdid", this.getView().getFormShowParameter().getCustomParam("id"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u8bed\u8a00\u6280\u80fd", (String)"LanguageEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void showUpdatePage(Long candidateId, DynamicObject skillInfo, OperationStatus status) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(status);
        Long id = skillInfo.getLong("id");
        if (!this.checkDataIsExistById(id, candidateId)) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u6761\u8bed\u8a00\u6280\u80fd\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"LanguageEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        if (HRStringUtils.equals((String)OperationStatus.EDIT.name(), (String)status.name()) && !this.getRequireLock(id, "modify")) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_languageskill_edit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hom_languageskill_edit"));
        formShowParameter.setCustomParam("id", skillInfo.get("id"));
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam(KEY_LANGUAGE, skillInfo.get(KEY_LANGUAGE));
        formShowParameter.setCustomParam(KEY_CERTIFICATE, skillInfo.get(KEY_CERTIFICATE));
        formShowParameter.setCustomParam(KEY_SCORE, skillInfo.get(KEY_SCORE));
        formShowParameter.setCustomParam(KEY_READS_CORE, skillInfo.get(KEY_READS_CORE));
        formShowParameter.setCustomParam(KEY_WRITES_CORE, skillInfo.get(KEY_WRITES_CORE));
        formShowParameter.setCustomParam(KEY_LISTENS_CORE, skillInfo.get(KEY_LISTENS_CORE));
        formShowParameter.setCustomParam(KEY_SPEAKS_CORE, skillInfo.get(KEY_SPEAKS_CORE));
        formShowParameter.setCustomParam(ISWORKINGLANGUAGE, skillInfo.get(ISWORKINGLANGUAGE));
        formShowParameter.setCustomParam(KEY_SIGNOFFTIME, skillInfo.get(KEY_SIGNOFFTIME));
        formShowParameter.setCustomParam("onbrdid", this.getView().getFormShowParameter().getCustomParam("id"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u8bed\u8a00\u6280\u80fd", (String)"LanguageEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private boolean getRequireLock(Long id, String opKey) {
        return IOnbrdCommonAppService.getInstance().tryRequireLockByHCF(this.getView(), id, "hcf_canlgability", opKey);
    }

    private boolean checkDataIsExistById(Long id, Long candidateId) {
        DynamicObjectCollection coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, "hcf_canlgability");
        return !CollectionUtils.isEmpty((Collection)coll);
    }

    private void refreshEntryEntity() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        DynamicObjectCollection skillInfos = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_canlgability");
        if (skillInfos == null || skillInfos.size() == 0) {
            new OnbrdNullPageServiceImpl().loadOnbrdNullPage(this.getView());
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP_1});
        this.getView().setVisible(Boolean.FALSE, new String[]{ONBRDNULLPAGE});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        if (LanguageSkillViewPlugin.generateViewForEnrollStatus(onbrdId, this.getView(), BTN_ADD, OPERATIONCOLUMNAP)) {
            entryGrid.setColumnProperty(OPERATIONCOLUMNAP_1, "visible", (Object)true);
        } else {
            entryGrid.setColumnProperty(OPERATIONCOLUMNAP, "visible", (Object)true);
            entryGrid.setColumnProperty(OPERATIONCOLUMNAP_1, "visible", (Object)false);
        }
        IDataModel dataModel = this.getModel();
        if (!(dataModel instanceof AbstractFormDataModel)) {
            return;
        }
        List<DynamicObject> skillList = skillInfos.stream().sorted(Comparator.comparing(dyo -> dyo.getDate("createtime"), Comparator.reverseOrder())).collect(Collectors.toList());
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.deleteEntryData(KEY_ENTRYENTITY);
        model.beginInit();
        TableValueSetter vs = this.getTableValue(skillList);
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    public static boolean generateViewForEnrollStatus(Long onbrdId, IFormView view, String ... btnStrs) {
        DynamicObject onbrdInfo = IOnbrdBillDomainService.getInstance().findOnbrdBillById("checkinstatus,enrollstatus,org.number,preenrollstatus,org", (Object)onbrdId);
        if (!HRObjectUtils.isEmpty((Object)onbrdInfo)) {
            String enrollStatus = onbrdInfo.getString("enrollstatus");
            if (HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.toString(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.toString(), (String)enrollStatus)) {
                view.setVisible(Boolean.FALSE, btnStrs);
                return true;
            }
        }
        return false;
    }

    private TableValueSetter getTableValue(List<DynamicObject> skillInfos) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int indexRow = 0;
        for (DynamicObject skillInfo : skillInfos) {
            Long id = skillInfo.getLong("id");
            List list = IHomToHcfAppService.getInstance().queryAttach(id, IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(1032641603216391168L)));
            if (!CollectionUtils.isEmpty((Collection)list)) {
                StringBuilder name = new StringBuilder();
                list.forEach(item -> name.append(item.getString(FATTACHMENTNAME)).append(" , "));
                String nameStr = name.length() > 0 ? name.substring(0, name.length() - 2) : "";
                vs.set("name", (Object)nameStr, indexRow);
            }
            indexRow = this.setTableValue(vs, indexRow, skillInfo, id);
        }
        return vs;
    }

    private int setTableValue(TableValueSetter vs, int indexRow, DynamicObject skillInfo, Long id) {
        vs.set("id", (Object)id, indexRow);
        vs.set(KEY_LANGUAGE, this.getSkillValue(skillInfo.getDynamicObject(KEY_LANGUAGE)), indexRow);
        vs.set(KEY_CERTIFICATE, this.getSkillValue(skillInfo.getDynamicObject(KEY_CERTIFICATE)), indexRow);
        vs.set(KEY_SCORE, skillInfo.get(KEY_SCORE), indexRow);
        vs.set(KEY_READS_CORE, this.getSkillValue(skillInfo.getDynamicObject(READ)), indexRow);
        vs.set(KEY_WRITES_CORE, this.getSkillValue(skillInfo.getDynamicObject(WRITE)), indexRow);
        vs.set(KEY_LISTENS_CORE, this.getSkillValue(skillInfo.getDynamicObject(LISTEN)), indexRow);
        vs.set(KEY_SPEAKS_CORE, this.getSkillValue(skillInfo.getDynamicObject(SPEAK)), indexRow);
        vs.set(KEY_SIGNOFFTIME, skillInfo.get(KEY_SIGNOFFTIME), indexRow);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ILanguageSkillService.class, (String)"kd.sdk.hr.hom.business.personinfo.ILanguageSkillService", null);
        int finalIndexRow = indexRow++;
        hrPluginProxy.callReplace(p -> {
            p.setTableValue(vs, finalIndexRow, skillInfo);
            return null;
        });
        return indexRow;
    }

    private Object getSkillValue(DynamicObject obj) {
        if (HRObjectUtils.isEmpty((Object)obj)) {
            return "";
        }
        return obj.get("name");
    }
}

