/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.extension.PersonInfoExService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.common.enums.HomPageToHcfPageEnum;
import kd.hr.hom.common.enums.OnbrdPanelBtnParamsEnum;
import kd.hr.hom.common.util.DateUtils;
import kd.hr.hom.common.util.PutValueToModelUtils;
import kd.sdk.hr.hom.business.personinfo.IBaseInfoService;
import kd.sdk.hr.hom.business.personinfo.IHcfInfoPageService;

public class PersonBaseInfoPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(PersonBaseInfoPlugin.class);
    private String BASE_INFO_PROPERTIES = "name,gender,nameen,engname,birthday,nationality,folk,nativeplace,marriagestatus,beginservicedate";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.checkValid(args);
        ILocaleString name = this.getModel().getDataEntity().getLocaleString("name");
        if (name != null && !name.isEmpty() && name.getLocaleValue() != null) {
            for (Map.Entry stringStringEntry : name.entrySet()) {
                name.setItem((String)stringStringEntry.getKey(), (Object)((String)stringStringEntry.getValue()).trim());
            }
            this.getModel().setValue("name", (Object)name);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.setBaseInfo();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult().isSuccess() && "save".equals(afterDoOperationEventArgs.getOperateKey())) {
            if (this.updatePersonBaseInfo()) {
                this.showEmbedPage(HomPageToHcfPageEnum.CONTACT_AP.getHomPageNumberView(), HomPageToHcfPageEnum.CONTACT_AP.getTargetKey());
            }
            this.hcfSyncHom();
        }
    }

    private void hcfSyncHom() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        LOGGER.info("===hcfSyncHom:{}===");
        if (onbrdId != null && onbrdId > 0L) {
            LOGGER.info("===hcfSyncHom:{}===", (Object)onbrdId.toString());
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            param.put("name", this.getModel().getValue("name"));
            param.put("gender", this.getModel().getValue("gender"));
            param.put("nationality", this.getModel().getValue("nationality"));
            IHcfDataDomainService.getInstance().saveHcfToHom(onbrdId, param);
        }
    }

    private void showEmbedPage(String pageNumber, String targetKey) {
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.setCustomParam("id", (Object)onbrdBillId);
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("hom_personbasicinfo", (Object)"hom_personbasicinfo");
        formShowParameter.setFormId(pageNumber);
        formShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().getParentView().setVisible(Boolean.TRUE, new String[]{OnbrdPanelBtnParamsEnum.CONTACT.getBtnModify()});
        this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{OnbrdPanelBtnParamsEnum.CONTACT.getBtnSave(), OnbrdPanelBtnParamsEnum.CONTACT.getBtnClose()});
        this.getView().getParentView().showForm(formShowParameter);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "nameen": {
                if (this.validateNameEn()) break;
                this.showTip(ResManager.loadKDString((String)"\u62fc\u97f3\u540d\u53ea\u80fd\u7531\u82f1\u6587\u5b57\u6bcd\u7ec4\u6210\uff0c\u8bf7\u53c2\u8003\u793a\u4f8b\u4fee\u6539\u3002", (String)"PersonBaseInfoPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                break;
            }
            case "engname": {
                if (this.validateEngName()) break;
                this.showTip(ResManager.loadKDString((String)"\u82f1\u6587\u540d\u53ea\u80fd\u4e3a\u82f1\u6587\u5b57\u6bcd\u7ec4\u6210\uff0c\u4e14\u5355\u8bcd\u9996\u5b57\u6bcd\u9700\u4e3a\u5927\u5199\uff0c\u8bf7\u53c2\u8003\u793a\u4f8b", (String)"PersonBaseInfoPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void checkValid(BeforeDoOperationEventArgs args) {
        if (!this.validateEngName()) {
            args.setCancelMessage(ResManager.loadKDString((String)"\u82f1\u6587\u540d\u53ea\u80fd\u4e3a\u82f1\u6587\u5b57\u6bcd\u7ec4\u6210\uff0c\u4e14\u5355\u8bcd\u9996\u5b57\u6bcd\u9700\u4e3a\u5927\u5199\uff0c\u8bf7\u53c2\u8003\u793a\u4f8b", (String)"PersonBaseInfoPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (!this.validateNameEn()) {
            args.setCancelMessage(ResManager.loadKDString((String)"\u62fc\u97f3\u540d\u53ea\u80fd\u7531\u82f1\u6587\u5b57\u6bcd\u7ec4\u6210\uff0c\u8bf7\u53c2\u8003\u793a\u4f8b\u4fee\u6539\u3002", (String)"PersonBaseInfoPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private boolean validateEngName() {
        String engName = (String)this.getModel().getValue("engname");
        if (HRStringUtils.isEmpty((String)engName)) {
            return true;
        }
        String regStr = "^[a-zA-Z\\s.]*$";
        Pattern pattern = Pattern.compile(regStr);
        if (pattern.matcher(engName).matches()) {
            String engNameStr = engName.trim().replaceAll("\\s+", " ");
            String[] engNames = engNameStr.split(" ");
            StringBuilder stringBuilder = new StringBuilder();
            for (String name : engNames) {
                String first = name.substring(0, 1).toUpperCase(Locale.ROOT);
                stringBuilder.append(first);
                if (StringUtils.isNotBlank((CharSequence)name.substring(1))) {
                    String after = name.substring(1).toLowerCase(Locale.ROOT);
                    stringBuilder.append(after);
                }
                stringBuilder.append(' ');
            }
            this.getModel().setValue("engname", (Object)stringBuilder.toString().trim());
            return true;
        }
        return false;
    }

    private void showTip(String description) {
        this.getView().getParentView().showTipNotification(description);
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private boolean validateNameEn() {
        String nameEn = (String)this.getModel().getValue("nameen");
        if (HRStringUtils.isEmpty((String)nameEn)) {
            return true;
        }
        String regStr = "^[a-zA-Z\\s]*$";
        Pattern checkPattern = Pattern.compile(regStr);
        if (checkPattern.matcher(nameEn).matches()) {
            this.getModel().setValue("nameen", (Object)nameEn.trim().replaceAll("\\s+", " "));
            return true;
        }
        return false;
    }

    private boolean updatePersonBaseInfo() {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        this.getView().getModel().setValue("candidate", (Object)candidateId);
        IHomToHcfAppService homToHcfService = IHomToHcfAppService.getInstance();
        DynamicObject personBaseDy = homToHcfService.getSingleRowEntity(candidateId, "hcf_canbaseinfo");
        boolean flag = true;
        long nationalityNew = this.getModel().getDataEntity().getLong("nationality.id");
        long nationalityOld = personBaseDy.getLong("nationality.id");
        if (nationalityNew == nationalityOld) {
            flag = false;
        }
        DynamicObject personBaseDyNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canbaseinfo"));
        personBaseDyNew.set("boid", HRObjectUtils.isEmpty((Object)personBaseDy) ? null : Long.valueOf(personBaseDy.getLong("boid")));
        this.getView().getModel().setValue("candidate", (Object)candidateId);
        personBaseDyNew.set("candidate", this.getView().getModel().getValue("candidate"));
        personBaseDyNew.set("name", HRObjectUtils.isEmpty((Object)personBaseDy) ? null : personBaseDy.getLocaleString("name"));
        this.pushPersonBaseData(personBaseDyNew);
        PersonInfoExService.setExFieldValue((IFormView)this.getView(), (DynamicObject)personBaseDyNew);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, kd.hr.hom.business.application.extension.IBaseInfoService.class, (String)"kd.hr.hom.business.application.extension.IBaseInfoService", null);
        hrPluginProxy.callReplace(p -> {
            p.setValueBeforeSave(this.getView(), personBaseDyNew);
            return null;
        });
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create(null, IBaseInfoService.class, (String)"kd.sdk.hr.hom.business.personinfo.IBaseInfoService", null);
        hrPluginProxySdk.callReplace(p -> {
            p.setValueBeforeSave(this.getView(), personBaseDyNew);
            return null;
        });
        HashMap<Long, DynamicObject> personMap = new HashMap<Long, DynamicObject>(2);
        personMap.put(candidateId, personBaseDyNew);
        Map result = homToHcfService.saveHisSingleRowEntity(personMap, "hcf_canbaseinfo");
        if (!((Boolean)result.get("success")).booleanValue()) {
            this.getView().getParentView().showErrorNotification(result.get("message").toString());
            LOGGER.error("Person Base Info Save Fail, ", (Object)result.get("message").toString());
        }
        return flag;
    }

    private void setBaseInfo() {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        if (candidateId == null || 0L == candidateId) {
            return;
        }
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, kd.hr.hom.business.application.extension.IBaseInfoService.class, (String)"kd.hr.hom.business.application.extension.IBaseInfoService", null);
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create(null, IBaseInfoService.class, (String)"kd.sdk.hr.hom.business.personinfo.IBaseInfoService", null);
        List properties = hrPluginProxy.callReplace(kd.hr.hom.business.application.extension.IHcfInfoPageService::getExtProperties);
        properties.addAll(hrPluginProxySdk.callReplace(IHcfInfoPageService::getExtProperties));
        Set exFields = PersonInfoExService.getExFields((IFormView)this.getView());
        if (!CollectionUtils.isEmpty((Collection)exFields)) {
            this.BASE_INFO_PROPERTIES = this.BASE_INFO_PROPERTIES + "," + String.join((CharSequence)",", exFields);
        }
        properties.add(this.BASE_INFO_PROPERTIES);
        String propertiesStr = String.join((CharSequence)",", properties);
        HashMap<String, String> entityFields = new HashMap<String, String>(2);
        entityFields.put("hcf_canbaseinfo", propertiesStr);
        Map candidate = IHomToHcfAppService.getInstance().getCandidate(candidateId, entityFields, null);
        DynamicObjectCollection baseObjs = (DynamicObjectCollection)candidate.get("hcf_canbaseinfo");
        if (baseObjs != null && baseObjs.size() != 0) {
            PutValueToModelUtils.putValueToModel((IFormView)this.getView(), (DynamicObject)((DynamicObject)baseObjs.get(0)), (String[])this.BASE_INFO_PROPERTIES.split(","));
            hrPluginProxy.callReplace(p -> {
                p.initViewForExt(this.getView(), (DynamicObject)baseObjs.get(0));
                return null;
            });
            hrPluginProxySdk.callReplace(p -> {
                p.initViewForExt(this.getView(), (DynamicObject)baseObjs.get(0));
                return null;
            });
        }
        DateEdit birthDayEdit = (DateEdit)this.getView().getControl("birthday");
        birthDayEdit.setMaxDate(DateUtils.selDay((Date)new Date(), (int)-1));
    }

    private void pushPersonBaseData(DynamicObject personBaseDyNew) {
        personBaseDyNew.set("name", this.getModel().getValue("name"));
        personBaseDyNew.set("gender", this.getModel().getValue("gender"));
        personBaseDyNew.set("nameen", this.getModel().getValue("nameen"));
        personBaseDyNew.set("engname", this.getModel().getValue("engname"));
        personBaseDyNew.set("birthday", this.getModel().getValue("birthday"));
        personBaseDyNew.set("nationality", this.getModel().getValue("nationality"));
        personBaseDyNew.set("folk", this.getModel().getValue("folk"));
        personBaseDyNew.set("nativeplace", this.getModel().getValue("nativeplace"));
        personBaseDyNew.set("marriagestatus", this.getModel().getValue("marriagestatus"));
        Date beginServiceDate = HRDateTimeUtils.truncateDate((Date)((Date)this.getModel().getValue("beginservicedate")));
        personBaseDyNew.set("beginservicedate", (Object)beginServiceDate);
    }
}

