/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.AttachmentDownloadListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.cvp.IHomToCvpAppService;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.extension.PersonInfoExService;
import kd.hr.hom.business.application.onbrd.IAttachmentAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.base.IUploadConfigDomainService;
import kd.hr.hom.common.entity.ocr.AlgoResultData;
import kd.hr.hom.common.entity.ocr.OcrWorkExpResult;
import kd.hr.hom.common.util.DateUtils;
import kd.hr.hom.common.util.PutValueToModelUtils;
import kd.hr.hom.formplugin.web.base.HomDataBaseEdit;
import kd.sdk.hr.hom.business.personinfo.IBasePeronInfoService;
import kd.sdk.hr.hom.business.personinfo.IPreviousWorkExpService;

public class PreWorkExpEditPlugin
extends HomDataBaseEdit
implements UploadListener,
AttachmentDownloadListener {
    private String PREWORKEXP_PROPERTIES = "unitname,position,startdate,enddate,exitdate,quitreason";
    private static final String BTN_SAVE = "btnsave";
    public static final String KEY_UNITNAME = "unitname";
    public static final String KEY_POSITION = "position";
    public static final String KEY_STARTDATE = "startdate";
    public static final String KEY_ENDDATE = "enddate";
    public static final String KEY_QUITREASON = "quitreason";
    private static final long ATTACH_TYPE = 1056338445011753984L;
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private static final Log LOGGER = LogFactory.getLog(PreWorkExpEditPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_SAVE});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        cache.remove("TampAttCache" + this.getView().getPageId());
        this.setEndDateRange(this.getModel().getDataEntity().getDate(KEY_STARTDATE));
        this.setStartDateRange(this.getModel().getDataEntity().getDate(KEY_ENDDATE));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isAlreadyClose = this.getPageCache().get("isalreadyclose");
        if (this.getModel().getDataChanged() && HRStringUtils.isEmpty((String)isAlreadyClose)) {
            e.setCancel(true);
            this.clickCancelChanged("cancel");
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (HRStringUtils.equalsIgnoreCase((String)status.name(), (String)"VIEW")) {
                return;
            }
            Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            IOnbrdCommonAppService.getInstance().releaseLockByHCF(id, "hcf_canprework", "modify");
        }
    }

    public void remove(UploadEvent evt) {
        Object[] urls;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long maidId = (Long)formShowParameter.getCustomParam("id");
        for (Object url : urls = evt.getUrls()) {
            if (!(url instanceof LinkedHashMap)) continue;
            AttachmentServiceHelper.remove((String)"hcf_canprework", (Object)maidId, ((LinkedHashMap)url).get("uid"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.checkDateValidate(args);
    }

    private void checkDateValidate(BeforeDoOperationEventArgs args) {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        if (IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
            args.setCancel(true);
            return;
        }
        DynamicObject dyo = this.getModel().getDataEntity();
        Date startDate = dyo.getDate(KEY_STARTDATE);
        Date endDate = dyo.getDate(KEY_ENDDATE);
        String unitname = dyo.getString(KEY_UNITNAME);
        String position = dyo.getString(KEY_POSITION);
        String errMsg = "";
        if (!this.checkValidDate(startDate, endDate)) {
            errMsg = ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"PreWorkExpEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.cancelDoOperation(errMsg, args);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (this.validateSameJob(startDate, endDate, unitname, position)) {
            errMsg = ResManager.loadKDString((String)"\u8be5\u6761\u524d\u5de5\u4f5c\u7ecf\u5386\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"PreWorkExpEdit_4", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.cancelDoOperation(errMsg, args);
        }
    }

    private boolean validateSameJob(Date startDate, Date endDate, String unitname, String position) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        QFilter filter = new QFilter(KEY_STARTDATE, "=", (Object)HRDateTimeUtils.truncateDate((Date)startDate)).and(KEY_ENDDATE, "=", (Object)HRDateTimeUtils.truncateDate((Date)endDate)).and(KEY_UNITNAME, "=", (Object)unitname).and(KEY_POSITION, "=", (Object)position).and("id", "!=", this.getView().getFormShowParameter().getCustomParams().get("id"));
        DynamicObjectCollection entity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_canprework", new QFilter[]{filter});
        return !CollectionUtils.isEmpty((Collection)entity);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (success && "save".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.updateOrSavePreworkInfo();
            this.getPageCache().put("isalreadyclose", "1");
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String name = evt.getProperty().getName();
        Object newValue = evt.getChangeSet()[0].getNewValue();
        if (HRStringUtils.equals((String)name, (String)KEY_STARTDATE)) {
            this.setEndDateRange((Date)newValue);
        }
        if (HRStringUtils.equals((String)name, (String)KEY_ENDDATE)) {
            this.setStartDateRange((Date)newValue);
        }
    }

    private void setEndDateRange(Date startDate) {
        DateEdit endDateEdit = (DateEdit)this.getView().getControl(KEY_ENDDATE);
        if (HRObjectUtils.isEmpty((Object)startDate)) {
            endDateEdit.setMinDate(DateUtils.getDateEditMinDate());
        }
        if (!HRObjectUtils.isEmpty((Object)startDate)) {
            endDateEdit.setMinDate(startDate);
        }
    }

    private void setStartDateRange(Date endDate) {
        DateEdit startDateEdit = (DateEdit)this.getView().getControl(KEY_STARTDATE);
        if (HRObjectUtils.isEmpty((Object)endDate)) {
            startDateEdit.setMaxDate(HRDateTimeUtils.getSysMaxDate());
        }
        if (!HRObjectUtils.isEmpty((Object)endDate)) {
            startDateEdit.setMaxDate(endDate);
        }
    }

    private boolean checkValidDate(Date oneDate, Date twoDate) {
        return oneDate == null || twoDate == null || !oneDate.after(twoDate);
    }

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String status = formShowParameter.getStatus().name();
        if (HRStringUtils.equals((String)status, (String)"VIEW")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE});
            this.getView().setEnable(Boolean.FALSE, new String[]{ATTACHMENTPANELAP});
        }
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("candidateid"));
        this.getView().getModel().setValue("candidate", (Object)candidateId);
        Long maidId = (Long)formShowParameter.getCustomParam("id");
        if (!HRObjectUtils.isEmpty((Object)maidId)) {
            Set exFields = PersonInfoExService.getExFields((IFormView)this.getView());
            if (!CollectionUtils.isEmpty((Collection)exFields)) {
                this.PREWORKEXP_PROPERTIES = this.PREWORKEXP_PROPERTIES + "," + String.join((CharSequence)",", exFields);
            }
            HashMap<String, String> entityFields = new HashMap<String, String>(2);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IPreviousWorkExpService.class, (String)"kd.sdk.hr.hom.business.personinfo.IPreviousWorkExpService", null);
            hrPluginProxy.callReplace(IBasePeronInfoService::getExtProperties).forEach(fieldStr -> {
                this.PREWORKEXP_PROPERTIES = fieldStr;
            });
            entityFields.put("hcf_canprework", this.PREWORKEXP_PROPERTIES);
            Map map = IHomToHcfAppService.getInstance().getCandidate(candidateId, entityFields, Long.valueOf(0L));
            DynamicObjectCollection workCollection = (DynamicObjectCollection)map.get("hcf_canprework");
            for (DynamicObject obj : workCollection) {
                if (obj.getLong("id") != maidId.longValue()) continue;
                PutValueToModelUtils.putValueToModel((IFormView)this.getView(), (DynamicObject)obj, (String[])this.PREWORKEXP_PROPERTIES.split(","));
                break;
            }
            List list = IHomToHcfAppService.getInstance().queryAttach(maidId, IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(1056338445011753984L)));
            IAttachmentAppService.getInstance().bindAttachmentInfo(list, this.getView(), ATTACHMENTPANELAP);
        }
    }

    private void updateOrSavePreworkInfo() {
        DynamicObject preWorkDyo = null;
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        if (!HRObjectUtils.isEmpty((Object)id)) {
            DynamicObjectCollection coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, "hcf_canprework");
            if (!CollectionUtils.isEmpty((Collection)coll)) {
                preWorkDyo = (DynamicObject)coll.get(0);
            }
        } else {
            id = ORM.create().genLongId("hcf_canprework");
        }
        DynamicObject personBaseDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canprework"));
        if (preWorkDyo == null) {
            personBaseDy.set("boid", null);
        } else {
            personBaseDy.set("boid", (Object)preWorkDyo.getLong("boid"));
        }
        personBaseDy.set("id", (Object)(HRObjectUtils.isEmpty((Object)preWorkDyo) ? id : 0L));
        personBaseDy.set("candidate", this.getView().getModel().getValue("candidate"));
        personBaseDy.set(KEY_UNITNAME, this.getView().getModel().getValue(KEY_UNITNAME));
        personBaseDy.set(KEY_POSITION, this.getView().getModel().getValue(KEY_POSITION));
        personBaseDy.set(KEY_STARTDATE, this.getView().getModel().getValue(KEY_STARTDATE));
        personBaseDy.set(KEY_ENDDATE, this.getView().getModel().getValue(KEY_ENDDATE));
        personBaseDy.set(KEY_QUITREASON, this.getView().getModel().getValue(KEY_QUITREASON));
        PersonInfoExService.setExFieldValue((IFormView)this.getView(), (DynamicObject)personBaseDy);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IPreviousWorkExpService.class, (String)"kd.sdk.hr.hom.business.personinfo.IPreviousWorkExpService", null);
        hrPluginProxy.callReplace(p -> {
            p.setDataModel(personBaseDy, this.getView().getModel());
            return null;
        });
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)personBaseDy);
        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>(2);
        map.put("hcf_canprework", collection);
        ArrayList<HashMap<String, DynamicObjectCollection>> list = new ArrayList<HashMap<String, DynamicObjectCollection>>(1);
        list.add(map);
        IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
        AttachmentPanel attachmentpanelap = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
        List attachmentData = attachmentpanelap.getAttachmentData();
        IAttachmentAppService.getInstance().saveAttachmentToHcf(attachmentData, id.longValue(), 1056338445011753984L);
    }

    private void cancelDoOperation(String errMsg, BeforeDoOperationEventArgs args) {
        this.getView().showErrorNotification(errMsg);
        args.setCancel(true);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        super.beforeBindData(eventObject);
        if (!IHomToCvpAppService.getInstance().isEnableOcr().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ocrtip"});
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls;
        if (!IHomToCvpAppService.getInstance().isEnableOcr().booleanValue()) {
            return;
        }
        this.getView().showLoading(ResManager.getLocaleString((String)"OCR\u6587\u672c\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"InfoGroupDynViewMobilePlugin_10", (String)"hr-hom-formplugin"));
        for (Object attachmentpanelapUrl : urls = evt.getUrls()) {
            if (!(attachmentpanelapUrl instanceof Map)) continue;
            Map url = (Map)attachmentpanelapUrl;
            String imageFullUrl = (String)url.get("url");
            AlgoResultData algoResultData = IHomToCvpAppService.getInstance().distinguishOcrImage("hcf_canprework", "OPM-CertificateOfResignation", imageFullUrl);
            LOGGER.info("===resData.errorCode:{}===", (Object)algoResultData.getErrorCode());
            LOGGER.info("===resData.description:{}==", (Object)algoResultData.getDescription());
            Object data = algoResultData.getData();
            this.getView().hideLoading();
            if (algoResultData.getErrorCode() != 0) {
                if (HRStringUtils.isEmpty((String)algoResultData.getDescription())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u6587\u672c\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u624b\u52a8\u8f93\u5165\u3002", (String)"Ocrcomn_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    continue;
                }
                this.getView().showTipNotification(algoResultData.getDescription());
                continue;
            }
            if (data == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u6587\u672c\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u624b\u52a8\u8f93\u5165\u3002", (String)"Ocrcomn_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                continue;
            }
            OcrWorkExpResult ocrWorkExpResult = (OcrWorkExpResult)JSONObject.parseObject((String)data.toString(), OcrWorkExpResult.class);
            this.getView().showSuccessNotification(ResManager.loadResFormat((String)"\u79bb\u804c\u8bc1\u660e\u5185\u5bb9\u8bc6\u522b\u6210\u529f\u3002", (String)"PreWorkExpEdit_6", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.setValueWithOcr(ocrWorkExpResult);
        }
    }

    private void setValueWithOcr(OcrWorkExpResult ocrWorkExpResult) {
        this.setFieldValueWithOcr(KEY_UNITNAME, ocrWorkExpResult.getCompany());
        this.setFieldValueWithOcr(KEY_POSITION, ocrWorkExpResult.getPosition());
        this.setFieldValueWithOcr(KEY_STARTDATE, ocrWorkExpResult.getStartDate());
        this.setFieldValueWithOcr(KEY_ENDDATE, ocrWorkExpResult.getExitDate());
        this.setFieldValueWithOcr(KEY_QUITREASON, ocrWorkExpResult.getLeaveReason());
    }
}

