/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.OnbrdNullPageServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.base.IUploadConfigDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.sdk.hr.hom.business.personinfo.IPreviousWorkExpService;

public class PreWorkExpViewPlugin
extends HRDynamicFormBasePlugin {
    private static final String BTN_ADD = "btn_add";
    private static final String KEY_ENTRYENTITY = "entryentity";
    public static final String KEY_UNITNAME = "unitname";
    public static final String KEY_POSITION = "position";
    public static final String KEY_STARTDATE = "startdate";
    public static final String KEY_ENDDATE = "enddate";
    public static final String KEY_QUITREASON = "quitreason";
    private static final long ATTACH_TYPE = 1056338445011753984L;
    private static final String DONOTHING_EDIT = "donothing_edit";
    private static final String DONOTHING_VIEW = "donothing_view";
    private static final String DONOTHING_DELETE = "donothing_delete";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.refreshEntryEntity();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        IOnbrdBillDomainService.getInstance().generateViewForEnrollStatus(onbrdId, this.getView(), new String[]{BTN_ADD});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("hom_previousworkexp_edit".equals(actionId)) {
            this.refreshEntryEntity();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operationKey = (FormOperate)args.getSource();
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject preWorksInfo = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, entryCurrentRowIndex);
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        String operateKey = operationKey.getOperateKey();
        if ((DONOTHING_DELETE.equals(operateKey) || DONOTHING_EDIT.equals(operateKey) || BTN_ADD.equals(operateKey)) && IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
            args.setCancel(true);
            return;
        }
        switch (operateKey) {
            case "donothing_delete": {
                this.delPreWorkExp(operateKey, preWorksInfo);
                break;
            }
            case "donothing_edit": {
                String appId = this.getView().getFormShowParameter().getAppId();
                if (IOnbrdCommonAppService.getInstance().checkPermission("hom_previousworkexp_view", "4715a0df000000ac", appId)) {
                    this.editPreWorkExp(operateKey, candidateId, preWorksInfo);
                    break;
                }
                this.viewPreWorkExp(operateKey, candidateId, preWorksInfo);
                break;
            }
            case "donothing_view": {
                this.viewPreWorkExp(operateKey, candidateId, preWorksInfo);
                break;
            }
            case "btn_add": {
                this.addPreWorkExp(operateKey, candidateId);
                break;
            }
        }
    }

    private void viewPreWorkExp(String keyName, Long candidateId, DynamicObject preWorksInfo) {
        this.showUpdatePage(candidateId, preWorksInfo, OperationStatus.VIEW);
    }

    private void delPreWorkExp(String keyName, DynamicObject preWorksInfo) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        if (!this.checkDataIsExistById(preWorksInfo.getLong("id"), candidateId)) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u6761\u524d\u5de5\u4f5c\u7ecf\u5386\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PreWorkExpEdit_5", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        if (!this.getRequireLock(preWorksInfo.getLong("id"), "delete")) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u8bb0\u5f55\uff1f", (String)"PreWorkExpViewPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DONOTHING_DELETE, (IFormPlugin)this));
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("preWorkId", preWorksInfo.getString("id"));
    }

    private void addPreWorkExp(String keyName, Long candidateId) {
        this.showNewPage(candidateId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)actionId, (String)DONOTHING_DELETE) && MessageBoxResult.Yes == resultValue) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String preWorkId = pageCache.get("preWorkId");
            try {
                Map result = IHomToHcfAppService.getInstance().deleteById(Long.valueOf(preWorkId), "hcf_canprework");
                Boolean success = (Boolean)result.get("success");
                if (success.booleanValue()) {
                    List list = IHomToHcfAppService.getInstance().queryAttach(Long.valueOf(preWorkId), IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(1056338445011753984L)));
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        this.delAllAttachment(preWorkId, list);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"LanguageSkillViewPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    this.getView().updateView();
                } else {
                    this.getView().showErrorNotification((String)result.get("message"));
                }
            }
            finally {
                IOnbrdCommonAppService.getInstance().releaseLockByHCF(Long.valueOf(preWorkId), "hcf_canprework", "delete");
            }
        }
    }

    private void editPreWorkExp(String keyName, Long candidateId, DynamicObject preWorksInfo) {
        this.showUpdatePage(candidateId, preWorksInfo, OperationStatus.EDIT);
    }

    private void delAllAttachment(String preWorkId, List<DynamicObject> list) {
        for (DynamicObject dyo : list) {
            AttachmentServiceHelper.remove((String)dyo.getString("fbilltype"), (Object)preWorkId, (Object)dyo.get("fnumber"));
        }
    }

    private void showNewPage(Long personId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_previousworkexp_edit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hom_previousworkexp_edit"));
        formShowParameter.setCustomParam("candidateid", (Object)personId);
        formShowParameter.setCustomParam("onbrdid", this.getView().getFormShowParameter().getCustomParam("id"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u524d\u5de5\u4f5c\u7ecf\u5386", (String)"PreWorkExpEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void showUpdatePage(Long candidateId, DynamicObject preWorkInfo, OperationStatus status) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(status);
        if (!this.checkDataIsExistById(preWorkInfo.getLong("id"), candidateId)) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u6761\u524d\u5de5\u4f5c\u7ecf\u5386\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PreWorkExpEdit_5", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        if (HRStringUtils.equals((String)OperationStatus.EDIT.name(), (String)status.name()) && !this.getRequireLock(preWorkInfo.getLong("id"), "modify")) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_previousworkexp_edit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hom_previousworkexp_edit"));
        formShowParameter.setCustomParam("id", preWorkInfo.get("id"));
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam(KEY_UNITNAME, preWorkInfo.get(KEY_UNITNAME));
        formShowParameter.setCustomParam(KEY_POSITION, preWorkInfo.get(KEY_POSITION));
        formShowParameter.setCustomParam(KEY_STARTDATE, preWorkInfo.get(KEY_STARTDATE));
        formShowParameter.setCustomParam(KEY_ENDDATE, preWorkInfo.get(KEY_ENDDATE));
        formShowParameter.setCustomParam("onbrdid", this.getView().getFormShowParameter().getCustomParam("id"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u524d\u5de5\u4f5c\u7ecf\u5386", (String)"PreWorkExpEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private boolean getRequireLock(Long id, String opKey) {
        return IOnbrdCommonAppService.getInstance().tryRequireLockByHCF(this.getView(), id, "hcf_canprework", opKey);
    }

    private boolean checkDataIsExistById(Long id, Long candidateId) {
        DynamicObjectCollection coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, "hcf_canprework");
        return !CollectionUtils.isEmpty((Collection)coll);
    }

    private void refreshEntryEntity() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        DynamicObjectCollection preWorksInfos = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_canprework");
        if (CollectionUtils.isEmpty((Collection)preWorksInfos)) {
            new OnbrdNullPageServiceImpl().loadOnbrdNullPage(this.getView());
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"onbrdnullpage"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        if (PreWorkExpViewPlugin.generateViewForEnrollStatus(onbrdId, this.getView(), BTN_ADD, "operationcolumnap1")) {
            entryGrid.setColumnProperty("operationcolumnap", "visible", (Object)true);
        } else {
            entryGrid.setColumnProperty("operationcolumnap1", "visible", (Object)true);
            entryGrid.setColumnProperty("operationcolumnap", "visible", (Object)false);
        }
        IDataModel dataModel = this.getModel();
        if (!(dataModel instanceof AbstractFormDataModel)) {
            return;
        }
        List<DynamicObject> perWorksList = preWorksInfos.stream().sorted(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date admissiondate1 = o1.getDate(PreWorkExpViewPlugin.KEY_ENDDATE);
                Date admissiondate2 = o2.getDate(PreWorkExpViewPlugin.KEY_ENDDATE);
                if (admissiondate1 == null) {
                    return 1;
                }
                if (admissiondate2 == null) {
                    return 1;
                }
                return admissiondate2.compareTo(admissiondate1);
            }
        }).collect(Collectors.toList());
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.deleteEntryData(KEY_ENTRYENTITY);
        model.beginInit();
        TableValueSetter vs = this.getTableValue(perWorksList);
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    public static boolean generateViewForEnrollStatus(Long onbrdId, IFormView view, String ... btnStrs) {
        DynamicObject onbrdInfo = IOnbrdBillDomainService.getInstance().findOnbrdBillById("checkinstatus,enrollstatus,org.number,preenrollstatus,org", (Object)onbrdId);
        if (!HRObjectUtils.isEmpty((Object)onbrdInfo)) {
            String enrollStatus = onbrdInfo.getString("enrollstatus");
            if (HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.toString(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.toString(), (String)enrollStatus)) {
                view.setVisible(Boolean.FALSE, btnStrs);
                return true;
            }
        }
        return false;
    }

    private TableValueSetter getTableValue(List<DynamicObject> preWorksInfos) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int indexRow = 0;
        for (DynamicObject preWorksInfo : preWorksInfos) {
            Long id = preWorksInfo.getLong("id");
            List list = IHomToHcfAppService.getInstance().queryAttach(id, IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(1056338445011753984L)));
            if (!CollectionUtils.isEmpty((Collection)list)) {
                StringBuilder name = new StringBuilder();
                list.forEach(item -> name.append(item.getString("fattachmentname")).append(" , "));
                String nameStr = name.length() > 0 ? name.substring(0, name.length() - 2) : "";
                vs.set("name", (Object)nameStr, indexRow);
            }
            vs.set("id", (Object)id, indexRow);
            vs.set(KEY_UNITNAME, (Object)(HRStringUtils.isEmpty((String)preWorksInfo.getString(KEY_UNITNAME)) ? "" : preWorksInfo.getString(KEY_UNITNAME)), indexRow);
            vs.set(KEY_POSITION, (Object)(HRStringUtils.isEmpty((String)preWorksInfo.getString(KEY_POSITION)) ? "" : preWorksInfo.getString(KEY_POSITION)), indexRow);
            vs.set(KEY_STARTDATE, preWorksInfo.get(KEY_STARTDATE), indexRow);
            vs.set(KEY_ENDDATE, preWorksInfo.get(KEY_ENDDATE), indexRow);
            vs.set(KEY_QUITREASON, (Object)(HRStringUtils.isEmpty((String)preWorksInfo.getString(KEY_QUITREASON)) ? "" : preWorksInfo.getString(KEY_QUITREASON)), indexRow);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IPreviousWorkExpService.class, (String)"kd.sdk.hr.hom.business.personinfo.IPreviousWorkExpService", null);
            int finalIndexRow = indexRow++;
            hrPluginProxy.callReplace(p -> {
                p.setTableValue(vs, finalIndexRow, preWorksInfo);
                return null;
            });
        }
        return vs;
    }
}

