/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.AttachmentDownloadListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.extension.PersonInfoExService;
import kd.hr.hom.business.application.impl.rule.HcfMultiRowCommonValidator;
import kd.hr.hom.business.application.onbrd.IAttachmentAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.base.IUploadConfigDomainService;
import kd.hr.hom.business.domain.service.impl.collect.CollectServiceImpl;
import kd.hr.hom.common.constant.MultiEntityImportConstants;
import kd.hr.hom.common.enums.AttachmentTypeEnum;
import kd.hr.hom.common.util.PutValueToModelUtils;
import kd.hr.hom.formplugin.web.base.HomDataBaseEdit;
import kd.sdk.hr.hom.business.personinfo.IBasePeronInfoService;
import kd.sdk.hr.hom.business.personinfo.IRsmpatinvService;

public class RsmpatinvEditPlugin
extends HomDataBaseEdit
implements UploadListener,
AttachmentDownloadListener {
    private static final String BTN_SAVE = "btnsave";
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private String PROPERTIES = "patentname,patentcategoryid,inventor,applicationdate,ptstartdate,ptendingdate,countryid,patentnumber,patentstatusid,patenturl,patentdesc";
    private static final String OPKEY_SAVE = "donothing_save";
    private static final Log logger = LogFactory.getLog(RsmpatinvEditPlugin.class);

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (HRStringUtils.equalsIgnoreCase((String)status.name(), (String)"VIEW")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE});
            this.getView().setEnable(Boolean.FALSE, new String[]{ATTACHMENTPANELAP});
        }
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("candidateid"));
        this.getView().getModel().setValue("candidate", (Object)candidateId);
        Long pkId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("id"));
        if (!HRObjectUtils.isEmpty((Object)pkId)) {
            Set exFields = PersonInfoExService.getExFields((IFormView)this.getView());
            if (!CollectionUtils.isEmpty((Collection)exFields)) {
                this.PROPERTIES = this.PROPERTIES + "," + String.join((CharSequence)",", exFields);
            }
            HashMap<String, String> entityFields = new HashMap<String, String>(2);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IRsmpatinvService.class, (String)"kd.sdk.hr.hom.business.personinfo.IRsmpatinvService", null);
            hrPluginProxy.callReplace(IBasePeronInfoService::getExtProperties).forEach(fieldStr -> {
                this.PROPERTIES = fieldStr;
            });
            entityFields.put("hcf_rsmpatinv", this.PROPERTIES);
            Map map = IHomToHcfAppService.getInstance().getCandidate(candidateId, entityFields, Long.valueOf(0L));
            DynamicObjectCollection rsmpatinvCollection = (DynamicObjectCollection)map.get("hcf_rsmpatinv");
            for (DynamicObject obj : rsmpatinvCollection) {
                if (obj.getLong("id") != pkId.longValue()) continue;
                PutValueToModelUtils.putValueToModel((IFormView)this.getView(), (DynamicObject)obj, (String[])this.PROPERTIES.split(","));
                break;
            }
            List list = IHomToHcfAppService.getInstance().queryAttach(pkId, IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(AttachmentTypeEnum.RSMPATINV.getId())));
            IAttachmentAppService.getInstance().bindAttachmentInfo(list, this.getView(), ATTACHMENTPANELAP);
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        cache.remove("TampAttCache" + this.getView().getPageId());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void remove(UploadEvent evt) {
        Object[] urls;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long maidId = (Long)formShowParameter.getCustomParam("id");
        for (Object url : urls = evt.getUrls()) {
            if (!(url instanceof LinkedHashMap)) continue;
            AttachmentServiceHelper.remove((String)"hcf_rsmpatinv", (Object)maidId, ((LinkedHashMap)url).get("uid"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operation = (FormOperate)args.getSource();
        String opKey = operation.getOperateKey();
        if (HRStringUtils.equals((String)OPKEY_SAVE, (String)opKey)) {
            this.validateData(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (success && OPKEY_SAVE.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.updateOrSaveRsmpatinvInfo();
            this.getPageCache().put("isalreadyclose", "1");
            this.getView().close();
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        String isAlreadyClose = this.getPageCache().get("isalreadyclose");
        if (this.getModel().getDataChanged() && HRStringUtils.isEmpty((String)isAlreadyClose)) {
            beforeClosedEvent.setCancel(true);
            this.clickCancelChanged("cancel");
        } else {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (HRStringUtils.equalsIgnoreCase((String)status.name(), (String)"VIEW")) {
                return;
            }
            Long id = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("id"));
            IOnbrdCommonAppService.getInstance().releaseLockByHCF(id, "hcf_rsmpatinv", "modify");
        }
    }

    private void validateData(BeforeDoOperationEventArgs args) {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        if (IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
            args.setCancel(true);
            return;
        }
        DynamicObject rsmpatinvInfo = this.getModel().getDataEntity();
        String errMsg = "";
        if (this.judgeIfDuplicate(rsmpatinvInfo)) {
            errMsg = ResManager.loadKDString((String)"\u8be5\u4e13\u5229\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"RsmpatinvEditPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.cancelDoOperation(errMsg, args);
        }
    }

    private boolean judgeIfDuplicate(DynamicObject rsmpatinvInfo) {
        Long pkId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        HcfMultiRowCommonValidator validatorService = new HcfMultiRowCommonValidator();
        String currentUniqueKey = validatorService.getUniqueKey(rsmpatinvInfo, (List)MultiEntityImportConstants.UNIQUE_FIELD_RSMPATINV);
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        DynamicObjectCollection rsmpatinvInfos = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_rsmpatinv");
        for (DynamicObject rsmpatinvInfoDB : rsmpatinvInfos) {
            String uniqueKey;
            if (!HRObjectUtils.isEmpty((Object)pkId) && rsmpatinvInfoDB.getLong("id") == pkId.longValue() || !HRStringUtils.equals((String)currentUniqueKey, (String)(uniqueKey = validatorService.getUniqueKey(rsmpatinvInfoDB, (List)MultiEntityImportConstants.UNIQUE_FIELD_RSMPATINV)))) continue;
            return true;
        }
        return false;
    }

    private void cancelDoOperation(String errMsg, BeforeDoOperationEventArgs args) {
        this.getView().showErrorNotification(errMsg);
        args.setCancel(true);
    }

    private void updateOrSaveRsmpatinvInfo() {
        DynamicObject rsmpatinvInfo = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_rsmpatinv"));
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        id = Optional.ofNullable(id).orElseGet(() -> ORM.create().genLongId("hcf_rsmpatinv"));
        rsmpatinvInfo.set("id", (Object)id);
        rsmpatinvInfo.set("candidate", this.getView().getModel().getValue("candidate"));
        IDataModel dataModel = this.getModel();
        rsmpatinvInfo.set("patentname", dataModel.getValue("patentname"));
        rsmpatinvInfo.set("patentcategoryid", dataModel.getValue("patentcategoryid"));
        rsmpatinvInfo.set("inventor", dataModel.getValue("inventor"));
        rsmpatinvInfo.set("applicationdate", dataModel.getValue("applicationdate"));
        rsmpatinvInfo.set("ptstartdate", dataModel.getValue("ptstartdate"));
        rsmpatinvInfo.set("ptendingdate", dataModel.getValue("ptendingdate"));
        rsmpatinvInfo.set("countryid", dataModel.getValue("countryid"));
        rsmpatinvInfo.set("patentnumber", dataModel.getValue("patentnumber"));
        rsmpatinvInfo.set("patentstatusid", dataModel.getValue("patentstatusid"));
        rsmpatinvInfo.set("patenturl", dataModel.getValue("patenturl"));
        rsmpatinvInfo.set("patentdesc", dataModel.getValue("patentdesc"));
        PersonInfoExService.setExFieldValue((IFormView)this.getView(), (DynamicObject)rsmpatinvInfo);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IRsmpatinvService.class, (String)"kd.sdk.hr.hom.business.personinfo.IRsmpatinvService", null);
        hrPluginProxy.callReplace(p -> {
            p.setDataModel(rsmpatinvInfo, dataModel);
            return null;
        });
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)rsmpatinvInfo);
        HashMap entities = Maps.newHashMapWithExpectedSize((int)1);
        entities.put(rsmpatinvInfo.getLong("candidate.id"), collection);
        IHomToHcfAppService.getInstance().saveMultiRowEntityWithoutDelete((Map)entities, "hcf_rsmpatinv");
        AttachmentPanel attachmentpanelap = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
        List attachmentData = attachmentpanelap.getAttachmentData();
        IAttachmentAppService.getInstance().saveAttachmentToHcf(attachmentData, id.longValue(), AttachmentTypeEnum.RSMPATINV.getId());
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        new CollectServiceImpl().syncSubmitPro(onbrdId);
    }
}

