/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo.ext;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.PanelApAdatper;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.web.base.HcfDataBaseExtViewPlugin;

public class CanExtAddViewPlugin
extends HcfDataBaseExtViewPlugin {
    private static final Log logger = LogFactory.getLog(CanExtAddViewPlugin.class);
    private static final String SHOW_CARD_INFOPANEL = "showcardinfopanel";
    private static final String KEY_PANEL_PREFIX = "hcfextpanel";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        IOnbrdBillDomainService.getInstance().generateViewForEnrollStatus(onbrdId, this.getView(), new String[]{"btn_add"});
        this.loadCanExtInfo();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if ("btn_add".equals(operate.getOperateKey())) {
            this.addCanExtCardInfo();
        }
    }

    private void addCanExtCardInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long candidateId = HRJSONUtils.getLongValOfCustomParam(customParams.get("candidateid"));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, (String)customParams.get("editinfo")));
        formShowParameter.setFormId((String)customParams.get("editinfo"));
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("onbrdid", customParams.get("onbrdid"));
        formShowParameter.setCustomParam("obj", customParams.get("obj"));
        formShowParameter.setCustomParam("showcols", customParams.get("showcols"));
        String caption = (String)customParams.get("objname");
        formShowParameter.setCaption(caption);
        this.getView().showForm(formShowParameter);
    }

    private void loadCanExtInfo() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Long candidateId = HRJSONUtils.getLongValOfCustomParam(customParams.get("candidateid"));
        DynamicObjectCollection hcfcanInfoDyc = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, (String)customParams.get("obj"));
        if (CollectionUtils.isEmpty((Collection)hcfcanInfoDyc)) {
            this.loadOnbrdNullPage();
            return;
        }
        Boolean ismul = (Boolean)customParams.get("ismul");
        String showtype = (String)customParams.get("showtype");
        if (ismul.booleanValue() && "card".equals(showtype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"onbrdnullpage"});
            this.getView().setVisible(Boolean.TRUE, new String[]{SHOW_CARD_INFOPANEL});
            this.showHcfCanCardView(hcfcanInfoDyc, candidateId, customParams);
        }
    }

    private void showHcfCanCardView(DynamicObjectCollection caninfoCollecttion, Long candidateId, Map<String, Object> customParams) {
        String showinfoPageNumber = (String)customParams.get("showinfo");
        String obj = (String)customParams.get("obj");
        List canInfos = caninfoCollecttion.stream().sorted(Comparator.comparing(dyo -> dyo.getDate("createtime"), Comparator.naturalOrder())).collect(Collectors.toList());
        FlexPanelAp showCardinfoPanel = this.generateCanExtPanel(SHOW_CARD_INFOPANEL);
        for (int i = 0; i < canInfos.size(); ++i) {
            DynamicObject canInfo = (DynamicObject)canInfos.get(i);
            PanelApAdatper canFamilyPanelStyleAdapter = new PanelApAdatper(KEY_PANEL_PREFIX + i){

                public void setStyle() {
                    this.panelAp.setWidth(new LocaleString("330px"));
                    this.panelAp.setHeight(new LocaleString("120px"));
                    this.panelAp.setGrow(0);
                    this.panelAp.setShrink(0);
                }
            };
            Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey(KEY_PANEL_PREFIX + i);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setFormId(showinfoPageNumber);
            formShowParameter.setCustomParams(this.getCanParams(canInfo));
            formShowParameter.setCustomParam("index", (Object)(i + 1 + ""));
            formShowParameter.setCustomParam("obj", (Object)obj);
            formShowParameter.setCustomParam("candidateid", (Object)candidateId);
            formShowParameter.setCustomParam("onbrdid", (Object)onbrdId);
            formShowParameter.setCustomParam("id", canInfo.get("id"));
            this.getView().showForm(formShowParameter);
            showCardinfoPanel.getItems().add(canFamilyPanelStyleAdapter.getPanelAp());
        }
        this.getView().updateControlMetadata(showCardinfoPanel.getKey(), showCardinfoPanel.createControl());
    }

    private Map<String, Object> getCanParams(DynamicObject canInfo) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String showcols = (String)formShowParameter.getCustomParam("showcols");
        String[] fieldArray = showcols.split(",");
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        HashMap<String, String> columnMap = new HashMap<String, String>();
        HashMap<String, String> columnName = new HashMap<String, String>();
        DataEntityPropertyCollection properties = canInfo.getDynamicObjectType().getProperties();
        for (String field : fieldArray) {
            IDataEntityProperty property;
            LocaleString displayName = ((IDataEntityProperty)properties.get((Object)field)).getDisplayName();
            if (displayName != null) {
                columnName.put(field, displayName.getLocaleValue());
            }
            if ((property = (IDataEntityProperty)properties.get((Object)field)) instanceof BasedataProp) {
                DynamicObject basedata = canInfo.getDynamicObject(field);
                if (basedata != null) {
                    IDataEntityProperty basedataNameProperty = (IDataEntityProperty)basedata.getDynamicObjectType().getProperties().get((Object)"name");
                    if (basedataNameProperty instanceof MuliLangTextProp) {
                        columnMap.put(field, canInfo.getDynamicObject(field).getLocaleString("name").getLocaleValue());
                        continue;
                    }
                    columnMap.put(field, canInfo.getDynamicObject(field).getString("name"));
                    continue;
                }
                logger.error("field = {} basedata not exist, candidateid={}", (Object)field, formShowParameter.getCustomParam("candidateid"));
                continue;
            }
            if (property instanceof MuliLangTextProp) {
                columnMap.put(field, canInfo.getString(field));
                continue;
            }
            if (property instanceof TextProp) {
                columnMap.put(field, canInfo.getString(field));
                continue;
            }
            if (property instanceof DateProp || property instanceof CreateDateProp || property instanceof ModifyDateProp) {
                Date date = canInfo.getDate(field);
                columnMap.put(field, DateUtils.dateToString((Date)date, (DatePattern)DatePattern.YYYY_MM_DD));
                continue;
            }
            if (property instanceof BooleanProp) {
                columnMap.put(field, this.getColumnName(canInfo.getBoolean(field)));
                continue;
            }
            if (!(property instanceof DecimalProp)) continue;
            columnMap.put(field, canInfo.getString(field));
        }
        customParams.put("showcols", showcols);
        customParams.put("columnMap", columnMap);
        customParams.put("columnName", columnName);
        customParams.put("objname", formShowParameter.getCustomParam("objname"));
        customParams.put("editinfo", formShowParameter.getCustomParam("editinfo"));
        formShowParameter.setCustomParam("obj.name", formShowParameter.getCustomParam("obj.name"));
        return customParams;
    }

    private String getColumnName(boolean value) {
        return value ? ResManager.loadKDString((String)"\u662f", (String)"CanExtAddViewPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"CanExtAddViewPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
    }

    private FlexPanelAp generateCanExtPanel(String panelKey) {
        PanelApAdatper mainPanelApt = new PanelApAdatper(panelKey){

            public void setStyle() {
                this.panelAp.setGrow(0);
                this.panelAp.setShrink(1);
                this.panelAp.setAlignSelf("stretch");
            }
        };
        return mainPanelApt.getPanelAp();
    }

    @Override
    protected void loadOnbrdNullPage() {
        super.loadOnbrdNullPage();
        this.getView().setVisible(Boolean.FALSE, new String[]{SHOW_CARD_INFOPANEL});
    }
}

