/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo.ext;

import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.web.base.HcfDataBaseExtViewPlugin;

public class CanExtShowCardPlugin
extends HcfDataBaseExtViewPlugin {
    private static final String BTN_EDIT = "btn_edit";
    private static final String BTN_DEL = "btn_del";
    private static final String BTN_VIEW = "btn_view";
    private static final String TITLEINFO = "titleinfo";
    private static final String HCFEXTPANEL = "hcfextpanel";
    private static final String SUFFIX = "extpanel";
    private static final String SUFFIX_LABEL = "extlabel";
    private static final String CARDID = "cardid";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        String showcols = (String)customParams.get("showcols");
        String[] fieldArray = showcols.split(",");
        Map columnMap = (Map)customParams.get("columnMap");
        Map columnNames = (Map)customParams.get("columnName");
        this.getModel().setValue(TITLEINFO, (Object)((String)customParams.get("objname") + customParams.get("index")));
        this.getModel().setValue("obj", (Object)((String)customParams.get("obj")));
        this.getModel().setValue(CARDID, (Object)((Long)customParams.get("id")));
        FlexPanelAp hcfextpanel = new FlexPanelAp();
        hcfextpanel.setKey(HCFEXTPANEL);
        hcfextpanel.setDirection("column");
        for (String field : fieldArray) {
            FlexPanelAp flexPanelAp = this.getPanelAp(field, (String)columnNames.get(field), (String)columnMap.get(field));
            hcfextpanel.getItems().add(flexPanelAp);
        }
        this.getView().updateControlMetadata(hcfextpanel.getKey(), hcfextpanel.createControl());
        this.isEnrolled(HRJSONUtils.getLongValOfCustomParam(customParams.get("onbrdid")));
    }

    private FlexPanelAp getPanelAp(String field, String fieldName, String value) {
        FlexPanelAp panelAp = new FlexPanelAp();
        panelAp.setKey(field + SUFFIX);
        panelAp.setWidth(new LocaleString("280px"));
        panelAp.setHeight(new LocaleString("20px"));
        panelAp.setGrow(1);
        panelAp.setShrink(1);
        panelAp.setDirection("row");
        panelAp.setAlignItems("center");
        panelAp.setStyle(this.createStyle());
        panelAp.setOverflow("hidden");
        panelAp.getItems().add(this.getLabelAp(field, fieldName, value));
        return panelAp;
    }

    private LabelAp getLabelAp(String field, String fieldName, String value) {
        LabelAp labelap = new LabelAp();
        labelap.setKey(field + SUFFIX_LABEL);
        if (value == null) {
            labelap.setName(new LocaleString(fieldName + "\uff1a"));
        } else {
            labelap.setName(new LocaleString(fieldName + "\uff1a" + value));
        }
        labelap.setForeColor("#000000");
        return labelap;
    }

    private Style createStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("10px");
        style.setMargin(margin);
        return style;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (!BTN_VIEW.equals(operateKey)) {
            Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
            if (onbrdId == null) {
                return;
            }
            if (IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if (BTN_EDIT.equals(operate.getOperateKey())) {
            this.editCanCardPage(OperationStatus.EDIT);
        }
        if (BTN_DEL.equals(operate.getOperateKey())) {
            this.delCanExtCardPage();
        }
        if (BTN_VIEW.equals(operate.getOperateKey())) {
            this.editCanCardPage(OperationStatus.VIEW);
        }
    }

    private void isEnrolled(Object onbrd) {
        if (onbrd instanceof Long) {
            boolean isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled((Long)onbrd);
            if (isEnroll) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"editanddeleteap"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"viewap"});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (HRStringUtils.equals((String)actionId, (String)BTN_DEL) && MessageBoxResult.Yes == resultValue) {
            Long cardId = (Long)this.getModel().getValue(CARDID);
            String entityNum = String.valueOf(this.getModel().getValue("obj"));
            try {
                Map result = IHomToHcfAppService.getInstance().deleteById(cardId, entityNum);
                Boolean success = (Boolean)result.get("success");
                if (success.booleanValue()) {
                    this.delAllAttachment((Long)customParams.get("id"), (String)customParams.get("obj"));
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"CanFamilyEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    this.getView().getParentView().updateView();
                    this.getView().sendFormAction(this.getView().getParentView());
                } else {
                    this.getView().showErrorNotification((String)result.get("message"));
                }
            }
            finally {
                IOnbrdCommonAppService.getInstance().releaseLockByHCF(cardId, entityNum, "delete");
            }
        }
    }

    private void delCanExtCardPage() {
        String obj;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long candidateId = HRJSONUtils.getLongValOfCustomParam(customParams.get("candidateid"));
        Long dataId = HRJSONUtils.getLongValOfCustomParam(customParams.get("id"));
        if (!this.checkDataIsExistById(dataId, candidateId, obj = (String)customParams.get("obj"))) {
            String errMsg = ResManager.loadKDString((String)"%s\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"CanExtShowCardPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[]{customParams.get("objname")});
            this.getView().showTipNotification(errMsg);
            return;
        }
        if (!this.getRequireLock(dataId, obj, "delete")) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u8bb0\u5f55\uff1f", (String)"CanFamilyEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_DEL, (IFormPlugin)this));
    }

    private boolean checkDataIsExistById(Long id, Long candidateId, String obj) {
        DynamicObjectCollection coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, obj);
        return !CollectionUtils.isEmpty((Collection)coll);
    }

    private void editCanCardPage(OperationStatus operationStatus) {
        String obj;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long candidateId = HRJSONUtils.getLongValOfCustomParam(customParams.get("candidateid"));
        Long id = HRJSONUtils.getLongValOfCustomParam(customParams.get("id"));
        if (!this.checkDataIsExistById(id, candidateId, obj = (String)customParams.get("obj"))) {
            String errMsg = ResManager.loadKDString((String)"%s\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"CanExtShowCardPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[]{customParams.get("objname")});
            this.getView().showTipNotification(errMsg);
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(operationStatus);
        if (OperationStatus.EDIT.equals((Object)operationStatus) && !this.getRequireLock(id, obj, "modify")) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam(customParams.get("onbrdid"));
        formShowParameter.setCustomParam("onbrdid", (Object)onbrdBillId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId((String)customParams.get("editinfo"));
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("id", (Object)id);
        formShowParameter.setCustomParam("obj", (Object)obj);
        formShowParameter.setCustomParam("showcols", customParams.get("showcols"));
        formShowParameter.setCaption((String)customParams.get("objname"));
        this.getView().showForm(formShowParameter);
    }

    private boolean getRequireLock(Long id, String entityNum, String opKey) {
        return IOnbrdCommonAppService.getInstance().tryRequireLockByHCF(this.getView(), id, entityNum, opKey);
    }
}

