/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo.ext;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.formplugin.web.base.HcfDataBaseExtAttachmentPlugin;

public class OnBrdSingleRowExtEditPlugin
extends HcfDataBaseExtAttachmentPlugin {
    private static final Log LOGGER = LogFactory.getLog(OnBrdSingleRowExtEditPlugin.class);

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.initData();
    }

    @Override
    protected Long getDataId() {
        return this.getModel().getDataEntity().getLong("id");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            IHomToHcfAppService homToHcfService = IHomToHcfAppService.getInstance();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long candidateId = HRJSONUtils.getLongValOfCustomParam(customParams.get("candidateid"));
            String hcfEntityNumber = (String)customParams.get("obj");
            DynamicObject hcfContactObj = homToHcfService.getSingleRowEntity(candidateId, hcfEntityNumber);
            DynamicObject hcfContactObjNew = HomCommonRepository.createEmptyDynamicObject((String)hcfEntityNumber);
            HRDynamicObjectUtils.copy((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)hcfContactObjNew);
            Long id = this.getModel().getDataEntity().getLong("id");
            if (id == 0L || id == null) {
                id = ORM.create().genLongId(hcfEntityNumber);
            }
            if (hcfContactObj != null) {
                hcfContactObjNew.set("boid", (Object)hcfContactObj.getLong("boid"));
            } else {
                hcfContactObjNew.set("id", (Object)id);
            }
            HashMap<Long, DynamicObject> entities = new HashMap<Long, DynamicObject>(2);
            entities.put(candidateId, hcfContactObjNew);
            Map result = homToHcfService.saveHisSingleRowEntity(entities, hcfEntityNumber);
            LOGGER.info("saveHisSingleRowEntity result={}", (Object)result);
            if (!((Boolean)result.get("success")).booleanValue()) {
                this.getView().getParentView().showErrorNotification(result.get("message").toString());
                LOGGER.error("Person Base Info Save Fail, ", (Object)result.get("message").toString());
                return;
            }
            this.saveAttachment(id, hcfEntityNumber);
        }
    }

    private void initData() {
        LOGGER.info("===OnBrdSingleRowExtEditPlugin initData===");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityNumber = (String)customParams.get("obj");
        this.getView().getModel().setValue("obj", (Object)entityNumber);
        Long candidateId = HRJSONUtils.getLongValOfCustomParam(customParams.get("candidateid"));
        this.getView().getModel().setValue("candidate", (Object)candidateId);
        IHomToHcfAppService homToHcfService = IHomToHcfAppService.getInstance();
        if (HRObjectUtils.isEmpty((Object)candidateId) || !customParams.containsKey("obj")) {
            return;
        }
        DynamicObject hcfInfo = homToHcfService.getSingleRowEntity(candidateId, entityNumber);
        if (hcfInfo == null) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        HRDynamicObjectUtils.copy((DynamicObject)hcfInfo, (DynamicObject)dataEntity);
        dataEntity.set("id", (Object)hcfInfo.getLong("id"));
        this.loadAttachments(hcfInfo.getLong("id"));
    }
}

