/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo.ext;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConBarItemAp;
import kd.bos.metadata.form.container.AdvConChildPanelAp;
import kd.bos.metadata.form.container.AdvConSummaryPanelAp;
import kd.bos.metadata.form.container.AdvConToolbarAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.mvc.cache.PageCache;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.OnbrdInfoConfigRepository;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.web.base.HomOnbrdDataBaseEdit;

public class OnbrdHcfExtInfoPlugin
extends HomOnbrdDataBaseEdit {
    private static final Log logger = LogFactory.getLog(OnbrdHcfExtInfoPlugin.class);
    private static final String SUFFIX = "hcfext";
    private static final String CONTAINER_KEY = "hcfext";
    private static final String TARGET_KEY = "flexpanelap";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String CONFIG = "config";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        Object[] configs = OnbrdInfoConfigRepository.getInstance().getAllConfigs();
        if (ArrayUtils.isEmpty((Object[])configs)) {
            return;
        }
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        HashMap<String, Long> map = new HashMap<String, Long>();
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("hcfext");
        for (int index = 0; index < configs.length; ++index) {
            Object config = configs[index];
            if (!onbrdCommonAppService.checkPermission(config.getString("viewinfo"), "47150e89000000ac")) {
                logger.info("No PermItem! pageNumber:{}", (Object)config.getString("viewinfo"));
                continue;
            }
            AdvConAp ap = new AdvConAp();
            ap.setKey("advconaphcfext" + index);
            ap.setName(new LocaleString(config.getString("obj.name")));
            ap.setCollapsible(true);
            ap.setBackColor("@container-bg-color");
            ap.setStyle(this.createStyle());
            ap.getItems().add(this.getAdvConSummaryPanelAp(index));
            ap.getItems().add(this.getAdvConToolbarAp(index, (DynamicObject)config, map));
            ap.getItems().add(this.getAdvConChildPanelAp(index));
            flexPanelAp.getItems().add(ap);
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("id", "hcfext");
        params.put("items", (String)flexPanelAp.createControl().get("items"));
        args.getItems().add(params);
        PageCache cache = new PageCache(((FormShowParameter)args.getSource()).getPageId());
        cache.put(CONFIG, SerializationUtils.toJsonString(map));
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        DynamicObject[] configs = OnbrdInfoConfigRepository.getInstance().getAllConfigs();
        for (int index = 0; index < configs.length; ++index) {
            DynamicObject config = configs[index];
            if (config.getBoolean("ismul")) continue;
            this.addItemListener("advcontoolbaraphcfext" + index, e);
        }
    }

    private Map<String, Long> getConfigMap() {
        IPageCache pageCache = this.getView().getPageCache();
        String configStr = pageCache.get(CONFIG);
        return (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Tuple<String, String> dataIds = this.getOnbrdId();
        DynamicObject[] configs = OnbrdInfoConfigRepository.getInstance().getAllConfigs();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        boolean enrollStatus = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        for (int index = 0; index < configs.length; ++index) {
            String containerKey;
            DynamicObject config = configs[index];
            if (!config.getBoolean("ismul")) {
                if (enrollStatus) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbaraphcfext" + index});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"btn_cancel" + index, "btn_save" + index});
                }
            }
            if (StringUtils.isEmpty((CharSequence)(containerKey = config.getString("showflex")))) {
                containerKey = "flexpanelaphcfext" + index;
            }
            String appId = this.getView().getFormShowParameter().getAppId();
            if (!onbrdCommonAppService.checkPermission(config.getString("viewinfo"), "47150e89000000ac", appId)) {
                logger.info("No PermItem! not show page, pageNumber:{}", (Object)config.getString("viewinfo"));
                continue;
            }
            this.showEmbedPage(config, containerKey, dataIds, OperationStatus.VIEW);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        boolean flag;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        String[] split = itemKey.split("^(btn_modity|btn_cancel|btn_save)");
        int index = Integer.parseInt(split[split.length - 1]);
        String containerKey = "flexpanelaphcfext" + index;
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        String candidateId = (String)this.getView().getFormShowParameter().getCustomParam("candidateid");
        Map<String, Long> configMap = this.getConfigMap();
        DynamicObject config = OnbrdInfoConfigRepository.getInstance().getConfigsById(configMap.get(itemKey));
        String editEntityNumber = config.getString("editinfo");
        String hcfEntityNumber = config.getString("obj.number");
        if ((itemKey.startsWith("btn_modity") || itemKey.startsWith("btn_save")) && IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
            return;
        }
        if (itemKey.startsWith("btn_modity")) {
            boolean lock = IOnbrdCommonAppService.getInstance().tryRequireLockByHCF(this.getView(), Long.valueOf(candidateId), hcfEntityNumber, "modify");
            if (!lock) {
                return;
            }
            if (!onbrdCommonAppService.checkPermissionAndShowTips(editEntityNumber, "4715a0df000000ac", this.getView())) {
                return;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{itemKey});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_save" + index, "btn_cancel" + index});
            this.setChildPageStatusView(editEntityNumber, containerKey, OperationStatus.EDIT, candidateId, hcfEntityNumber);
        } else if (itemKey.startsWith("btn_cancel")) {
            if (this.checkChildPageDataChange(editEntityNumber, index, candidateId, hcfEntityNumber)) {
                this.setChildPageStatusAndHideButton(index, editEntityNumber, hcfEntityNumber, candidateId, containerKey, OperationStatus.VIEW);
            }
            IOnbrdCommonAppService.getInstance().releaseLockByHCF(Long.valueOf(candidateId), hcfEntityNumber, "modify");
        } else if (itemKey.startsWith("btn_save") && (flag = this.invokeChildOperation(editEntityNumber, "save"))) {
            this.setChildPageStatusAndHideButton(index, editEntityNumber, hcfEntityNumber, candidateId, containerKey, OperationStatus.VIEW);
            IOnbrdCommonAppService.getInstance().releaseLockByHCF(Long.valueOf(candidateId), hcfEntityNumber, "modify");
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"extConfirmCallBack") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            IPageCache pageCache = this.getPageCache();
            String pageNumber = pageCache.get("pageNumber");
            Integer index = Integer.valueOf(pageCache.get("index"));
            String objNumber = pageCache.get("objNumber");
            String candidateId = pageCache.get("candidateId");
            this.setChildPageStatusAndHideButton(index, pageNumber, objNumber, candidateId, "flexpanelaphcfext" + index, OperationStatus.VIEW);
        }
    }

    private void setChildPageStatusAndHideButton(int index, String editEntityNumber, String hcfEntityNumber, String candidateId, String containerKey, OperationStatus status) {
        this.setChildPageStatusView(editEntityNumber, containerKey, status, candidateId, hcfEntityNumber);
        this.getView().setVisible(Boolean.TRUE, new String[]{"btn_modity" + index});
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save" + index, "btn_cancel" + index});
    }

    private void setChildPageStatusView(String pageNumber, String containerKey, OperationStatus status, String candidateId, String objNumber) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(containerKey);
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("obj", (Object)objNumber);
        formShowParameter.setFormId(pageNumber);
        formShowParameter.setStatus(status);
        formShowParameter.setSendToClient(true);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(pageNumber, formShowParameter.getPageId());
        logger.info("this.getView().getPageId():" + this.getView().getPageId() + ", formShowParameter.getPageId():" + formShowParameter.getPageId() + ", pageNumber:" + pageNumber);
        this.getView().showForm(formShowParameter);
    }

    private boolean checkChildPageDataChange(String pageNumber, Integer index, String candidateId, String objNumber) {
        IFormView childView = this.getEmbedPageView(pageNumber);
        if (childView != null && childView.getModel() != null && childView.getModel().getDataChanged()) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractFormDrawEdit_6", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AbstractFormDrawEdit_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f%s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AbstractFormDrawEdit_9", (String)"hr-hom-formplugin", (Object[])new Object[0]), System.lineSeparator());
            String changeDesc = childView.getModel().getChangeDesc();
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("extConfirmCallBack", (IFormPlugin)this);
            this.getView().showConfirm(msg, changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            IPageCache pageCache = this.getPageCache();
            pageCache.put("pageNumber", pageNumber);
            pageCache.put("index", String.valueOf(index));
            pageCache.put("candidateId", candidateId);
            pageCache.put("objNumber", objNumber);
            return false;
        }
        return true;
    }

    private void showEmbedPage(DynamicObject config, String containerKey, Tuple<String, String> dataIds, OperationStatus status) {
        logger.info("containerKey={}, dataIds={}, config={}", new Object[]{containerKey, dataIds, config});
        FormShowParameter formShowParameter = new FormShowParameter();
        String pageNumber = config.getString("viewinfo");
        try {
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey(containerKey);
            formShowParameter.setCustomParam("onbrdid", dataIds.item1);
            formShowParameter.setCustomParam("candidateid", dataIds.item2);
            formShowParameter.setCustomParam("showinfo", (Object)config.getString("showinfo"));
            formShowParameter.setCustomParam("editinfo", (Object)config.getString("editinfo"));
            formShowParameter.setCustomParam("objname", (Object)config.getString("obj.name"));
            formShowParameter.setCustomParam("obj", (Object)config.getString("obj.number"));
            formShowParameter.setCustomParam("showcols", (Object)config.getString("showcols"));
            formShowParameter.setCustomParam("ismul", (Object)config.getBoolean("ismul"));
            formShowParameter.setCustomParam("showtype", (Object)config.getString("showtype"));
            formShowParameter.setFormId(pageNumber);
            formShowParameter.setStatus(status);
            formShowParameter.setSendToClient(true);
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.put(pageNumber, formShowParameter.getPageId());
            logger.info("this.getView().getPageId():" + this.getView().getPageId() + ", formShowParameter.getPageId():" + formShowParameter.getPageId() + ", pageNumber:" + pageNumber);
            this.getView().showForm(formShowParameter);
        }
        catch (Exception exception) {
            logger.error("pageNumber = {}, error:", (Object)pageNumber, (Object)exception);
        }
    }

    private Tuple<String, String> getOnbrdId() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        String candidateId = (String)this.getView().getFormShowParameter().getCustomParam("candidateid");
        return Tuple.create((Object)onbrdId.toString(), (Object)candidateId);
    }

    private FlexPanelAp getFlexPanelAp(int index) {
        FlexPanelAp ap = new FlexPanelAp();
        ap.setKey("flexpanelaphcfext" + index);
        ap.setName(new LocaleString(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5185\u5d4c\u4fe1\u606f\u533a%s", (String)"OnbrdHcfExtInfoPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), "hcfext" + index)));
        ap.setCollapsible(false);
        ap.setDirection("column");
        ap.setJustifyContent("flex-start");
        ap.setAlignItems("flex-start");
        return ap;
    }

    private AdvConChildPanelAp getAdvConChildPanelAp(int index) {
        AdvConChildPanelAp ap = new AdvConChildPanelAp();
        ap.setKey("advconchildpanelaphcfext" + index);
        ap.getItems().add(this.getFlexPanelAp(index));
        return ap;
    }

    private AdvConToolbarAp getAdvConToolbarAp(int index, DynamicObject config, Map<String, Long> map) {
        AdvConToolbarAp ap = new AdvConToolbarAp();
        ap.setKey("advcontoolbaraphcfext" + index);
        ap.setName(new LocaleString("advcontoolbaraphcfext" + index));
        if (!config.getBoolean("ismul")) {
            ap.getItems().add(this.createAdvConBarItemAp("btn_modity", this.getButtonNameByButtonKey("btn_modity"), index));
            ap.getItems().add(this.createAdvConBarItemAp("btn_cancel", this.getButtonNameByButtonKey("btn_cancel"), index));
            ap.getItems().add(this.createAdvConBarItemAp("btn_save", this.getButtonNameByButtonKey("btn_save"), index));
            long configId = config.getLong("id");
            map.put("btn_modity" + index, configId);
            map.put("btn_cancel" + index, configId);
            map.put("btn_save" + index, configId);
        }
        return ap;
    }

    private AdvConBarItemAp createAdvConBarItemAp(String key, String name, int index) {
        AdvConBarItemAp advConBarItemAp = new AdvConBarItemAp();
        advConBarItemAp.setKey(key + index);
        advConBarItemAp.setName(new LocaleString(name));
        advConBarItemAp.setOperationKey(key);
        return advConBarItemAp;
    }

    private ControlAp<?> getAdvConSummaryPanelAp(int index) {
        AdvConSummaryPanelAp ap = new AdvConSummaryPanelAp();
        ap.setKey("advconsummarypanelaphcfext" + index);
        ap.setName(new LocaleString("advconsummarypanelap_ext" + index));
        return ap;
    }

    private Style createStyle() {
        Style style = new Style();
        style.setBorder(this.setBorder());
        return style;
    }

    private Border setBorder() {
        Border border = new Border();
        border.setTop("10px_solid_#F2F2F2");
        border.setBottom("1px_solid_#F2F2F2");
        return border;
    }

    private void addItemListener(String buttonKey, OnGetControlArgs e) {
        if (StringUtils.equals((CharSequence)buttonKey, (CharSequence)e.getKey())) {
            Toolbar bar = new Toolbar();
            bar.setKey(buttonKey);
            bar.setView(this.getView());
            bar.addItemClickListener((ItemClickListener)this);
            e.setControl((Control)bar);
        }
    }

    private String getButtonNameByButtonKey(String buttonKey) {
        switch (buttonKey) {
            case "btn_save": {
                return ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"OnbrdHcfExtInfoPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            }
            case "btn_modity": {
                return ResManager.loadKDString((String)"\u4fee\u6539", (String)"OnbrdHcfExtInfoPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            }
            case "btn_cancel": {
                return ResManager.loadKDString((String)"\u53d6\u6d88", (String)"OnbrdHcfExtInfoPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }
}

