/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo.ext;

import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.web.base.HcfDataBaseExtViewPlugin;

public class OnbrdMultiRowTableExtViewPlugin
extends HcfDataBaseExtViewPlugin {
    private static final String OPCOLUMNAP_EDIT = "opcolumnapedit";
    private static final String OPCOLUMNAP_VIEW = "opcolumnapview";
    private static final String OPKEY_ADD = "donothing_add";
    private static final String OPKEY_MODIFY = "donothing_modify";
    private static final String OPKEY_DELETE = "donothing_delete";
    private static final String OPKEY_VIEW = "donothing_view";
    private static final String MUTIL_ROW_EDIT_CALLBACK = "mutilrow_editCallBack";
    private static final Log logger = LogFactory.getLog(OnbrdMultiRowTableExtViewPlugin.class);

    public void afterCreateNewData(EventObject eventObject) {
        this.refreshEntryEntity();
    }

    @Override
    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.isEnrolled();
    }

    private void refreshEntryEntity() {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        String objNumber = (String)this.getView().getFormShowParameter().getCustomParam("obj");
        DynamicObjectCollection dataCol = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, objNumber);
        if (CollectionUtils.isEmpty((Collection)dataCol)) {
            this.loadOnbrdNullPage();
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"conentpanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"onbrdnullpage"});
        this.isEnrolled();
        IDataModel dataModel = this.getModel();
        if (!(dataModel instanceof AbstractFormDataModel)) {
            return;
        }
        List<DynamicObject> dataList = dataCol.stream().sorted(Comparator.comparing(dyo -> dyo.getDate("createtime"), Comparator.reverseOrder())).collect(Collectors.toList());
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter vs = this.getTableValue(dataList);
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private TableValueSetter getTableValue(List<DynamicObject> dataList) {
        DynamicObjectType dynamicObjectType = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").getDynamicObjectType();
        List entryProperties = dynamicObjectType.getProperties().stream().filter(property -> !"locale".equals(property.getName())).map(property -> property.getName()).collect(Collectors.toList());
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int indexRow = 0;
        for (DynamicObject data : dataList) {
            DynamicObject dy = new DynamicObject(dynamicObjectType);
            HRDynamicObjectUtils.copy((DynamicObject)data, (DynamicObject)dy);
            for (String property2 : entryProperties) {
                if ("id".equals(property2) || "multilanguagetext".equals(property2)) continue;
                vs.set(property2, dy.get(property2), indexRow);
            }
            vs.set("id", (Object)data.getLong("id"), indexRow);
            ++indexRow;
        }
        return vs;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject currentRowData = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        FormOperate operation = (FormOperate)args.getSource();
        String opKey = operation.getOperateKey();
        if (opKey.equals(OPKEY_ADD) || opKey.equals(OPKEY_MODIFY) || opKey.equals(OPKEY_DELETE)) {
            Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid").toString());
            if (IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
                args.setCancel(true);
                return;
            }
        }
        switch (opKey) {
            case "donothing_add": {
                this.showNewPage(candidateId);
                break;
            }
            case "donothing_modify": {
                String appId = this.getView().getFormShowParameter().getAppId();
                if (IOnbrdCommonAppService.getInstance().checkPermission(this.getView().getEntityId(), "4715a0df000000ac", appId)) {
                    this.editCurrentRow(candidateId, currentRowData.getLong("id"));
                    break;
                }
                this.showEditPage(candidateId, currentRowData.getLong("id"), OperationStatus.VIEW);
                break;
            }
            case "donothing_delete": {
                this.deleteCurrentRow(currentRowData.getLong("id"));
                break;
            }
            case "donothing_view": {
                this.showEditPage(candidateId, currentRowData.getLong("id"), OperationStatus.VIEW);
                break;
            }
        }
    }

    private void editCurrentRow(Long candidateId, Long dataId) {
        Object entityNum = this.getView().getFormShowParameter().getCustomParams().get("obj");
        if (!IOnbrdCommonAppService.getInstance().tryRequireLockByHCF(this.getView(), dataId, String.valueOf(entityNum), "modify")) {
            this.showEditPage(candidateId, dataId, OperationStatus.VIEW);
            return;
        }
        this.showEditPage(candidateId, dataId, OperationStatus.EDIT);
    }

    private void deleteCurrentRow(Long dataId) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityNum = String.valueOf(customParams.get("obj"));
        if (!IOnbrdCommonAppService.getInstance().tryRequireLockByHCF(this.getView(), dataId, entityNum, "delete")) {
            return;
        }
        try {
            IHomToHcfAppService.getInstance().getById(dataId, entityNum);
        }
        catch (KDException e) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"RsmpatinvViewPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u8bb0\u5f55\uff1f", (String)"PreWorkExpViewPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OPKEY_DELETE, (IFormPlugin)this));
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("dataId", String.valueOf(dataId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)actionId, (String)OPKEY_DELETE) && MessageBoxResult.Yes == resultValue) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String dataId = pageCache.get("dataId");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String entityNum = String.valueOf(customParams.get("obj"));
            try {
                Map result = IHomToHcfAppService.getInstance().deleteById(Long.valueOf(dataId), entityNum);
                Boolean success = (Boolean)result.get("success");
                if (success.booleanValue()) {
                    this.delAllAttachment(Long.valueOf(dataId), (String)customParams.get("obj"));
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"RsmpatinvViewPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                } else {
                    this.getView().showErrorNotification((String)result.get("message"));
                }
            }
            finally {
                IOnbrdCommonAppService.getInstance().releaseLockByHCF(Long.valueOf(dataId), entityNum, "delete");
            }
        }
    }

    private void showNewPage(Long candidateId) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId((String)customParams.get("editinfo"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MUTIL_ROW_EDIT_CALLBACK));
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("onbrdid", customParams.get("onbrdid"));
        formShowParameter.setCustomParam("obj", customParams.get("obj"));
        formShowParameter.setCaption((String)customParams.get("obj.name"));
        this.getView().showForm(formShowParameter);
    }

    private void showEditPage(Long candidateId, Long dataId, OperationStatus status) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(status);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId((String)customParams.get("editinfo"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MUTIL_ROW_EDIT_CALLBACK));
        formShowParameter.setCustomParam("id", (Object)dataId);
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("onbrdid", customParams.get("onbrdid"));
        formShowParameter.setCustomParam("obj", customParams.get("obj"));
        formShowParameter.setCaption((String)customParams.get("obj.name"));
        this.getView().showForm(formShowParameter);
    }

    @Override
    protected void loadOnbrdNullPage() {
        super.loadOnbrdNullPage();
        this.getView().setVisible(Boolean.FALSE, new String[]{"conentpanel"});
    }

    private void isEnrolled() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        boolean isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        if (isEnroll) {
            this.getView().setVisible(Boolean.TRUE, new String[]{OPCOLUMNAP_VIEW});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_add", OPCOLUMNAP_EDIT});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{OPCOLUMNAP_VIEW});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_add", OPCOLUMNAP_EDIT});
        }
    }
}

