/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.preonbrd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.common.util.HOMObjectUtils;
import org.apache.commons.collections.CollectionUtils;

public class PreOnBrdF7SelectEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(PreOnBrdF7SelectEdit.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit certificateTypeEdit = (BasedataEdit)this.getView().getControl("certificatetype");
        certificateTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ajoblevelEdit = (BasedataEdit)this.getView().getControl("joblevel");
        ajoblevelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ajobgradeEdit = (BasedataEdit)this.getView().getControl("jobgrade");
        ajobgradeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ajoblevelscmEdit = (BasedataEdit)this.getView().getControl("joblevelscm");
        ajoblevelscmEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ajobgradescmEdit = (BasedataEdit)this.getView().getControl("jobgradescm");
        ajobgradescmEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit affactionEdit = (BasedataEdit)this.getView().getControl("paffaction");
        affactionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        QFilter filter = null;
        switch (propertyName) {
            case "paffaction": {
                filter = this.getQFilterChgevent();
                break;
            }
            case "joblevel": {
                filter = this.getQFilterWithAjoblevel();
                break;
            }
            case "jobgrade": {
                filter = this.getQFilterWithAjobgrade();
                break;
            }
            case "joblevelscm": {
                filter = this.getQFilterWithJoblevelScm();
                break;
            }
            case "jobgradescm": {
                filter = this.getQFilterWithJobgradeScm();
                break;
            }
        }
        if (!HRObjectUtils.isEmpty(filter)) {
            beforeF7SelectEvent.getCustomQFilters().add(filter);
        }
    }

    private QFilter getQFilterChgevent() {
        List chgeventKeys = IBaseDataDomainService.getInstance().getChgActionIdsByHomMetadata();
        QFilter qFilter = new QFilter("enable", "in", (Object)"1");
        if (CollectionUtils.isNotEmpty((Collection)chgeventKeys)) {
            qFilter.and("id", "in", (Object)chgeventKeys);
        } else {
            qFilter.and(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            LOGGER.info("getHpfsChgactionInfo_null");
        }
        return qFilter;
    }

    private QFilter getQFilterWithJoblevelScm() {
        long joblevelscmId = (Long)this.getJobLevelGradeScmId().item1;
        return joblevelscmId == 0L ? null : new QFilter("id", "=", (Object)joblevelscmId);
    }

    private QFilter getQFilterWithJobgradeScm() {
        long jobgradescmId = (Long)this.getJobLevelGradeScmId().item2;
        return jobgradescmId == 0L ? null : new QFilter("id", "=", (Object)jobgradescmId);
    }

    private Tuple<Long, Long> getJobLevelGradeScmId() {
        long joblevelscmId = 0L;
        long jobgradescmId = 0L;
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject currentRowDy = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(entryCurrentRowIndex);
        long jobId = currentRowDy.getLong("ajob.id");
        Map jobInfoMap = new HashMap(8);
        if (jobId != 0L) {
            jobInfoMap = IBaseDataDomainService.getInstance().getJobLevelGradeRangeInfoByJobId(Long.valueOf(jobId));
        }
        if (jobInfoMap != null) {
            joblevelscmId = HOMObjectUtils.getLongValOfCustomParam(jobInfoMap.get("joblevelScmid"));
            jobgradescmId = HOMObjectUtils.getLongValOfCustomParam(jobInfoMap.get("jobgradeScmid"));
        }
        return Tuple.create((Object)joblevelscmId, (Object)jobgradescmId);
    }

    private QFilter getQFilterWithAjoblevel() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject currentRowDy = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(entryCurrentRowIndex);
        Long jobId = currentRowDy.getLong("ajob.id");
        QFilter qFilter = null;
        QFilter idFilter = null;
        long joblevelscmId = currentRowDy.getLong("joblevelscm.id");
        if (joblevelscmId != 0L) {
            qFilter = new QFilter("joblevelscm", "=", (Object)joblevelscmId);
        }
        List jobleves = null;
        CollectionUtils.isEmpty(jobleves);
        Tuple<List<DynamicObject>, List<DynamicObject>> jobleveGradeTuple = this.getLevelGradeRangesByJobId(jobId);
        jobleves = (List)jobleveGradeTuple.item1;
        if (jobleves != null && !jobleves.isEmpty()) {
            List jobleveIdList = jobleves.stream().map(jobLevel -> jobLevel.getLong("id")).collect(Collectors.toList());
            idFilter = new QFilter("id", "in", jobleveIdList);
        }
        if (idFilter != null) {
            qFilter = qFilter == null ? idFilter : idFilter.and(qFilter);
        }
        LOGGER.info("qFilter:{}", (Object)(qFilter == null ? "null" : qFilter.toString()));
        return qFilter;
    }

    private Tuple<List<DynamicObject>, List<DynamicObject>> getLevelGradeRangesByJobId(Long jobId) {
        Map jobInfoMap = new HashMap();
        if (jobId != 0L) {
            jobInfoMap = IBaseDataDomainService.getInstance().getJobLevelGradeRangeInfoByJobId(jobId);
        }
        List jobGrades = new ArrayList();
        List jobleves = new ArrayList();
        if (jobInfoMap != null && !jobInfoMap.isEmpty()) {
            jobGrades = (List)jobInfoMap.get("jobgradeRanges");
            jobleves = (List)jobInfoMap.get("joblevelRanges");
        }
        return Tuple.create(jobleves, jobGrades);
    }

    private QFilter getQFilterWithAjobgrade() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject currentRowDy = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(entryCurrentRowIndex);
        Long jobId = currentRowDy.getLong("ajob.id");
        QFilter qFilter = null;
        long jobgradeScmId = currentRowDy.getLong("jobgradescm.id");
        if (jobgradeScmId != 0L) {
            qFilter = new QFilter("jobgradescm", "=", (Object)jobgradeScmId);
        }
        QFilter idFilter = null;
        List jobGrades = null;
        CollectionUtils.isEmpty(jobGrades);
        jobGrades = (List)this.getLevelGradeRangesByJobId((Long)jobId).item2;
        if (jobGrades != null && !jobGrades.isEmpty()) {
            List jobGradeIdList = jobGrades.stream().map(jobGrade -> jobGrade.getLong("id")).collect(Collectors.toList());
            idFilter = new QFilter("id", "in", jobGradeIdList);
        }
        if (idFilter != null) {
            qFilter = qFilter == null ? idFilter : idFilter.and(qFilter);
        }
        LOGGER.info("qFilter:{}", (Object)(qFilter == null ? "null" : qFilter.toString()));
        return qFilter;
    }
}

