/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.preonbrd.validator;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.odc.service.CommonPermissionValidateService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.utils.PreOnbrdUtil;
import kd.hr.hom.business.domain.service.preonbrd.IPreOnBrdService;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.util.PreOnBrdCommonUtil;
import kd.hr.hom.formplugin.common.PreOnBrdHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hrmp.hies.entry.core.validate.AbstractEntryValidateHandler;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PreOnBrdValidateHandler
extends AbstractEntryValidateHandler {
    private static final Log logger = LogFactory.getLog(PreOnBrdValidateHandler.class);
    public static final String SELECT_PROPERTIES = "id,billno,pbillno,entryentity,entryentity.certificatetype,entryentity.certificatenumber,entryentity.phone,entryentity.name,entryentity.peremail";
    String billno = "";

    public PreOnBrdValidateHandler(String billno) {
        this.billno = billno;
    }

    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.AFTER;
    }

    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (CollectionUtils.isEmpty(billDataList)) {
            return;
        }
        try {
            List<DynamicObject> preOnBrdDys = PreOnBrdHelper.importBillDataToOnBrdData(billDataList);
            ArrayList<String> validateFields = new ArrayList<String>();
            validateFields.add("certificatenumber");
            validateFields.add("peremail");
            validateFields.add("phone");
            Set onBrdRepeatBillDys = IOnbrdCommonAppService.getInstance().batchValidField(preOnBrdDys, validateFields);
            List perCerNos = preOnBrdDys.stream().map(e -> e.getString("certificatenumber")).collect(Collectors.toList());
            DynamicObject[] preOnBrdRepeatBillDys = IPreOnBrdService.getInstance().queryByCerNos(SELECT_PROPERTIES, perCerNos);
            HashSet fieldNameSet = Sets.newHashSet((Object[])new String[]{"phone", "certificatenumber", "peremail", "employeeno", "name"});
            Map checkResultMap = IHomToHrpiAppService.getInstance().checkAndTipByPersonFieldsForPre(preOnBrdDys, (List)Lists.newArrayList((Iterable)fieldNameSet));
            logger.info("validPersonIsExistByHspm.checkResultMap:{}", (Object)checkResultMap);
            List phones = billDataList.stream().map(ImportBillData::getData).map(jsonObject -> jsonObject.getJSONObject("entryentity")).map(jsonObject -> jsonObject.getString("phone")).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
            Map telephoneVerifyResultMap = PreOnbrdUtil.getInstance().telephoneVerify(phones);
            CommonPermissionValidateService validateService = new CommonPermissionValidateService(preOnBrdDys, "hom_preonbrdbasebill");
            this.putLabrelstatuscls(billDataList);
            for (ImportBillData billData : billDataList) {
                try {
                    Boolean personFieldUniqueBool;
                    String phone;
                    boolean telephoneVerifyResult;
                    Boolean formatBool;
                    Boolean mustInputBool = this.mustInputValidateForImport(billData, importLog);
                    if (mustInputBool.booleanValue() && (formatBool = this.formatValidateForImport(billData, telephoneVerifyResult = telephoneVerifyResultMap.getOrDefault(phone = Optional.ofNullable(billData.getData()).map(data -> data.getJSONObject("entryentity")).map(jsonObject -> jsonObject.getString("phone")).orElse(""), Boolean.FALSE).booleanValue(), importLog)).booleanValue() && (personFieldUniqueBool = this.personFieldUniqueValidateForImport(onBrdRepeatBillDys, checkResultMap, billData, importLog)).booleanValue()) {
                        this.preUniqueValidateForImport(preOnBrdRepeatBillDys, billData, importLog);
                    }
                    this.validAjobScmOrgPermission(billData, preOnBrdDys, importLog, validateService);
                }
                catch (Exception e2) {
                    logger.error((Throwable)e2);
                    importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), String.format(e2.getMessage(), new Object[0]));
                }
            }
        }
        catch (Exception e3) {
            logger.error((Throwable)e3);
        }
    }

    private void putLabrelstatuscls(List<ImportBillData> billDataList) {
        try {
            List plaborrelstatusIds = billDataList.stream().map(data -> data.getData().getJSONObject("entryentity").getJSONObject("plaborrelstatus").getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", plaborrelstatusIds);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_laborrelstatus");
            DynamicObject[] labrelstatuscls = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
            for (ImportBillData billData : billDataList) {
                JSONObject entity = billData.getData().getJSONObject("entryentity");
                JSONObject plaborrelStatus = entity.getJSONObject("plaborrelstatus");
                if (ObjectUtils.isEmpty((Object)plaborrelStatus)) {
                    entity.put("labrelstatusclsId", null);
                }
                Long plaborrelStatusId = plaborrelStatus.getLong("id");
                Optional<DynamicObject> plaborrelStatusOptional = Arrays.stream(labrelstatuscls).filter(e -> e.getLong("id") == plaborrelStatusId.longValue()).findFirst();
                if (!plaborrelStatusOptional.isPresent()) continue;
                DynamicObject laborrelStatus = plaborrelStatusOptional.get();
                entity.put("labrelstatusclsId", (Object)laborrelStatus.getDynamicObject("labrelstatuscls").getLong("id"));
                entity.put("labrelstatusName", (Object)laborrelStatus.getString("name"));
            }
        }
        catch (Exception e2) {
            logger.error((Throwable)e2);
        }
    }

    private Boolean personFieldUniqueValidateForImport(Set<DynamicObject> repeatBillDys, Map<String, String> checkResultMap, ImportBillData billData, ImportLog importLog) {
        Boolean personFieldUniqueBool = Boolean.TRUE;
        if (CollectionUtils.isEmpty(repeatBillDys) && checkResultMap == null) {
            return Boolean.TRUE;
        }
        StringBuilder errorMessage = new StringBuilder();
        try {
            JSONObject data = billData.getData();
            JSONObject entry = data.getJSONObject("entryentity");
            JSONObject cerType = entry.getJSONObject("certificatetype");
            Object cerTypeId = cerType.get((Object)"id");
            String cerNo = entry.getString("certificatenumber");
            String phone = entry.getString("phone");
            String permail = entry.getString("peremail");
            AtomicInteger bool = new AtomicInteger(0);
            StringBuffer errorMessageFirst = new StringBuffer();
            repeatBillDys.forEach(dynamicObject -> {
                boolean permailBool;
                String cerNoRepeat = dynamicObject.getString("certificatenumber");
                DynamicObject cerTypeRepeat = dynamicObject.getDynamicObject("certificatetype");
                Long cerTypeIdRepeat = cerTypeRepeat.getLong("id");
                String phoneRepeat = dynamicObject.getString("phone");
                String permailRepeat = dynamicObject.getString("peremail");
                StringBuilder errorMessageSec = new StringBuilder();
                boolean cerBool = cerNoRepeat.equals(cerNo) && cerTypeIdRepeat.equals(cerTypeId);
                boolean phoneBool = phoneRepeat.equals(phone);
                boolean bl = permailBool = HRStringUtils.isNotEmpty((String)permail) && permailRepeat.equals(permail);
                if (cerBool || phoneBool || permailBool) {
                    bool.set(1);
                    String billNo = dynamicObject.getString("billno");
                    if (HRStringUtils.isEmpty((String)billNo)) {
                        return;
                    }
                    errorMessageSec.append(PreOnBrdCommonUtil.getMergeAttrName((boolean)cerBool, (boolean)phoneBool, (boolean)permailBool));
                    errorMessageFirst.append(String.format(ResManager.loadKDString((String)"%1$s\u4e0e\u5728\u9014\u5165\u804c\u5355\"%2$s\"\u7684\u5019\u9009\u4eba\u91cd\u590d\u3001", (String)"PreOnBrdValidateHandler_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), errorMessageSec, billNo));
                }
            });
            if (ObjectUtils.isNotEmpty(checkResultMap)) {
                String prepkId = String.valueOf(entry.getLong("prepkid"));
                String validPersonResult = checkResultMap.get(prepkId);
                if (checkResultMap.containsKey(prepkId)) {
                    bool.set(1);
                    errorMessageFirst.append(validPersonResult);
                }
            }
            if (bool.get() > 0) {
                String err = errorMessageFirst.toString();
                if (err.endsWith("\u3001")) {
                    errorMessageFirst.replace(errorMessageFirst.length() - 1, errorMessageFirst.length(), "");
                }
                errorMessage.append(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u3002", (String)"PreOnBrdValidateHandler_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), errorMessageFirst)).append(ResManager.loadKDString((String)"\n", (String)"", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errorMessage.toString());
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5c5e\u6027\u552f\u4e00\u6027\u6821\u9a8c\u53d1\u751f\u5f02\u5e38\u3002", (String)"PreOnBrdValidateHandler_4", (String)"hr-hom-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        return personFieldUniqueBool;
    }

    private Boolean formatValidateForImport(ImportBillData billData, boolean phoneError, ImportLog importLog) {
        Boolean bool = Boolean.TRUE;
        JSONObject data = billData.getData();
        try {
            JSONObject entry = data.getJSONObject("entryentity");
            String checkFormat = PreOnbrdUtil.getInstance().checkFormatForImport(entry, phoneError);
            if (HRStringUtils.isNotEmpty((String)checkFormat)) {
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), checkFormat);
                bool = Boolean.FALSE;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u683c\u5f0f\u6821\u9a8c\u53d1\u751f\u5f02\u5e38\u3002", (String)"PreOnBrdValidateHandler_5", (String)"hr-hom-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        return bool;
    }

    private Boolean mustInputValidateForImport(ImportBillData billData, ImportLog importLog) {
        Boolean bool = Boolean.TRUE;
        try {
            String phoneCode;
            JSONObject data = billData.getData();
            JSONObject entry = data.getJSONObject("entryentity");
            String locationCode = entry.getString("locationcode");
            if (HRStringUtils.isEmpty((String)locationCode)) {
                PreOnBrdValidateHandler.setLineMustInputErrMsg(importLog, billData, "locationcode");
                bool = Boolean.FALSE;
            }
            if (HRStringUtils.isEmpty((String)(phoneCode = entry.getString("phonecode")))) {
                PreOnBrdValidateHandler.setLineMustInputErrMsg(importLog, billData, "phonecode");
                bool = Boolean.FALSE;
            }
            Long labrelstatusclsId = entry.getLong("labrelstatusclsId");
            String labrelstatusName = entry.getString("labrelstatusName");
            if (ObjectUtils.isEmpty((Object)labrelstatusclsId)) {
                return bool;
            }
            Boolean isProbationBool = entry.getBoolean("isprobation");
            Integer probationtime = entry.getInteger("probationtime");
            String perprobationtime = entry.getString("perprobationtime");
            String falseStr = ResManager.loadKDString((String)"\u5426", (String)"PreOnBrdValidateHandler_20", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            String trueStr = ResManager.loadKDString((String)"\u662f", (String)"PreOnBrdValidateHandler_21", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            if (BaseDataIdConstants.HBSS_LABRELSTATUSCLS_1010.equals(labrelstatusclsId)) {
                if (ObjectUtils.isEmpty((Object)isProbationBool) || !isProbationBool.booleanValue()) {
                    this.setIsProbationMustInputErrMsg(importLog, billData, labrelstatusName, trueStr);
                    bool = Boolean.FALSE;
                } else if (ObjectUtils.isEmpty((Object)probationtime) || ObjectUtils.isEmpty((Object)perprobationtime)) {
                    PreOnBrdValidateHandler.setLineMustInputErrMsgForProbation(importLog, billData, labrelstatusName);
                    bool = Boolean.FALSE;
                }
            } else if (ObjectUtils.isEmpty((Object)isProbationBool) || isProbationBool.booleanValue()) {
                this.setIsProbationMustInputErrMsg(importLog, billData, labrelstatusName, falseStr);
                bool = Boolean.FALSE;
            } else {
                entry.put("probationtime", null);
                entry.put("perprobationtime", null);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), String.format(ResManager.loadKDString((String)"\u5fc5\u586b\u6821\u9a8c\u53d1\u751f\u5f02\u5e38\u3002", (String)"PreOnBrdValidateHandler_7", (String)"hr-hom-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        return bool;
    }

    private void setIsProbationMustInputErrMsg(ImportLog importLog, ImportBillData billData, String labrelstatusName, String boolStr) {
        String inputErrMsgForIsProbation = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4eba\u5458\u7684\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u4e3a%1$s\uff0c\u201c\u662f\u5426\u6709\u8bd5\u7528\u671f\u201d\u5e94\u4e3a%2$s\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"PreOnBrdValidateHandler_16", (String)"hr-hom-formplugin", (Object[])new Object[0]), labrelstatusName, boolStr);
        importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), inputErrMsgForIsProbation);
    }

    private static void setLineMustInputErrMsg(ImportLog importLog, ImportBillData billData, String filed) {
        String cnNameByFieldName = PreOnBrdCommonUtil.getCnNameByFieldNameForImport((String)filed);
        String mustInputErrMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5fc5\u5f55\u5b57\u6bb5\u201c%s\u201d\u4e2d\u7684\u6570\u636e\u540e\u518d\u4e0a\u4f20\u3002", (String)"PreOnBrdValidateHandler_8", (String)"hr-hom-formplugin", (Object[])new Object[0]), cnNameByFieldName);
        importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), mustInputErrMsg);
    }

    private static void setLineMustInputErrMsgForProbation(ImportLog importLog, ImportBillData billData, String labrelstatusclsName) {
        String inputErrMsgForProbation = PreOnBrdCommonUtil.getLineMustInputErrMsgForProbation((String)labrelstatusclsName);
        importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), inputErrMsgForProbation);
    }

    private void preUniqueValidateForImport(DynamicObject[] dyByCerNos, ImportBillData billData, ImportLog importLog) {
        try {
            JSONObject data = billData.getData();
            JSONObject entry = data.getJSONObject("entryentity");
            JSONObject cerType = entry.getJSONObject("certificatetype");
            Object cerTypeId = cerType.get((Object)"id");
            String cerNo = entry.getString("certificatenumber");
            JSONObject name = entry.getJSONObject("name");
            String zhCnName = name == null ? "" : name.getString("zh_CN");
            for (DynamicObject dyByCerNo : dyByCerNos) {
                DynamicObjectCollection entryentity = dyByCerNo.getDynamicObjectCollection("entryentity");
                List isExist = entryentity.stream().filter(dy -> Objects.equals(dy.getDynamicObject("certificatetype").getLong("id"), cerTypeId) && dy.getString("certificatenumber").equals(cerNo)).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(isExist)) continue;
                String bigBillNo = this.billno;
                String repeatBillNo = dyByCerNo.getString("billno");
                if (!HRStringUtils.isNotEmpty((String)bigBillNo) || bigBillNo.equals(repeatBillNo)) continue;
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%1$s\u5df2\u6709\u5728\u9014\u7684\u9884\u5165\u804c\u7533\u8bf7\u5355\uff08\u5355\u636e\u7f16\u53f7\uff1a%2$s\uff09\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u3002", (String)"PreOnBrdValidateHandler_13", (String)"hr-hom-formplugin", (Object[])new Object[0]), zhCnName, dyByCerNo.getString("billno")));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6821\u9a8c\u53d1\u751f\u5f02\u5e38\u3002", (String)"PreOnBrdValidateHandler_12", (String)"hr-hom-formplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void validAjobScmOrgPermission(ImportBillData billData, List<DynamicObject> preOnBrdDys, ImportLog importLog, CommonPermissionValidateService validateService) {
        Long onbrdId = billData.getData().getJSONObject("entryentity").getLong("prepkid");
        for (DynamicObject preOnBrdDy : preOnBrdDys) {
            String errMsg;
            if (preOnBrdDy.getLong("id") != onbrdId.longValue() || HRStringUtils.isBlank((CharSequence)(errMsg = validateService.validate(preOnBrdDy)))) continue;
            importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errMsg);
        }
    }
}

