/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.reservation;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.application.utils.HomAppConfigUtil;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;

public class ReservationBillListPlugin
extends HRDataBaseList
implements TabSelectListener {
    private static final Log LOGGER = LogFactory.getLog(ReservationBillListPlugin.class);
    private static final String SPACE_VALUE = " ";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "all": {
                this.loadCheckinList("hom_allreservation", "alllist", null, null);
                break;
            }
            case "waitreservation": {
                this.loadCheckinList("hom_waitreservation", "waitreservationlist", PreEnrollStatusEnum.WAIT_RESERVATION.getValue(), null);
                break;
            }
            case "hasreservation": {
                this.loadCheckinList("hom_hasreservation", "hasreservationlist", PreEnrollStatusEnum.HAS_RESERVATION.getValue(), null);
                break;
            }
            case "breakup": {
                this.loadCheckinList("hom_breakupreservation", "breakuplist", null, OnbrdStatusEnum.BREAK_UP.toString());
                break;
            }
            case "waitconfirm": {
                this.loadCheckinList("hom_reservationhrconfirm", "waitconfirmlist", PreEnrollStatusEnum.WAIT_CONFIRM_RESERVATION.getValue(), null);
                break;
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.tabInit();
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab(((Control)tab.getItems().get(1)).getKey());
    }

    private void loadCheckinList(String sourceFormId, String tabLabelName, String preStatus, String enrollStatus) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(sourceFormId);
        listShowParameter.getOpenStyle().setTargetKey(tabLabelName);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.setCustomParam("preenrollstatus", (Object)preStatus);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        if (HRStringUtils.isNotEmpty((String)enrollStatus)) {
            QFilter enrollStatusFilter = new QFilter("enrollstatus", "=", (Object)enrollStatus);
            QFilter preStatusFilter = new QFilter("preenrollstatus", "!=", (Object)SPACE_VALUE);
            listFilterParameter.getQFilters().add(enrollStatusFilter);
            listFilterParameter.getQFilters().add(preStatusFilter);
        } else {
            QFilter preStatusFilter;
            if (HRStringUtils.isNotEmpty((String)preStatus)) {
                preStatusFilter = new QFilter("preenrollstatus", "=", (Object)preStatus);
                listFilterParameter.getQFilters().add(new QFilter("enrollstatus", "!=", (Object)OnbrdStatusEnum.BREAK_UP.toString()));
                if (PreEnrollStatusEnum.WAIT_RESERVATION.getValue().equals(preStatus)) {
                    preStatusFilter.and(new QFilter("enrollstatus", "!=", (Object)OnbrdStatusEnum.HAS_ONBRD.getValue()));
                }
            } else {
                preStatusFilter = new QFilter("preenrollstatus", "!=", (Object)SPACE_VALUE);
            }
            listFilterParameter.getQFilters().add(preStatusFilter);
        }
        listShowParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)listShowParameter);
        IFormView listView = this.getView().getView(listShowParameter.getPageId());
        if (null != listView) {
            this.getView().sendFormAction(listView);
        }
    }

    private void tabInit() {
        Long userId = RequestContext.get().getCurrUserId();
        Object obj = HomAppConfigUtil.getHomAppParam((String)"reservationconfirm");
        LOGGER.info("ReservationBillListPlugin_tabInit:{}", obj);
        boolean isOpen = obj != null && (Boolean)obj != false;
        QFilter qFilter = new QFilter("preins.handlers.fbasedataid", "=", (Object)userId);
        QFilter statusFilter = new QFilter("preenrollstatus", "=", (Object)PreEnrollStatusEnum.WAIT_CONFIRM_RESERVATION.getValue());
        QFilter[] filters = new QFilter[]{qFilter, statusFilter};
        int count = IOnbrdBillDomainService.getInstance().getCount(filters);
        LOGGER.info("ReservationBillListPlugin_tabInit_count:{}", (Object)count);
        if (!isOpen && count <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"waitconfirm"});
        }
    }
}

