/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.reservation;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.page.IShowEmbedPageService;
import kd.hr.hom.business.domain.service.common.IPreOpenFormCheckService;
import kd.hr.hom.business.domain.service.impl.reservation.ReservationService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.CheckinPanelBtnParamsEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.formplugin.common.CheckHelper;

public class ReservationBodyInfoPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(ReservationBodyInfoPlugin.class);
    private static final String SELECT_PORP = "enrollstatus,preenrollstatus";
    private static final String RESERVATION_CONFIRM = "reservation_confirm";
    private static final String RESERVATION_CANCEL = "reservation_cancel";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        IPreOpenFormCheckService.getInstance().isHandlerCheck(e);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.reloadStatus();
        this.initButton();
        String tipMessage = (String)this.getView().getFormShowParameter().getCustomParam("tipmessage");
        if (StringUtils.isNotBlank((CharSequence)tipMessage) && this.getView().getPageCache().get("tipmessage") == null) {
            this.getView().getPageCache().put("tipmessage", tipMessage);
            this.getView().showTipNotification(tipMessage);
        }
    }

    private void reloadStatus() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        boolean isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        if (isEnroll) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_reservationinfomodify"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_reservationinfoclose", "btn_reservationinfosave"});
    }

    private void initButton() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        DynamicObject onbrd = IOnbrdBillDomainService.getInstance().findOnbrdBillById(SELECT_PORP, (Object)onbrdId);
        String preenrollStatus = onbrd.getString("preenrollstatus");
        if (!HRStringUtils.equals((String)PreEnrollStatusEnum.WAIT_CONFIRM_RESERVATION.getValue(), (String)preenrollStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_confirm", "btn_cancel"});
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        CheckHelper.showPersonHeadView(onbrdId, this.getView());
        this.showCheckinBodyInfo(onbrdId, OperationStatus.VIEW);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String lblKey = operate.getOperateKey();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        if (!IOnbrdCommonAppService.getInstance().tryRequireLockWithOnbrdCheck(onbrdId, this.getView(), "hom_reservationbody")) {
            return;
        }
        this.clickOnCheckinInfo(lblKey, onbrdId);
        if ("donothing_close".equals(lblKey)) {
            if (!this.checkDataChange()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u51fa\uff1f", (String)"OnbrdBodyInfoPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(lblKey, (IFormPlugin)this));
            } else {
                this.getView().close();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)RESERVATION_CONFIRM, (String)operateKey)) {
            this.confirm();
        }
        if (HRStringUtils.equals((String)RESERVATION_CANCEL, (String)operateKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u9884\u7ea6\u5c06\u6e05\u7a7a\u9884\u7ea6\u5165\u804c\u65e5\u671f\u548c\u5165\u804c\u5730\u70b9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d6\u6d88\u9884\u7ea6\u3002", (String)"ReservationWaitConfirmPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
        }
    }

    private void confirm() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        DynamicObject onbrd = IOnbrdBillDomainService.getInstance().findOnbrdBillById(SELECT_PORP, (Object)onbrdId);
        String preenrollStatus = onbrd.getString("preenrollstatus");
        String enrollStatus = onbrd.getString("enrollstatus");
        if (HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.toString(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.toString(), (String)enrollStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5165\u804c\u72b6\u6001\u4e3a\u201c\u5df2\u5165\u804c\u201d\u201c\u5df2\u7ec8\u6b62\u201d\u4e0d\u80fd\u8fdb\u884c\u201c\u786e\u8ba4\u9884\u7ea6\u201d\u64cd\u4f5c\u3002", (String)"ReservationBodyInfoPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!HRStringUtils.equals((String)PreEnrollStatusEnum.WAIT_CONFIRM_RESERVATION.getValue(), (String)preenrollStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7ea6\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\u3002", (String)"ReservationBodyInfoPlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(onbrdId);
        ReservationService.reservationConfirm(idList);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u9884\u7ea6\u64cd\u4f5c\u6210\u529f\u3002", (String)"ReservationBodyInfoPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
        this.getView().close();
    }

    protected IFormView getEmbedPageView(String pageNumber) {
        IFormView parentView = this.getView();
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String cardPageId = pageCache.get(pageNumber);
        return parentView.getView(cardPageId);
    }

    private boolean checkDataChange() {
        IFormView childView = this.getEmbedPageView(CheckinPanelBtnParamsEnum.RESERVATION_INFO.getPageIdName());
        IFormView childView1 = this.getEmbedPageView(CheckinPanelBtnParamsEnum.CHECKIN_INFO.getPageIdName());
        return this.childViewChange(childView) && this.childViewChange(childView1);
    }

    private boolean childViewChange(IFormView childView) {
        return childView == null || childView.getModel() == null || !childView.getModel().getDataChanged();
    }

    private void clickOnCheckinInfo(String lblKey, Long onbrdId) {
        switch (lblKey) {
            case "btn_reservationinfomodify": {
                this.updatePageStatusToEdit(CheckinPanelBtnParamsEnum.RESERVATION_INFO, onbrdId, OperationStatus.EDIT);
                break;
            }
            case "btn_reservationinfoclose": {
                this.checkCloseChange(CheckinPanelBtnParamsEnum.RESERVATION_INFO, onbrdId);
                break;
            }
            case "btn_reservationinfosave": {
                if (!this.invokeChildOperation(CheckinPanelBtnParamsEnum.RESERVATION_INFO, "save")) break;
                this.updatePageStatusToView(CheckinPanelBtnParamsEnum.RESERVATION_INFO, onbrdId, OperationStatus.VIEW);
                this.getView().updateView();
                this.reloadStatus();
                break;
            }
        }
    }

    private void updatePageStatusToEdit(CheckinPanelBtnParamsEnum checkinPanelBtnParamsEnum, Long onbrdId, OperationStatus status) {
        this.showEmbedPage(checkinPanelBtnParamsEnum.getPageNumber(), checkinPanelBtnParamsEnum.getTargetKey(), checkinPanelBtnParamsEnum.getPageIdName(), onbrdId, status);
        this.getView().setVisible(Boolean.FALSE, new String[]{checkinPanelBtnParamsEnum.getBtnModify()});
        this.getView().setVisible(Boolean.TRUE, new String[]{checkinPanelBtnParamsEnum.getBtnClose(), checkinPanelBtnParamsEnum.getBtnSave()});
    }

    private boolean invokeChildOperation(CheckinPanelBtnParamsEnum checkinPanelBtnParamsEnum, String operation) {
        String pageIdName;
        IFormView view = this.getView();
        IFormView childView = view.getView(pageIdName = this.getPageCache().get(checkinPanelBtnParamsEnum.getPageIdName()));
        OperationResult result = childView.invokeOperation(operation);
        if (result.isSuccess()) {
            return true;
        }
        if (result.getAllErrorOrValidateInfo().size() > 0) {
            view.showOperationResult(result);
        } else if (HRStringUtils.isNotEmpty((String)result.getMessage())) {
            String msg = result.getMessage();
            if (msg.startsWith("validateStaffUseResult:")) {
                view.showErrorNotification(msg.replaceFirst("validateStaffUseResult:", ""));
            } else {
                view.showTipNotification(msg);
            }
        } else if (HRStringUtils.isNotEmpty((String)result.getClearText())) {
            view.showTipNotification(result.getClearText());
        } else if (result.getInteractionContext() != null && HRStringUtils.isNotEmpty((String)result.getInteractionContext().getSimpleMessage())) {
            view.showTipNotification(result.getInteractionContext().getSimpleMessage());
        } else {
            String defaultTip = ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HomOnbrdDataBaseEdit_3", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            LOGGER.info("operationResult:{}, defaultTip:{}", (Object)HOMObjectUtils.toJSONString((Object)result), (Object)defaultTip);
            view.showTipNotification(defaultTip);
        }
        return false;
    }

    private void checkCloseChange(CheckinPanelBtnParamsEnum checkinPanelBtnParamsEnum, Long onbrdId) {
        String pageId = this.getPageCache().get(checkinPanelBtnParamsEnum.getPageIdName());
        IFormView childView = this.getView().getView(pageId);
        this.getPageCache().put("pageNumber", checkinPanelBtnParamsEnum.getPageNumber());
        this.getPageCache().put("onbrdid", onbrdId.toString());
        if (childView != null && childView.getModel() != null && childView.getModel().getDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(checkinPanelBtnParamsEnum.getPageNumber(), (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f%s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"CheckinBodyInfoPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), System.lineSeparator()), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            return;
        }
        this.updatePageStatusToView(checkinPanelBtnParamsEnum, onbrdId, OperationStatus.VIEW);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("onbrdid"));
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            switch (actionId) {
                case "donothing_close": {
                    this.getView().close();
                    this.reloadView();
                    break;
                }
                case "reservation_cancel": {
                    this.cancel();
                    break;
                }
            }
            String pageNumber = this.getPageCache().get("pageNumber");
            if (StringUtils.isBlank((CharSequence)pageNumber)) {
                return;
            }
            if (HRStringUtils.equals((String)actionId, (String)pageNumber)) {
                CheckinPanelBtnParamsEnum checkinPanelBtnParamsEnum = CheckinPanelBtnParamsEnum.getEnumByName((String)pageNumber);
                this.updatePageStatusToView(checkinPanelBtnParamsEnum, onbrdId, OperationStatus.VIEW);
            }
        }
    }

    private void cancel() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(onbrdId);
        ReservationService.reservationCancel(idList);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u9884\u7ea6\u64cd\u4f5c\u6210\u529f\u3002", (String)"ReservationBodyInfoPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
        this.getView().close();
    }

    private void reloadView() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
        this.getView().updateView();
        this.reloadStatus();
    }

    private void updatePageStatusToView(CheckinPanelBtnParamsEnum checkinPanelBtnParamsEnum, Long onbrdId, OperationStatus status) {
        this.showEmbedPage(checkinPanelBtnParamsEnum.getPageNumber(), checkinPanelBtnParamsEnum.getTargetKey(), null, onbrdId, status);
        this.getView().setVisible(Boolean.TRUE, new String[]{checkinPanelBtnParamsEnum.getBtnModify()});
        this.getView().setVisible(Boolean.FALSE, new String[]{checkinPanelBtnParamsEnum.getBtnClose(), checkinPanelBtnParamsEnum.getBtnSave()});
    }

    private void showCheckinBodyInfo(Long onbrdId, OperationStatus status) {
        this.showEmbedPage("hom_reservationinfo", "reservationinfopanel", null, onbrdId, status);
    }

    private void showEmbedPage(String pageNumber, String targetKey, String pageIdName, Long onbrdId, OperationStatus status) {
        IShowEmbedPageService.getInstance().showEmbedPage(pageNumber, targetKey, pageIdName, onbrdId, status, this.getView());
    }

    public void pageRelease(EventObject e) {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        IOnbrdCommonAppService.getInstance().releaseLockWithOnbrdCheck(onbrdId, "hom_reservationbody");
    }
}

