/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.worktable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.application.impl.onbrd.OnbrdWorkTableServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdWorkTableService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.impl.collect.CollectServiceImpl;
import kd.hr.hom.business.domain.service.impl.invite.OnbrdInviteDomainService;
import kd.hr.hom.business.domain.service.invite.IOnbrdInviteDomainService;
import kd.hr.hom.common.enums.CollectManageStatusEnum;
import kd.hr.hom.common.enums.ExceptionCauseEnum;
import kd.hr.hom.common.enums.LoginStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.SendStatusEnum;

public class WarningOnboardCarPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(WarningOnboardCarPlugin.class);
    private static final IOnbrdWorkTableService WORK_TABLE_SERVICE = new OnbrdWorkTableServiceImpl();
    private static final ICollectService COLLECT_SERVICE = new CollectServiceImpl();
    private static final IOnbrdInviteDomainService DOMAIN_SERVICE = new OnbrdInviteDomainService();
    private static final String EXCEPTION_TYPE1 = "1";
    private static final String EXCEPTION_TYPE2 = "2";
    private static final String LBLINTEN = "lblinten";
    private static final String LBLINTEN1 = "lblinten1";
    private static final String LBLINTEN2 = "lblinten2";
    private static final String LBLINTEN3 = "lblinten3";
    private static final String LOGIN_TIPS = "logintips";
    private static final String COMMIT_TIPS = "sendtips";
    private static final String BUTTONAP1 = "buttonap1";
    private static final String BUTTONAP = "buttonap";
    private static final String DONOTHING_NOLOGIN = "donothing_nologin";
    private static final String DONOTHING_NOCOMMIT = "donothing_nocommit";
    private static final String DONOTHING_EXPCOME = "donothing_expcome";
    private static final String DONOTHING_OUTTIME = "donothing_outtime";

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        LOGGER.info("==WarningOnboardCarPlugin==");
        if (!"vectorap".equals(e.getKey())) {
            return;
        }
        LOGGER.info("==WarningOnboardCarPlugin==");
        HRPageCache pageCache = new HRPageCache(this.getView().getParentView());
        this.pageCacheChange(pageCache);
    }

    public void pageCacheChange(HRPageCache pageCache) {
        List hrbuids = (List)pageCache.get("hrbuids", List.class);
        List adminorgids = (List)pageCache.get("adminorgids", List.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bizappid", this.getView().getFormShowParameter().getAppId());
        map.put("hrbuids", hrbuids);
        map.put("adminorgids", adminorgids);
        List<String> causeList = this.getExceptionCause(EXCEPTION_TYPE1);
        map.put("ExceptionCause", causeList);
        int checkinAbnormal = WORK_TABLE_SERVICE.getWarningConut(map, "5");
        this.upDateLabel(LBLINTEN2, String.valueOf(checkinAbnormal));
        causeList = this.getExceptionCause(EXCEPTION_TYPE2);
        map.put("ExceptionCause", causeList);
        int checkinOverdue = WORK_TABLE_SERVICE.getWarningConut(map, "6");
        this.upDateLabel(LBLINTEN3, String.valueOf(checkinOverdue));
        int loginNum = DOMAIN_SERVICE.workTableInviteCountNum(OnbrdStatusEnum.WAIT_ONBRD.getValue(), SendStatusEnum.HAS_SEND.getValue(), LoginStatusEnum.NO_LOGIN.getValue(), adminorgids, hrbuids);
        this.upDateButton(loginNum, BUTTONAP1);
        this.upDateLabel(LBLINTEN, String.valueOf(loginNum));
        this.getView().getPageCache().put("loginNum", String.valueOf(loginNum));
        int collectNum = COLLECT_SERVICE.workTableCollectCountNum(OnbrdStatusEnum.WAIT_ONBRD.getValue(), CollectManageStatusEnum.SUBMIT.getStatus(), adminorgids, hrbuids);
        this.upDateButton(collectNum, BUTTONAP);
        this.upDateLabel(LBLINTEN1, String.valueOf(collectNum));
        this.getView().getPageCache().put("commitNum", String.valueOf(collectNum));
    }

    private void upDateButton(int num, String name) {
        if (num < 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{name});
        }
    }

    private List<String> getExceptionCause(String type) {
        ArrayList<String> list = new ArrayList<String>();
        if (EXCEPTION_TYPE1.equals(type)) {
            list.add(ExceptionCauseEnum.GPS.getNumber());
            list.add(ExceptionCauseEnum.NO_REACHED.getNumber());
            list.add(ExceptionCauseEnum.NO_STARTED.getNumber());
        }
        if (EXCEPTION_TYPE2.equals(type)) {
            list.add(ExceptionCauseEnum.NO_CHECKIN.getNumber());
        }
        return list;
    }

    private void upDateLabel(String lable, String text) {
        Label label = (Label)this.getView().getControl(lable);
        label.setText(text);
        if (String.valueOf(0).equals(text)) {
            LabelAp labelAp = new LabelAp();
            labelAp.setForeColor("#666666");
            labelAp.setKey(lable);
            this.getView().updateControlMetadata(lable, labelAp.createControl());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String key;
        super.afterDoOperation(eventArgs);
        switch (key = eventArgs.getOperateKey()) {
            case "logintips": {
                this.loginSend();
                break;
            }
            case "sendtips": {
                this.commitTips();
                break;
            }
            case "donothing_nologin": {
                this.loadList("7", "hom_collaborationmanage");
                break;
            }
            case "donothing_nocommit": {
                this.loadList("8", "hom_collaborationmanage");
                break;
            }
            case "donothing_expcome": {
                this.loadList("5", "hom_collaborationmanage");
                break;
            }
            case "donothing_outtime": {
                this.loadList("6", "hom_collaborationmanage");
            }
        }
    }

    private void loadList(String type, String pageId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(pageId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("type", (Object)type);
        this.getView().showForm(showParameter);
    }

    private void loginSend() {
        String loginName = ResManager.loadKDString((String)"\u63d0\u9192\u5f85\u5165\u804c\u4eba\u5458\u767b\u5f55", (String)"WarningOnboardCarPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        this.showOnboardInfo("LOGINTIPSCALLBACK", loginName);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map resultMap;
        super.closedCallBack(closedCallBackEvent);
        HRPageCache pageCache = new HRPageCache(this.getView().getParentView());
        List hrbuids = (List)pageCache.get("hrbuids", List.class);
        List adminorgids = (List)pageCache.get("adminorgids", List.class);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"LOGINTIPSCALLBACK") && closedCallBackEvent.getReturnData() != null) {
            resultMap = (Map)closedCallBackEvent.getReturnData();
            this.loginSend(resultMap, hrbuids, adminorgids);
        }
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"SENDTIPSCALLBACK") && closedCallBackEvent.getReturnData() != null) {
            resultMap = (Map)closedCallBackEvent.getReturnData();
            this.collectSend(resultMap, hrbuids, adminorgids);
        }
    }

    private void loginSend(Map<String, String> resultMap, List<Long> hrbuids, List<Long> adminorgids) {
        Boolean isAll = this.getBooleanIsAll(resultMap);
        if (isAll == null) {
            return;
        }
        try {
            DOMAIN_SERVICE.workTableInviteSendNotice(OnbrdStatusEnum.WAIT_ONBRD.getValue(), SendStatusEnum.HAS_SEND.getValue(), LoginStatusEnum.NO_LOGIN.getValue(), adminorgids, hrbuids, isAll);
            String msg = ResManager.loadKDString((String)"\u63d0\u9192\u53d1\u9001\u6210\u529f", (String)"WarningOnboardCarPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
        }
        catch (Exception exception) {
            String msg = ResManager.loadKDString((String)"\u63d0\u9192\u53d1\u9001\u5931\u8d25", (String)"WarningOnboardCarPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg + ":" + exception.getMessage());
            LOGGER.error("collectSend_error_msg:", (Throwable)exception);
        }
    }

    private void collectSend(Map<String, String> resultMap, List<Long> hrbuids, List<Long> adminorgids) {
        Boolean isAll = this.getBooleanIsAll(resultMap);
        if (isAll == null) {
            return;
        }
        try {
            COLLECT_SERVICE.workTableSendNotice(OnbrdStatusEnum.WAIT_ONBRD.getValue(), CollectManageStatusEnum.SUBMIT.getStatus(), adminorgids, hrbuids, isAll);
            String msg = ResManager.loadKDString((String)"\u63d0\u9192\u53d1\u9001\u6210\u529f", (String)"WarningOnboardCarPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
        }
        catch (Exception exception) {
            String msg = ResManager.loadKDString((String)"\u63d0\u9192\u53d1\u9001\u5931\u8d25", (String)"WarningOnboardCarPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg + ":" + exception.getMessage());
            LOGGER.error("collectSend_error_msg:", (Throwable)exception);
        }
    }

    private Boolean getBooleanIsAll(Map<String, String> resultMap) {
        if (Objects.isNull(resultMap)) {
            return null;
        }
        Boolean isAll = Boolean.FALSE;
        if ("No".equals(resultMap.get("isAll"))) {
            isAll = Boolean.TRUE;
        }
        return isAll;
    }

    private void commitTips() {
        String commitName = ResManager.loadKDString((String)"\u63d0\u9192\u5f85\u5165\u804c\u4eba\u5458\u63d0\u4ea4", (String)"WarningOnboardCarPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        this.showOnboardInfo("SENDTIPSCALLBACK", commitName);
    }

    public void showOnboardInfo(String callBackKey, String name) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hom_wbtips");
        showParameter.setCustomParam("callbackkey", (Object)callBackKey);
        showParameter.setCustomParam("commitNum", (Object)this.getPageCache().get("commitNum"));
        showParameter.setCustomParam("loginNum", (Object)this.getPageCache().get("loginNum"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackKey));
        showParameter.setCaption(name);
        this.getView().showForm(showParameter);
    }
}

