/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.common.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.hr.hbp.common.util.HRCollUtil;

public class DataDiv<T> {
    private final T t;
    private final List<String> errMsgs;
    private final List<String> tipMsgs;
    private final Map<String, Object> context;

    public DataDiv(T t) {
        this.t = t;
        this.errMsgs = new ArrayList<String>(0);
        this.tipMsgs = new ArrayList<String>(0);
        this.context = new HashMap<String, Object>(0);
    }

    public void addErrMsg(String msg) {
        this.errMsgs.add(msg);
    }

    public void addTipMsg(String msg) {
        this.tipMsgs.add(msg);
    }

    public boolean hasErrMsg() {
        return HRCollUtil.isNotEmpty(this.errMsgs);
    }

    public boolean hasTipMsg() {
        return HRCollUtil.isNotEmpty(this.tipMsgs);
    }

    public T getEntity() {
        return this.t;
    }

    public List<String> getErrMsgs() {
        return this.errMsgs;
    }

    public List<String> getTipMsgs() {
        return this.tipMsgs;
    }

    public String getFirstErrMsg() {
        if (this.hasErrMsg()) {
            return this.errMsgs.get(0);
        }
        return "";
    }

    public String getFirstTipMsg() {
        if (this.hasTipMsg()) {
            return this.tipMsgs.get(0);
        }
        return "";
    }

    public void addContextParam(String key, Object value) {
        this.context.put(key, value);
    }

    public Object getContextParam(String key) {
        return this.context.get(key);
    }

    public void clearErrMsg() {
        this.errMsgs.clear();
    }

    public void clearTipMsg() {
        this.tipMsgs.clear();
    }
}

