/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.common.entity;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hom.common.entity.ErrorMsgSyncProcessor;

public class HomCommonWrapper<T, P> {
    private DynamicObject bizData;
    private Queue<String> warningMsgs;
    private Queue<String> errorMsgs;
    private int rowIndex;
    private T originWrapper;
    P wrapperMsgHelper;
    private ErrorMsgSyncProcessor<P, T> errorMsgSyncProcessor;
    private boolean isSyncErrorMsg;
    private int errorMsgNum;

    public HomCommonWrapper(DynamicObject bizData) {
        this.bizData = bizData;
    }

    public HomCommonWrapper(DynamicObject bizData, T originWrapper, int rowIndex) {
        this.bizData = bizData;
        this.originWrapper = originWrapper;
        this.rowIndex = rowIndex;
    }

    public HomCommonWrapper(DynamicObject bizData, T originWrapper, int rowIndex, P wrapperMsgHelper, ErrorMsgSyncProcessor<P, T> errorMsgSyncProcessor) {
        this.bizData = bizData;
        this.originWrapper = originWrapper;
        this.rowIndex = rowIndex;
        this.wrapperMsgHelper = wrapperMsgHelper;
        this.errorMsgSyncProcessor = errorMsgSyncProcessor;
        if (wrapperMsgHelper != null && errorMsgSyncProcessor != null) {
            this.isSyncErrorMsg = true;
        }
    }

    public DynamicObject getBizData() {
        return this.bizData;
    }

    public void setBizData(DynamicObject bizData) {
        this.bizData = bizData;
    }

    public Queue<String> getWarningMsgs() {
        return this.warningMsgs;
    }

    public void setWarningMsgs(Queue<String> warningMsgs) {
        this.warningMsgs = warningMsgs;
    }

    public Queue<String> getErrorMsgs() {
        return this.errorMsgs;
    }

    public void setErrorMsgs(Queue<String> errorMsgs) {
        this.errorMsgs = errorMsgs;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public T getOriginWrapper() {
        return this.originWrapper;
    }

    public void setOriginWrapper(T originWrapper) {
        this.originWrapper = originWrapper;
    }

    public P getWrapperMsgHelper() {
        return this.wrapperMsgHelper;
    }

    public void setWrapperMsgHelper(P wrapperMsgHelper) {
        this.wrapperMsgHelper = wrapperMsgHelper;
    }

    public ErrorMsgSyncProcessor<P, T> getErrorMsgSyncProcessor() {
        return this.errorMsgSyncProcessor;
    }

    public void setErrorMsgSyncProcessor(ErrorMsgSyncProcessor<P, T> errorMsgSyncProcessor) {
        this.errorMsgSyncProcessor = errorMsgSyncProcessor;
    }

    public boolean isSyncErrorMsg() {
        return this.isSyncErrorMsg;
    }

    public void setSyncErrorMsg(boolean syncErrorMsg) {
        this.isSyncErrorMsg = syncErrorMsg;
    }

    public int getErrorMsgNum() {
        return this.errorMsgNum;
    }

    public void setErrorMsgNum(int errorMsgNum) {
        this.errorMsgNum = errorMsgNum;
    }

    public void addWarningMsg(String warningMsg) {
        if (this.warningMsgs == null) {
            this.warningMsgs = new ArrayBlockingQueue<String>(4);
        }
        this.warningMsgs.add(warningMsg);
    }

    public void addErrMsg(String errorMsg) {
        ++this.errorMsgNum;
        if (this.errorMsgs == null) {
            this.errorMsgs = new ArrayBlockingQueue<String>(30);
        }
        if (this.isSyncErrorMsg) {
            this.errorMsgSyncProcessor.process(this.wrapperMsgHelper, this.originWrapper, errorMsg);
        } else {
            this.errorMsgs.add(errorMsg);
        }
    }
}

