/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.common.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.HZPinyin;
import kd.bos.orm.util.CollectionUtils;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;

public class PinyinUtil {
    public static String converterToSpell(String chines) throws Exception {
        StringBuilder pinyinName = new StringBuilder();
        char[] nameChar = chines.toCharArray();
        for (int i = 0; i < nameChar.length; ++i) {
            if (nameChar[i] > '\u0080') {
                String pinyin = HZPinyin.getFullSpell((String)String.valueOf(nameChar[i]), (String)"");
                pinyinName.append(pinyin);
                if (i != nameChar.length - 1) {
                    pinyinName.append(',');
                }
                pinyinName.append(' ');
                continue;
            }
            pinyinName.append(nameChar[i]);
        }
        List<Map<String, Integer>> mapList = PinyinUtil.discountTheChinese(pinyinName.toString());
        return PinyinUtil.checkPinyinName(mapList);
    }

    private static List<Map<String, Integer>> discountTheChinese(String theStr) {
        String[] firsts;
        ArrayList<Map<String, Integer>> mapList = new ArrayList<Map<String, Integer>>(8);
        Hashtable<String, Integer> onlyOne = null;
        String[] var4 = firsts = theStr.split(" ");
        int var5 = firsts.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String[] china;
            String str = var4[var6];
            onlyOne = new Hashtable<String, Integer>();
            String[] var9 = china = str.split(",");
            int var10 = china.length;
            for (int var11 = 0; var11 < var10; ++var11) {
                String s = var9[var11];
                Integer count = (Integer)onlyOne.get(s);
                if (count == null) {
                    onlyOne.put(s, 1);
                    continue;
                }
                onlyOne.remove(s);
                count = count + 1;
                onlyOne.put(s, count);
            }
            mapList.add(onlyOne);
        }
        return mapList;
    }

    private static void addAllSpell(StringBuilder pinyinName, char[] nameChar, HanyuPinyinOutputFormat defaultFormat, int i) throws UnsupportedEncodingException {
        String pinyin = HZPinyin.getFullSpell((String)String.valueOf(nameChar[i]), (String)"");
        pinyinName.append(pinyin);
        if (i != nameChar.length - 1) {
            pinyinName.append(',');
        }
    }

    private static String checkPinyinName(List<Map<String, Integer>> mapList) {
        StringBuilder bul = new StringBuilder();
        for (int i = 0; i < mapList.size(); ++i) {
            Map<String, Integer> map = mapList.get(i);
            if (CollectionUtils.isEmpty(map)) continue;
            Map.Entry<String, Integer> entry = map.entrySet().iterator().next();
            bul.append(entry.getKey()).append(' ');
        }
        String pinyinName = bul.toString();
        String engNameStr = pinyinName.trim().replaceAll("\\s+", " ");
        String[] engNames = engNameStr.split(" ");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < engNames.length; ++i) {
            String name = engNames[i];
            if (i == 0 || i == 1) {
                String first = name.substring(0, 1).toUpperCase(Locale.ROOT);
                stringBuilder.append(first);
                if (StringUtils.isNotBlank((CharSequence)name.substring(1))) {
                    String after = name.substring(1).toLowerCase(Locale.ROOT);
                    stringBuilder.append(after);
                }
                if (i != 0) continue;
                stringBuilder.append(' ');
                continue;
            }
            stringBuilder.append(name);
        }
        return stringBuilder.toString();
    }
}

