/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.common.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.enums.PreOnBrdBillStatusEnum;
import org.apache.commons.lang3.ObjectUtils;

public class PreOnBrdCommonUtil {
    private static final String TAG_AUDIT_VIEW = "SCENE";
    private static final Map<String, String> HOM_TO_HRPI_MAP = new ImmutableMap.Builder().put((Object)"phone", (Object)"phone").put((Object)"employeeno", (Object)"number").put((Object)"peremail", (Object)"email").put((Object)"certificatenumber", (Object)"cardno").put((Object)"certificatetype.id", (Object)"cardtype").put((Object)"name", (Object)"name").build();

    public static void setLblText(IFormView view, String key, String text) {
        Label label = (Label)view.getControl(key);
        label.setText(text);
    }

    public static void showPage(IFormView view, String formId, long id, String caption, Map<String, Object> customs) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId((Object)id);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setPageId(view.getPageId() + "_" + "hom" + "_" + id);
        if (!ObjectUtils.isEmpty(customs)) {
            showParameter.setCustomParams(customs);
        }
        if (!HRStringUtils.isEmpty((String)caption)) {
            showParameter.setCaption(caption);
        }
        view.showForm((FormShowParameter)showParameter);
    }

    public static boolean isAuditView(IFormView formView) {
        Object scene = formView.getFormShowParameter().getCustomParam(TAG_AUDIT_VIEW);
        return scene != null;
    }

    public static String getCnNameByFieldName(String fieldName) {
        switch (fieldName) {
            case "phone": {
                return ResManager.loadKDString((String)"\u8054\u7cfb\u7535\u8bdd", (String)"PreOnBrdCommonUtil_0", (String)"hr-hom-common", (Object[])new Object[0]);
            }
            case "number": {
                return ResManager.loadKDString((String)"\u5de5\u53f7", (String)"PreOnBrdCommonUtil_12", (String)"hr-hom-common", (Object[])new Object[0]);
            }
            case "email": {
                return ResManager.loadKDString((String)"\u7535\u5b50\u90ae\u7bb1", (String)"PreOnBrdCommonUtil_1", (String)"hr-hom-common", (Object[])new Object[0]);
            }
            case "cardno": {
                return ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801", (String)"PreOnBrdCommonUtil_2", (String)"hr-hom-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static String getCnNameByFieldNameForImport(String fieldName) {
        switch (fieldName) {
            case "locationcode": {
                return ResManager.loadKDString((String)"*\u533a\u4f4d\u7801", (String)"PreOnBrdCommonUtil_8", (String)"hr-hom-common", (Object[])new Object[0]);
            }
            case "phonecode": {
                return ResManager.loadKDString((String)"*\u8054\u7cfb\u7535\u8bdd", (String)"PreOnBrdCommonUtil_9", (String)"hr-hom-common", (Object[])new Object[0]);
            }
            case "ajob": {
                return ResManager.loadKDString((String)"*\u804c\u4f4d", (String)"PreOnBrdCommonUtil_10", (String)"hr-hom-common", (Object[])new Object[0]);
            }
            case "plaborrelstatus": {
                return ResManager.loadKDString((String)"\u8bd5\u7528\u4e2d", (String)"PreOnBrdCommonUtil_11", (String)"hr-hom-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static Set<DynamicObject> getDistinctDynamicObject(Set<DynamicObject> dynamicObjects) {
        HashSet<DynamicObject> result = new HashSet<DynamicObject>();
        HashMap map = new HashMap(16);
        dynamicObjects.forEach(dynamicObject -> {
            if (!map.containsKey(dynamicObject.getString("billno"))) {
                result.add((DynamicObject)dynamicObject);
            }
            map.put(dynamicObject.getString("billno"), dynamicObject.getString("billno"));
        });
        return result;
    }

    public static String getRepeatErrorMessage(Set<DynamicObject> repeatBillDys, List<DynamicObject> onBrdList, Map<String, String> checkResultMap) {
        StringBuilder errorMessage = new StringBuilder();
        for (int i = 0; i < onBrdList.size(); ++i) {
            String validPersonResult;
            DynamicObject onBrdBill = onBrdList.get(i);
            String cerNo = onBrdBill.getString("certificatenumber");
            DynamicObject cerType = onBrdBill.getDynamicObject("certificatetype");
            String phone = onBrdBill.getString("phone");
            String permail = onBrdBill.getString("peremail");
            AtomicInteger bool = new AtomicInteger(0);
            StringBuffer errorMessageFirst = new StringBuffer();
            repeatBillDys.forEach(dynamicObject -> {
                boolean permailBool;
                String cerNo1 = dynamicObject.getString("certificatenumber");
                DynamicObject cerType1 = dynamicObject.getDynamicObject("certificatetype");
                String phone1 = dynamicObject.getString("phone");
                String permail1 = dynamicObject.getString("peremail");
                StringBuilder errorMessageSec = new StringBuilder();
                boolean cerBool = cerNo1.equals(cerNo) && cerType1.equals(cerType);
                boolean phoneBool = phone1.equals(phone);
                boolean bl = permailBool = HRStringUtils.isNotEmpty((String)permail) && permail1.equals(permail);
                if (cerBool || phoneBool || permailBool) {
                    bool.set(1);
                    String billNo = dynamicObject.getString("billno");
                    if (HRStringUtils.isEmpty((String)billNo)) {
                        return;
                    }
                    errorMessageSec.append(PreOnBrdCommonUtil.getMergeAttrName(cerBool, phoneBool, permailBool));
                    errorMessageFirst.append(String.format(ResManager.loadKDString((String)"%1$s\u4e0e\u5728\u9014\u5165\u804c\u5355\"%2$s\"\u7684\u5019\u9009\u4eba\u91cd\u590d\u3001", (String)"PreOnBrdCommonUtil_4", (String)"hr-hom-common", (Object[])new Object[0]), errorMessageSec, billNo));
                }
            });
            if (ObjectUtils.isNotEmpty(checkResultMap) && HRStringUtils.isNotEmpty((String)(validPersonResult = checkResultMap.get(String.valueOf(onBrdBill.getLong("id")))))) {
                bool.set(1);
                errorMessageFirst.append(validPersonResult);
            }
            if (bool.get() <= 0) continue;
            String err = errorMessageFirst.toString();
            if (err.endsWith("\u3001")) {
                errorMessageFirst.replace(errorMessageFirst.length() - 1, errorMessageFirst.length(), "");
            }
            errorMessage.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c:%2$s\uff0c\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u3002", (String)"PreOnBrdCommonUtil_3", (String)"hr-hom-common", (Object[])new Object[0]), i + 1, errorMessageFirst)).append(ResManager.loadKDString((String)"\n", (String)"", (String)"hr-hom-common", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)errorMessage)) {
            return "";
        }
        return errorMessage.toString();
    }

    public static String getMergeAttrName(boolean cerBool, boolean phoneBool, boolean permailBool) {
        StringBuilder fieldBuilder = new StringBuilder();
        if (!(cerBool || phoneBool || permailBool)) {
            return "";
        }
        fieldBuilder.append(ResManager.loadKDString((String)"\"", (String)"", (String)"hr-hom-common", (Object[])new Object[0]));
        if (cerBool) {
            fieldBuilder.append(PreOnBrdCommonUtil.getCnNameByFieldNameWithChar("certificatenumber")).append(ResManager.loadKDString((String)"\u3001", (String)"", (String)"hr-hom-common", (Object[])new Object[0]));
        }
        if (phoneBool) {
            fieldBuilder.append(PreOnBrdCommonUtil.getCnNameByFieldNameWithChar("phone")).append(ResManager.loadKDString((String)"\u3001", (String)"", (String)"hr-hom-common", (Object[])new Object[0]));
        }
        if (permailBool) {
            fieldBuilder.append(PreOnBrdCommonUtil.getCnNameByFieldNameWithChar("peremail")).append(ResManager.loadKDString((String)"\u3001", (String)"", (String)"hr-hom-common", (Object[])new Object[0]));
        }
        if (fieldBuilder.length() > 0) {
            fieldBuilder.deleteCharAt(fieldBuilder.length() - 1);
        }
        fieldBuilder.append(ResManager.loadKDString((String)"\"", (String)"", (String)"hr-hom-common", (Object[])new Object[0]));
        return fieldBuilder.toString();
    }

    public static String getCnNameByFieldNameWithChar(String fieldName) {
        switch (fieldName) {
            case "phone": {
                return ResManager.loadKDString((String)"\u8054\u7cfb\u7535\u8bdd", (String)"PreOnBrdCommonUtil_0", (String)"hr-hom-common", (Object[])new Object[0]);
            }
            case "peremail": {
                return ResManager.loadKDString((String)"\u7535\u5b50\u90ae\u7bb1", (String)"PreOnBrdCommonUtil_1", (String)"hr-hom-common", (Object[])new Object[0]);
            }
            case "certificatenumber": {
                return ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801", (String)"PreOnBrdCommonUtil_2", (String)"hr-hom-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static LabelAp setAuditStatusLabelWithColorful(String labelName, String labelValue) {
        String borderColor;
        LabelAp statusLabel = new LabelAp();
        statusLabel.setKey(labelName);
        statusLabel.setName(new LocaleString(PreOnBrdBillStatusEnum.getName(labelValue)));
        Style style = new Style();
        Border border = new Border();
        style.setBorder(border);
        switch (labelValue) {
            case "F": 
            case "A": {
                statusLabel.setForeColor("#666666");
                statusLabel.setBackColor("#F5F5F5");
                borderColor = " #CCCCCC";
                break;
            }
            case "D": 
            case "B": {
                statusLabel.setForeColor("#276FF5");
                statusLabel.setBackColor("#F2F9FF");
                borderColor = "#85B8FF";
                break;
            }
            case "C": {
                statusLabel.setForeColor("#1BA854");
                statusLabel.setBackColor("#F2FFF5");
                borderColor = "#6DD18E";
                break;
            }
            case "E": {
                statusLabel.setForeColor("#FB2323");
                statusLabel.setBackColor("#FFF2F4");
                borderColor = "#FF8088";
                break;
            }
            case "G": {
                statusLabel.setForeColor("#FF991C");
                statusLabel.setBackColor("#FFFBF2");
                borderColor = "#FFCB78";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + labelValue);
            }
        }
        String borderType = "1px_solid_" + borderColor;
        border.setTop(borderType);
        border.setBottom(borderType);
        border.setLeft(borderType);
        border.setRight(borderType);
        style.setBorder(border);
        Padding padding = new Padding();
        padding.setTop("2px");
        padding.setBottom("2px");
        padding.setLeft("8px");
        padding.setRight("8px");
        style.setPadding(padding);
        statusLabel.setStyle(style);
        return statusLabel;
    }

    public static List<Map<String, Object>> genOnBrdCheckList(List<DynamicObject> onbrdBills, Set<String> fieldNameSet) {
        ArrayList<Map<String, Object>> onBrdCheckList = new ArrayList<Map<String, Object>>(1);
        for (DynamicObject onbrdBill : onbrdBills) {
            HashMap<String, Object> tmpMap = new HashMap<String, Object>(16);
            for (String fieldName : fieldNameSet) {
                String keyName;
                if (HRStringUtils.isEmpty((String)fieldName) || HRStringUtils.isEmpty((String)(keyName = HOM_TO_HRPI_MAP.get(fieldName)))) continue;
                if (!HRStringUtils.equals((String)"certificatenumber", (String)fieldName)) {
                    tmpMap.put(keyName, onbrdBill.getString(fieldName));
                    continue;
                }
                String certificateNumber = onbrdBill.getString("certificatenumber");
                tmpMap.put(keyName, HRStringUtils.isEmpty((String)certificateNumber) ? "" : certificateNumber);
                tmpMap.put(HOM_TO_HRPI_MAP.get("certificatetype.id"), onbrdBill.get("certificatetype") == null ? 0L : onbrdBill.getLong("certificatetype.id"));
                tmpMap.put("prepkid", String.valueOf(onbrdBill.getLong("id")));
            }
            onBrdCheckList.add(tmpMap);
        }
        return onBrdCheckList;
    }

    public static StringBuilder getPersonRepeatMsg(StringBuilder msgBuild, List<Map<String, String>> check) {
        Map<String, String> checkMap = check.get(0);
        String repeatnumber = checkMap.get("repeatnumber");
        String repeatname = checkMap.get("repeatname");
        if (check.size() > 1) {
            StringBuilder repeatKeyStringBuilder = new StringBuilder().append("\"");
            for (int i = 0; i < check.size(); ++i) {
                Map<String, String> stringMap = check.get(i);
                String repeatKeyFeild = stringMap.get("repeatkey");
                String cnNameByFieldName = PreOnBrdCommonUtil.getCnNameByFieldName(repeatKeyFeild);
                repeatKeyStringBuilder.append(cnNameByFieldName);
                if (i >= check.size() - 1) continue;
                repeatKeyStringBuilder.append(ResManager.loadKDString((String)"\u3001", (String)"", (String)"hr-hom-common", (Object[])new Object[0]));
            }
            String repeatkey = repeatKeyStringBuilder.append(ResManager.loadKDString((String)"\"", (String)"", (String)"hr-hom-common", (Object[])new Object[0])).toString();
            msgBuild.append(repeatkey);
        } else {
            String repeatkey = checkMap.get("repeatkey");
            String cnNameByFieldName = PreOnBrdCommonUtil.getCnNameByFieldName(repeatkey);
            msgBuild.append(ResManager.loadKDString((String)"\"", (String)"", (String)"hr-hom-common", (Object[])new Object[0])).append(cnNameByFieldName).append(ResManager.loadKDString((String)"\"", (String)"", (String)"hr-hom-common", (Object[])new Object[0]));
        }
        msgBuild.append(String.format(ResManager.loadKDString((String)"\u4e0e\u5728\u804c\u4eba\u5458\"%1$s%2$s\"\u91cd\u590d\u3001", (String)"PreOnBrdCommonUtil_15", (String)"hr-hom-common", (Object[])new Object[0]), repeatname, repeatnumber));
        return msgBuild;
    }

    public static String getMustInputErrorMessage(List<DynamicObject> onBrdList) {
        StringBuilder errorMessage = new StringBuilder();
        AtomicInteger bool = new AtomicInteger(0);
        for (int i = 0; i < onBrdList.size(); ++i) {
            DynamicObject entry = onBrdList.get(i);
            DynamicObject plaborrelStatus = entry.getDynamicObject("laborrelstatus");
            if (ObjectUtils.isEmpty((Object)plaborrelStatus)) {
                return "";
            }
            Long labrelstatusclsId = plaborrelStatus.getLong("labrelstatuscls.id");
            String labrelstatusName = plaborrelStatus.getString("name");
            StringBuilder errMsg = new StringBuilder();
            if (!BaseDataIdConstants.HBSS_LABRELSTATUSCLS_1010.equals(labrelstatusclsId)) continue;
            Boolean isProbationBool = entry.getBoolean("isprobation");
            Integer probationtime = entry.getInt("probationtime");
            String perprobationtime = entry.getString("perprobationtime");
            if (!ObjectUtils.isEmpty((Object)isProbationBool) && !ObjectUtils.isEmpty((Object)probationtime) && probationtime > 0 && !ObjectUtils.isEmpty((Object)perprobationtime)) continue;
            String errMsgForProbation = PreOnBrdCommonUtil.getLineMustInputErrMsgForProbation(labrelstatusName);
            errMsg.append(errMsgForProbation);
            if (ObjectUtils.isNotEmpty((Object)errMsg)) {
                bool.set(1);
            }
            if (bool.get() <= 0) continue;
            String err = errMsg.toString();
            errorMessage.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c:%2$s", (String)"PreOnBrdCommonUtil_14", (String)"hr-hom-common", (Object[])new Object[0]), i + 1, err)).append(ResManager.loadKDString((String)"\n", (String)"", (String)"hr-hom-common", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)errorMessage)) {
            return "";
        }
        return errorMessage.toString();
    }

    public static String getLineMustInputErrMsgForProbation(String labrelstatusclsName) {
        return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4eba\u5458\u7684\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u4e3a%s\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u8bd5\u7528\u671f\u4fe1\u606f\u3002", (String)"PreOnBrdCommonUtil_13", (String)"hr-hom-common", (Object[])new Object[0]), labrelstatusclsName);
    }
}

