/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.common.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.model.ruleengine.SceneResult;

public class SceneResultUtil {
    private static final Log logger = LogFactory.getLog(SceneResultUtil.class);

    public static Map<String, Object> getRespResult(SceneResult sceneResult) {
        List<Map<String, Object>> list = SceneResultUtil.getRespResultList(sceneResult);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public static List<Map<String, Object>> getRespResultList(SceneResult sceneResult) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (!"success".equals(sceneResult.getResponseDesc())) {
            logger.error(MessageFormat.format("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u5931\u8d25,{0}", sceneResult.getErrorMsg()));
            return list;
        }
        List policyResults = sceneResult.getPolicyResults();
        if (CollectionUtils.isEmpty((Collection)policyResults)) {
            logger.error("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u5931\u8d25,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            return list;
        }
        policyResults.stream().forEach(policyResult -> {
            if (!CollectionUtils.isEmpty((Collection)policyResult.getRuleResults())) {
                policyResult.getRuleResults().stream().forEach(ruleResult -> list.add(ruleResult.getMatchResults()));
            }
            if (!CollectionUtils.isEmpty((Map)policyResult.getDefaultResults())) {
                list.add(policyResult.getDefaultResults());
            }
        });
        return list;
    }
}

