/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.botp;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class OnBrdInfoConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log LOGGER = LogFactory.getLog(OnBrdInfoConvertPlugin.class);
    private static final String HOM_ONBRDINFO_KEY = "hom_onbrdinfo";
    private static final String HCDM_SINGLECANDSETSALAPPL_KEY = "hcdm_singlecandsetsalappl";
    private static final String CAND_SET_SAL_PERSON_ENTRYKEY = "candsetsalperson";
    private static final String PERSON_SET_SALARY_RECORD_ENTRYKEY = "persetsalrec";
    private static final String TRANS_DATE = "transdate";
    private static final String DEPARTMENTTYPE = "departmenttype";
    private static final HRBaseServiceHelper CANDSETSALACT_HELPER = new HRBaseServiceHelper("hcdm_candsetsalact");

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        LOGGER.info("OnBrdInfoConvertPlugin afterFieldMapping begin");
    }

    public void afterConvert(AfterConvertEventArgs e) {
        LOGGER.info("OnBrdInfoConvertPlugin afterConvert begin");
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(HCDM_SINGLECANDSETSALAPPL_KEY);
        this.setActId(billDataEntitys);
        Map<Long, DynamicObject> originDynamicObjectMap = Arrays.stream(billDataEntitys).collect(Collectors.toMap(dy -> dy.getDataEntity().getLong("id"), ExtendedDataEntity::getDataEntity, (o1, o2) -> o2));
        try {
            Map dynamicObjectMap = (Map)HRMServiceHelper.invokeBizService((String)"swc", (String)"hcdm", (String)"ICandidateSalaryService", (String)"generateFullCandSetSalAppl", (Object[])new Object[]{originDynamicObjectMap});
            for (ExtendedDataEntity billDataEntity : billDataEntitys) {
                long id = billDataEntity.getDataEntity().getLong("id");
                billDataEntity.setDataEntity((DynamicObject)dynamicObjectMap.get(id));
            }
        }
        catch (Exception exception) {
            LOGGER.error("OnBrdInfoConvertPlugin afterConvert throw exception is: ", (Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
    }

    private void setActId(ExtendedDataEntity[] billDataEntitys) {
        String onBrdInfoIdToActIdMapStr = this.getOption().getVariableValue("onBrdInfoIdToActIdMap", "");
        if (!Strings.isNullOrEmpty((String)onBrdInfoIdToActIdMapStr)) {
            Map onBrdInfoIdToActIdMap = (Map)SerializationUtils.deSerializeFromBase64((String)onBrdInfoIdToActIdMapStr);
            Arrays.stream(billDataEntitys).forEach(billDataEntity -> {
                DynamicObject dataEntity = billDataEntity.getDataEntity();
                DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(CAND_SET_SAL_PERSON_ENTRYKEY);
                for (DynamicObject entryDy : dynamicObjectCollection) {
                    long onBrdInfoId = entryDy.getLong("onbrdinfo");
                    Long actId = (Long)onBrdInfoIdToActIdMap.get(onBrdInfoId);
                    DynamicObject emptyDy = CANDSETSALACT_HELPER.generateEmptyDynamicObject();
                    emptyDy.set("id", (Object)actId);
                    dataEntity.set("candsetsalact", (Object)emptyDy);
                }
            });
        }
    }
}

