/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.common;

import java.lang.reflect.Method;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hom.business.application.common.HRProxyService;
import kd.hr.hom.business.application.common.annotation.PerfLog;

public class PerfLogAop
implements HRProxyService {
    private static final Log LOGGER = LogFactory.getLog(PerfLogAop.class);
    private long startTime = 0L;

    @Override
    public void beforeExecute(Object proxy, Method method, Object[] args) {
        PerfLog annotation = method.getAnnotation(PerfLog.class);
        if (annotation == null) {
            return;
        }
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void afterExecute(Object proxy, Method method, Object[] args) {
        PerfLog annotation = method.getAnnotation(PerfLog.class);
        if (annotation == null) {
            return;
        }
        long executeTime = System.currentTimeMillis() - this.startTime;
        LOGGER.info("execute {} {}s", (Object)method.getName(), (Object)(executeTime / 1000L));
    }
}

