/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.common;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;
import kd.hr.hom.common.enums.EmployeeNoSchemeEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.DateUtils;

public class ReentryRuleService {
    private static Log LOGGER = LogFactory.getLog(ReentryRuleService.class);
    private static final String PERSON_2 = "Person2";
    private static final String PERSON_3 = "Person3";
    private static final String PERSON_1 = "Person1";
    private static final ReentryRuleService RULE_SERVICE = new ReentryRuleService();
    private static final String HRPI_EMPLOYEE = "hrpi_employee";
    private static final String HRPI_EMPNONENTREL = "hrpi_empnonentrel";
    private static final String HSPM_ERMANFILE = "hspm_ermanfile";
    private static final String HRPI_EMPJOBREL = "hrpi_empjobrel";
    private static final String HRPI_EMPENTREL = "hrpi_empentrel";
    private static final String HRPI_PERSON = "hrpi_person";
    private static final String HTM_QUITFILEINFO = "htm_quitfileinfo";
    private static final String HRPI_EMPLOYEE_SELECT = "person,mid";
    private static final String HRPI_PERSON_SELECT = "id,personindexid";
    private static final String HSPM_ERMANFILE_SELECT = "person,bsed,enddate,empgroup,affiliateadminorg,dependency,cmpemp,org,hbsscmpemp";
    private static final String HRPI_EMPJOBREL_SELECT = "jobgradescm,joblevelscm,jobseq,jobfamily,jobclass,jobscm,hrbu,position,job,jobgrade,joblevel,company,adminorg,enddate,person";
    private static final String HRPI_EMPENTREL_SELECT = "enterprise,laborreltype,laborrelstatus,laborsubcate,labrelstatusprd,firststartdate,servicelength,adjustlength,startdate,enddate,lastworkdate,sysenddate,person";
    private static final String HRPI_EMPNONENTREL_SELECT = "id,person";

    public static ReentryRuleService getInstance() {
        return RULE_SERVICE;
    }

    public Long getPersonId(Long empId) {
        QFilter qFilter = new QFilter("id", "=", (Object)empId);
        Object[] employees = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(HRPI_EMPLOYEE_SELECT, this.setQFilter(qFilter, true), HRPI_EMPLOYEE);
        if (ArrayUtils.isEmpty((Object[])employees)) {
            return null;
        }
        Object employee = employees[0];
        DynamicObject person = employee.getDynamicObject("person");
        return person.getLong("id");
    }

    public Map<Long, Long> batchGetPersonId(Set<Long> empIds) {
        QFilter qFilter = new QFilter("id", "in", empIds);
        Object[] employees = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(HRPI_EMPLOYEE_SELECT, this.setQFilter(qFilter, true), HRPI_EMPLOYEE);
        if (ArrayUtils.isEmpty((Object[])employees)) {
            return null;
        }
        return Arrays.stream(employees).collect(Collectors.toMap(emp -> emp.getLong("id"), emp -> emp.getLong("person.id"), (oldV, newV) -> newV));
    }

    public DynamicObject getCommonPersonObj(String entityName, String selectStr, QFilter qFilter, boolean business) {
        DynamicObject[] dynamicObjects = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(selectStr, this.setQFilter(qFilter, business), entityName);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        return dynamicObjects[0];
    }

    List<Long> getPersonIds(Long personId) {
        if (Objects.isNull(personId)) {
            return new ArrayList<Long>(0);
        }
        QFilter qFilter = new QFilter("id", "=", (Object)personId);
        Object[] persons = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(HRPI_PERSON_SELECT, this.setQFilter(qFilter, false), HRPI_PERSON);
        if (ArrayUtils.isEmpty((Object[])persons)) {
            return new ArrayList<Long>(0);
        }
        Object person = persons[0];
        long personIndexId = person.getLong("personindexid");
        QFilter personFilter = new QFilter("personindexid", "=", (Object)personIndexId);
        Object[] allPerson = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(HRPI_PERSON_SELECT, this.setQFilter(personFilter, false), HRPI_PERSON);
        if (ArrayUtils.isEmpty((Object[])allPerson)) {
            return new ArrayList<Long>(0);
        }
        return Arrays.stream(allPerson).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    private Map<Long, List<Long>> batchGetPersonIds(Map<Long, Long> personAndPersonindexidMap) {
        QFilter personFilter = new QFilter("personindexid", "in", personAndPersonindexidMap.values());
        Object[] allPerson = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(HRPI_PERSON_SELECT, this.setQFilter(personFilter, false), HRPI_PERSON);
        if (ArrayUtils.isEmpty((Object[])allPerson)) {
            return new HashMap<Long, List<Long>>(0);
        }
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(personAndPersonindexidMap.size());
        for (Object person : allPerson) {
            long personindexid = person.getLong("personindexid");
            List personIdList = resultMap.getOrDefault(personindexid, new ArrayList());
            personIdList.add(person.getLong("id"));
            resultMap.put(personindexid, personIdList);
        }
        return resultMap;
    }

    Tuple<Long, DynamicObject> getLastErmanfile(List<Long> personIds) {
        if (CollectionUtils.isEmpty(personIds)) {
            return new Tuple(null, null);
        }
        QFilter qFilter = new QFilter("person", "in", personIds);
        Object[] ermanfiles = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(HSPM_ERMANFILE_SELECT, this.setQFilter(qFilter, true), HSPM_ERMANFILE);
        if (ArrayUtils.isEmpty((Object[])ermanfiles)) {
            return new Tuple(null, null);
        }
        List ermanfileList = Arrays.stream(ermanfiles).sorted(Comparator.comparing(dy -> dy.getDate("bsed"), Comparator.reverseOrder())).collect(Collectors.toList());
        DynamicObject dynamicObject = (DynamicObject)ermanfileList.get(0);
        return new Tuple((Object)dynamicObject.getLong("person.id"), (Object)dynamicObject);
    }

    private Map<Long, DynamicObject> batchGetLastErmanfile(Map<Long, List<Long>> personIdsMap, Map<Long, Long> personindexidAndLatestPersonMap) {
        if (CollectionUtils.isEmpty(personIdsMap)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        List personIds = personIdsMap.entrySet().stream().map(entry -> (List)entry.getValue()).flatMap(Collection::stream).collect(Collectors.toList());
        QFilter qFilter = new QFilter("person", "in", personIds);
        Object[] ermanfiles = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(HSPM_ERMANFILE_SELECT, this.setQFilter(qFilter, true), HSPM_ERMANFILE);
        if (ArrayUtils.isEmpty((Object[])ermanfiles)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>();
        Map<Long, List<DynamicObject>> ermanfileMap = Arrays.stream(ermanfiles).collect(Collectors.groupingBy(ermanfile -> ermanfile.getLong("person.personindexid")));
        ermanfileMap.forEach((personindexid, ermanfileList) -> {
            List list = ermanfileList.stream().sorted(Comparator.comparing(dy -> dy.getDate("bsed"), Comparator.reverseOrder())).collect(Collectors.toList());
            DynamicObject lastestErmanfile = (DynamicObject)list.get(0);
            personindexidAndLatestPersonMap.put(lastestErmanfile.getLong("person.personindexid"), lastestErmanfile.getLong("person.id"));
            resultMap.put(lastestErmanfile.getLong("person.personindexid"), lastestErmanfile);
        });
        return resultMap;
    }

    public Map<Long, DynamicObject> getLastErmanfiles(List<Long> personIndexIds) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personIndexIds.size());
        if (CollectionUtils.isEmpty(personIndexIds)) {
            return resultMap;
        }
        QFilter qFilter = new QFilter("person.personindexid", "in", personIndexIds);
        Object[] ermanfiles = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(HSPM_ERMANFILE_SELECT, this.setQFilter(qFilter, true).and(new QFilter("filetype", "=", (Object)1050L)), HSPM_ERMANFILE);
        if (ArrayUtils.isEmpty((Object[])ermanfiles)) {
            return resultMap;
        }
        List ermanfileList = Arrays.stream(ermanfiles).sorted(Comparator.comparing(dy -> dy.getDate("bsed"), Comparator.reverseOrder())).collect(Collectors.toList());
        return ermanfileList.stream().collect(Collectors.toMap(data -> data.getLong("person.personindexid"), data -> data, (k1, k2) -> k1));
    }

    public DynamicObject getEmpjobrelByPersonId(Long personId) {
        return this.getDynamicObject(personId, HRPI_EMPJOBREL_SELECT, HRPI_EMPJOBREL);
    }

    private Map<Long, DynamicObject> batchGetEmpjobrelByPersonId(Set<Long> personIds) {
        return this.batchGetDynamicObject(personIds, HRPI_EMPJOBREL_SELECT, HRPI_EMPJOBREL);
    }

    public DynamicObject getEmpentrelByPersonId(Long personId) {
        return this.getDynamicObject(personId, HRPI_EMPENTREL_SELECT, HRPI_EMPENTREL);
    }

    public Map<Long, DynamicObject> batchGetEmpentrelByPersonId(Set<Long> personIds) {
        return this.batchGetDynamicObject(personIds, HRPI_EMPENTREL_SELECT, HRPI_EMPENTREL);
    }

    private DynamicObject getDynamicObject(Long personId, String selectStr, String entityName) {
        if (Objects.isNull(personId)) {
            return null;
        }
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        Object[] dynamicObjects = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(selectStr, this.setQFilter(qFilter, true), entityName);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return null;
        }
        List list = Arrays.stream(dynamicObjects).sorted(Comparator.comparing(dy -> dy.getDate("enddate"), Comparator.reverseOrder())).collect(Collectors.toList());
        return (DynamicObject)list.get(0);
    }

    private Map<Long, DynamicObject> batchGetDynamicObject(Set<Long> personIds, String selectStr, String entityName) {
        if (personIds.isEmpty()) {
            return new HashMap<Long, DynamicObject>(0);
        }
        QFilter qFilter = new QFilter("person", "in", personIds);
        Object[] dynamicObjects = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(selectStr, this.setQFilter(qFilter, true), entityName);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>();
        Map<Long, List<DynamicObject>> dyMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong("person.id")));
        dyMap.forEach((personId, list) -> {
            List orderList = list.stream().sorted(Comparator.comparing(dy -> dy.getDate("enddate"), Comparator.reverseOrder())).collect(Collectors.toList());
            resultMap.put((Long)personId, (DynamicObject)orderList.get(0));
        });
        return resultMap;
    }

    public int getEmpnonentrelNum(List<Long> personIds) {
        if (CollectionUtils.isEmpty(personIds)) {
            return -1;
        }
        QFilter qFilter = new QFilter("person", "in", personIds);
        Object[] dynamicObjects = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(HRPI_EMPNONENTREL_SELECT, this.setQFilter(qFilter, true), HRPI_EMPNONENTREL);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return -1;
        }
        return dynamicObjects.length;
    }

    private Map<Long, Integer> batchGetEmpnonentrelNum(Map<Long, List<Long>> personIdsMap) {
        List personIds = personIdsMap.entrySet().stream().map(entry -> (List)entry.getValue()).flatMap(Collection::stream).collect(Collectors.toList());
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        if (CollectionUtils.isEmpty(personIds)) {
            return resultMap;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(HRPI_EMPNONENTREL);
        QFilter qFilter = new QFilter("person", "in", personIds);
        DynamicObject[] dynamicObjects = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(HRPI_EMPNONENTREL_SELECT, this.setQFilter(qFilter, true), HRPI_EMPNONENTREL);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return resultMap;
        }
        Map<Long, List<DynamicObject>> collect = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong("person.personindexid")));
        collect.forEach((personindexid, list) -> {
            if (list.size() >= 1) {
                resultMap.put((Long)personindexid, list.size());
            }
        });
        return resultMap;
    }

    public Long getEmployeeIdByPersonId(Long personId) {
        DynamicObject employee = this.getDynamicObject(personId, "enddate", HRPI_EMPLOYEE);
        if (Objects.isNull(employee)) {
            return null;
        }
        return employee.getLong("id");
    }

    public Map<Long, Long> batchGetEmployeeIdByPersonId(Set<Long> personIds) {
        Map<Long, DynamicObject> employeeMap = this.batchGetDynamicObject(personIds, "enddate,person", HRPI_EMPLOYEE);
        if (employeeMap == null || employeeMap.isEmpty()) {
            return new HashMap<Long, Long>(0);
        }
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(employeeMap.size());
        employeeMap.forEach((personId, employee) -> resultMap.put((Long)personId, employee.getLong("id")));
        return resultMap;
    }

    public DynamicObject getQuitfileinfoByEmployeeId(Long employeeId) {
        QFilter qFilter = new QFilter("employee", "=", (Object)employeeId);
        Object[] dynamicObjects = HomCommonRepository.queryDynamicObjects(HTM_QUITFILEINFO, null, qFilter);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return null;
        }
        return dynamicObjects[0];
    }

    private Map<Long, DynamicObject> batchGetQuitfileinfoByEmployeeIds(Set<Long> employeeIds) {
        QFilter qFilter = new QFilter("employee", "in", employeeIds);
        Object[] dynamicObjects = HomCommonRepository.queryDynamicObjects(HTM_QUITFILEINFO, null, qFilter);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), Function.identity(), (oldV, newV) -> newV));
    }

    public DynamicObject getLastFile(DynamicObject onbrd) {
        DynamicObject personfield = onbrd.getDynamicObject("personfield");
        if (Objects.isNull(personfield)) {
            return null;
        }
        Long empId = personfield.getLong("id");
        Date effectdate = onbrd.getDate("effectdate");
        Long personId = this.getPersonId(empId);
        List<Long> personIds = this.getPersonIds(personId);
        Tuple<Long, DynamicObject> tuple = this.getLastErmanfile(personIds);
        return (DynamicObject)tuple.item2;
    }

    public Map<String, Object> getInputParams(DynamicObject onbrd) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicObject personfield = onbrd.getDynamicObject("personfield");
        if (Objects.isNull(personfield)) {
            return map;
        }
        Long empId = personfield.getLong("id");
        Long personId = this.getPersonId(empId);
        List<Long> personIds = this.getPersonIds(personId);
        Tuple<Long, DynamicObject> tuple = this.getLastErmanfile(personIds);
        DynamicObject lastErmanfile = (DynamicObject)tuple.item2;
        Long lastPersonId = (Long)tuple.item1;
        LOGGER.info("lastPersonId=={}", (Object)lastPersonId);
        DynamicObject empjobrel = this.getEmpjobrelByPersonId(lastPersonId);
        DynamicObject empentrel = this.getEmpentrelByPersonId(lastPersonId);
        Long lastEmployeeId = this.getEmployeeIdByPersonId(lastPersonId);
        LOGGER.info("lastEmployeeId=={}", (Object)lastEmployeeId);
        DynamicObject quitfileinfo = this.getQuitfileinfoByEmployeeId(lastEmployeeId);
        map.put("language", RequestContext.get().getLang().name().toUpperCase());
        map.put("reboard", onbrd);
        map.put("exit", quitfileinfo);
        map.put(PERSON_2, empentrel);
        map.put(PERSON_3, empjobrel);
        map.put(PERSON_1, lastErmanfile);
        int empnonentrelNum = this.getEmpnonentrelNum(personIds);
        if (empnonentrelNum >= 0) {
            map.put("count", empnonentrelNum);
        }
        if (Objects.nonNull(empentrel)) {
            int exitduration = DateUtils.getMonths((Date)empentrel.getDate("enddate"), (Date)new Date(), (boolean)false);
            map.put("exit_duration", exitduration);
            int appearances = DateUtils.getMonths((Date)empentrel.getDate("startdate"), (Date)empentrel.getDate("enddate"), (boolean)true);
            map.put("appearances", appearances);
        }
        return map;
    }

    public List<Map<String, Object>> batchGetInputParams(DynamicObject[] againOnbrdArray) {
        HashMap<Long, DynamicObject> onbrdMap = new HashMap<Long, DynamicObject>(againOnbrdArray.length);
        HashMap<Long, Long> onbrdHRParsonMap = new HashMap<Long, Long>(againOnbrdArray.length);
        for (DynamicObject onbrd2 : againOnbrdArray) {
            long billId2 = onbrd2.getLong("id");
            DynamicObject hrPerson = onbrd2.getDynamicObject("personfield");
            if (hrPerson != null) {
                onbrdHRParsonMap.put(billId2, hrPerson.getLong("id"));
            }
            onbrdMap.put(billId2, onbrd2);
        }
        Map<Long, Long> empAndPersonIdMap = this.batchGetPersonId(new HashSet<Long>(onbrdHRParsonMap.values()));
        Map<Long, Long> personAndPersonindexidMap = this.getPersonindexid(new HashSet<Long>(empAndPersonIdMap.values()));
        Map<Long, List<Long>> personIdsMap = this.batchGetPersonIds(personAndPersonindexidMap);
        HashMap<Long, Long> personindexidAndLatestPersonMap = new HashMap<Long, Long>();
        Map<Long, DynamicObject> lastestErmanfileMap = this.batchGetLastErmanfile(personIdsMap, personindexidAndLatestPersonMap);
        HashSet<Long> lastestPersonIds = new HashSet<Long>(personindexidAndLatestPersonMap.values());
        Map<Long, DynamicObject> empjobrelMap = this.batchGetEmpjobrelByPersonId(lastestPersonIds);
        Map<Long, DynamicObject> empentrelMap = this.batchGetEmpentrelByPersonId(lastestPersonIds);
        Map<Long, Long> employeeIdAndPersonMap = this.batchGetEmployeeIdByPersonId(lastestPersonIds);
        Map<Long, DynamicObject> quitfileinfoMap = this.batchGetQuitfileinfoByEmployeeIds(new HashSet<Long>(employeeIdAndPersonMap.values()));
        Map<Long, Integer> empnonentrelNumMap = this.batchGetEmpnonentrelNum(personIdsMap);
        ArrayList<Map<String, Object>> inputParamList = new ArrayList<Map<String, Object>>(againOnbrdArray.length);
        String language = RequestContext.get().getLang().name().toUpperCase();
        onbrdMap.forEach((billId, onbrd) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            long empId = onbrd.getLong("personfield.id");
            Long personindexid = (Long)personAndPersonindexidMap.get(empAndPersonIdMap.get(empId));
            Long lastestPersonId = (Long)personindexidAndLatestPersonMap.get(personindexid);
            Long lastestEmpolyeeId = (Long)employeeIdAndPersonMap.get(lastestPersonId);
            DynamicObject empentrel = (DynamicObject)empentrelMap.get(lastestPersonId);
            map.put("language", language);
            map.put("reboard", onbrd);
            map.put("exit", quitfileinfoMap.get(lastestEmpolyeeId));
            map.put(PERSON_2, empentrel);
            map.put(PERSON_3, empjobrelMap.get(lastestPersonId));
            map.put(PERSON_1, lastestErmanfileMap.get(personindexid));
            if (empnonentrelNumMap.containsKey(personindexid)) {
                map.put("count", empnonentrelNumMap.get(personindexid));
            }
            if (Objects.nonNull(empentrel)) {
                int exitduration = DateUtils.getMonths((Date)empentrel.getDate("enddate"), (Date)new Date(), (boolean)false);
                map.put("exit_duration", exitduration);
                int appearances = DateUtils.getMonths((Date)empentrel.getDate("startdate"), (Date)empentrel.getDate("enddate"), (boolean)true);
                map.put("appearances", appearances);
            }
            inputParamList.add(map);
        });
        return inputParamList;
    }

    public Map<String, List<Map<String, Object>>> groupByBuNumber(List<Map<String, Object>> inputParamList) {
        HashMap<String, List<Map<String, Object>>> resultMap = new HashMap<String, List<Map<String, Object>>>(inputParamList.size());
        inputParamList.forEach(map -> {
            DynamicObject onbrd = (DynamicObject)map.get("reboard");
            String orgNumber = onbrd.getString("org.number");
            List mapList = resultMap.getOrDefault(orgNumber, new ArrayList());
            mapList.add(map);
            resultMap.put(orgNumber, mapList);
        });
        return resultMap;
    }

    private Map<Long, Long> getPersonindexid(HashSet<Long> personIds) {
        QFilter qFilter = new QFilter("id", "in", personIds);
        if (Objects.isNull(personIds)) {
            return new HashMap<Long, Long>(0);
        }
        Object[] persons = IHomToHrpiAppService.getInstance().listFieldsFilterInfo(HRPI_PERSON_SELECT, this.setQFilter(qFilter, false), HRPI_PERSON);
        if (ArrayUtils.isEmpty((Object[])persons)) {
            return new HashMap<Long, Long>(0);
        }
        return Arrays.stream(persons).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("personindexid"), (oldV, newV) -> newV));
    }

    private QFilter setQFilter(QFilter qFilter, boolean businesss) {
        qFilter = qFilter.and("iscurrentversion", "=", (Object)"1").and("datastatus", "=", (Object)"1");
        if (businesss) {
            qFilter = qFilter.and("businessstatus", "=", (Object)"1");
        }
        return qFilter;
    }

    public DynamicObject[] queryEmpentrelInfoByNumber(String ... numbers) {
        QFilter qFilter = new QFilter("number", "in", (Object)numbers).and(new QFilter("datastatus", "=", (Object)"1"));
        return HomCommonRepository.queryDynamicObjects(HRPI_PERSON, "name,number", "createtime desc", qFilter);
    }

    public boolean queryReplaceNumberSwitch() {
        String replaceNumberSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig("replacenumber_switch");
        return "true".equals(replaceNumberSwitch);
    }

    public boolean isReplaceNumber(DynamicObject dataEntity) {
        String viewType = dataEntity.getString("viewtype");
        String employeenoScheme = dataEntity.getString("employeenoscheme");
        return ViewTypeEnum.ROUTINE.getCode().equals(viewType) || ViewTypeEnum.AGAIN.getCode().equals(viewType) && EmployeeNoSchemeEnum.NEW_EMPLOYEE_NO.getValue().equals(employeenoScheme);
    }
}

