/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.cvp;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.hr.hom.business.application.cvp.IHomFaceDetectService;
import kd.hr.hom.common.entity.ocr.FaceDetectResult;
import kd.hr.hom.common.util.FileServiceUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class HomFaceDetectServiceImpl
implements IHomFaceDetectService {
    private static final Log logger = LogFactory.getLog(HomFaceDetectServiceImpl.class);
    private static CloseableHttpClient httpClient = HttpClients.createDefault();

    public static String kdCloudHttpClientTraceIdPost(String url, String api, HttpEntity httpEntity, String traceId) throws Exception {
        String method = "POST";
        Header[] headers = HomFaceDetectServiceImpl.kdCloudPlatformHeader(method, api, null, traceId);
        String respStr = HomFaceDetectServiceImpl.httpClientPostByHttpEntity(httpClient, url, httpEntity, headers);
        return HomFaceDetectServiceImpl.unicodeDecode(respStr);
    }

    public static String httpClientPostByHttpEntity(CloseableHttpClient httpClient, String url, HttpEntity httpEntity, Header[] headers) throws Exception {
        String result;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(httpEntity);
        httpPost.setHeaders(headers);
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
            result = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException var20) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"OcrHttpClientUtils_0", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        logger.info(String.format("%s \u63a5\u53e3,\u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u8bc6\u522b\u8fd4\u56de\u4fe1\u606f: %s", url, result));
        return result;
    }

    public static String unicodeDecode(String string) {
        StringBuilder ss = new StringBuilder();
        ss.append("(\\\\u(\\p{XDigit}");
        ss.append("{4}))");
        Pattern pattern = Pattern.compile(ss.toString());
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            string = string.replace(matcher.group(1), ch + "");
        }
        return string;
    }

    private static Header[] kdCloudPlatformHeader(String method, String url, TreeMap<String, String> paramMap, String traceId) throws Exception {
        String xApiClientID = System.getProperty("hr.client.id", "201230");
        String xApiAuthVersion = "2.0";
        final String xApiTimeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        final String xApiNonce = UUID.randomUUID().toString().replace("-", "");
        TreeMap<String, String> xApiSignHeaders = new TreeMap<String, String>(){
            private static final long serialVersionUID = 3083723355901877770L;
            {
                this.put("X-Api-Nonce", xApiNonce);
                this.put("X-Api-TimeStamp", xApiTimeStamp);
            }
        };
        String xApiSecretID = System.getProperty("hr.client.secret");
        String signature = URLEncoder.encode(HomFaceDetectServiceImpl.sign(method, url, paramMap, xApiSignHeaders, xApiSecretID), "utf-8").replaceAll("%0D%0A", "%20");
        return new BasicHeader[]{new BasicHeader("X-Api-ClientID", xApiClientID), new BasicHeader("X-Api-Auth-Version", xApiAuthVersion), new BasicHeader("X-Api-TimeStamp", String.valueOf(xApiTimeStamp)), new BasicHeader("X-Api-Nonce", String.valueOf(xApiNonce)), new BasicHeader("X-Api-SignHeaders", "X-Api-TimeStamp,X-Api-Nonce"), new BasicHeader("X-Request-Id", traceId), new BasicHeader("X-Api-Signature", URLDecoder.decode(signature, "utf-8").replaceAll(" ", "")), new BasicHeader("accept", "*/*"), new BasicHeader("connection", "Keep-Alive")};
    }

    public static String sign(String method, String url, TreeMap<String, String> params, TreeMap<String, String> headers, String key) throws Exception {
        String paramsString;
        String source = method.toUpperCase() + "\n";
        source = source + URLEncoder.encode(url, "utf-8") + "\n";
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> stringStringEntry;
                Map.Entry<String, String> obj = stringStringEntry = iterator.next();
                sb.append(URLEncoder.encode(obj.getKey(), "utf-8")).append('=').append(URLEncoder.encode(obj.getValue(), "utf-8")).append('&');
            }
        }
        if ((paramsString = sb.toString()).length() > 0) {
            paramsString = paramsString.substring(0, paramsString.length() - 1);
            source = source + paramsString + "\n";
        } else {
            source = source + paramsString + "\n";
        }
        sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> stringStringEntry;
            Map.Entry<String, String> obj = stringStringEntry = iterator.next();
            sb.append(obj.getKey().toLowerCase()).append(':').append(obj.getValue().trim()).append('\n');
        }
        return HomFaceDetectServiceImpl.hmac(source + sb, key);
    }

    private static String hmac(String source, String key) throws Exception {
        byte[] keyBytes = key.getBytes(StandardCharsets.ISO_8859_1);
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(source.getBytes(StandardCharsets.ISO_8859_1));
        byte[] bytes1 = HomFaceDetectServiceImpl.bytesToHex(rawHmac);
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] bytes = encoder.encode(bytes1);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static byte[] bytesToHex(byte[] hashInBytes) {
        StringBuilder sb = new StringBuilder();
        for (byte hashInByte : hashInBytes) {
            String hex = Integer.toHexString(hashInByte & 0xFF);
            if (hex.length() < 2) {
                hex = '0' + hex;
            }
            sb.append(hex);
        }
        return sb.toString().getBytes(StandardCharsets.ISO_8859_1);
    }

    @Override
    public FaceDetectResult detectFaceImage(String imageUrl) {
        try {
            HttpEntity httpEntity = this.getHttpFileEntity(imageUrl);
            String url = HomFaceDetectServiceImpl.getOcrServiceIp() + "/face/detect";
            String api = "/face/detect";
            String traceId = RequestContext.get().getTraceId();
            String respStr = HomFaceDetectServiceImpl.kdCloudHttpClientTraceIdPost(url, api, httpEntity, traceId);
            logger.info(respStr);
            return (FaceDetectResult)JSONObject.parseObject((String)respStr, FaceDetectResult.class);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            return new FaceDetectResult(RequestContext.get().getTraceId(), 40000, exception.getMessage());
        }
    }

    private HttpEntity getHttpFileEntity(String imageUrl) throws IOException {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        byte[] imageData = Base64.getDecoder().decode(FileServiceUtils.imageToBase64ByOnline((String)imageUrl));
        if (imageData == null || imageData.length <= 0) {
            return null;
        }
        InputStreamBody bin = new InputStreamBody((InputStream)new ByteArrayInputStream(imageData), new Date().getTime() + ".png");
        multipartEntityBuilder.addPart("image_file", (ContentBody)bin);
        return multipartEntityBuilder.build();
    }

    private static String getOcrServiceIp() {
        StringBuilder servicePath = new StringBuilder();
        String ip = System.getProperty("hr.algo.ocr.service.ip", "http://bj2-api.kingdee.com");
        if (StringUtils.isEmpty((String)ip)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OcrHttpClientUtils_1", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if ((ip = ip.trim()).endsWith("/")) {
            ip = ip.substring(0, ip.lastIndexOf(47));
        }
        servicePath.append(ip);
        return servicePath.toString();
    }
}

