/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.hpfs.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.common.enums.PositionTypeEnum;

public class DirectLeaderHelper {
    private static final Log LOGGER = LogFactory.getLog(DirectLeaderHelper.class);
    private static String TAG_NOT_MAJOR = "0";
    private static String TAG_MAJOR = "1";
    private static String TAG_COMMON = "2";

    public static List<Map<String, Object>> buildParamMap(DynamicObject[] dataEntityArr, Map<DynamicObject, Long> dynVsIdMap) {
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)1);
        for (DynamicObject dataEntity : dataEntityArr) {
            DynamicObject roleDyn;
            DynamicObject positionDy;
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
            paramMap.put("person", dynVsIdMap.get(dataEntity));
            paramMap.put("tag", DirectLeaderHelper.judgePersonTagForSuperior(dataEntity));
            String aPositionType = dataEntity.getString("apositiontype");
            paramMap.put("apositiontype", aPositionType);
            DynamicObject adminOrgDyn = dataEntity.getDynamicObject("aadminorg");
            if (Objects.nonNull(adminOrgDyn)) {
                paramMap.put("org", adminOrgDyn.getLong("boid"));
            } else {
                LOGGER.info("PersonFileIntegrateServiceImpl#setLeader orgid is null");
            }
            if (HRStringUtils.equals((String)aPositionType, (String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue()) && (positionDy = dataEntity.getDynamicObject("aposition")) != null && Objects.nonNull(roleDyn = positionDy.getDynamicObject("workrole"))) {
                paramMap.put("role", roleDyn.getLong("id"));
            }
            paramMap.put("querydate", new Date());
            paramList.add(paramMap);
        }
        return paramList;
    }

    public static String judgePersonTagForSuperior(DynamicObject dyn) {
        String aPositionType = dyn.getString("apositiontype");
        if (HRStringUtils.equals((String)aPositionType, (String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue())) {
            DynamicObject positionDyn = dyn.getDynamicObject("aposition");
            if (Objects.nonNull(positionDyn)) {
                String isLeader = positionDyn.getString("isleader");
                if (HRStringUtils.equals((String)isLeader, (String)"1")) {
                    return TAG_MAJOR;
                }
                return TAG_COMMON;
            }
        } else {
            return TAG_COMMON;
        }
        return "";
    }
}

