/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.hrcs;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.model.DimValueResultWithSub;
import kd.hr.hbp.common.model.DimValueSubInfo;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.utils.SendMessageUtil;
import kd.hr.hom.business.domain.repository.activity.ActivityRepository;
import kd.hr.hom.business.domain.service.collect.ICooperationManageService;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.DimValueResultDTO;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.enums.WorkflowSchemeStatusEnum;
import kd.hr.hom.common.util.HOMObjectUtils;

public class HomToHrcsAppServiceImpl
implements IHomToHrcsAppService {
    private static final Log LOGGER = LogFactory.getLog(HomToHrcsAppServiceImpl.class);
    private static final String IHRCS_ACTIVITY_SERVICE = "IHRCSActivityService";
    private static final String TRANSFER_SELECT_FIELDS = "id,activityins,onbrdid,activity,bindbizbillid";
    private static final String HRCS = "hrcs";
    private static final String IHRCSSERVICE = "IHRCSService";
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"HrcsAppService#&", (int)5, (int)1000);
    private static final String IHRCS_PERMISSION_SERVICE = "IHRCSDataPermissionService";

    @Override
    public Tuple<Boolean, String> dealTransfer(List<Long> ids, Long userId, String description) {
        String msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"ActivityHandleServiceImpl_9", (String)"hr-hom-business", (Object[])new Object[0]);
        Boolean isSuccess = Boolean.TRUE;
        try {
            Tuple<DynamicObject[], List<Long>> activityIns = this.getActivityIns(TRANSFER_SELECT_FIELDS, ids);
            if (activityIns == null) {
                LOGGER.info("ActivityHandleServiceImpl.dealTransfer---NO HANDLERS");
                return Tuple.create((Object)Boolean.FALSE, (Object)msg);
            }
            LOGGER.info("dealTransfer_batchTransferTask_star:{},userId:{}", activityIns.item2 == null ? "null" : activityIns.item2, (Object)userId);
            OperationResult result = (OperationResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_ACTIVITY_SERVICE, (String)"batchTransferTask", (Object[])new Object[]{activityIns.item2, userId, description == null ? "" : description});
            LOGGER.info("dealTransfer_end:{}", (Object)(result == null ? "null" : result.toString()));
            ArrayList<Long> personList = new ArrayList<Long>();
            personList.add(userId);
            THREAD_POOL.execute(() -> {
                LOGGER.info("dealTransfer_sendMessageWithUrl_star");
                SendMessageUtil.sendMessageWithUrl((DynamicObject[])activityIns.item1, personList, RuleEngineSceneNumberEnum.DO_NOTICE_TRANSFER);
                LOGGER.info("dealTransfer_sendMessageWithUrl_star");
            }, RequestContext.get());
            msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ActivityHandleServiceImpl_8", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            isSuccess = Boolean.FALSE;
            throw new KDBizException(ex.getMessage());
        }
        return Tuple.create((Object)isSuccess, (Object)msg);
    }

    @Override
    public Tuple<Boolean, String> batchAssignTask(List<Long> ids, List<Long> userIds, String description) {
        String msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"ActivityHandleServiceImpl_9", (String)"hr-hom-business", (Object[])new Object[0]);
        Boolean isSuccess = Boolean.TRUE;
        try {
            Tuple<DynamicObject[], List<Long>> activityIns = this.getActivityIns(TRANSFER_SELECT_FIELDS, ids);
            if (activityIns == null) {
                LOGGER.info("ActivityHandleServiceImpl.dealTransfer---NO HANDLERS");
                return Tuple.create((Object)Boolean.FALSE, (Object)msg);
            }
            LOGGER.info("batchAssignTask_batchAssignTask_star_ids:{},userId:{}", activityIns.item2 == null ? "null" : activityIns.item2, userIds);
            OperationResult result = (OperationResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_ACTIVITY_SERVICE, (String)"batchAssignTask", (Object[])new Object[]{activityIns.item2, userIds, description == null ? "" : description});
            LOGGER.info("batchAssignTask_batchAssignTask_end:{}", (Object)(result == null ? "null" : result.toString()));
            THREAD_POOL.execute(() -> {
                LOGGER.info("batchAssignTask_sendMessageWithUrl_star");
                SendMessageUtil.sendMessageWithUrl((DynamicObject[])activityIns.item1, userIds, RuleEngineSceneNumberEnum.MANAGE_NOTICE_TRANSFER);
                LOGGER.info("batchAssignTask_sendMessageWithUrl_star");
            }, RequestContext.get());
            msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ActivityHandleServiceImpl_8", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        return Tuple.create((Object)isSuccess, (Object)msg);
    }

    private Tuple<DynamicObject[], List<Long>> getActivityIns(String selectFields, List<Long> ids) {
        Tuple<DynamicObject[], List<Long>> handles = null;
        handles = ICooperationManageService.getInstance().getActivityIns(selectFields, ids);
        return handles;
    }

    @Override
    public DynamicObject getLatestActivityTask(Object bizBillId, Long activityId) {
        return (DynamicObject)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_ACTIVITY_SERVICE, (String)"getLatestActivityTask", (Object[])new Object[]{bizBillId, activityId});
    }

    @Override
    public OperationResult batchConsentTask(List<Long> taskIdList, String auditMessage) {
        return (OperationResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_ACTIVITY_SERVICE, (String)"batchConsentTask", (Object[])new Object[]{taskIdList, auditMessage});
    }

    @Override
    public OperationResult batchConsentTask(List<Long> taskIdList, Long userId, String auditMessage) {
        LOGGER.info("batchConsentTask taskIdList:{} userId:{} auditMessage:{}", new Object[]{taskIdList, userId, auditMessage});
        return (OperationResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_ACTIVITY_SERVICE, (String)"batchConsentTask", (Object[])new Object[]{taskIdList, userId, auditMessage});
    }

    @Override
    public OperationResult batchTerminateTask(List<Long> taskIdList, String auditMessage) {
        return (OperationResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_ACTIVITY_SERVICE, (String)"batchTerminateTask", (Object[])new Object[]{taskIdList, auditMessage});
    }

    @Override
    public void initActivityInfo(List<Long> onbrdBillIds, Map<Long, Long> activitySchemeMap, Map<Long, DynamicObjectCollection> actSchemeEntryDysMap, Map<Long, String> workflowStatusSchemeMap) {
        LOGGER.info(MessageFormat.format("HomToHrcsAppServiceImpl.initActivityInfo-start onbrdBillIds is {0}", String.valueOf(onbrdBillIds)));
        HRBaseServiceHelper activityOverviewHelper = new HRBaseServiceHelper("hom_activityoverview");
        RequestContext requestContext = RequestContext.get();
        DynamicObjectCollection activityOverviewObjs = new DynamicObjectCollection();
        for (int i = 0; i < onbrdBillIds.size(); ++i) {
            DynamicObject activityOverviewObj = activityOverviewHelper.generateEmptyDynamicObject();
            activityOverviewObj.set("onbrd", (Object)onbrdBillIds.get(i));
            activityOverviewObj.set("activityscheme", (Object)activitySchemeMap.get(onbrdBillIds.get(i)));
            activityOverviewObj.set("schemestartdate", (Object)new Date());
            activityOverviewObj.set("schemefinishdate", null);
            activityOverviewObj.set("totalactivitnum", (Object)actSchemeEntryDysMap.get(onbrdBillIds.get(i)).size());
            activityOverviewObj.set("waitactivitnum", (Object)0);
            activityOverviewObj.set("finishactivitnum", (Object)0);
            activityOverviewObj.set("earlywarnactivitnum", (Object)0);
            activityOverviewObj.set("flowworkschemestatus", (Object)workflowStatusSchemeMap.getOrDefault(onbrdBillIds.get(i), WorkflowSchemeStatusEnum.MATCH_SUCCESS.getValue()));
            activityOverviewObj.set("createtime", (Object)requestContext.getCurrUserId());
            activityOverviewObj.set("createtime", (Object)new Date());
            activityOverviewObj.set("modifier", (Object)requestContext.getCurrUserId());
            activityOverviewObj.set("modifytime", (Object)new Date());
            DynamicObjectCollection activityEntryDys = activityOverviewHelper.generateEmptyEntryCollection(activityOverviewObj, "entryentity");
            int seq = 0;
            for (DynamicObject actSchemeEntryDy : actSchemeEntryDysMap.get(onbrdBillIds.get(i))) {
                DynamicObjectCollection paramConfigDys = actSchemeEntryDy.getDynamicObjectCollection("paramconfig");
                DynamicObject activityEntryDy = activityEntryDys.addNew();
                activityEntryDy.set("seq", (Object)seq);
                activityEntryDy.set("activity", actSchemeEntryDy.get("activity"));
                activityEntryDy.set("iscandidatehandle", (Object)"0");
                this.setOnrdLink(paramConfigDys, activityEntryDy);
                ++seq;
            }
            activityOverviewObj.set("entryentity", (Object)activityEntryDys);
            activityOverviewObjs.add(i, activityOverviewObj);
        }
        ActivityRepository.update((DynamicObject[])activityOverviewObjs.toArray((Object[])new DynamicObject[activityOverviewObjs.size()]));
        LOGGER.info(MessageFormat.format("HomToHrcsAppServiceImpl.initActivityInfo-end onbrdBillIds is {0}", String.valueOf(onbrdBillIds)));
    }

    private void setOnrdLink(DynamicObjectCollection paramConfigDys, DynamicObject activityEntryDy) {
        for (DynamicObject paramConfigDy : paramConfigDys) {
            if (!"onbrdlink".equals(paramConfigDy.getString("paramnumber"))) continue;
            activityEntryDy.set("onbrdlink", (Object)paramConfigDy.getString("paramvalue"));
        }
    }

    @Override
    public DynamicObject getActivitySchemeByNumberAndVersion(String selectProperties, String number, String version) {
        return (DynamicObject)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_ACTIVITY_SERVICE, (String)"getActivitySchemeByNumberAndVersion", (Object[])new Object[]{selectProperties, number, version});
    }

    @Override
    public DynamicObject getTipByHRCS(Long promId) {
        return (DynamicObject)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCSSERVICE, (String)"getPromptContent", (Object[])new Object[]{promId});
    }

    @Override
    public DynamicObject getActivityInsById(String selectProperties, Long activityInsId) {
        return (DynamicObject)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_ACTIVITY_SERVICE, (String)"getActivityInsById", (Object[])new Object[]{selectProperties, activityInsId});
    }

    @Override
    public QFilter getDataResult(String entityNumber, String permNumber) {
        long userId = RequestContext.get().getCurrUserId();
        String appId = this.getIdByNumber("bos_devportal_bizapp", "hom");
        String permItemId = this.getPermPermitemId(permNumber);
        try {
            LOGGER.info("IHRCS_PERMISSION_SERVICE_getDataResult:{},{}", (Object)entityNumber, (Object)permNumber);
            QFilter qFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERMISSION_SERVICE, (String)"getDataRule", (Object[])new Object[]{userId, appId, entityNumber, permItemId, new HashMap()});
            LOGGER.info("IHRCSBizDataPermissionService_getAuthorizedAdminOrg_result:{}", (Object)(HRObjectUtils.isEmpty((Object)qFilter) ? "null" : qFilter.toString()));
            return qFilter;
        }
        catch (Exception exception) {
            LOGGER.error("IHRCS_PERMISSION_SERVICE_getDataResult_error:", (Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
    }

    @Override
    public HasPermOrgResult getAllPermOrgs(String entityNumber, String permNumber) {
        String appId = this.getIdByNumber("bos_devportal_bizapp", "hom");
        String permItemId = this.getPermPermitemId(permNumber);
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityNumber, (String)permItemId);
        return result;
    }

    private String getIdByNumber(String entityNum, String number) {
        DynamicObject dynamicObject = IBaseDataDomainService.getInstance().getBaseDataInfoByNumber(entityNum, number, "id");
        if (HOMObjectUtils.isEmpty((Object)dynamicObject)) {
            return null;
        }
        return dynamicObject.getString("id");
    }

    @Override
    public String getPermPermitemId(String number) {
        return this.getIdByNumber("perm_permitem", number);
    }

    @Override
    public Map<String, Object> getActivitySchemeFromWorkflow(DynamicObject bill, String selectProperties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map getActivitySchemeFromWorkflow = (Map)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_ACTIVITY_SERVICE, (String)"getActivitySchemeFromWorkflow", (Object[])new Object[]{bill, selectProperties});
            if (getActivitySchemeFromWorkflow == null) {
                result.put("success", Boolean.FALSE);
                result.put("errorMsg", ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6d3b\u52a8\u65b9\u6848\u3002", (String)"ActivityHandleServiceImpl_10", (String)"hr-hom-business", (Object[])new Object[0]));
                return result;
            }
            LOGGER.info("getActivitySchemeFromWorkflow_result:{}", (Object)getActivitySchemeFromWorkflow);
            return getActivitySchemeFromWorkflow;
        }
        catch (Exception exception) {
            LOGGER.error("getActivitySchemeFromWorkflow_exception:", (Throwable)exception);
            result.put("success", Boolean.FALSE);
            result.put("errorMsg", ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6d3b\u52a8\u65b9\u6848\u3002", (String)"ActivityHandleServiceImpl_10", (String)"hr-hom-business", (Object[])new Object[0]));
            return result;
        }
    }

    @Override
    public OperationResult batchRevocation(List<String> bizBillIds, Long userId) {
        if (CollectionUtil.isEmpty(bizBillIds)) {
            LOGGER.info("batchRevocation_bizBillIds_null");
            OperationResult result = new OperationResult();
            result.setSuccess(false);
            return result;
        }
        LOGGER.info("batchRevocation_bizBillIds:{}", (Object)bizBillIds.toString());
        OperationResult result = new OperationResult();
        try {
            String traceId = RequestContext.get().getTraceId();
            THREAD_POOL.execute(() -> {
                LOGGER.info("batchRevocation_traceId start{}", (Object)traceId);
                HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_ACTIVITY_SERVICE, (String)"batchRevocation", (Object[])new Object[]{bizBillIds, userId});
                LOGGER.info("batchRevocation_traceId end {}", (Object)traceId);
            }, RequestContext.get());
            LOGGER.info("batchRevocation_bizBillIds_result_isSuccess:{}_msg:{}", (Object)result.isSuccess(), (Object)result.getMessage());
        }
        catch (Exception ext) {
            LOGGER.error("batchRevocation_bizBillIds_error", (Throwable)ext);
            result.setSuccess(false);
            result.setMessage(ext.getMessage());
        }
        return result;
    }

    @Override
    public DimValueResultDTO getDimValueWithSub(String entityNum, String propName) {
        DimValueResultDTO dimValueResultDto = new DimValueResultDTO();
        DimValueResultWithSub dimValueResultWithSub = (DimValueResultWithSub)HRMServiceHelper.invokeBizService((String)"hrmp", (String)HRCS, (String)"IHRCSBizDataPermissionService", (String)"getEntityDimValueWithSub", (Object[])new Object[]{RequestContext.getOrCreate().getCurrUserId(), "1WXB5G9/BL46", entityNum, "47150e89000000ac", "orgdesign"});
        ArrayList<Long> orgIds = new ArrayList<Long>(dimValueResultWithSub.getDimValues().size());
        LOGGER.info("###HomToHrcsAppServiceImpl.getDimValueWithSub, dimValueResultWithSub:{}", (Object)JSON.toJSONString((Object)dimValueResultWithSub));
        if (!dimValueResultWithSub.isAll()) {
            ArrayList<Long> includeSubIds = new ArrayList<Long>(dimValueResultWithSub.getDimValues().size());
            for (DimValueSubInfo dimValue : dimValueResultWithSub.getDimValues()) {
                Long orgId = HRJSONUtils.getLongValOfCustomParam((Object)dimValue.getValue());
                if (dimValue.isContainSub()) {
                    includeSubIds.add(orgId);
                    continue;
                }
                orgIds.add(orgId);
            }
            if (!HRCollUtil.isEmpty(includeSubIds)) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
                OrgProp orgProp = (OrgProp)dataEntityType.getProperty(propName);
                List allSubordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)orgProp.getOrgFunc(), includeSubIds, (boolean)true);
                orgIds.addAll(allSubordinateOrgs);
            }
        }
        dimValueResultDto.setAll(dimValueResultWithSub.isAll());
        dimValueResultDto.setOrgIds(orgIds);
        LOGGER.info("###HomToHrcsAppServiceImpl.getDimValueWithSub, dimValueResultWithSub:{}", (Object)JSON.toJSONString((Object)dimValueResultDto));
        return dimValueResultDto;
    }

    @Override
    public Map<String, Object> terminateOrDeleteTask(List<Long> onbrdIds) {
        Map<String, Object> resultMap = new HashMap<String, Object>(2);
        if (HRCollUtil.isEmpty(onbrdIds)) {
            LOGGER.warn("###HomToHrcsAppServiceImpl.terminateOrDeleteTask, onbrdIds is empty");
            return resultMap;
        }
        boolean openHrssc = HRBaseDataConfigUtil.getOpenhrssc();
        if (Boolean.FALSE.equals(openHrssc)) {
            LOGGER.warn("###HomToHrcsAppServiceImpl.terminateOrDeleteTask, openHrssc is false");
            resultMap.put("success", Boolean.TRUE.toString());
            return resultMap;
        }
        QFilter qFilter = new QFilter("id", "in", onbrdIds);
        DynamicObject[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills("handler", qFilter.toArray());
        HashMap billIdMap = new HashMap(2);
        for (DynamicObject onbrdBill : onbrdBills) {
            HashMap<String, Long> onbrdInfo = new HashMap<String, Long>(2);
            onbrdInfo.put("currentPersonId", onbrdBill.getLong("handler.id"));
            billIdMap.put(onbrdBill.getLong("id"), onbrdInfo);
        }
        HashMap<String, Long> params = new HashMap<String, Long>(2);
        params.put("operatorId", RequestContext.get().getCurrUserId());
        try {
            LOGGER.info("###HomToHrcsAppServiceImpl.terminateOrDeleteTask, billIdMap:{},param:{}", billIdMap, params);
            resultMap = (Map)HRMServiceHelper.invokeBizService((String)"ssc", (String)"hstc", (String)"ITaskService", (String)"terminateOrDeleteTask", (Object[])new Object[]{"hom_onbrdinfo", billIdMap, params});
            LOGGER.info("###HomToHrcsAppServiceImpl.terminateOrDeleteTask, invoke result:{}", resultMap);
        }
        catch (Exception e) {
            LOGGER.error("###HomToHrcsAppServiceImpl.terminateOrDeleteTask, invoke api error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5171\u4eab\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ActivityHandleServiceImpl_11", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        return resultMap;
    }
}

