/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.hrpi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.util.query.DateTimeUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hpfs.IPersonFileIntegrateService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.PreOnBrdCommonUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class HomToHrpiAppService
implements IHomToHrpiAppService {
    private static final Log LOGGER = LogFactory.getLog(HomToHrpiAppService.class);
    private static final int NUMBER_SEVEN = 7;
    private Map<String, String> homToHrpiMap = new ImmutableMap.Builder().put((Object)"phone", (Object)"phone").put((Object)"employeeno", (Object)"number").put((Object)"peremail", (Object)"email").put((Object)"certificatenumber", (Object)"cardno").put((Object)"certificatetype.id", (Object)"cardtype").put((Object)"name", (Object)"name").build();

    @Override
    public List<Map<String, Object>> listBatchPropPersonAttachs(List<Long> personIds, String selectProps, String attachEntityName) {
        if (CollectionUtils.isEmpty(personIds)) {
            return new ArrayList<Map<String, Object>>(1);
        }
        return (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPropPersonAttachs", (Object[])new Object[]{personIds, selectProps, null, attachEntityName});
    }

    @Override
    public List<Map<String, Object>> checkPerson(List<Map<String, Object>> checkList) {
        if (CollectionUtils.isEmpty(checkList)) {
            return new ArrayList<Map<String, Object>>(1);
        }
        List result = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"checkPerson", (Object[])new Object[]{checkList});
        return result;
    }

    @Override
    public List<Map<String, Object>> checkPersonByOpt(List<Map<String, Object>> checkList, String queryType) {
        if (CollectionUtils.isEmpty(checkList)) {
            return new ArrayList<Map<String, Object>>(1);
        }
        List result = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"checkPersonByOpt", (Object[])new Object[]{checkList, queryType});
        return result;
    }

    @Override
    public Map<String, String> validPersonIsExist(List<Map<String, Object>> checkList, String keyName) {
        return this.validPersonIsExist(checkList, keyName, false);
    }

    @Override
    public Map<String, String> validPersonIsExist(List<Map<String, Object>> checkList, String keyName, boolean isReOnBrd) {
        if (CollectionUtils.isEmpty(checkList)) {
            return new HashMap<String, String>(1);
        }
        LOGGER.info("===start checkPerson params===");
        List<Map<String, Object>> checkPersonList = this.checkPerson(checkList);
        if (CollectionUtils.isEmpty(checkPersonList)) {
            LOGGER.error("checkPersonList is empty");
            return new HashMap<String, String>(1);
        }
        LOGGER.info("===end checkPerson ===");
        HashMap<String, String> resMap = new HashMap<String, String>(checkPersonList.size());
        for (Map<String, Object> checkPersonMap : checkPersonList) {
            String key = HRStringUtils.isEmpty((String)keyName) ? String.valueOf(checkPersonMap.get("cardno")) + checkPersonMap.get("phone") : String.valueOf(checkPersonMap.get(keyName));
            this.handleCheckPersonResult(checkPersonMap, resMap, key, isReOnBrd);
        }
        return resMap;
    }

    @Override
    public Optional<String> validOnePersonWithTip(DynamicObject dy, String keyName) {
        ArrayList<Map<String, Object>> checkList = new ArrayList<Map<String, Object>>(2);
        HashMap<String, Object> tmpMap = new HashMap<String, Object>(7);
        tmpMap.put("number", dy.getString("employeeno"));
        tmpMap.put("name", dy.getString("name"));
        tmpMap.put("phone", dy.getString("phone"));
        if (!HRStringUtils.isEmpty((String)dy.getString("certificatenumber"))) {
            tmpMap.put("cardno", dy.getString("certificatenumber"));
            tmpMap.put("cardtype", dy.get("certificatetype") == null ? 0L : dy.getLong("certificatetype.id"));
        } else {
            tmpMap.put("cardno", "");
            tmpMap.put("cardtype", 0L);
        }
        tmpMap.put("email", dy.getString("peremail"));
        checkList.add(tmpMap);
        String viewType = dy.getString("viewtype");
        boolean isReOnBrd = HRStringUtils.equals((String)viewType, (String)ViewTypeEnum.AGAIN.getCode());
        Map<String, String> oneMap = this.validPersonIsExist(checkList, this.homToHrpiMap.get(keyName), isReOnBrd);
        if (CollectionUtils.isEmpty(oneMap)) {
            return Optional.empty();
        }
        LOGGER.info("=== validPersonIsExist map start===");
        String key = HRStringUtils.isEmpty((String)keyName) ? dy.getString("certificatenumber") + dy.getString("phone") : dy.getString(keyName);
        if (HRStringUtils.equals((String)oneMap.get(key), (String)"true")) {
            return Optional.empty();
        }
        String value = oneMap.get(key);
        StringBuilder msgBulid = new StringBuilder();
        String msg = ResManager.loadKDString((String)"\u4e0e\u5728\u804c\u4eba\u5458\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HomToHrpi_0", (String)"hr-hom-business", (Object[])new Object[0]);
        this.buildValidPersonMsg(value, msgBulid);
        msgBulid.append(msg);
        return Optional.of(msgBulid.toString());
    }

    @Override
    public Map<String, Object> getPersonInfoByCert(Map<String, Object> certInfos) {
        if (CollectionUtils.isEmpty(certInfos)) {
            return Collections.emptyMap();
        }
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonInfoByCert", (Object[])new Object[]{certInfos});
    }

    @Override
    public Map<String, Object> getPersonInfoFuzzy(Map<String, Object> fuzzyParam) {
        if (CollectionUtils.isEmpty(fuzzyParam)) {
            return Collections.emptyMap();
        }
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonInfoFuzzy", (Object[])new Object[]{fuzzyParam});
    }

    @Override
    public Map<String, Map<String, Object>> isFormerEmployeeByCreNumberAndCreType(List<String> credentialsNumbers, Long credentialsType) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
        if (CollectionUtils.isEmpty(credentialsNumbers) || credentialsType == null || credentialsType == 0L) {
            return resultMap;
        }
        HashMap certInfos = Maps.newHashMapWithExpectedSize((int)2);
        certInfos.put("credentialsType", credentialsType);
        certInfos.put("numbers", credentialsNumbers);
        Map<String, Object> personInfoByCert = this.getPersonInfoByCert(certInfos);
        Boolean success = MapUtils.getBoolean(personInfoByCert, (Object)"success");
        if (personInfoByCert == null || Boolean.FALSE.equals(success)) {
            LOGGER.error("isFormerEmployeeByCreNumberAndCreType-personInfoByCert error");
            return resultMap;
        }
        for (String credentialsNumber : credentialsNumbers) {
            HashMap result = Maps.newHashMapWithExpectedSize((int)2);
            Object data = personInfoByCert.get("data");
            if (data instanceof List) {
                List dataList = (List)data;
                for (Map stringObjectMap : dataList) {
                    Map empentrelMap;
                    Object labrelstatusprd;
                    if (!credentialsNumber.equals(stringObjectMap.get("number"))) continue;
                    Object empentrel = stringObjectMap.get("hrpi_empentrel");
                    if (!(empentrel instanceof Map) || !BaseDataIdConstants.HBSS_LABRELSTATUSPRD_1020.equals(labrelstatusprd = (empentrelMap = (Map)empentrel).get("laborrelstatus_labrelstatusprd_id"))) break;
                    result.put("personfield", empentrelMap.get("employee_id"));
                    if (!(stringObjectMap.get("hrpi_person") instanceof Map)) break;
                    Map person = (Map)stringObjectMap.get("hrpi_person");
                    result.put("personindexid", person.get("personindexid"));
                    result.put("name", person.get("name"));
                    break;
                }
            }
            resultMap.put(credentialsNumber, result);
        }
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> getPersonInfoFuzzyDedupByPhoneAndName(String name, String phone) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)phone)) {
            return resultList;
        }
        HashMap fuzzyParam = Maps.newHashMapWithExpectedSize((int)3);
        fuzzyParam.put("name", name);
        fuzzyParam.put("phone", phone);
        fuzzyParam.put("fuzzyFlag", Boolean.FALSE);
        Map<String, Object> personInfoFuzzy = this.getPersonInfoFuzzy(fuzzyParam);
        if (personInfoFuzzy == null || Boolean.FALSE.equals(personInfoFuzzy.get("success"))) {
            LOGGER.error("getPersonInfoFuzzyDedupByPhoneAndName is error");
            return resultList;
        }
        Object data = personInfoFuzzy.get("data");
        if (data instanceof List) {
            List dataLists = (List)data;
            Map<Object, List<Map>> pidMap = dataLists.stream().collect(Collectors.groupingBy(data1 -> data1.get("personindexid")));
            for (Map.Entry<Object, List<Map>> objectListEntry : pidMap.entrySet()) {
                List<Map> value = objectListEntry.getValue();
                Collections.sort(value, (o1, o2) -> {
                    Object empentrel1 = o1.get("hrpi_empentrel");
                    Object empentrel2 = o2.get("hrpi_empentrel");
                    Timestamp dateOne = null;
                    Timestamp dateTwo = null;
                    try {
                        dateOne = empentrel1 == null ? new Timestamp(DateTimeUtils.parseDate((String)"1900-01-01").getTime()) : (Timestamp)((Map)empentrel1).get("startdate");
                        dateTwo = empentrel2 == null ? new Timestamp(DateTimeUtils.parseDate((String)"1900-01-01").getTime()) : (Timestamp)((Map)empentrel2).get("startdate");
                    }
                    catch (ParseException parseException) {
                        LOGGER.error("getPersonInfoFuzzyDedupByPhoneAndName parseDate error");
                    }
                    return dateTwo.after(dateOne) ? 0 : -1;
                });
                resultList.add(value.get(0));
            }
            List<Map<String, Object>> dataList = resultList.stream().filter(var -> var.get("hrpi_empentrel") != null && BaseDataIdConstants.HBSS_LABRELSTATUSCLS_1040.equals(((Map)var.get("hrpi_empentrel")).get("laborrelstatus_labrelstatuscls_id"))).collect(Collectors.toList());
            return dataList;
        }
        return resultList;
    }

    @Override
    public Map<Long, String> validAllPersonWithTip(List<DynamicObject> dys, List<String> keyNames) {
        if (CollectionUtils.isEmpty(dys)) {
            return new HashMap<Long, String>(1);
        }
        int size = dys.size();
        ArrayList<Map<String, Object>> onBrdCheckList = new ArrayList<Map<String, Object>>(size);
        ArrayList<Map<String, Object>> reOnBrdCheckList = new ArrayList<Map<String, Object>>(size);
        HashSet fieldNameSet = Sets.newHashSet((Object[])new String[]{"phone", "employeeno", "name"});
        fieldNameSet.addAll(keyNames);
        HashMap<Long, String> onBrdMap = new HashMap<Long, String>(size);
        for (DynamicObject dy : dys) {
            HashMap<String, Object> tmpMap = new HashMap<String, Object>(7);
            tmpMap.put("number", dy.getString("employeeno"));
            tmpMap.put("name", dy.getString("name"));
            tmpMap.put("phone", dy.getString("phone"));
            if (!HRStringUtils.isEmpty((String)dy.getString("certificatenumber"))) {
                tmpMap.put("cardno", dy.getString("certificatenumber"));
                tmpMap.put("cardtype", dy.get("certificatetype") == null ? 0L : dy.getLong("certificatetype.id"));
            } else {
                tmpMap.put("cardno", "");
                tmpMap.put("cardtype", 0L);
            }
            tmpMap.put("email", dy.getString("peremail"));
            StringBuilder builder = new StringBuilder();
            for (String str : fieldNameSet) {
                Object value = dy.get(str);
                if (HRStringUtils.equals((String)str, (String)"certificatetype.id") && HRStringUtils.isEmpty((String)dy.getString("certificatenumber"))) {
                    builder.append('0').append('-');
                    continue;
                }
                builder.append(value instanceof String ? value.toString().trim() : value).append('-');
            }
            String value = builder.toString();
            onBrdMap.put(dy.getLong("id"), value);
            String viewType = dy.getString("viewtype");
            boolean isReOnBrd = HRStringUtils.equals((String)viewType, (String)ViewTypeEnum.AGAIN.getCode());
            if (isReOnBrd) {
                reOnBrdCheckList.add(tmpMap);
                continue;
            }
            onBrdCheckList.add(tmpMap);
        }
        HashMap<String, String> resMap = new HashMap<String, String>(size);
        Map<String, String> onBrdResMap = this.validPersonIsExist(onBrdCheckList, new ArrayList<String>(fieldNameSet), false);
        Map<String, String> reOnBrdResMap = this.validPersonIsExist(reOnBrdCheckList, new ArrayList<String>(fieldNameSet), true);
        resMap.putAll(onBrdResMap);
        resMap.putAll(reOnBrdResMap);
        if (CollectionUtils.isEmpty(resMap)) {
            return new HashMap<Long, String>(1);
        }
        HashMap<Long, String> returnMap = new HashMap<Long, String>(size);
        for (Map.Entry entry : onBrdMap.entrySet()) {
            String value = (String)entry.getValue();
            Long onbrdId = (Long)entry.getKey();
            if ("true".equals(resMap.get(value))) {
                returnMap.put(onbrdId, "");
                continue;
            }
            String errMsg = (String)resMap.get(value);
            StringBuilder msgBulid = new StringBuilder();
            if (HRStringUtils.isEmpty((String)errMsg)) {
                msgBulid.append(ResManager.loadKDString((String)"\u4eba\u5458\u63a5\u53e3\u672a\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c\u3002", (String)"HomToHrpi_5", (String)"hr-hom-business", (Object[])new Object[0]));
            } else {
                this.buildValidPersonMsg(errMsg, msgBulid);
            }
            returnMap.put(onbrdId, msgBulid.toString());
        }
        return returnMap;
    }

    @Override
    public Map<Long, String> checkAndTipByPersonFields(List<DynamicObject> onbrdBills, List<String> fieldNames) {
        if (CollectionUtils.isEmpty(onbrdBills)) {
            return new HashMap<Long, String>(1);
        }
        HashSet fieldNameSet = Sets.newHashSet((Object[])new String[]{"phone", "employeeno", "name"});
        fieldNameSet.addAll(fieldNames);
        int size = onbrdBills.size();
        ArrayList<Map<String, Object>> onBrdCheckList = new ArrayList<Map<String, Object>>(size);
        ArrayList<Map<String, Object>> reOnBrdCheckList = new ArrayList<Map<String, Object>>(size);
        HashMap<Long, String> onbrdMap = new HashMap<Long, String>(onbrdBills.size());
        for (DynamicObject onbrdBill : onbrdBills) {
            StringBuilder uniqueKey = new StringBuilder();
            HashMap<String, Object> tmpMap = new HashMap<String, Object>(8);
            for (String string : fieldNameSet) {
                String keyName;
                if (HRStringUtils.isEmpty((String)string) || HRStringUtils.isEmpty((String)(keyName = this.homToHrpiMap.get(string)))) continue;
                Object value = onbrdBill.get(string);
                uniqueKey.append(value instanceof String ? value.toString().trim() : value).append('-');
                if (!HRStringUtils.equals((String)"certificatenumber", (String)string)) {
                    tmpMap.put(keyName, onbrdBill.getString(string));
                    continue;
                }
                String certificateNumber = onbrdBill.getString("certificatenumber");
                tmpMap.put(keyName, HRStringUtils.isEmpty((String)certificateNumber) ? "" : certificateNumber);
                tmpMap.put(this.homToHrpiMap.get("certificatetype.id"), onbrdBill.get("certificatetype") == null ? 0L : onbrdBill.getLong("certificatetype.id"));
            }
            onbrdMap.put(onbrdBill.getLong("id"), uniqueKey.toString());
            String viewType = onbrdBill.getString("viewtype");
            boolean bl = HRStringUtils.equals((String)viewType, (String)ViewTypeEnum.AGAIN.getCode());
            if (bl) {
                reOnBrdCheckList.add(tmpMap);
                continue;
            }
            onBrdCheckList.add(tmpMap);
        }
        HashMap<String, String> resMap = new HashMap<String, String>(size);
        Map<String, String> onBrdResMap = this.validPersonIsExist(onBrdCheckList, new ArrayList<String>(fieldNameSet), false);
        Map<String, String> reOnBrdResMap = this.validPersonIsExist(reOnBrdCheckList, new ArrayList<String>(fieldNameSet), true);
        resMap.putAll(onBrdResMap);
        resMap.putAll(reOnBrdResMap);
        if (CollectionUtils.isEmpty(resMap)) {
            return new HashMap<Long, String>(1);
        }
        HashMap<Long, String> resultMap = new HashMap<Long, String>(onbrdBills.size());
        for (Map.Entry entry : onbrdMap.entrySet()) {
            String uniqueKey = (String)entry.getValue();
            String isSuccess = (String)resMap.get(uniqueKey);
            if (isSuccess == null) {
                LOGGER.error("isSuccess is null");
            }
            if (HRStringUtils.equals((String)isSuccess, (String)"true")) continue;
            String errMsg = (String)resMap.get(uniqueKey);
            StringBuilder msgBulid = new StringBuilder();
            if (HRStringUtils.isEmpty((String)errMsg)) {
                msgBulid.append(ResManager.loadKDString((String)"\u4eba\u5458\u63a5\u53e3\u672a\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c\u3002", (String)"HomToHrpi_5", (String)"hr-hom-business", (Object[])new Object[0]));
            } else {
                LOGGER.info("errMsg:{}", (Object)errMsg);
                this.buildValidPersonMsg(errMsg, msgBulid, fieldNames);
            }
            Long onbrdId = (Long)entry.getKey();
            resultMap.put(onbrdId, msgBulid.toString());
        }
        return resultMap;
    }

    @Override
    public Map<String, String> checkAndTipByPersonFieldsForPre(List<DynamicObject> onbrdBills, List<String> fieldNames) {
        if (CollectionUtils.isEmpty(onbrdBills)) {
            return new HashMap<String, String>(1);
        }
        HashSet fieldNameSet = Sets.newHashSet((Object[])new String[]{"phone", "employeeno", "name"});
        fieldNameSet.addAll(fieldNames);
        int size = onbrdBills.size();
        List onBrdCheckList = PreOnBrdCommonUtil.genOnBrdCheckList(onbrdBills, (Set)fieldNameSet);
        HashMap<String, String> resMap = new HashMap<String, String>(size);
        Map<String, String> onBrdResMap = this.validPersonIsExistForPre(onBrdCheckList, new ArrayList<String>(fieldNameSet), false);
        resMap.putAll(onBrdResMap);
        if (CollectionUtils.isEmpty(resMap)) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(onbrdBills.size());
        for (Map stringObjectMap : onBrdCheckList) {
            List checkhr;
            if (Boolean.TRUE.equals(stringObjectMap.get("result")) || CollectionUtils.isEmpty((Collection)(checkhr = (List)stringObjectMap.get("checkhr")))) continue;
            StringBuilder msgBulid = new StringBuilder();
            Map<String, List<Map>> groupByRepeatNumber = checkhr.stream().collect(Collectors.groupingBy(c -> (String)c.get("repeatnumber")));
            LOGGER.info("checkAndTipByPersonFieldsForPre.groupByRepeatNumber\uff1a{}", (Object)HOMObjectUtils.toJSONString(groupByRepeatNumber));
            Collection<List<Map>> listCollection = groupByRepeatNumber.values();
            for (List<Map> check : listCollection) {
                msgBulid = PreOnBrdCommonUtil.getPersonRepeatMsg((StringBuilder)msgBulid, check);
            }
            String prepkid = (String)stringObjectMap.get("prepkid");
            resultMap.put(prepkid, msgBulid.toString());
            LOGGER.info("checkAndTipByPersonFieldsForPre.prepkid\uff1a{}", (Object)prepkid);
            LOGGER.info("checkAndTipByPersonFieldsForPre.msgBulid\uff1a{}", (Object)msgBulid.toString());
        }
        return resultMap;
    }

    private Map<String, String> validPersonIsExistForPre(List<Map<String, Object>> checkList, List<String> keyNames, boolean isReOnBrd) {
        if (CollectionUtils.isEmpty(checkList)) {
            return new HashMap<String, String>(1);
        }
        LOGGER.info("===start checkPerson params===");
        List<Map<String, Object>> checkPersonList = this.checkPerson(checkList);
        if (CollectionUtils.isEmpty(checkPersonList)) {
            LOGGER.error("checkPersonList is empty");
            return new HashMap<String, String>(1);
        }
        LOGGER.info("===end checkPerson ===");
        HashMap<String, String> resMap = new HashMap<String, String>(checkPersonList.size());
        for (Map<String, Object> checkPersonMap : checkPersonList) {
            String key;
            Object prepkid = checkPersonMap.get("prepkid");
            if (prepkid != null) {
                List mapList = checkList.stream().filter(c -> c.get("prepkid").equals(prepkid)).collect(Collectors.toList());
                if (ObjectUtils.isNotEmpty((Object)checkPersonMap.get("checkhr")) && mapList.size() > 0) {
                    ((Map)mapList.get(0)).put("checkhr", checkPersonMap.get("checkhr"));
                }
            }
            if (CollectionUtils.isEmpty(keyNames)) {
                key = String.valueOf(checkPersonMap.get("cardno")) + checkPersonMap.get("phone");
            } else {
                StringBuilder builder = new StringBuilder();
                for (String str : keyNames) {
                    String keyName = this.homToHrpiMap.get(str);
                    Object value = checkPersonMap.get(keyName);
                    builder.append(value instanceof String ? value.toString().trim() : value).append('-');
                }
                key = builder.toString();
            }
            this.handleCheckPersonResult(checkPersonMap, resMap, key, isReOnBrd);
        }
        return resMap;
    }

    private void buildValidPersonMsg(String errMsg, StringBuilder msgBulid) {
        String[] strs = errMsg.split("-");
        Map<String, String> msgMap = this.buildMsgMap();
        for (String str : strs) {
            msgBulid.append(msgMap.get(str));
        }
    }

    private void buildValidPersonMsg(String errMsg, StringBuilder msgBulid, List<String> fieldNames) {
        String[] strs = errMsg.split("-");
        Map<String, String> msgMap = this.buildMsgMap();
        for (String str : strs) {
            List fieldNameHrips = fieldNames.stream().map(fieldName -> this.homToHrpiMap.getOrDefault(fieldName, "")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(fieldNames) && !fieldNameHrips.contains(str)) continue;
            msgBulid.append(msgMap.get(str));
        }
    }

    @Override
    public Map<String, String> validPersonIsExist(List<Map<String, Object>> checkList, List<String> keyNames) {
        return this.validPersonIsExist(checkList, keyNames, false);
    }

    @Override
    public Map<String, String> validPersonIsExist(List<Map<String, Object>> checkList, List<String> keyNames, boolean isReOnBrd) {
        if (CollectionUtils.isEmpty(checkList)) {
            return new HashMap<String, String>(1);
        }
        LOGGER.info("===start checkPerson params===");
        List<Map<String, Object>> checkPersonList = this.checkPerson(checkList);
        if (CollectionUtils.isEmpty(checkPersonList)) {
            LOGGER.error("checkPersonList is empty");
            return new HashMap<String, String>(1);
        }
        LOGGER.info("===end checkPerson ===");
        HashMap<String, String> resMap = new HashMap<String, String>(checkPersonList.size());
        for (Map<String, Object> checkPersonMap : checkPersonList) {
            String key;
            if (CollectionUtils.isEmpty(keyNames)) {
                key = String.valueOf(checkPersonMap.get("cardno")) + checkPersonMap.get("phone");
            } else {
                StringBuilder builder = new StringBuilder();
                for (String str : keyNames) {
                    String keyName = this.homToHrpiMap.get(str);
                    Object value = checkPersonMap.get(keyName);
                    builder.append(value instanceof String ? value.toString().trim() : value).append('-');
                }
                key = builder.toString();
            }
            this.handleCheckPersonResult(checkPersonMap, resMap, key, isReOnBrd);
        }
        return resMap;
    }

    private void handleCheckPersonResult(Map<String, Object> checkPersonMap, Map<String, String> resMap, String key, boolean isReOnBrd) {
        LOGGER.info("isReOnBrd:{}", (Object)isReOnBrd);
        boolean res = (Boolean)checkPersonMap.get("result");
        StringBuilder strBuild = new StringBuilder();
        this.checkRepeatKey(checkPersonMap, strBuild, "checkhr", false);
        this.checkRepeatKey(checkPersonMap, strBuild, "checkbos", isReOnBrd);
        String msg = strBuild.toString();
        if (res || HRStringUtils.isEmpty((String)msg)) {
            resMap.put(key, "true");
        } else {
            resMap.put(key, msg);
        }
    }

    @Override
    public void sendMessageToLeaderAndTeacher(List<DynamicObject> dys) {
        try {
            ArrayList<Long> teacherIdList = new ArrayList<Long>(dys.size());
            ArrayList<Long> roleIdList = new ArrayList<Long>(dys.size());
            HashMap<Long, Long> teachOnbrdMap = new HashMap<Long, Long>(dys.size());
            Map<Long, List<Long>> leaderOnbrdMap = new HashMap<Long, List<Long>>(dys.size());
            HashMap<Long, List<Long>> responOnbrdMap = new HashMap(dys.size());
            ArrayList<DynamicObject> leaderOnbrdList = new ArrayList<DynamicObject>(dys.size());
            ArrayList<DynamicObject> responOnbrdList = new ArrayList<DynamicObject>(dys.size());
            String selProp = "phone" + "," + "person.id" + "," + "peremail" + "," + "person.name";
            for (DynamicObject dy : dys) {
                DynamicObject roleDy;
                DynamicObject apositionDy;
                DynamicObject teacherDy = dy.getDynamicObject("teacher");
                if (teacherDy != null) {
                    teacherIdList.add(teacherDy.getLong("id"));
                    teachOnbrdMap.put(dy.getLong("id"), teacherDy.getLong("id"));
                }
                if ((apositionDy = dy.getDynamicObject("aposition")) != null && (roleDy = dy.getDynamicObject("role")) != null) {
                    roleIdList.add(roleDy.getLong("id"));
                    leaderOnbrdList.add(dy);
                }
                responOnbrdList.add(dy);
            }
            LOGGER.info("===sendMessageToLeaderAndTeacher getMainChargeInfoByOrg start===");
            Map<Long, List<Map<String, Object>>> responMap = IPersonFileIntegrateService.getInstance().getListMainChargeInfoByOrg(responOnbrdList.toArray(new DynamicObject[dys.size()]));
            LOGGER.info("===sendMessageToLeaderAndTeacher getMainChargeInfoByOrg end===");
            if (!(CollectionUtils.isEmpty(responMap) || CollectionUtils.isEmpty(responOnbrdList) || CollectionUtils.isEmpty(responMap))) {
                responOnbrdMap = this.bulidResponOnbrdMap(responOnbrdList, responMap);
                LOGGER.info("===sendMessageToLeaderAndTeacher bulidResponOnbrdMap:{}===", responOnbrdMap);
            }
            if (!CollectionUtils.isEmpty(roleIdList) && !CollectionUtils.isEmpty(leaderOnbrdList)) {
                LOGGER.info("===sendMessageToLeaderAndTeacher getLeaderByRoleIdHrpi start===");
                Map<Long, List<Map<String, Object>>> leaderMap = IPersonFileIntegrateService.getInstance().getListSuperiorByOrg(roleIdList);
                LOGGER.info("===sendMessageToLeaderAndTeacher getLeaderByRoleIdHrpi end===");
                if (!CollectionUtils.isEmpty(leaderMap)) {
                    leaderOnbrdMap = this.bulidLeaderOnbrdMap(leaderOnbrdList, leaderMap);
                    LOGGER.info("===sendMessageToLeaderAndTeacher bulidLeaderOnbrdMap:{}===", leaderOnbrdMap);
                }
            }
            if (!CollectionUtils.isEmpty(teacherIdList) && !CollectionUtils.isEmpty(teachOnbrdMap)) {
                LOGGER.info("===teachOnbrPhoneMap start===");
                Map<Long, List<Map<Long, Map<String, String>>>> teachOnbrPhoneMap = this.buildOnbrdPhoneMap(teacherIdList, teachOnbrdMap, selProp);
                if (!CollectionUtils.isEmpty(teachOnbrPhoneMap)) {
                    LOGGER.info("===teachOnbrPhoneMap end===");
                    ServiceFactory.getService(ISendMessageService.class).sendMessage(teachOnbrPhoneMap, RuleEngineSceneNumberEnum.HOMSCE_TEACHER_MESSAGE);
                }
            }
            if (!CollectionUtils.isEmpty(leaderOnbrdMap)) {
                LOGGER.info("===leaderOnbrdMap start===");
                Map<Long, List<Map<Long, Map<String, String>>>> leaderOnbrdPhoneMap = this.buildOnbrdPhoneMap(leaderOnbrdMap, selProp);
                if (!CollectionUtils.isEmpty(leaderOnbrdPhoneMap)) {
                    LOGGER.info("===leaderOnbrdPhoneMap end===");
                    ServiceFactory.getService(ISendMessageService.class).sendMessage(leaderOnbrdPhoneMap, RuleEngineSceneNumberEnum.HOMSCE_LEADER_MESSAGE);
                }
            }
            if (!CollectionUtils.isEmpty(responOnbrdMap)) {
                LOGGER.info("===responOnbrdMap start===");
                Map<Long, List<Map<Long, Map<String, String>>>> responListMap = this.buildOnbrdPhoneMap(responOnbrdMap, selProp);
                if (!CollectionUtils.isEmpty(responListMap)) {
                    LOGGER.info("===responListMap end===");
                    ServiceFactory.getService(ISendMessageService.class).sendMessage(responListMap, RuleEngineSceneNumberEnum.HOMSCE_RESPONSIBLE_MESSAGE);
                }
            }
        }
        catch (Exception exp) {
            LOGGER.error("===sendMessageToLeaderAndTeacher===", (Throwable)exp);
        }
    }

    private Map<Long, List<Long>> bulidResponOnbrdMap(List<DynamicObject> responOnbrdList, Map<Long, List<Map<String, Object>>> responMap) {
        HashMap<Long, List<Long>> responOnbrdMap = new HashMap<Long, List<Long>>(responOnbrdList.size());
        for (DynamicObject onbrd : responOnbrdList) {
            Long adminorgId;
            List<Map<String, Object>> responList;
            DynamicObject adminorgDy = onbrd.getDynamicObject("aadminorg");
            if (adminorgDy == null || CollectionUtils.isEmpty(responList = responMap.get(adminorgId = Long.valueOf(adminorgDy.getLong("id"))))) continue;
            responOnbrdMap.put(onbrd.getLong("id"), responList.stream().filter(map -> map.get("person") instanceof Long).map(map -> (Long)map.get("person")).collect(Collectors.toList()));
        }
        return responOnbrdMap;
    }

    private Map<Long, List<Long>> bulidLeaderOnbrdMap(List<DynamicObject> leaderOnbrdList, Map<Long, List<Map<String, Object>>> leaderMap) {
        HashMap<Long, List<Long>> leaderOnbrdMap = new HashMap<Long, List<Long>>(leaderOnbrdList.size());
        for (DynamicObject onbrd : leaderOnbrdList) {
            DynamicObject apositionDy = onbrd.getDynamicObject("aposition");
            if (apositionDy == null) continue;
            this.leaderOnbrdMapByRoles(leaderMap, leaderOnbrdMap, onbrd);
        }
        return leaderOnbrdMap;
    }

    private void leaderOnbrdMapByRoles(Map<Long, List<Map<String, Object>>> leaderMap, Map<Long, List<Long>> leaderOnbrdMap, DynamicObject onbrd) {
        Long roleId;
        List<Map<String, Object>> superiorList;
        DynamicObject roleDy = onbrd.getDynamicObject("role");
        if (roleDy != null && !CollectionUtils.isEmpty(superiorList = leaderMap.get(roleId = Long.valueOf(roleDy.getLong("id"))))) {
            leaderOnbrdMap.put(onbrd.getLong("id"), superiorList.stream().filter(map -> map.get("person.id") instanceof Long).map(map -> (Long)map.get("person.id")).collect(Collectors.toList()));
        }
    }

    private Map<Long, List<Map<Long, Map<String, String>>>> buildOnbrdPhoneMap(Map<Long, List<Long>> leaderOnbrdMap, String selProp) {
        ArrayList<Long> personIdList = new ArrayList<Long>();
        for (Map.Entry<Long, List<Long>> entry : leaderOnbrdMap.entrySet()) {
            personIdList.addAll((Collection<Long>)entry.getValue());
        }
        List<Map<String, Object>> personAttachList = this.listBatchPropPersonAttachs(personIdList, selProp, "hrpi_percontact");
        if (CollectionUtils.isEmpty(personAttachList)) {
            return new HashMap<Long, List<Map<Long, Map<String, String>>>>(1);
        }
        HashMap<Long, List<Map<Long, Map<String, String>>>> phoneMap = new HashMap<Long, List<Map<Long, Map<String, String>>>>(leaderOnbrdMap.size());
        for (Map.Entry<Long, List<Long>> entry : leaderOnbrdMap.entrySet()) {
            Long onbrdId = entry.getKey();
            List<Long> pesontTmpList = entry.getValue();
            List<Map<Long, Map<String, String>>> phoneList = this.buildPhoneList(personAttachList, pesontTmpList);
            if (CollectionUtils.isEmpty(phoneList)) continue;
            phoneMap.put(onbrdId, phoneList);
        }
        return phoneMap;
    }

    private List<Map<Long, Map<String, String>>> buildPhoneList(List<Map<String, Object>> personAttachList, Long pesonIdTmp) {
        ArrayList<Map<Long, Map<String, String>>> phoneList = new ArrayList<Map<Long, Map<String, String>>>();
        for (Map<String, Object> map : personAttachList) {
            Long personId = (Long)map.get("person.id");
            String personName = (String)map.get("person.name");
            String phone = (String)map.get("phone");
            String email = (String)map.get("peremail");
            if (HRStringUtils.isEmpty((String)phone) || !pesonIdTmp.equals(personId)) continue;
            HashMap tmpMap = new HashMap(1);
            HashMap<String, String> concatMap = new HashMap<String, String>(16);
            concatMap.put("phone", phone);
            concatMap.put("name", personName);
            concatMap.put("email", email);
            tmpMap.put(personId, concatMap);
            phoneList.add(tmpMap);
        }
        return phoneList;
    }

    private List<Map<Long, Map<String, String>>> buildPhoneList(List<Map<String, Object>> personAttachList, List<Long> pesontTmpList) {
        ArrayList<Map<Long, Map<String, String>>> phoneList = new ArrayList<Map<Long, Map<String, String>>>();
        for (Map<String, Object> map : personAttachList) {
            Long personId = (Long)map.get("person.id");
            String personName = (String)map.get("person.name");
            String phone = (String)map.get("phone");
            String email = (String)map.get("peremail");
            if (HRStringUtils.isEmpty((String)phone) || !pesontTmpList.contains(personId)) continue;
            HashMap tmpMap = new HashMap(1);
            HashMap<String, String> concatMap = new HashMap<String, String>(16);
            concatMap.put("name", personName);
            concatMap.put("phone", phone);
            concatMap.put("email", email);
            tmpMap.put(personId, concatMap);
            phoneList.add(tmpMap);
        }
        return phoneList;
    }

    private Map<Long, List<Map<Long, Map<String, String>>>> buildOnbrdPhoneMap(List<Long> personIdList, Map<Long, Long> onbrdMap, String selProp) {
        List<Map<String, Object>> personAttachList = this.listBatchPropPersonAttachs(personIdList, selProp, "hrpi_percontact");
        if (CollectionUtils.isEmpty(personAttachList)) {
            return new HashMap<Long, List<Map<Long, Map<String, String>>>>(1);
        }
        HashMap<Long, List<Map<Long, Map<String, String>>>> phoneMap = new HashMap<Long, List<Map<Long, Map<String, String>>>>(onbrdMap.size());
        for (Map.Entry<Long, Long> entry : onbrdMap.entrySet()) {
            Long onbrdId = entry.getKey();
            Long pesonIdTmp = entry.getValue();
            List<Map<Long, Map<String, String>>> phoneList = this.buildPhoneList(personAttachList, pesonIdTmp);
            if (CollectionUtils.isEmpty(phoneList)) continue;
            phoneMap.put(onbrdId, phoneList);
        }
        return phoneMap;
    }

    private void checkRepeatKey(Map<String, Object> checkPersonMap, StringBuilder strBuild, String type, boolean isValidForbidden) {
        if (checkPersonMap.get(type) != null) {
            ArrayList checkResultList = (ArrayList)checkPersonMap.get(type);
            this.buildMsg(strBuild, checkResultList, isValidForbidden);
        }
    }

    private void buildMsg(StringBuilder strBuild, List<Map<String, Object>> checkResultList, boolean isValidForbidden) {
        if (!CollectionUtils.isEmpty(checkResultList)) {
            for (Map<String, Object> bosMap : checkResultList) {
                String repeatKey = (String)bosMap.get("repeatkey");
                if (strBuild.toString().contains(repeatKey) || isValidForbidden && !HRStringUtils.equals((String)bosMap.get("isforbidden").toString(), (String)"0")) continue;
                strBuild.append(repeatKey).append('-');
            }
        }
    }

    private Map<String, String> buildMsgMap() {
        HashMap<String, String> buildMap = new HashMap<String, String>(4);
        buildMap.put("phone", ResManager.loadKDString((String)"\"\u8054\u7cfb\u7535\u8bdd\"", (String)"HomToHrpi_1", (String)"hr-hom-business", (Object[])new Object[0]));
        buildMap.put("number", ResManager.loadKDString((String)"\"\u5de5\u53f7\"", (String)"HomToHrpi_2", (String)"hr-hom-business", (Object[])new Object[0]));
        buildMap.put("email", ResManager.loadKDString((String)"\"\u7535\u5b50\u90ae\u7bb1\"", (String)"HomToHrpi_3", (String)"hr-hom-business", (Object[])new Object[0]));
        buildMap.put("cardno", ResManager.loadKDString((String)"\"\u8bc1\u4ef6\u53f7\u7801\"", (String)"HomToHrpi_4", (String)"hr-hom-business", (Object[])new Object[0]));
        return buildMap;
    }

    @Override
    public DynamicObject[] listFieldsFilterInfo(String selectFields, QFilter custFilter, String entityName) {
        LOGGER.info("HomToHrpiAppService_listFieldsFilterInfo_entityName:{},selectFields:{}", (Object)entityName, (Object)selectFields);
        try {
            Object[] result = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{selectFields, custFilter, entityName});
            LOGGER.info("HomToHrpiAppService_listFieldsFilterInfo_size:{}", (Object)(ArrayUtils.isEmpty((Object[])result) ? 0 : result.length));
            return result;
        }
        catch (Exception ext) {
            LOGGER.error("HomToHrpiAppService_listFieldsFilterInfo_error", (Throwable)ext);
            return null;
        }
    }

    @Override
    public Map<String, Map<String, Object>> queryEmployeeInfo(Map<String, Object> var1) {
        LOGGER.info("###IHRPIPersonGenericQueryService.queryEmployeeInfo params:{}", var1);
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericQueryService", (String)"queryEmployeeInfo", (Object[])new Object[]{var1});
    }

    @Override
    public Map<String, List<DynamicObject>> getHCFInfoForReOnboard(Long employeeId) {
        LOGGER.info("###IHPFSPersonChgService.getHCFInfoForReOnboard params:{}", (Object)employeeId);
        return (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getHCFInfoForReOnboard", (Object[])new Object[]{employeeId});
    }

    @Override
    public DynamicObject[] queryAppointRemovErels(Long employeeId, String appdispatchnum) {
        LOGGER.info("###HomToHrpiAppService.queryAppointRemovErels param employeeId:{},appdispatchnum:{}", (Object)employeeId, (Object)appdispatchnum);
        String selectFields = "company,adminorgvid,positionvid,empposrel,jobvid,stdpositionvid,apositiontype";
        QFilter qFilters = new QFilter("employee", "=", (Object)employeeId).and(new QFilter("appointdispatchnymber", "=", (Object)appdispatchnum)).and(new QFilter("appointtypestatus", "=", (Object)"1")).and(new QFilter("empposrel", "=", (Object)0)).and(new QFilter("businessstatus", "=", (Object)"1"));
        String entityName = "hrpi_appointremoverel";
        DynamicObject[] appointRemovErels = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{selectFields, qFilters, entityName});
        LOGGER.info("###HomToHrpiAppService.queryAppointRemovErels result appointRemovErels length is :{}", (Object)appointRemovErels.length);
        return appointRemovErels;
    }
}

