/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.mobile;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.web.dto.LoginConfigDTO;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.tcc.TCCGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.HtmlAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.model.org.staff.StaffUseParam;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.impl.onbrd.OnbrdConfirmAppServiceImpl;
import kd.hr.hom.business.application.impl.rule.OnbrdConfirmValidatorService;
import kd.hr.hom.business.application.mobile.IMobCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.application.utils.HomAppConfigUtil;
import kd.hr.hom.business.domain.repository.common.BaseDataRepository;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.AcceptManageEntity;
import kd.hr.hom.common.entity.GuideEntity;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.ExceptionCauseEnum;
import kd.sdk.hr.hom.business.onbrd.IConfirmOnbrdService;

public class MobMobCommonAppServiceImpl
implements IMobCommonAppService {
    private static final Log LOGGER = LogFactory.getLog(MobMobCommonAppServiceImpl.class);
    private static final String ERROR_TYPE1 = "1";
    private static final String ERROR_TYPE2 = "2";
    private static final String ERROR_TYPE3 = "3";
    private static final String SELECT_PROPERTIES = "id,exceptioncause,checkinstatus,ischeckinexception,checkintype";

    @Override
    public void showPageWithOnbrdId(IFormView formView, Long onbrdId, String entityNum) {
        String caption = ResManager.loadKDString((String)"\u5165\u804c\u670d\u52a1\u5e73\u53f0", (String)"MobMobCommonAppServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]);
        this.showPageWithOnbrdId(formView, onbrdId, entityNum, caption);
    }

    @Override
    public void showPageWithOnbrdId(IFormView formView, Long onbrdId, String entityNum, String caption) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(entityNum);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        if (onbrdId != null) {
            showParameter.setCustomParam("onbrdid", (Object)onbrdId);
        }
        if (HRStringUtils.isNotEmpty((String)caption)) {
            showParameter.setCaption(caption);
        } else {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5165\u804c\u670d\u52a1\u5e73\u53f0", (String)"MobMobCommonAppServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        formView.showForm((FormShowParameter)showParameter);
    }

    @Override
    public void showPageNoBackWithOnbrdId(IFormView formView, Long onbrdId, String entityNum, String caption) {
        this.showPageWithOnbrdId(formView, onbrdId, entityNum, caption);
        formView.close();
    }

    @Override
    public void showHomePage(IFormView formView, Long onbrdId) {
        this.showPageWithOnbrdId(formView, onbrdId, "hom_homepage");
    }

    @Override
    public void showReservationPage(IFormView formView, Long onbrdId) {
        this.showReservationPage(formView, onbrdId, null);
    }

    @Override
    public void showReservationPage(IFormView formView, Long onbrdId, OperationStatus operationStatus) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("hom_mobreservation");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        if (operationStatus != null) {
            showParameter.setStatus(operationStatus);
            showParameter.setCustomParam("operationStatus", (Object)operationStatus.name());
        }
        if (onbrdId != null) {
            showParameter.setCustomParam("onbrdid", (Object)onbrdId);
        }
        IFormView parentView = formView.getParentView();
        if (HRStringUtils.equals((String)"hom_mobreservation", (String)formView.getEntityId()) && parentView != null) {
            parentView.showForm((FormShowParameter)showParameter);
            formView.sendFormAction(parentView);
        } else {
            formView.showForm((FormShowParameter)showParameter);
        }
    }

    @Override
    public void showCheckinPage(IFormView formView, Long onbrdId) {
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdId);
        DynamicObject onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBill("checkinstatus", new QFilter[]{qFilter});
        if (HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            return;
        }
        String checkinStatus = onbrdBillInfo.getString("checkinstatus");
        if (HRStringUtils.equals((String)CheckinStatusEnum.WAIT_CHECKIN.toString(), (String)checkinStatus)) {
            this.showPageWithOnbrdId(formView, onbrdId, "hom_checkinwait");
        } else {
            this.showPageWithOnbrdId(formView, onbrdId, "hom_checkined");
        }
    }

    @Override
    public void shwowAcceptView(IFormView formView, List<AcceptManageEntity> imgAndAttachList, String acceptStatus, Long onbrdId) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("hom_datacheck");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("acceptentity", imgAndAttachList);
        showParameter.setCustomParam("status", (Object)acceptStatus);
        if (onbrdId != null) {
            showParameter.setCustomParam("onbrdid", (Object)onbrdId);
        }
        formView.showForm((FormShowParameter)showParameter);
    }

    @Override
    public void showClickInfo(IFormView formView, Long onbrdId) {
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.setFormId("hom_collectphone_mob");
        showParameter.setHasRight(true);
        if (onbrdId != null) {
            showParameter.setCustomParam("onbrdid", (Object)onbrdId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        formView.showForm((FormShowParameter)showParameter);
    }

    @Override
    public void doCheckinConfirm(IFormView formView, Long onbrdId, String errType) {
        LOGGER.info("Start to doCheckinConfirm");
        Object[] onbrdBillInfos = new OnbrdConfirmAppServiceImpl().getOnbrdBillsForShowPage(new Long[]{onbrdId});
        if (HRArrayUtils.isEmpty((Object[])onbrdBillInfos)) {
            LOGGER.info("cannot find onbrdBill");
            return;
        }
        Object simpleDynamicObject = onbrdBillInfos[0];
        List<String> fieldList = Arrays.asList("certificatenumber", "employeeno", "peremail", "phone");
        Map<Long, String> resultMap = IHomToHrpiAppService.getInstance().validAllPersonWithTip(Arrays.asList(onbrdBillInfos), fieldList);
        if (!CollectionUtils.isEmpty(resultMap)) {
            StringBuilder result = new StringBuilder();
            String msg = ResManager.loadKDString((String)"\u4e0e\u5728\u804c\u4eba\u5458\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HomToHrpi_0", (String)"hr-hom-business", (Object[])new Object[0]);
            for (Map.Entry<Long, String> entry : resultMap.entrySet()) {
                String fieldDisplayName = entry.getValue();
                if (HRStringUtils.isEmpty((String)fieldDisplayName)) continue;
                result.append(fieldDisplayName).append(msg).append(';');
            }
            if (StringUtils.isNotBlank((CharSequence)result)) {
                formView.showTipNotification(ResManager.loadKDString((String)result.toString(), (String)"MobMobCommonAppServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]));
                return;
            }
        }
        Long userId = RequestContext.get().getCurrUserId();
        if (!CheckinStatusEnum.WAIT_CHECKIN.getValue().equals(simpleDynamicObject.getString("checkinstatus"))) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u62a5\u5230\u72b6\u6001\u5df2\u66f4\u6539\uff0c\u8bf7\u9000\u51fa\u81f3\u9996\u9875\u91cd\u65b0\u8fdb\u5165\u3002", (String)"MobMobCommonAppServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]));
            return;
        }
        try {
            Object obj = HomAppConfigUtil.getHomAppParam("checkinconfirm", simpleDynamicObject.getLong("org.id"));
            Boolean isOpen = obj == null ? Boolean.FALSE : (Boolean)obj;
            LOGGER.info("HomAppConfig_Checkin\uff1a{}", (Object)isOpen);
            if (errType.equals(ERROR_TYPE1) || errType.equals(ERROR_TYPE2) || errType.equals(ERROR_TYPE3)) {
                if (this.checkInBackward(formView, onbrdId, errType)) {
                    return;
                }
            } else {
                if (!IOnbrdBillDomainService.getInstance().isAuditPass((DynamicObject)simpleDynamicObject)) {
                    this.updateWithExceptionCause(onbrdId, ExceptionCauseEnum.NO_COMPLETE_AUDIT.getNumber());
                    this.showPageNoBackWithOnbrdId(formView, onbrdId, "hom_checkinsuccess", null);
                    return;
                }
                if (isOpen.booleanValue()) {
                    this.updateToWaitConfirm(onbrdId);
                    this.showPageNoBackWithOnbrdId(formView, onbrdId, "hom_checkinsuccess", null);
                } else {
                    this.checkInSuccess(formView, onbrdId, (DynamicObject)simpleDynamicObject, userId);
                }
            }
        }
        catch (KDException kdException) {
            LOGGER.error((Throwable)kdException);
            formView.showErrMessage(kdException.getMessage(), " Fail to do doCheckinConfirm ! ");
        }
    }

    private DynamicObject updateWithExceptionCause(Long onbrdId, String errType) {
        DynamicObject onbrdBillInfo = this.getOnbrdDynamicObject(onbrdId, SELECT_PROPERTIES);
        if (onbrdBillInfo == null) {
            return null;
        }
        onbrdBillInfo.set("exceptioncause", (Object)errType);
        onbrdBillInfo.set("checkinstatus", (Object)CheckinStatusEnum.CHECKIN_EXCEPTION.getValue());
        onbrdBillInfo.set("ischeckinexception", (Object)ERROR_TYPE1);
        onbrdBillInfo.set("checkintype", (Object)ERROR_TYPE1);
        IOnbrdBillDomainService.getInstance().saveOnbrdBillInfo(onbrdBillInfo);
        return onbrdBillInfo;
    }

    private DynamicObject updateToWaitConfirm(Long onbrdId) {
        DynamicObject onbrdBillInfo = this.getOnbrdDynamicObject(onbrdId, SELECT_PROPERTIES);
        if (onbrdBillInfo == null) {
            return null;
        }
        onbrdBillInfo.set("checkinstatus", (Object)CheckinStatusEnum.CHECKIN_WAIT_CONFIRM.getValue());
        onbrdBillInfo.set("ischeckinexception", (Object)"0");
        onbrdBillInfo.set("checkintype", (Object)ERROR_TYPE1);
        IOnbrdBillDomainService.getInstance().saveOnbrdBillInfo(onbrdBillInfo);
        return onbrdBillInfo;
    }

    private DynamicObject getOnbrdDynamicObject(Long onbrdId, String selectProperties) {
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdId);
        DynamicObject onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBill(selectProperties, new QFilter[]{qFilter});
        if (Objects.isNull(onbrdBillInfo)) {
            LOGGER.info("onbrdBillInfo_null");
            return null;
        }
        return onbrdBillInfo;
    }

    private boolean checkInBackward(IFormView formView, Long onbrdId, String errType) {
        DynamicObject onbrdBillInfo = this.updateWithExceptionCause(onbrdId, errType);
        if (Objects.isNull(onbrdBillInfo)) {
            LOGGER.info("onbrdBillInfo_null");
            return true;
        }
        this.showPageNoBackWithOnbrdId(formView, onbrdId, "hom_checkinbackward", errType);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInSuccess(IFormView formView, Long onbrdId, DynamicObject simpleDynamicObject, Long userId) {
        if (!new OnbrdConfirmValidatorService().checkCertCountForConfirmNoTips(1, "btn_confirmcheckin")) {
            this.updateWithExceptionCause(onbrdId, ExceptionCauseEnum.OUTOF_LICENSE.getNumber());
            this.showPageNoBackWithOnbrdId(formView, onbrdId, "hom_checkinsuccess", null);
            return;
        }
        boolean staffTryFail = false;
        StaffUseParam staffUseParam = IStaffUseService.getInstance().getStaffUseParamTCCBeforeOnbrd((List<Long>)ImmutableList.of((Object)onbrdId));
        try (TXHandle txHandle = TX.required();){
            TCCGlobalSession.Try((String)"hom_IHAOSStaffUseService", (String)"hrmp", (String)"haos", (String)"IHAOSStaffUseService", (Param)staffUseParam, null, (DBRoute)DBRoute.of((String)"hrb.hom"));
            txHandle.commit();
        }
        if (staffTryFail) {
            this.updateWithExceptionCause(onbrdId, ExceptionCauseEnum.OUTOF_STAFFUSE.getNumber());
            this.showPageNoBackWithOnbrdId(formView, onbrdId, "hom_checkinsuccess", null);
            return;
        }
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IConfirmOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IConfirmOnbrdService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.beforeConfirmOnbrds(new Object[]{onbrdId});
            return null;
        });
        Map<String, Object> resultMap = new OnbrdConfirmAppServiceImpl().doComfirmWithSimpleInfo(userId, simpleDynamicObject, "btn_confirmcheckin");
        Boolean isSuccess = (Boolean)resultMap.get("isSuccess");
        if (!isSuccess.booleanValue()) {
            String failReason = resultMap.get("failReason").toString();
            formView.showTipNotification(failReason);
        } else {
            this.showPageNoBackWithOnbrdId(formView, onbrdId, "hom_checkinsuccess", null);
        }
    }

    @Override
    public void showViewByDyos(String flexPanel, IFormView formView, Long onbrdId, DynamicObjectCollection coll) {
        this.createShowPanel(flexPanel, coll.size(), formView);
        for (int index = 0; index < coll.size(); ++index) {
            FormShowParameter showParameter = new FormShowParameter();
            DynamicObject dyo = (DynamicObject)coll.get(index);
            if (HRObjectUtils.isEmpty((Object)dyo.getDynamicObject("guideconfig"))) continue;
            String imgUrl = dyo.getDynamicObject("guideconfig").getString("selectabstractpicture");
            String checkinName = dyo.getDynamicObject("guideconfig").getString("abstracttitle");
            String checkinRemark = dyo.getDynamicObject("guideconfig").getString("simplename");
            if (checkinRemark.length() > 27) {
                checkinRemark = checkinRemark.substring(0, 27) + "...";
            }
            if ("mobilelap".equalsIgnoreCase(flexPanel)) {
                showParameter.setFormId("hom_guidpreview");
            } else {
                showParameter.setFormId("hom_homecheckin");
            }
            if (index == coll.size() - 1) {
                showParameter.setCustomParam("index", (Object)(index + "last"));
            } else {
                showParameter.setCustomParam("index", (Object)index);
            }
            showParameter.setCustomParam("imageap", (Object)imgUrl);
            showParameter.setCustomParam("checkinname", (Object)checkinName);
            showParameter.setCustomParam("checkinremark", (Object)checkinRemark);
            showParameter.setCustomParam("id", (Object)dyo.getLong("guideconfig.id"));
            if (onbrdId != null) {
                showParameter.setCustomParam("onbrdid", (Object)onbrdId);
            }
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(flexPanel + index);
            showParameter.setStatus(OperationStatus.EDIT);
            formView.showForm(showParameter);
        }
    }

    @Override
    public void showNavigationbarView(IFormView formView, Long onbrdId, String panelKey) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("hom_navigationbar");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(panelKey);
        if (onbrdId != null) {
            showParameter.setCustomParam("onbrdid", (Object)onbrdId);
        }
        formView.showForm((FormShowParameter)showParameter);
    }

    @Override
    public void showGuideDetail(IFormView formView, GuideEntity entity, Long onbrdId) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("hom_guidedetail");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("entity", (Object)entity);
        if (onbrdId != null) {
            showParameter.setCustomParam("onbrdid", (Object)onbrdId);
        }
        formView.showForm((FormShowParameter)showParameter);
    }

    @Override
    public String getNavigationBarLogo(Long onbrdId) {
        LoginConfigDTO loginConfigDTO;
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdId);
        IOnbrdBillDomainService onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
        DynamicObject onbrdBillInfo = onbrdBillDomainService.findOnbrdBill("loginconfig", new QFilter[]{qFilter});
        String loginConfigNumber = onbrdBillInfo.getString("loginconfig");
        if (HRStringUtils.isEmpty((String)loginConfigNumber)) {
            Map<Long, String> mobLoginConfigMap = IOnbrdCommonAppService.getInstance().getMobLoginConfigMap((Collection<Long>)ImmutableList.of((Object)onbrdId));
            loginConfigNumber = mobLoginConfigMap.get(onbrdId);
            onbrdBillInfo.set("loginconfig", (Object)loginConfigNumber);
            onbrdBillDomainService.saveOnbrdBillInfo(onbrdBillInfo);
        }
        return (loginConfigDTO = (LoginConfigDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSLoginService", (String)"getHrLoginConfig", (Object[])new Object[]{loginConfigNumber})) == null ? "" : loginConfigDTO.getBannerPic();
    }

    @Override
    public String getTipByHRCS(IFormView formView, Long id, String key) {
        String content;
        HRBaseServiceHelper ERVICE_HELPER = new HRBaseServiceHelper("hrcs_prompt");
        QFilter qFilter = new QFilter("id", "=", (Object)id).and("enable", "=", (Object)ERROR_TYPE1);
        DynamicObject[] dynamicObjects = ERVICE_HELPER.query("id,selectcontent", new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            LOGGER.info("===getTipByHRCS_promptContentDy_nothing:{}===", (Object)id);
            return null;
        }
        Long promId = dynamicObjects[0].getLong("id");
        String selectContentType = dynamicObjects[0].getString("selectcontent");
        DynamicObject promptContentDy = IHomToHrcsAppService.getInstance().getTipByHRCS(promId);
        if (HRObjectUtils.isEmpty((Object)promptContentDy)) {
            return null;
        }
        LOGGER.info("===getTipByHRCS promptContentDy:{}===", (Object)promptContentDy);
        String string = content = ERROR_TYPE1.equals(selectContentType) ? promptContentDy.getString("syscontent") : promptContentDy.getString("promptcontent");
        if (key != null) {
            HtmlAp htmlAp = new HtmlAp();
            htmlAp.setKey(key);
            htmlAp.setHtmlContent(content);
            htmlAp.setDirection("column");
            formView.updateControlMetadata(key, htmlAp.createControl());
        }
        String result = ERROR_TYPE1.equals(selectContentType) ? promptContentDy.getString("syscontenttext") : promptContentDy.getString("contenttext");
        return result;
    }

    @Override
    public Long getLastestVersionPrivacyId(Long onbrdBillId) {
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
        IOnbrdBillDomainService onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
        String properties = "candidate" + "," + "loginconfig";
        DynamicObject onbrdBillInfo = onbrdBillDomainService.findOnbrdBill(properties, new QFilter[]{qFilter});
        String loginConfigNumber = onbrdBillInfo.getString("loginconfig");
        if (HRStringUtils.isEmpty((String)loginConfigNumber)) {
            Map<Long, String> mobLoginConfigMap = IOnbrdCommonAppService.getInstance().getMobLoginConfigMap((Collection<Long>)ImmutableList.of((Object)onbrdBillId));
            loginConfigNumber = mobLoginConfigMap.get(onbrdBillId);
            onbrdBillInfo.set("loginconfig", (Object)loginConfigNumber);
            onbrdBillDomainService.saveOnbrdBillInfo(onbrdBillInfo);
        }
        Long candidateId = onbrdBillInfo.getLong("candidate.id");
        return this.getLastestVersionPrivacyId(candidateId, loginConfigNumber);
    }

    @Override
    public void showPrivacyContent(IFormView formView, Long onbrdId, String targetPanelKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hbss_privacysign");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.setCustomParam("privacyId", (Object)this.getLastestVersionPrivacyId(onbrdId));
        formShowParameter.setCustomParam("hiddenBtn", (Object)Boolean.TRUE.toString());
        if (HRStringUtils.isNotEmpty((String)targetPanelKey)) {
            formShowParameter.getOpenStyle().setTargetKey(targetPanelKey);
        }
        formView.showForm(formShowParameter);
    }

    private Long getLastestVersionPrivacyId(Long candidateId, String loginConfigNumber) {
        String properties = "number" + ',' + "usertype" + ',' + "privacystmt";
        DynamicObject loginConfigInfo = IBaseDataDomainService.getInstance().getBaseDataInfoByNumber("hbss_loginconfig", loginConfigNumber, properties);
        if (HRObjectUtils.isEmpty((Object)loginConfigInfo)) {
            return 0L;
        }
        DynamicObject privacystmt = loginConfigInfo.getDynamicObject("privacystmt");
        QFilter qFilter = new QFilter("id", "=", (Object)privacystmt.getLong("id"));
        String privacyProperties = "number" + ',' + "form" + ',' + "locale";
        Object[] privacyInfos = BaseDataRepository.getPrivacyStatementInfos(privacyProperties, new QFilter[]{qFilter});
        if (HRArrayUtils.isEmpty((Object[])privacyInfos)) {
            return 0L;
        }
        Object privacyInfo = privacyInfos[0];
        DynamicObject usertype = loginConfigInfo.getDynamicObject("usertype");
        HashMap requestMap = Maps.newHashMapWithExpectedSize((int)4);
        requestMap.put("user", candidateId.toString());
        requestMap.put("userType", usertype.getLong("id"));
        HashMap group = Maps.newHashMapWithExpectedSize((int)1);
        String formNumber = privacyInfo.getDynamicObject("form").getString("number");
        LOGGER.info(formNumber);
        group.put(formNumber, ImmutableSet.of((Object)privacyInfo.getDynamicObject("locale").getLong("id")));
        requestMap.put("group", group);
        requestMap.put("system", Boolean.FALSE);
        Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPrivacyService", (String)"getNewVersionPrivacy", (Object[])new Object[]{requestMap});
        LOGGER.info(JSONObject.toJSONString((Object)responseMap));
        if (!HRStringUtils.equals((String)responseMap.get("responseCode").toString(), (String)"200")) {
            return 0L;
        }
        List dataList = (List)responseMap.get("data");
        Map data = (Map)dataList.get(0);
        Long privacyId = HRJSONUtils.getLongValOfCustomParam(data.get("id"));
        return privacyId == null ? Long.valueOf(0L) : privacyId;
    }

    private void createShowPanel(String key, int size, IFormView formView) {
        FlexPanelAp headPanelAp = this.createColumnFlexPanel(key).build();
        for (int index = 0; index < size; ++index) {
            HRFlexPanelAp.Builder flexPanelBuilder = this.createColumnFlexPanel(key + index);
            flexPanelBuilder.setMarginTop("8px");
            headPanelAp.getItems().add(flexPanelBuilder.build());
        }
        formView.updateControlMetadata(key, headPanelAp.createControl());
    }

    private HRFlexPanelAp.Builder createColumnFlexPanel(String key) {
        return new HRFlexPanelAp.Builder(key).setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").setGrow(0).setShrink(0);
    }

    @Override
    public DynamicObject getOnbrdtCity(Long onbrdBillId) {
        if (Objects.isNull(onbrdBillId)) {
            return null;
        }
        DynamicObject onbrdBillInfo = this.getOnbrdDynamicObject(onbrdBillId, "onbrdtcity");
        if (onbrdBillInfo == null) {
            return null;
        }
        DynamicObject onbrdtCity = onbrdBillInfo.getDynamicObject("onbrdtcity");
        if (Objects.isNull(onbrdtCity)) {
            LOGGER.info("onbrdtCity_null");
            return null;
        }
        QFilter qFilter1 = new QFilter("id", "=", (Object)onbrdtCity.getLong("id"));
        HRBaseServiceHelper HOM_PLACEENTRY_HELPER = new HRBaseServiceHelper("hom_placeentry");
        return HOM_PLACEENTRY_HELPER.loadDynamicObject(qFilter1);
    }

    @Override
    public boolean checkUserIdAndPhone(String userId, String phone) {
        if (HRStringUtils.isEmpty((String)userId)) {
            LOGGER.info("userId cannot be empty");
            return false;
        }
        if (!phone.contains("-")) {
            phone = phone.replace("+86", "+86-");
        }
        Long candidateId = Long.parseLong(userId.trim());
        return this.checkCandidateIdAndPhone(candidateId, phone);
    }

    private boolean checkCandidateIdAndPhone(Long candidateId, String phone) {
        String properties = "phone" + ',' + "candidate";
        Map<Long, DynamicObject> queryResult = IHcfDataDomainService.getInstance().querySingleRowEntity((Collection<Long>)ImmutableSet.of((Object)candidateId), "hcf_cancontactinfo", properties);
        DynamicObject contactInfo = queryResult.get(candidateId);
        return !HRObjectUtils.isEmpty((Object)contactInfo) && HRStringUtils.equals((String)phone, (String)contactInfo.getString("phone"));
    }

    @Override
    public boolean checkUserIdAndEmail(String userId, String email) {
        if (HRStringUtils.isEmpty((String)userId)) {
            LOGGER.info("userId cannot be empty");
            return false;
        }
        Long candidateId = Long.parseLong(userId.trim());
        String properties = "peremail,candidate";
        Map<Long, DynamicObject> queryResult = IHcfDataDomainService.getInstance().querySingleRowEntity((Collection<Long>)ImmutableSet.of((Object)Long.parseLong(userId.trim())), "hcf_cancontactinfo", properties);
        DynamicObject contactInfo = queryResult.get(candidateId);
        return !HRObjectUtils.isEmpty((Object)contactInfo) && HRStringUtils.equals((String)email, (String)contactInfo.getString("peremail"));
    }
}

