/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.mq;

import java.text.MessageFormat;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;

public class ActivityConsumer
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(ActivityConsumer.class);

    public void onMessage(Object obj, String messageId, boolean flag, MessageAcker messageAcker) {
        LOGGER.info(MessageFormat.format("ActivityConsumer.onMessage-start-obj is {0}", obj));
        if (obj instanceof Map) {
            Map map = (Map)obj;
            String eventType = map.getOrDefault("eventType", "");
            LOGGER.info(MessageFormat.format("ActivityConsumer.onMessage-eventType is {0}", eventType));
            if (StringUtils.isNotBlank((CharSequence)eventType)) {
                return;
            }
            Long bizBillId = HRJSONUtils.getLongValOfCustomParam(map.get("bizBillId"));
            QFilter onbrdFilter = new QFilter("onbrd", "=", (Object)bizBillId);
            try (TXHandle txHandle = TX.required();){
                try {
                    IActivityDomainService.getInstance().workflowToDealActivityData(map, onbrdFilter);
                }
                catch (Exception exception) {
                    LOGGER.error("ActivityConsumer.onMessage-end-bizBillId {0},exception_is {1}:", (Object)bizBillId, (Object)exception);
                    txHandle.markRollback();
                    messageAcker.deny(messageId);
                    if (txHandle != null) {
                        if (var10_10 != null) {
                            try {
                                txHandle.close();
                            }
                            catch (Throwable throwable) {
                                var10_10.addSuppressed(throwable);
                            }
                        } else {
                            txHandle.close();
                        }
                    }
                    return;
                }
            }
            messageAcker.ack(messageId);
            LOGGER.info(MessageFormat.format("ActivityConsumer.onMessage-end-bizBillId is {0}", bizBillId));
        }
    }
}

