/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.onbrd;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdReservationService;
import kd.hr.hom.business.application.utils.HomAppConfigUtil;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;

public class OnbrdReservationServiceImpl
implements IOnbrdReservationService {
    private static final Log LOGGER = LogFactory.getLog(OnbrdReservationServiceImpl.class);
    private static final String PROPERTIES = "id,preenrollstatus,preeneffectdate,preenonbrdtcity,checkinstatus,effectdate,onbrdtcity,validuntil,org,handler";

    @Override
    public boolean doReservation(IFormView formView, Long onbrdBillId, Date preEffectDate, DynamicObject preOnbrdCity) {
        if (this.checkBeforeReservation(onbrdBillId)) {
            return this.doSomethingsWithReservation(formView, onbrdBillId, preEffectDate, preOnbrdCity);
        }
        LOGGER.info("OnbrdReservationServiceImpl_doReservation_check_error");
        formView.showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5165\u804c\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u8bf7\u8054\u7cfbHR\u3002", (String)"OnbrdReservationServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]));
        return false;
    }

    @Override
    public boolean cancelReservation(IFormView formView, Long onbrdBillId) {
        if (this.checkBeforeReservation(onbrdBillId)) {
            return this.doCancelWithReservation(formView, onbrdBillId);
        }
        formView.showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5165\u804c\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u8bf7\u8054\u7cfbHR\u3002", (String)"OnbrdReservationServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]));
        return false;
    }

    private boolean checkBeforeReservation(Long onbrdBillId) {
        String properties = "id" + ',' + "enrollstatus" + ',' + "checkinstatus";
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBill(properties, new QFilter[]{qFilter});
        String enrollStatus = onbrdBill.getString("enrollstatus");
        if (HRStringUtils.equals((String)OnbrdStatusEnum.WAIT_ONBRD.getValue(), (String)enrollStatus)) {
            return true;
        }
        LOGGER.info("enrollStatus:{}", (Object)enrollStatus);
        return false;
    }

    /*
     * Loose catch block
     */
    private boolean doSomethingsWithReservation(IFormView formView, Long onbrdBillId, Date preEffectDate, DynamicObject preOnbrdCity) {
        Date effectDateOld;
        DynamicObject onbrdBill;
        boolean isSuccess;
        Throwable throwable;
        TXHandle txHandle;
        block29: {
            boolean bl;
            block30: {
                block31: {
                    IOnbrdBillDomainService onbrdBillDomainService;
                    block26: {
                        boolean bl2;
                        block27: {
                            block28: {
                                txHandle = TX.required();
                                throwable = null;
                                isSuccess = true;
                                onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
                                QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
                                onbrdBill = onbrdBillDomainService.findOnbrdBill(PROPERTIES, new QFilter[]{qFilter});
                                if (!HRObjectUtils.isEmpty((Object)onbrdBill)) break block26;
                                LOGGER.info("cannot find onbrdBill");
                                formView.showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnbrdReservationServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]));
                                bl2 = false;
                                if (txHandle == null) break block27;
                                if (throwable == null) break block28;
                                try {
                                    txHandle.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block27;
                            }
                            txHandle.close();
                        }
                        return bl2;
                    }
                    Object obj = HomAppConfigUtil.getHomAppParam("reservationconfirm", onbrdBill.getLong("org.id"));
                    Boolean isOpen = obj == null ? Boolean.FALSE : (Boolean)obj;
                    LOGGER.info("OnbrdReservationServiceImpl_doSomethingsWithReservation:{}", (Object)isOpen);
                    effectDateOld = onbrdBill.getDate("effectdate");
                    onbrdBill.set("preenrollstatus", (Object)(isOpen != false ? PreEnrollStatusEnum.WAIT_CONFIRM_RESERVATION.getValue() : PreEnrollStatusEnum.HAS_RESERVATION.getValue()));
                    onbrdBill.set("preeneffectdate", (Object)preEffectDate);
                    onbrdBill.set("preenonbrdtcity", (Object)preOnbrdCity.getLong("id"));
                    onbrdBill.set("effectdate", (Object)preEffectDate);
                    onbrdBill.set("onbrdtcity", (Object)preOnbrdCity.getLong("id"));
                    onbrdBillDomainService.setWaitCheckin(new DynamicObject[]{onbrdBill});
                    onbrdBillDomainService.saveOnbrdBillInfo(onbrdBill);
                    if (!isOpen.booleanValue()) break block29;
                    bl = true;
                    if (txHandle == null) break block30;
                    if (throwable == null) break block31;
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block30;
                }
                txHandle.close();
            }
            return bl;
        }
        try {
            String taskStatus = IOnbrdCommonAppService.getInstance().getActTaskStatus(onbrdBillId, ActivityNumberEnum.APPOINTMENT.getId());
            LOGGER.info("onbrdBillId:{}, taskStatus:{}", (Object)onbrdBillId.toString(), (Object)taskStatus);
            if (HRStringUtils.equals((String)ActivityStatusEnum.PROCESSING.getValue(), (String)taskStatus)) {
                DynamicObject handler = onbrdBill.getDynamicObject("handler");
                Tuple<Boolean, String> executeResult = this.executeActivityTask(onbrdBillId, preEffectDate, effectDateOld, handler);
                isSuccess = (Boolean)executeResult.item1;
                if (!isSuccess) {
                    formView.showErrorNotification((String)executeResult.item2);
                }
            }
            {
                catch (Exception throwable4) {
                    txHandle.markRollback();
                    LOGGER.error((Throwable)throwable4);
                    formView.showErrorNotification(throwable4.getMessage());
                    isSuccess = false;
                }
            }
            if (!isSuccess) {
                txHandle.markRollback();
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        catch (Throwable throwable6) {
            throw throwable6;
        }
        finally {
            if (txHandle != null) {
                if (throwable != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
        ServiceFactory.getService(ISendMessageService.class).sendMessage((Collection<Long>)ImmutableList.of((Object)onbrdBillId), RuleEngineSceneNumberEnum.NOTICE_APPOINTMENT);
        return true;
    }

    private Tuple<Boolean, String> executeActivityTask(Long onbrdBillId, Date preEffectDate, Date effectDateOld, DynamicObject handler) {
        Boolean isSuccess;
        String errorInfo = null;
        try (TXHandle txHandle = TX.notSupported((String)"executeActivityTask");){
            LOGGER.info("not Tx, executeActivityTask");
            ServiceFactory.getService(ICollectService.class).sendNoticeCandidate(onbrdBillId, preEffectDate, effectDateOld);
            OperationResult operationResult = IActivityDomainService.getInstance().batchConsentTask((List<Long>)ImmutableList.of((Object)onbrdBillId), ActivityNumberEnum.APPOINTMENT);
            isSuccess = operationResult.isSuccess();
            if (!isSuccess.booleanValue()) {
                OperateErrorInfo operateErrorInfo = (OperateErrorInfo)operationResult.getAllErrorOrValidateInfo().get(0);
                errorInfo = HRStringUtils.isEmpty((String)operateErrorInfo.getMessage()) ? operateErrorInfo.getErrorCode() : operateErrorInfo.getMessage();
                LOGGER.info(errorInfo);
            }
        }
        return Tuple.create((Object)isSuccess, errorInfo);
    }

    private boolean doCancelWithReservation(IFormView formView, Long onbrdBillId) {
        IOnbrdBillDomainService onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
        DynamicObject onbrdBill = onbrdBillDomainService.findOnbrdBill(PROPERTIES, new QFilter[]{qFilter});
        if (HRObjectUtils.isEmpty((Object)onbrdBill)) {
            LOGGER.info("cannot find onbrdBill");
            formView.showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnbrdReservationServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]));
            return false;
        }
        onbrdBill.set("preenrollstatus", (Object)PreEnrollStatusEnum.WAIT_RESERVATION.getValue());
        onbrdBill.set("preeneffectdate", null);
        onbrdBill.set("preenonbrdtcity", (Object)0L);
        onbrdBill.set("effectdate", null);
        onbrdBill.set("onbrdtcity", (Object)0L);
        onbrdBillDomainService.saveOnbrdBillInfo(onbrdBill);
        return true;
    }
}

