/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.onbrd;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdWorkTableService;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;
import org.apache.commons.lang3.time.DateUtils;

public class OnbrdWorkTableServiceImpl
implements IOnbrdWorkTableService {
    private static final Log LOGGER = LogFactory.getLog(OnbrdWorkTableServiceImpl.class);
    private static final HRBaseServiceHelper onbrdHelp = new HRBaseServiceHelper("hom_onbrdbillbase");
    private static final HRBaseServiceHelper activeInfoHelp = new HRBaseServiceHelper("hom_activeinfobody");
    private static final Map<String, Long> EXCEPTION_MAP = ImmutableMap.builder().put((Object)"5", (Object)ActivityNumberEnum.CHECKININFO.getId()).put((Object)"6", (Object)ActivityNumberEnum.CHECKININFO.getId()).build();
    private static final Map<String, String> PAGE_MAP = ImmutableMap.builder().put((Object)"1", (Object)"hom_personwaitstart").put((Object)"2", (Object)"hom_personwaitonbrd").put((Object)"3", (Object)"hom_personwaitonbrd").put((Object)"4", (Object)"hom_personwaitonbrd").put((Object)"5", (Object)"hom_collaborationalllist").put((Object)"6", (Object)"hom_collaborationalllist").put((Object)"7", (Object)"hom_collaborationalllist").put((Object)"8", (Object)"hom_collaborationalllist").put((Object)"9", (Object)"hom_personwaitonbrd").build();

    @Override
    public Integer getConutForTable(Map<String, Object> map, String type) {
        String appId = (String)map.get("bizappid");
        boolean flag = IOnbrdCommonAppService.getInstance().checkPermission(PAGE_MAP.get(type), "47150e89000000ac", appId);
        LOGGER.info("getConutForTable_page:{},flag:{}", (Object)PAGE_MAP.get(type), (Object)flag);
        if (!flag) {
            return 0;
        }
        QFilter filter = this.getQFiltersByType(map, type);
        if (Objects.isNull(filter)) {
            return 0;
        }
        QFilter permQFilter = this.getPermQFilter(PAGE_MAP.get(type), "QXX0001");
        if (!HRObjectUtils.isEmpty((Object)permQFilter)) {
            filter = filter.and(permQFilter);
        }
        return this.getOnbrdBillInfo(filter);
    }

    @Override
    public List<Long> getOnbsIdForTable(Map<String, Object> map, String type) {
        QFilter filter = this.getQFiltersByType(map, type);
        DynamicObject[] dynamicObjects = this.getOnbrdsInfo(filter);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    @Override
    public Integer getWarningConut(Map<String, Object> map, String type) {
        DynamicObject[] activeInfoBodys;
        String appId = (String)map.get("bizappid");
        LOGGER.info("###OnbrdWorkTableServiceImpl.getWarningConut type:{}", (Object)type);
        if (!IOnbrdCommonAppService.getInstance().checkPermission(PAGE_MAP.get(type), "47150e89000000ac", appId)) {
            return 0;
        }
        LOGGER.info("###OnbrdWorkTableServiceImpl.getWarningConut getOnbsIdForTable");
        List<Long> onbIds = this.getOnbsIdForTable(map, type);
        if (HRCollUtil.isEmpty(onbIds)) {
            return 0;
        }
        LOGGER.info("###OnbrdWorkTableServiceImpl.getWarningConut type:{},onbIds:{}", (Object)type, onbIds);
        QFilter qFilter = new QFilter("onbrdid", "in", onbIds);
        QFilter permQFilter = this.getPermQFilter(PAGE_MAP.get(type), "QXX0001");
        if (!HRObjectUtils.isEmpty((Object)permQFilter)) {
            qFilter = qFilter.and(permQFilter);
        }
        int count = 0;
        for (DynamicObject activeInfoBody : activeInfoBodys = activeInfoHelp.query("id,activityins,onbrdid,activityins,activity", qFilter.toArray())) {
            String actInsTaskStatus = activeInfoBody.getString("activityins.taskstatus");
            Long actId = activeInfoBody.getDynamicObject("activity").getLong("id");
            if (ActivityStatusEnum.TOASSIGN.getValue().equals(actInsTaskStatus) || !EXCEPTION_MAP.get(type).equals(actId)) continue;
            ++count;
        }
        return count;
    }

    public int getOnbrdBillInfo(QFilter filter) {
        return onbrdHelp.count("hom_onbrdbillbase", new QFilter[]{filter, this.getDataPermissionFilter()});
    }

    @Override
    public QFilter getDataPermissionFilter() {
        long userId = RequestContext.get().getCurrUserId();
        PermissionService permissionService = ServiceFactory.getService(PermissionService.class);
        HashMap<String, Boolean> customParams = new HashMap<String, Boolean>();
        customParams.put("isLookUp", Boolean.FALSE);
        return permissionService.getDataPermWithOrg(userId, "1WXB5G9/BL46", "hom_onbrdinfo", customParams);
    }

    public DynamicObject[] getOnbrdsInfo(QFilter filter) {
        return onbrdHelp.query("id", new QFilter[]{filter, this.getDataPermissionFilter()});
    }

    private QFilter getQFiltersByType(Map<String, Object> map, String type) {
        switch (type) {
            case "1": {
                return this.getStatusQFilter(map, OnbrdStatusEnum.WAIT_START.getValue(), null, false);
            }
            case "2": {
                QFilter statusQFilter = this.getStatusQFilter(map, OnbrdStatusEnum.WAIT_ONBRD.getValue(), null, false);
                return statusQFilter.and(new QFilter("preenrollstatus", "=", (Object)PreEnrollStatusEnum.WAIT_RESERVATION.getValue()));
            }
            case "3": {
                return this.getStatusQFilter(map, OnbrdStatusEnum.WAIT_ONBRD.getValue(), CheckinStatusEnum.WAIT_CHECKIN.getValue(), false);
            }
            case "4": {
                return this.getStatusQFilter(map, OnbrdStatusEnum.WAIT_ONBRD.getValue(), CheckinStatusEnum.WAIT_CHECKIN.getValue(), true);
            }
            case "5": {
                return this.getStatusQFilter(map, OnbrdStatusEnum.WAIT_ONBRD.getValue(), CheckinStatusEnum.CHECKIN_EXCEPTION.getValue(), false);
            }
            case "6": {
                return this.getStatusQFilter(map, OnbrdStatusEnum.WAIT_ONBRD.getValue(), CheckinStatusEnum.CHECKIN_EXCEPTION.getValue(), false);
            }
        }
        return null;
    }

    @Override
    public QFilter getStatusQFilter(Map<String, Object> map, String onbrdStatus, String checkinStatus, boolean isDate) {
        QFilter onbrdStatusFilter = new QFilter("enrollstatus", "=", (Object)onbrdStatus);
        if (!Objects.isNull(map) && !Objects.isNull(map.get("adminorgids"))) {
            List adminorgids = (List)map.get("adminorgids");
            QFilter adminorgFilter = new QFilter("aadminorg", "in", (Object)adminorgids);
            onbrdStatusFilter = onbrdStatusFilter.and(adminorgFilter);
        }
        if (!Objects.isNull(map) && !Objects.isNull(map.get("hrbuids"))) {
            List hrbuids = (List)map.get("hrbuids");
            QFilter hrbuFilter = new QFilter("org", "in", (Object)hrbuids);
            onbrdStatusFilter = onbrdStatusFilter.and(hrbuFilter);
        }
        if (!HRStringUtils.isEmpty((String)checkinStatus)) {
            QFilter checkinStatusFilter = new QFilter("checkinstatus", "=", (Object)checkinStatus);
            onbrdStatusFilter = onbrdStatusFilter.and(checkinStatusFilter);
        }
        if (CheckinStatusEnum.CHECKIN_EXCEPTION.getValue().equals(checkinStatus) && !Objects.isNull(map) && !Objects.isNull(map.get("ExceptionCause"))) {
            List list = (List)map.get("ExceptionCause");
            QFilter exceptionCauseFilter = new QFilter("exceptioncause", "in", (Object)list);
            onbrdStatusFilter = onbrdStatusFilter.and(exceptionCauseFilter);
        }
        if (isDate) {
            QFilter effectdateFilterMax = new QFilter("effectdate", "<", (Object)DateUtils.addDays((Date)KDDateUtils.today(), (int)1));
            QFilter effectdateFilterMin = new QFilter("effectdate", ">=", (Object)DateUtils.addDays((Date)KDDateUtils.today(), (int)0));
            onbrdStatusFilter = onbrdStatusFilter.and(effectdateFilterMax);
            onbrdStatusFilter = onbrdStatusFilter.and(effectdateFilterMin);
        }
        return onbrdStatusFilter;
    }

    private Date getDate(boolean today) {
        if (today) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    @Override
    public QFilter getSearchFilter(List<String> nameList, String text, boolean nameIsLike, boolean carIsLike) {
        QFilter qFilter = null;
        if (CollectionUtils.isEmpty(nameList) || HRStringUtils.isEmpty((String)text)) {
            return qFilter;
        }
        for (String str : nameList) {
            if (null == qFilter) {
                qFilter = new QFilter(str, "=", (Object)text);
                continue;
            }
            qFilter.or(new QFilter(str, "=", (Object)text));
        }
        return qFilter;
    }

    @Override
    public QFilter getAllSearchFilter(List<String> nameList, String text, boolean nameIsLike, boolean carIsLike) {
        QFilter searchFilter = this.getSearchFilter(nameList, text, nameIsLike, carIsLike);
        QFilter dataResult = IHomToHrcsAppService.getInstance().getDataResult("hom_onbrdinfo", "QXX0001");
        if (searchFilter == null) {
            searchFilter = dataResult;
        } else if (dataResult != null) {
            searchFilter.and(dataResult);
        }
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAuthorizedBizOrg((Long)RequestContext.getOrCreate().getCurrUserId(), (String)"25", (String)"1WXB5G9/BL46", (String)"hom_apphome", (String)"47150e89000000ac");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
            List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
            if (hasPermOrgs != null && !hasPermOrgs.isEmpty()) {
                QFilter orgQFilter = new QFilter("org", "in", (Object)hasPermOrgs);
                searchFilter = searchFilter == null ? orgQFilter : searchFilter.and(orgQFilter);
            }
            LOGGER.info("hasPermOrgs:{}", (Object)hasPermOrgs);
        }
        return searchFilter;
    }

    @Override
    public DynamicObject[] getDynamicObjects(QFilter qFilter) {
        if (Objects.isNull(qFilter)) {
            return new DynamicObject[0];
        }
        DynamicObject[] dynamicObjects = onbrdHelp.query("id", new QFilter[]{qFilter});
        return dynamicObjects;
    }

    @Override
    public Map<String, Object> getStringObjectMap(HRPageCache pageCache) {
        if (Objects.isNull(pageCache)) {
            return new HashMap<String, Object>();
        }
        List hrbuids = (List)pageCache.get("hrbuids", List.class);
        List adminorgids = (List)pageCache.get("adminorgids", List.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hrbuids", hrbuids);
        map.put("adminorgids", adminorgids);
        return map;
    }

    @Override
    public QFilter getPermQFilter(String entityNumber, String permNumber) {
        QFilter dataResult = IHomToHrcsAppService.getInstance().getDataResult(entityNumber, permNumber);
        HasPermOrgResult orgResult = IHomToHrcsAppService.getInstance().getAllPermOrgs(entityNumber, permNumber);
        if (!HRObjectUtils.isEmpty((Object)orgResult) && !orgResult.hasAllOrgPerm()) {
            List hasPermOrgs = orgResult.getHasPermOrgs();
            dataResult = HRObjectUtils.isEmpty((Object)dataResult) ? new QFilter("org", "in", (Object)hasPermOrgs) : dataResult.and(new QFilter("org", "in", (Object)hasPermOrgs));
        }
        return dataResult;
    }
}

