/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.onbrd;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hbpm.IHrmpExternalService;
import kd.hr.hom.business.application.onbrd.IQueryVidService;

public class QueryVidServiceImpl
implements IQueryVidService {
    private static final Log LOGGER = LogFactory.getLog(QueryVidServiceImpl.class);
    static final String DATE_FORMAT = "yyyyMMdd";
    static IHRAppCache ihrAppCache = HRAppCache.get((String)"kd.hr.hom.business.application.onbrd.IQueryVidService");
    static IHrmpExternalService hrmpService = IHrmpExternalService.getInstance();

    @Override
    public Long queryOrgVid(Long boid, Date effectDate) {
        LOGGER.info("###QueryVidServiceImpl.queryOrgVid, boid:{},effectDate:{}", (Object)boid, (Object)effectDate);
        if (Objects.isNull(boid) || Objects.isNull(effectDate)) {
            return 0L;
        }
        String formatDate = HRDateTimeUtils.format((Date)effectDate, (String)DATE_FORMAT);
        String orgCacheKey = HRStringUtils.format((String)"key:org:{}:{}", (Object[])new Object[]{formatDate, boid});
        Long vid = (Long)ihrAppCache.get(orgCacheKey, Long.class);
        if (Objects.nonNull(vid)) {
            return vid;
        }
        Map<String, Map<String, Object>> adminOrgMap = hrmpService.invokeAdminOrgInfoQuery(Collections.singletonList(boid), effectDate);
        Map<String, Object> deptMapInfo = adminOrgMap.get(boid.toString());
        if (Objects.nonNull(deptMapInfo)) {
            vid = (Long)deptMapInfo.get("vid");
        }
        ihrAppCache.put(orgCacheKey, (Object)Optional.ofNullable(vid).orElseGet(() -> 0L));
        return vid;
    }

    @Override
    public Long queryStdPositionVid(Long boid, Date effectDate) {
        List hisDataList;
        LOGGER.info("###QueryVidServiceImpl.queryStdPositionVid, boid:{},effectDate:{}", (Object)boid, (Object)effectDate);
        if (Objects.isNull(boid) || Objects.isNull(effectDate)) {
            return 0L;
        }
        String formatDate = HRDateTimeUtils.format((Date)effectDate, (String)DATE_FORMAT);
        String stdPositionCacheKey = HRStringUtils.format((String)"key:stdposition:{}:{}", (Object[])new Object[]{formatDate, boid});
        Long vid = (Long)ihrAppCache.get(stdPositionCacheKey, Long.class);
        if (Objects.nonNull(vid)) {
            return vid;
        }
        Map<String, Object> invokeResult = hrmpService.invokeQueryStandardPosition(Collections.singletonList(boid), effectDate);
        if ("200".equals(invokeResult.get("code").toString()) && HRCollUtil.isNotEmpty((Collection)(hisDataList = (List)invokeResult.get("data")))) {
            Map hisData = (Map)hisDataList.get(0);
            vid = (Long)hisData.get("id");
        }
        ihrAppCache.put(stdPositionCacheKey, (Object)Optional.ofNullable(vid).orElseGet(() -> 0L));
        return vid;
    }

    @Override
    public Long queryPositionVid(Long boid, Date effectDate) {
        Map dataMap;
        List hisDataList;
        LOGGER.info("###QueryVidServiceImpl.queryPositionVid, boid:{},effectDate:{}", (Object)boid, (Object)effectDate);
        if (Objects.isNull(boid) || Objects.isNull(effectDate)) {
            return 0L;
        }
        String formatDate = HRDateTimeUtils.format((Date)effectDate, (String)DATE_FORMAT);
        String positionCacheKey = HRStringUtils.format((String)"key:position:{}:{}", (Object[])new Object[]{formatDate, boid});
        Long vid = (Long)ihrAppCache.get(positionCacheKey, Long.class);
        if (Objects.nonNull(vid)) {
            return vid;
        }
        Map<String, Object> invokeResult = hrmpService.invokeQueryPositionHis(Collections.singletonList(boid), effectDate);
        if ("200".equals(invokeResult.get("code").toString()) && HRCollUtil.isNotEmpty((Collection)(hisDataList = (List)(dataMap = (Map)invokeResult.get("data")).get("hisdata")))) {
            Map hisData = (Map)hisDataList.get(0);
            vid = (Long)hisData.get("id");
        }
        ihrAppCache.put(positionCacheKey, (Object)Optional.ofNullable(vid).orElseGet(() -> 0L));
        return vid;
    }

    @Override
    public Long queryJobVid(Long boid, Date effectDate) {
        List hisDataList;
        LOGGER.info("###QueryVidServiceImpl.queryJobVid, boid:{},effectDate:{}", (Object)boid, (Object)effectDate);
        if (Objects.isNull(boid) || Objects.isNull(effectDate)) {
            return 0L;
        }
        String formatDate = HRDateTimeUtils.format((Date)effectDate, (String)DATE_FORMAT);
        String jobCacheKey = HRStringUtils.format((String)"key:job:{}:{}", (Object[])new Object[]{formatDate, boid});
        Long vid = (Long)ihrAppCache.get(jobCacheKey, Long.class);
        if (Objects.nonNull(vid)) {
            return vid;
        }
        Map<String, Object> invokeResult = hrmpService.invokeSelectJobHisinfo(Collections.singletonList(boid), effectDate);
        if ("200".equals(invokeResult.get("code").toString()) && HRCollUtil.isNotEmpty((Collection)(hisDataList = (List)invokeResult.get("data")))) {
            Map hisData = (Map)hisDataList.get(0);
            Object id = hisData.get("id");
            vid = Objects.nonNull(id) ? Long.parseLong(id.toString()) : 0L;
        }
        ihrAppCache.put(jobCacheKey, (Object)Optional.ofNullable(vid).orElseGet(() -> 0L));
        return vid;
    }
}

